////////////////////////////////////////////////////////
/* Store a bin of bids; used for the array of bins */
////////////////////////////////////////////////////////

#ifndef BIN_H
#define BIN_H

#include "defines.h"

#ifndef MULTI_UNIT

#include "allocation.h"
#include "bid.h"
#include "linkedlist.h"
#include "bidhistory.h"

class Bin
{
public:
	void sort();
	// bin management functions
	void constructNewBin(Allocation *allocation, unsigned best_amount, BidHistory *history=NULL);
	void constructNewBin();
	bool nextBid();
	int percentDone();
	void add (Bid *b);
	void bidSearched(Bid *bid);

	// pruning functions
	void constructPruningTables();
	LinkedList *getPruneTable(int item);
	int pruneVal(int t, BitVector *vec);
	unsigned pruneVal(BitVector *vec);

	// accessor functions
	int binNumber();
	int dynNum();
	Bid * currentBid();
	Allocation * tempAllocation();

	// constructor/destructor
	Bin(int current_bin, int num, Bin **binvec);
	~Bin();
	
	// variable
	int progress;
	unsigned max_prune_val;
//	int lom_count;

	// should be private
	int dyn_num,base_num, maxnum,bin_number;
private:
	// functions
	static int qsortCompare(const void *bid1, const void *bid2);
	static int qsortCompareFirst(const void *bid1, const void *bid2);
	static int qsortCompare2(const void *bid1, const void *bid2);
	
	// variables
	Bid **base_bid,**dyn_bid;
	int current_bid;
	int num_bids;
	LinkedList **prune_table;
	unsigned t, estimate;	// for pruneVal, a very commonly called function:
	BitVector *temp_vec;
	Bin **bin;
	Allocation *temp_allocation; // used inside Cass::allocate
};

#ifdef INLINING_ON
#include "bin2.cpp"
#endif

#endif //!multiunit
#endif
