////////////////////////////////////////////////////////
/* Store a bin of bids; used for the array of bins */
////////////////////////////////////////////////////////

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "defines.h"

#ifndef MULTI_UNIT

#include "bin.h"
#include "qsort.h"
#include "bitvector.h"

/* constructor */
Bin::Bin(int bin_number, int maxnum, Bin **binvec)
{
	this->bin_number = bin_number;
	this->maxnum = maxnum;
	this->bin = binvec;
	base_num = 0;
	dyn_num = 0;
	base_bid = new Bid*[maxnum];
	dyn_bid = new Bid*[maxnum];
	current_bid = -1;
	temp_vec = new BitVector(NUM_ITEMS,NULL,0);
	temp_allocation = new Allocation(new BitVector(NUM_ITEMS,NULL,0),0);
	progress = 0;

	// allocate pruning table
	prune_table = new LinkedList *[NUM_ITEMS];
	for (unsigned t=bin_number; t<NUM_ITEMS; t++)
	{
		prune_table[t] = new LinkedList(bin_number);
	}
}

/* destructor */
Bin::~Bin()
{
	int t;
	
	delete temp_vec;
	delete temp_allocation;
	delete[] dyn_bid;
	for (t=0;t<base_num;t++)
		delete base_bid[t];
	delete[] base_bid;

	// delete pruning table
	for (t=bin_number; t<(signed)NUM_ITEMS; t++)
	{
		delete prune_table[t];
	}
	delete[] prune_table;
}


extern double randNeg();
extern double randFactor(double variance);
extern double bin_rand_factor;

// the compare function required by the standard C quicksort function
// sorts bids in descending order of expected revenue.
// expected revenue is actual revenue from bid plus overestimated further revenue from pruning
int Bin::qsortCompare(const void *bid1, const void *bid2)
{
	static unsigned amt1, amt2;

	// calculate the amounts to sort on
	amt1 = (unsigned) (((*(Bid **)bid1)->pruneAvg() + 2*(*(Bid **)bid1)->average) *  randFactor(bin_rand_factor));
	amt2 = (unsigned) (((*(Bid **)bid2)->pruneAvg() + 2*(*(Bid **)bid2)->average) *  randFactor(bin_rand_factor));

	// note: these comparisons are backwards to get qsort to sort in descending order
	if (amt1 < amt2) return 1;
	else if (amt1 > amt2) return -1;
	else return (randNeg() > 0? 1:-1);
}

int Bin::qsortCompareFirst(const void *bid1, const void *bid2)
{
//	static unsigned amt1, amt2;
//
//	// calculate the amounts to sort on
//	amt1 = (unsigned) (((*(Bid **)bid1)->pruneAvg() + 2*(*(Bid **)bid1)->average) *  randFactor(bin_rand_factor * FIRST_BIN_FACTOR));
//	amt2 = (unsigned) (((*(Bid **)bid2)->pruneAvg() + 2*(*(Bid **)bid2)->average) *  randFactor(bin_rand_factor * FIRST_BIN_FACTOR));
//
//	// note: these comparisons are backwards to get qsort to sort in descending order
//	if (amt1 < amt2) return 1;
//	else if (amt1 > amt2) return -1;
//	else return (randNeg() > 0? 1:-1);
	return 0;
}

// the compare function required by the standard C quicksort function
// sorts bids in descending order of expected revenue.
// expected revenue is actual revenue from bid plus overestimated further revenue from pruning
int Bin::qsortCompare2(const void *bid1, const void *bid2)
{
	static float amt1, amt2;

	// calculate the amounts to sort on
	amt1 = (float)(*(Bid **)bid1)->average + 0*(*(Bid **)bid1)->amount;
	amt2 = (float)(*(Bid **)bid2)->average + 0*(*(Bid **)bid2)->amount;

	// check for equality
	if (amt1-amt2 == 0) return 0;

	// for some reason the above equality check doesn't work on the Sun
#ifndef _WIN32
	if ((*(Bid **)bid1)->bid_num == (*(Bid **)bid2)->bid_num) return 0;
#endif

	// note: these comparisons are backwards to get qsort to sort in descending order
	if (amt1 < amt2) return 1;
	else return -1;
}

// sort the whole base bin
void Bin::sort()
{
	Qsort((void *)(base_bid),base_num,sizeof(Bid *),qsortCompare2);
}

#endif // !multi_unit
