
//////////////////////////////////////////////////////////////////////////////////////
/* stores the sequence of partial allocations used to achieve a complete allocation */
//////////////////////////////////////////////////////////////////////////////////////

#ifndef BIDHISTORY_H
#define BIDHISTORY_H

class Bid;

#include "bid.h"

class BidHistory
{
public:
	BIDHISTORY_TYPE num;
#ifdef _DEBUG
	int maxnum;
#endif
	Bid **bid;
	BidHistory *duplicate(int max_space);
	void remove(void);
	void copyTo (BidHistory *dest);
	void append(Bid *bid);
	void printPath();
	BidHistory(int maxnum);
	~BidHistory();
	void reset();
	BIDHISTORY_TYPE top();
};

#ifdef INLINING_ON
#include "bidhistory2.cpp"
#endif

#endif
