//////////////////////////////////////////////////////////////////////////////////////
/* stores the sequence of partial allocations used to achieve a complete allocation */
//////////////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "bidhistory.h"
#include "assert.h"
#include "defines.h"

/* constructor */
BidHistory::BidHistory(int maxnum)
{
#ifdef _DEBUG
	this->maxnum = maxnum;
#endif
	bid = new Bid * [maxnum];
	num = 0;
}

/* destructor */
BidHistory::~BidHistory()
{
//	for (int t=0;t<num;t++)
//		if (bid[t] && bid[t]->delete_flag == 2)
//			delete bid[t];
	delete[] bid;
}

// top
BIDHISTORY_TYPE BidHistory::top()
{
	assert (num);
	return bid[num-1]->bid_num;
}


void BidHistory::printPath()
{
  printf("Bids: ");
  for (int i = 0; i < num; i++)
    printf ("%d ", bid[i]->bid_num);
  printf("\n");
}
