// bid2.cpp

#include <stdio.h>
#include "defines.h"
#include "bid.h"
#include "assert.h"

#ifndef BID2
#define BID2

// read values

INLINE unsigned Bid::nextBin()
{
#ifdef MULTI_UNIT
	return next_bin[subbin_num[bin_number]];
#else
	return next_bin;
#endif
}

INLINE int Bid::pruneAvg()
{
#ifdef MULTI_UNIT
	return prune_avg[subbin_num[bin_number]];
#else
	return prune_avg;
#endif
}

INLINE unsigned Bid::pruneVal()
{
#ifdef MULTI_UNIT
	return prune_val[subbin_num[bin_number]];
#else
	return prune_val;
#endif
}

INLINE bool Bid::isSingleton()
{
	return (delete_flag == DF_IS_SINGLETON);
}

// set values

void INLINE Bid::setPruneVal(unsigned val)
{
#ifdef MULTI_UNIT
	prune_val[subbin_num[bin_number]] = val;
#else
	prune_val = val;
#endif
}

INLINE void Bid::setPruneAvg(int val)
{
#ifdef MULTI_UNIT
	prune_avg[subbin_num[bin_number]] = val;
#else
	prune_avg = val;
#endif
}

INLINE void Bid::setNextBin(unsigned val)
{
#ifdef MULTI_UNIT
	next_bin[subbin_num[bin_number]] = val;
#else
	next_bin = val;
#endif
}

// subbin math

INLINE void Bid::prevSubbin(int bin_num)
{
	assert(subbin_num[bin_num] != 0);
	subbin_num[bin_num]--;
}

INLINE void Bid::nextSubbin(int bin_num)
{
	assert((unsigned)subbin_num[bin_num] < NUM_UNITS);
	subbin_num[bin_num]++;
	//printArray(subbin_num, NUM_UNITS);
}

INLINE void Bid::firstSubbin()
{
#ifdef MULTI_UNIT
	subbin_num = new int[NUM_UNITS];
	for (unsigned t=0;t<NUM_UNITS;t++)
		subbin_num[t]=0;
#endif
}

#endif
