//////////////////////////////////
/* Stores a full or partial Bid */
//////////////////////////////////

#include <stdio.h>

#define BID_CPP
#include "assert.h"
#include "bid.h"

extern unsigned int NUM_ITEMS;
extern unsigned int NUM_DUMMY_ITEMS;

/* constructor */
Bid::Bid(VECTOR *v, int a, int num, int bin_num,InputBid *ib)
{
	vec = v;
	assert (v);
	amount = a;
	bid_num = num;
	bin_number = bin_num;
	bid_array = NULL; // no bidhistory unless one is explicitly set up
	num_dummies = 0;

	// compute the number of dummies
	for (unsigned t=NUM_ITEMS-NUM_DUMMY_ITEMS;t<NUM_ITEMS;t++)
		num_dummies += vec->readArray(t);
	
	// compute the average price per *non-dummy* good: used in pruning
	unsigned temp = max(vec->getNumSet() - num_dummies,1); // handle singleton bids on dummies gracefully
	average = (amount << PRUNE_SHIFT)/ temp +
		((amount << PRUNE_SHIFT) % temp ? 1 : 0);  // add one if there's a remainder
	delete_flag = 0;  // don't do anything special unless this is explicitly changed
	slaves = NULL;
	input_bid = ib;
}

/* destructor */
Bid::~Bid()
{
	delete vec;
	if (bid_array) delete bid_array;
	
	// slaves exist in only one place.  Kill them here
	if (slaves) 
	{
		for (int t=0;t<slaves->num;t++)
			delete slaves->bid[t];
		delete slaves;
	}
}


