// stats.h: interface for the Stats class.
//
//////////////////////////////////////////////////////////////////////

#ifndef STATS_H
#define STATS_H

#include "inputfile.h"
#include "defines.h"

#ifdef COUNT_MIS
	#ifdef _WIN32
		typedef signed __int64 BIG_INT;
	#else
		typedef unsigned long long BIG_INT;
	#endif
#endif

class Stats  
{
public:
	void incrementNumPropagated();
	void incrementRecursiveCalls();
	void incrementPruneHit();
	void incrementCacheHit();
	// functions
	void updateAnytimeStats(int best_amount);
	void outputAnytimeStats(InputFile &infile);
	void incrementNumExamined();
	
	// constructor/destructor
	Stats();
	virtual ~Stats();

	// anytime stats
	#ifdef GATHER_ANYTIME_STATS
		int *best_history_amount;
		int best_history_index;
		double *best_history_time;
	#endif

	// pruning stats
	#ifdef GATHER_PRUNING_STATS
		int *prune_hits;
		int *prune_bin;
	#endif

	// max independent set stats
	#ifdef COUNT_MIS
		BIG_INT mis_num;
		BIG_INT mis_sum;
		BIG_INT mis_sum_sq;
		unsigned int mis_max, mis_min;
	#endif

	// basic stats
	unsigned long int num_examined, num_cache, num_propagated, num_prune, num_recursive_calls, search_count,num_prune_billions;
	double time;
};

#ifdef INLINING_ON
#include "stats2.cpp"
#endif

#endif
