// stats.cpp: implementation of the Stats class.
//
//////////////////////////////////////////////////////////////////////

#include <string.h>
#include <stdio.h>
#include "stats.h"
#include "defines.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Stats::Stats()
{
	num_examined = num_prune = num_prune_billions = num_cache = num_propagated = num_recursive_calls = 0;

	// anytime stats
	#ifdef GATHER_ANYTIME_STATS
		best_history_amount = new int[BEST_HISTORY_MAX];
		best_history_time = new double[BEST_HISTORY_MAX];
		best_history_index = 0;
	#endif

	// pruning stats
	#ifdef GATHER_PRUNING_STATS
		prune_hits = new int[NUM_ITEMS];
		prune_bin = new int[NUM_ITEMS];
		memset(prune_hits,0,sizeof(int)*NUM_ITEMS);
		memset(prune_bin,0,sizeof(int)*NUM_ITEMS);
	#endif

	// Maximum independent set variables
	#ifdef COUNT_MIS
		mis_num = mis_sum = mis_sum_sq = 0;
		mis_max = 0;
		mis_min = LARGE_NUMBER;
	#endif
}

Stats::~Stats()
{
	// anytime stats
	#ifdef GATHER_ANYTIME_STATS
		delete[] best_history_amount;
		delete[] best_history_time;
	#endif
	
	// pruning stats
	#ifdef GATHER_PRUNING_STATS
		delete[] prune_hits;
		delete[] prune_bin;
	#endif
}

// output binned anytime data
void Stats::outputAnytimeStats(InputFile &infile)
{
#ifdef GATHER_ANYTIME_STATS
	FILE *fp;
	double anytime_bin[] = {.8,.9,.95,.96,.97,.98,.99,1.0};
	int last_anytime_bin = 8;
	fp = fopen ("CASS_anytime.csv","at");
	fprintf (fp, "\"CASS: (%d, %d)\"",NUM_ITEMS, infile.num_bids);
	int current_anytime_bin=0;
	for (int t=0;t<this->best_history_index && current_anytime_bin < last_anytime_bin;t++)
	{
		while (this->best_history_amount[t] >= best_history_amount[best_history_index-1] * anytime_bin[current_anytime_bin]&& current_anytime_bin < last_anytime_bin)
		{
			fprintf (fp, ", anytime bin stuff %lf, %lf",anytime_bin[current_anytime_bin],/*this->best_history_amount[t],*/this->best_history_time[t]);
			current_anytime_bin++;
		}
	}
	fprintf (fp,"\n");
	fclose(fp);
#endif	
}


