// INLINE functions from the MultiBin class

#ifndef MULTIBIN2
#define MULTIBIN2

#include "defines.h"

#ifdef MULTI_UNIT

#include "multibin.h"
#include "qsort.h"
#include "stats.h"

extern Stats *stats;

// add 
INLINE void MultiBin::add(Bid *bid, bool singleton_item)
{
	// error checking
#ifdef _DEBUG // was BIN_ERROR_CHECKING
	if (num[0]+1 > maxnum)
	{
		printf ("Error -- too many items in multibin!\n");
		exit(1);
	}
#endif

	// allocate a singleton
	if (singleton_item) 
		singleton[sing_num++] = bid;


	// allocate another multibin item
	else
		subbin[0][num[0]++] = bid;
}

// go to the previous subbin
INLINE void MultiBin::prevSubbin()
{
	current_subbin--;
	Bid::prevSubbin(bin_number);

	// double-check
	#ifdef _DEBUG
		if (current_subbin < 0)
		{
			printf ("MultiBin::prevSubbin() error!\n");
			exit(1);
		}
	#endif
}

// accessor for private member prune_table -- use with care!
// used by MultiBinSet for the construction of the pruning tables
INLINE LinkedList* MultiBin::getPruneTable(int item)
{
	return prune_table[item];
}

// find the prune value for all unallocated goods in an allocation
INLINE unsigned MultiBin::pruneVal(Vector *vec)
{
	estimate = 0;
//	lom_count = 0;
	t = bin_number;
	

	// consider the revenue from each unallocated good
	do {
		estimate += pruneVal(t, vec);
//		lom_count++;
		t=vec->lowOrderMissing(t+1);
	} while (t != -1);
	
	// is this bit math still correct, as it was for single goods?
	return (estimate + ((1<<PRUNE_SHIFT)-1) ) >> PRUNE_SHIFT;
}

// consider the next bid
INLINE bool MultiBin::nextBid()
{
	// last bid
	if (getCurrentBidNum() == getNum() - 1)
	{
		current_bid[current_subbin] = -1;
		return false;
	}
	
	// next bid
	else current_bid[current_subbin]++;

	return true;
}

INLINE Allocation * MultiBin::tempAllocation()
{
	return temp_allocation[current_subbin];
}

// number of items in the multibin
INLINE int MultiBin::getNum()
{
	return num[current_subbin];
}

// runs every time a bid has been searched (prune, cache, real search)
// right now just for randomization, but in the future could be used for other things
INLINE void MultiBin::bidSearched(Bid *bid)
{
#ifdef RANDOMIZE
	// everything below has been searched, so we never need to consider this bid again
	if (this->bin_number == 0 && this->current_subbin == 1)
		bid->input_bid->deleted = true;
#endif
}

// number of items in the multibin
INLINE int MultiBin::getNumSubbins()
{
	return num_subbins;
}

// number of items in the multibin
INLINE Bid *MultiBin::getSingleton(int index)
{
	return singleton[index];
}

// number of items in the multibin
INLINE int MultiBin::currentSubbin()
{
	return current_subbin;
}

// number of items in the multibin
INLINE int MultiBin::getCurrentBidNum()
{
	return current_bid[current_subbin];
}

// return the current bid
INLINE Bid * MultiBin::currentBid()
{
#ifdef _DEBUG
	if (getCurrentBidNum() == -1 || getCurrentBidNum() >= getNum())
	{
		printf ("MultiBin::currentBid() error!\n");
		exit(1);
	}
#endif
	return subbin[currentSubbin()][getCurrentBidNum()];
}

// return the percentage through the goods in this multibin
INLINE int MultiBin::percentDone()
{
	return (100 * current_bid[1]) / num[1];  // position through subbin 1
}

INLINE int MultiBin::binNumber()
{
	return bin_number;
}

// return the pruning overestimate for good t, vector vec
INLINE int MultiBin::pruneVal(int t, Vector *vec)
{
	return (int) prune_table[t]->maxAvgRevenue(vec,t);
	//return (int) prune_table[t]->maxAvgRevenue();
}

// make a new multibin, containing only bids disjunct from allocation and sorted dynamically
// this function pre-calculates all of the values that are important to Cass::allocate()
INLINE void MultiBin::constructNewBin(Allocation *allocation, unsigned best_amount)
{
  
	unsigned temp_prune;
	int temp_lom;
	int temp_prune_avg;
	int num_slaves = 0;
	
 	//printf ("In construct new bin: with amount: %d, alloc amt: %d and vector ", best_amount, allocation->amount);
	//allocation->vec->printVector();

	//printf ("Current subbin %d, binNumber %d, numSubbins %d\n", current_subbin, bin_number, num_subbins);

	current_subbin++;
	Bid::nextSubbin(bin_number);
	num[current_subbin]=0;
	max_prune_val = 0;
	
	//printf ("Currentbid: %d\n", current_bid[current_subbin - 1]);
	
	Bid *this_bid, **new_bid=subbin[current_subbin], *prev_bid = NULL; 
	if (current_bid[current_subbin-1] != -1)
	  prev_bid = subbin[current_subbin-1][current_bid[current_subbin-1]];
       
	// add in dominated bids, if any
	if (current_subbin > 1 && prev_bid->slaves)
		num_slaves = prev_bid->slaves->num;

	// consider every bid in the previous subbin, plus the singleton, plus slaves
	//int loop_bound = (current_subbin==1 ? num[0]+1 : num[current_subbin-1]);  // take off the dummy bid, if there is one.
	int loop_bound = num[current_subbin-1];
	int loop_init = (current_subbin == 1 ? 0 : current_bid[current_subbin-1]+1);

	for (int t=loop_init;t<=loop_bound+num_slaves; t++)
	{
		//bool singleton_flag = false;

		// set the "this_bid" pointer
		if (t<loop_bound)  // note we skip one bid here: this is the dummy bid from the last subbin
			this_bid = subbin[current_subbin-1][t];
		
		// add in the dummy bid
		else if (t==loop_bound)
		{
			this_bid = singleton[allocation->vec->remaining(bin_number)-1];
	//		singleton_flag = true;
		}

		// add in slaves
		else
			this_bid = prev_bid->slaves->bid[t-loop_bound-1];
		
		// test for disjunction and the same bid just added last time
		//if 	((current_subbin == 1 || this_bid->bid_num != prev_bid->bid_num) &&	// this is not the bid that was added last time
			//(singleton_flag || !this_bid->isSingleton()) &&
		// this is either the designated singleton, or not a
		// singleton
		//printf ("Bid details: no. %d, avg: %d, amt: %d \n",
		//this_bid->bid_num, this_bid->average, this_bid->amount);
		
		if (this_bid->vec->disjunctFrom(allocation->vec,bin_number))			// bids are disjunct
		{
			// add the bid to the allocation, so we can start examining the vector
			allocation->vec->unionWith(temp_vec,this_bid->vec);
			
			// determine next multibin after adding this bid
			temp_lom = temp_vec->lowOrderMissing(bin_number);
			//printf ("currentbinNumber %d LOM %d \n", bin_number, temp_lom);
			
			// construct pruning value
			#ifdef PRUNING_ENABLED
				if (temp_lom != -1)
				{
					temp_prune = bin[temp_lom]->pruneVal(temp_vec);
					temp_prune_avg = (temp_prune << PRUNE_SHIFT) / (NUM_UNITS - temp_vec->getNumSet());
					temp_prune +=  this_bid->amount;
				}
				else 
				{
					temp_prune = this_bid->amount;
					temp_prune_avg = this_bid->average;
				}
			#else
				temp_prune = LARGE_NUMBER;
				temp_prune_avg = 0;
                             #endif

			// add the bid if it *can't* be pruned out
			if (temp_prune + allocation->amount >= best_amount)
			{
				// add the bid to the new multibin
				new_bid[num[current_subbin]] = this_bid;
				new_bid[num[current_subbin]]->setPruneVal(temp_prune);
				new_bid[num[current_subbin]]->setNextBin(temp_lom);
				new_bid[num[current_subbin]]->setPruneAvg(temp_prune_avg);
				num[current_subbin]++;
#ifdef CACHING_ENABLED
				max_prune_val = max (max_prune_val,temp_prune);
#endif
				
			}
			// else, keep track of the amount pruned for caching purposes
			else
			{ 
				stats->incrementPruneHit();
				bidSearched(this_bid);
								
				#ifdef CACHING_ENABLED
					max_prune_val = max (max_prune_val,temp_prune);
                                #endif
			}
		}
	}

	// sort the new multibin
	#ifdef DYNAMICALLY_ORDER_BINS
		if (num[current_subbin]) 
			Qsort((void *)(new_bid),num[current_subbin],sizeof(Bid *),qsortCompare);
	#endif
		
	// start from the beginning of the new multibin
	current_bid[current_subbin] = -1;
}

// construct a new multibin with no reordering
INLINE void MultiBin::constructNewBin()
{
	current_subbin = 0;
	current_bid[current_subbin] = -1;
}

#endif // multi_unit
#endif
