////////////////////////////////////////////////////////
/* Store a bin of bids; used for the array of bins */
////////////////////////////////////////////////////////

#ifndef MULTIBIN_H
#define MULTIBIN_H

#include "defines.h"

#ifdef MULTI_UNIT

#include "allocation.h"
#include "bid.h"
#include "linkedlist.h"
#include "bidhistory.h"
#include "vector.h"

class MultiBin
{
public:
	void bidSearched(Bid *bid);
	int getNumSubbins();
	Bid *getSingleton(int index);
	void constructSingletonArray();
	Bid *mergeBids(Bid *bid1, Bid *bid2);
	Bid *createDummyBid(int num_units);
	
	// bin management functions
	void constructNewBin(Allocation *allocation, unsigned best_amount);
	void constructNewBin();
	bool nextBid();
	int percentDone();
	void add (Bid *b, bool singleton_item);
	void sort();
	void prevSubbin();

	// pruning functions
	void constructPruningTables();
	LinkedList *getPruneTable(int item);
	int pruneVal(int t, Vector *vec);
	unsigned pruneVal(Vector *vec);

	// accessor functions
	int binNumber();
	Bid * currentBid();
	Allocation * tempAllocation();
	int currentSubbin();
	int getNum();
	int getCurrentBidNum();

	// constructor/destructor
	MultiBin(int current_bin, int num, MultiBin **binvec, int num_subbins);
	~MultiBin();
	
	// variable
	int progress;
	unsigned max_prune_val;
//	int lom_count;
private:
	// functions
	static int qsortCompare(const void *bid1, const void *bid2);
	static int qsortCompare2(const void *bid1, const void *bid2);
	
	// variables
	Bid ***subbin;
	int current_subbin;
	int num_subbins;  // WARNING: this is actually the number of subbins + 1.  Because the original set of bids (from which subbin 0 is generated) also has to be stored in a subbin
	int num_bids, maxnum,bin_number;
	int *current_bid, *num;
	LinkedList **prune_table;
	unsigned t, estimate;	// for pruneVal, a very commonly called function:
	unsigned sing_num;
	MultiBin **bin;
	Allocation **temp_allocation; // used inside Cass::allocate
	Vector *temp_vec;  // allocated once, to avoid constant memory allocation
public:
	void printSingletonArray();
	Bid **singleton;  // this should be private ******************************************************************************
};

#ifdef INLINING_ON
#include "multibin2.cpp"
#endif

#endif // multi_unit
#endif
