#ifndef DEFINE_H
#define DEFINE_H
/* *********************************************************************
   * FEATURES                                                          *
   ********************************************************************* */

// uncomment to enable refining goods
#define REFINE_ENABLED

// uncomment to sort bids within bins
#define SORT_BINS

// uncomment the following to dynamically sort bins
#define DYNAMICALLY_ORDER_BINS

// uncomment to enable pruning
#define PRUNING_ENABLED

// uncomment the following to enable caching
#define CACHING_ENABLED

// uncomment the following to turn on propagation of cache values
// I'm not sure if this one works
//#define PROPAGATE_AMOUNTS

// multiple unit auctions
#define MULTI_UNIT

//#define _DEBUG
// randomization
//#define RANDOMIZE
//#define RANDOMIZE_FIRST_BIN_CONSTANT

// uncomment to enable the decision-problem version of CASS
//#define DECISION_PROBLEM

//uncomment to enable time cutoff for using as an anytime algorithm
#define TIME_LIMIT

// uncomment to count the number of maximal independent sets and report this info: note: PRUNING_ENABLED and CACHING_ENABLED are turned off
//#define COUNT_MIS


/* *********************************************************************
   * PARAMETERS                                                        *
   ********************************************************************* */

// default bytes of memory to devote to the cache: overridden by the command-line switch "-c"
#define CACHE_SIZE (2000000)

// don't store an item in the cache unless at least this many recursive calls to allocate() have been made
#define CACHE_MIN_RECURSIVE_CALLS (1)

// don't search more than this for a pruning solution
#define PRUNE_MAX_TRIES (40)

// number of iterations to propagate
#define PROPAGATE_MAX_DEPTH (1)
  
// maximum number of goods supported by this compiled version of the program (if <= 32, faster BitVector operations are used.  Otherwise the actual number doesn't matter)
#define MAX_NUM_GOODS (5000)

// maximum number of bids supported by this compiled version of the program (relevant numbers are 256,65536,4B)
#define MAX_NUM_BIDS (65535)

// largest number of units possible
#define MAX_SUBBINS (10)

// number of slaves before a realloc
#define NUM_SLAVES (20)

// amount that prices should be shifted left before calculating averages--to avoid rounding error
#define PRUNE_SHIFT (6)

// randomization parameters
#define ABORT_FIRST (20)
#define ABORT_INCREMENT (.003)  // was 0.01
#define DELETE_SEARCHED_BIDS
//#define MIN_CALLS_BEFORE_ABORT_INCREASE (500) // was 500
#define ABORT_INCREASE_FACTOR (2)  // was 2
#define RANDOMIZATION_LIMIT (100000) // 3500 for 65 goods, 1500 bids
//#define SEARCH_ALL_BIDS_FIRST_BIN  // must implement this #define!
//#define RANDOMIZE_GOOD_ORDERING
//#define NUM_BIDS_AVG_FACTOR (0.)
#define MIN_NUM_BIDS_CHANGE (1)
#define NUM_BIDS_HORIZON (12)
#define NUM_BIDS_INCREASE_HORIZON (9)

// bin randomization factor
#define BIN_RAND_FACTOR (0.025)  // was .05
#define GOOD_RAND_FACTOR (0.85)  // was .65
//#define BIN_RAND_FACTOR (0.02)
//#define GOOD_RAND_FACTOR (0.03)
//#define FIRST_BIN_FACTOR (1)

/* *********************************************************************
   * OUTPUT                                                            *
   ********************************************************************* */

// print all bids after refine has completed
//#define PRINT_AFTER_REFINE

// output while refining bids
#define REFINE_OUTPUT

// output from caching
#define CACHING_OUTPUT

// uncomment the following to see best allocations as they are found
#define PRINTOUT_BEST_ALLOCS

// if defined, after CPLEX file is created the search is aborted
//#define BREAK_AFTER_MAKING_CPLEX_FILE

// uncomment to output singleton array after DP creates it
//#define PRINT_SINGLETONS
 
// uncomment the following to see percentage done
#define DISPLAY_PROGRESS

// log file uses the same name as the input file, but with the .LOG extension
#define LOG_FILE_NAME_SAME_AS_INPUT_FILE

// filename for the csv file to output results, if the above is commented out
#define OUTPUT_FILENAME		"cass-output.csv"

// set this if it's a release to be distributed
#define PUBLIC_RELEASE

// set to make the public release display less of the output (refine, cache, etc.)
//#define QUIET_PUBLIC_RELEASE

// the version number, displays on public release
#define PUBLIC_RELEASE_VER	"1.01"

// output winning bids to a file
#define WINNING_BIDS_FILE

/* *********************************************************************
   * STATISTICS                                                        *
   ********************************************************************* */

// uncomment the following to count the number of entries (and cache entries) examined
#define GATHER_STATS

// if undefined, system time is measured
#define STOPWATCH_CPU_TIME

// uncomment the following to gather cache usage statistics */
//#define GATHER_CACHE_USAGE_STATS

// uncomment to record anytime behaviour
//#define GATHER_ANYTIME_STATS

// uncomment to record amount of pruning per level
//#define GATHER_PRUNING_STATS

/* *********************************************************************
   * ERROR CHECKING                                                    *
   ********************************************************************* */

// run DABL after CASS, to see if it gets the same result
//#define CHECK_WITH_DABL

// recalculate num_set every time it is called, and check
//#define DEBUG_NUMSET
 
// the number of best history entries to record, for anytime stats
#define BEST_HISTORY_MAX 8000

// allows the multiple-unit CASS to read single-unit files (for debugging)
//#define ASSUME_SINGLE_UNITS

#define SINGLE_UNITS_MAX (1)

#define FUDGE_FACTOR (2)

/* *********************************************************************
   * COMPILING                                                         *
   ********************************************************************* */

// set this if designated functions are to be inlined; comment it for profiling
#define INLINING_ON

// set this to turn on inlining of recursive functions
#define INLINE_RECURSION_ON

// the depth of expansion of inline recursive functions
#define INLINE_RECURSION_DEPTH 100
	
// uncomment if a long integer is 64 bits
#ifndef _WIN32
//#define INT_64
#endif

#define LARGE_NUMBER (2000000000L)

/* *********************************************************************
   * AUTOMATIC STUFF                                                   *
   ********************************************************************* */

// number of goods at auction
//#ifndef NUM_ITEMS_DEFINED
extern unsigned int NUM_ITEMS;
extern unsigned int NUM_DUMMY_ITEMS;
//#endif
//#ifndef NUM_UNITS_DEFINED
extern unsigned int NUM_UNITS;
//#endif

// min and max macros
#define min(a,b) ((a)<(b)?(a):(b))
#define max(a,b) ((a)>(b)?(a):(b))

// take care of inlining
#ifdef INLINING_ON
	#define INLINE inline
	#ifdef INLINE_RECURSION_ON
		#define INLINE_RECURSIVE inline
		#pragma inline_recursion(on)
		#pragma inline_depth(INLINE_RECURSION_DEPTH)
	#else
		#define INLINE_RECURSIVE
		#pragma inline_recursion(off)
	#endif
#else
	#define INLINE
	#define INLINE_RECURSIVE
#endif

// inline memcpy() and memset()
#include <string.h> 
#ifdef _WIN32
#pragma intrinsic(memcpy,memset)
#endif

// GATHER_CACHE_USAGE_STATS decoder
#define CACHE_STAT(array,level,numbits) ((array)[(level)*NUM_ITEMS+(numbits)])

// BIDHISTORY_TYPE
// signed so that created singleton bids can have a number of -1.
#if (MAX_NUM_BIDS <= 127)
	typedef signed char BIDHISTORY_TYPE;
#elif (MAX_NUM_BIDS <= 32767)
	typedef signed short int BIDHISTORY_TYPE;
#else
	typedef signed long int BIDHISTORY_TYPE;
#endif

// stuff for non-windows compile
#ifndef _WIN32
	#define stricmp strcmp
	#ifndef STOPWATCH_CPU_TIME  // force this setting to be on for non-windows compile
		#define STOPWATCH_CPU_TIME
	#endif
#endif

// newline
#ifdef _WIN32
#define NEWLINE "\r\n"
#else
#define NEWLINE "\n"
#endif

// public release stuff
//#ifdef PUBLIC_RELEASE
#ifdef QUIET_PUBLIC_RELEASE
	#ifdef REFINE_OUTPUT 
		#undef REFINE_OUTPUT
	#endif
	#ifdef CACHING_OUTPUT
		#undef CACHING_OUTPUT
	#endif
	#ifdef GATHER_STATS
		#undef GATHER_STATS
	#endif
	#define WINNING_BIDS_FILE
#endif // PUBLIC_RELEASE

// makebids
#ifdef _WIN32
#define MAKEBIDS_PATH ""
#else
#define MAKEBIDS_PATH "./"
#endif

// multiple goods
#ifdef MULTI_UNIT
	#define VECTOR Vector
	#define BIN MultiBin
	#define BINSET MultiBinSet
	#ifdef PROPAGATE_AMOUNTS
		#undef PROPAGATE_AMOUNTS  // doesn't work with vectors yet
	#endif
	#undef PRUNE_MAX_TRIES
	#define PRUNE_MAX_TRIES (75)
#else
	#define VECTOR BitVector
	#define BINSET BinSet
	#define BIN Bin
#endif

#ifdef ASSUME_SINGLE_UNITS
#ifndef MULTI_UNIT
#undef ASSUME_SINGLE_UNITS
#endif
#endif

#ifndef RANDOMIZE
#ifdef BIN_RAND_FACTOR
#undef BIN_RAND_FACTOR 
#define BIN_RAND_FACTOR (0)
#endif
#ifdef GOOD_RAND_FACTOR
#undef GOOD_RAND_FACTOR  
#define GOOD_RAND_FACTOR (0)
#endif
#endif

// we can't count the maximal independent sets if we do any pruning.
#ifdef COUNT_MIS
#ifdef PRUNING_ENABLED
#undef PRUNING_ENABLED 
#endif
#ifdef CACHING_ENABLED 
#undef CACHING_ENABLED 
#endif
#endif

// convert __int64 or longlong to double
#define _64to2(a) ((double) (long unsigned int) ((a) >> 32) * (double)4294967296L + (double)(long unsigned int) (((a) << 32)>>32))

#endif // DEFINE_H
