#include "defines.h"

#ifndef MULTI_UNIT

#include "bin.h"
#include "bitvector.h"
#include "stopwatch.h"
#include "inputfile.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#define MAXREVERSE 20
#define NUM_PERCENTILES 9

class Dabl {
public:

	int *npPrices;
	BitVector **bvppBids;

	FILE *fp_dabOutput;
	FILE *fp_2output;
	FILE *fp_3output;

	double dpPercentiles[NUM_PERCENTILES];
	int nBinReached;

	int nGoods, nBids, 
		*npBestAlloc, nBestRevenue, nNumBestRevenueBids, 
		*npSortArray, *npTakenBids;
	int nSoldGoods;
	int numreversed;
	BitVector *bvpSoldGoods;
	BitVector **bvppSoldGoods;
	Stopwatch *pfsw;

	void DescAvgBidRev(const InputFile& infile, int ssarev, double ssatime, double timelimit=9e20, int runOnce=0);
	Dabl(void);
	~Dabl(void);

	inline int incompatible(int p, int NumTakenBids);
//	inline void unUpdateBitVector(int p);
	inline void updateBitVector(int p, int NumTakenBids);

	// recursive: given a list of bids we've already accepted, and 
	// a pointer into the sorted list of all bids, find the best 
	// remaining list of bids to take
	
	inline void findBest(int nNumTakenSoFar, int pos, int nCurTotPr);
	double newtime;
	double timelimit;
	
	int nSSArev;
	double dSSAtime;
	int runOnce;
	int backtrack;
};



void Dabl::findBest(int nNumTakenSoFar, int pos, int nCurTotPr)
{
	int i = 0, avgpriceOK = 1, incompat = 1;

	if (pfsw->Lap() > timelimit) return;
	// find next admissible bid, if any;
	// avgpriceOK is false just if adding *all* currently
	// unsold goods at current avg price per good
	// still wouldn't beat best-known revenue
	if (nSoldGoods != nGoods) {
		while (pos < nBids && 
			  (incompat = incompatible(pos, nNumTakenSoFar)) &&
			  (avgpriceOK = 
					(nCurTotPr + 
					(nGoods - nSoldGoods)*(double)(npPrices[npSortArray[pos]])/
										  (double)(bvppBids[npSortArray[pos]])->getNumSet()
					>= nBestRevenue)
				)
			  )
			pos++;
	}

	// following test is only true if we were able to get past
	// the (nSoldGoods != nGoods) test above; i.e., if not all goods
	// have been sold
	if (!avgpriceOK) 
		return;


	if (nSoldGoods == nGoods || pos >= nBids) {
	// there were no more admissible bids, so allocation is maximal;
	// see if this allocation beats the best known
	
		if (nCurTotPr > nBestRevenue) {
			newtime = pfsw->Lap();
#ifdef PRINTOUT_BEST_ALLOCS
			printf ("revenue: %d #bids: %d, time: %lf\n",nCurTotPr,nNumTakenSoFar,newtime);
#endif
			fprintf(fp_dabOutput, "%d, %f, %d bids taken\n", 
				nCurTotPr, newtime, nNumTakenSoFar);
			while (nBinReached < NUM_PERCENTILES &&
				((double)nCurTotPr)/((double)nSSArev) >= 
				dpPercentiles[nBinReached]) {
				// we've reached the next threshold percentage
				// of optimal revenue -- record cur't time
				fprintf(fp_2output, "%f, %f\n",
					dpPercentiles[nBinReached], newtime);
				nBinReached++;				
			}	
			nBestRevenue = nCurTotPr;
			if (runOnce) 
			{
				//backtrack = 1;
				timelimit = pfsw->Lap() * 2;
				return;
			}
			for (i = 0; i < nNumTakenSoFar; i++)
				 npBestAlloc[i] = npTakenBids[i];
			for ( ; i < nGoods; i++)
				 npBestAlloc[i] = 0;
			nNumBestRevenueBids = nNumTakenSoFar;  		
		}
		return;				   	
	}

	else {
#ifdef _DEBUG
		assert(pos < nBids);
#endif
	// we're at an addable bid

	// add it:
		npTakenBids[nNumTakenSoFar] = npSortArray[pos];
		updateBitVector(pos, nNumTakenSoFar);
		nNumTakenSoFar++;
		nSoldGoods = (int)(bvppSoldGoods[nNumTakenSoFar - 1])->getNumSet();
		
	// best allocation *with* the bid just added
		if (!backtrack) 
			findBest(nNumTakenSoFar, pos + 1, nCurTotPr + npPrices[npSortArray[pos]]);		
	
	// now, remove that bid	
		nNumTakenSoFar--;
		if (nNumTakenSoFar > 0)
			nSoldGoods = (int)(bvppSoldGoods[nNumTakenSoFar - 1])->getNumSet();
		else nSoldGoods = 0;

// Use numreversed here to control how often it branches...		
	
	// and find the best *without* the bid just added
		if (!backtrack)
			findBest(nNumTakenSoFar, pos + 1, nCurTotPr);

	}
}


// add bid at position p in sorted list of bids;
// given that the number of bids we've already tentatively accepted
// is NumTakenBids
void Dabl::updateBitVector(int p, int NumTakenBids)
{
	if (0)
	{
		bvppSoldGoods[NumTakenBids-1]->printVector();
		bvppBids[npSortArray[p]]->printVector();
	}
	
	if (NumTakenBids > 0) {
		assert((bvppSoldGoods[NumTakenBids - 1])->
			disjunctFrom(bvppBids[npSortArray[p]], 0));
		
//		delete bvppSoldGoods[NumTakenBids];
//		bvppSoldGoods[NumTakenBids] = bvppBids[NumTakenBids-1]->duplicate();

		//*(bvppSoldGoods[NumTakenBids]) = *(bvppSoldGoods[NumTakenBids - 1]);
		bvppSoldGoods[NumTakenBids - 1]->
				unionWith(bvppSoldGoods[NumTakenBids],
				bvppBids[npSortArray[p]]);
		
//		bvppSoldGoods[NumTakenBids]->array_int =
//			bvppSoldGoods[NumTakenBids - 1]->array_int |
//			bvppBids[npSortArray[p]]->array_int;
//		bvppSoldGoods[NumTakenBids]->num_set = 
//			bvppSoldGoods[NumTakenBids - 1]->num_set +
//			bvppBids[npSortArray[p]]->num_set ;
	}
	else { 
		delete bvppSoldGoods[0];
		bvppSoldGoods[0] = bvppBids[npSortArray[p]]->duplicate();
//		bvppSoldGoods[0]->array_int = bvppBids[npSortArray[p]]->array_int;
//		bvppSoldGoods[0]->num_set = bvppBids[npSortArray[p]]->num_set;
	}
}


//void Dabl::updateBitVector(int p)
//{
//
//	assert(bvpSoldGoods->
//		disjunctFrom(bvppBids[npSortArray[p]], 0));
//	bvpSoldGoods = bvpSoldGoods->
//		unionWith(bvpSoldGoods, bvppBids[npSortArray[p]]);
//}



// Not used:
//void Dabl::unUpdateBitVector(int p)
//{

//	bvpSoldGoods->array_int = 
//		(bvpSoldGoods->array_int) & 
//		~((bvppBids[npSortArray[p]])->array_int);
//	bvpSoldGoods->num_set -= (bvppBids[npSortArray[p]])->num_set;
//
//}


// Bid at position p in sorted list is not compatible with 
// bids we've already tentatively accepted
int Dabl::incompatible(int p, int NumTakenBids)
{
	if (NumTakenBids > 0) {
		if ((bvppSoldGoods[NumTakenBids - 1])->
			disjunctFrom(bvppBids[npSortArray[p]], 0))
			return 0;
		else return 1;
	}
	else
		return 0;


}

//int Dabl::incompatible(int p)
//{
//	if (bvpSoldGoods->disjunctFrom(bvppBids[npSortArray[p]], 0))
//		return 0;
//	else return 1;
//}

#endif // MULTI_UNIT
