/////////////////////////////////////////////////
/* a class to store an array of ones and zeros */
/* in the current implementation, can only hold 65,535 bits. */
/////////////////////////////////////////////////

#ifndef BITVECTOR_H
#define BITVECTOR_H

#include "defines.h"

// automatic defines
#ifdef INT_64
	#ifdef _WIN32
		typedef unsigned __int64 VECTOR_DATA_TYPE;
	#else
		typedef unsigned long long VECTOR_DATA_TYPE;
	#endif
	#define INT_BITS (64)
	#define INT_BYTES (8)
#else
	typedef unsigned long int VECTOR_DATA_TYPE;
	#define INT_BITS	(32)
	#define INT_BYTES	(4)
#endif

// BitvectorCountingType
#if (MAX_NUM_BIDS <= 127)
	typedef signed char VECTOR_COUNTING_TYPE;
#else
	#if (MAX_NUM_BIDS <= 32767)
		typedef signed short int VECTOR_COUNTING_TYPE;
	#else
		typedef signed long int VECTOR_COUNTING_TYPE;
	#endif
#endif

// assume that bitvectors are disjunct, so num_set doesn't always have to be recalculated
#define BV_ASSUME_DISJUNCT

class BitVector
{
public:
	/* intersection and union */
	void unionWith (BitVector *list2);
	void intersectWith(BitVector *input);
	void intersectWithNot(BitVector *input);
	BitVector *unionWith(BitVector *new_array, BitVector *list2);

	/* access functions */
	VECTOR_COUNTING_TYPE getNumSet();
	VECTOR_COUNTING_TYPE getIntNum();
	VECTOR_DATA_TYPE *getArray();
	
	/* multi-bit functions */
	bool disjunctFrom(BitVector *list2, int i=0);
	bool notDisjunctFrom(BitVector *input, int start_at=0);
	int lowOrderMissing(int start_at=0);
	int lowOrderPresent(int start_at=0);
	bool equalTo(BitVector *input);
	bool equalTo(VECTOR_DATA_TYPE *array);
	bool subsetequalof(BitVector *vec2);

	/* single-bit functions */
	bool readArray(int index);
	void setBit(int index);
	void clearBit(int index);

	/* hashing */
	unsigned hash();
	unsigned hash(unsigned key);
	
	/* management functions */
	void countNumSet();
	BitVector *duplicate();
	void copyTo(BitVector *input);
	void reset();
	void printVector(void);

	/* constructor/destructor */
	BitVector(unsigned n, VECTOR_DATA_TYPE *ptr, bool copymem);
	~BitVector();
	
private:
	/* variables */
	VECTOR_COUNTING_TYPE num;			// the number of elements in the bitvector
	VECTOR_COUNTING_TYPE int_num;		// the number of long integers used to represent the bitvector

	VECTOR_COUNTING_TYPE num_set;		// the number of true bits in the bitvector
#if (MAX_NUM_GOODS > INT_BITS)
	VECTOR_DATA_TYPE *array;
#else
	VECTOR_DATA_TYPE array;			// if its length is 1, why store (& dereference) a pointer too?
#endif
};

#ifdef INLINING_ON
#include "bitvector2.cpp"
#endif

#endif // BITVECTOR_H
