// binset.h: interface for the BinSet class.
//
//////////////////////////////////////////////////////////////////////

#ifndef BINSET_H
#define BINSET_H

#include "defines.h"

#ifndef MULTI_UNIT

#include "allocation.h"
#include "bin.h"
#include "bitvector.h"
#include "inputfile.h"

class BinSet  
{
public:
	void sortBins();
	// functions
	Bin *currentBin();
	bool nextBin(Allocation *allocation, int best_amount, BidHistory *history);
	void prevBin();
	void displayProgress();
	unsigned pruneVal(BitVector *vec, int bin_num);
	unsigned pruneVal(BitVector *vec);
	bool nextBid();  // displays progress and calls bin::nextBid()
	void currentBidSearched();

	// setup
	void constructPruningTables();
	void gatherPruningStats();
	void populateBins(InputFile& infile);
	void makeFirstBin(Allocation *allocation, int best_amount);
	
	// constructor/destructor
	BinSet(int numBins);
	~BinSet();

	unsigned *singleton;
	int current_bin, num_bids;

private:
	// variables
	Bin **bin;
	int num_bins, temp, prev_bin;
	int *binstack;
	int binstack_pointer;
};

#ifdef INLINING_ON
#include "binset2.cpp"
#endif

#endif // !multi_unit
#endif // BINSET_H
