// BIDHISTORY2.CPP - INLINEd functions from BidHistory.cpp

#ifndef BIDHISTORY2
#define BIDHISTORY2

#include "defines.h"
#include "bidhistory.h"

#include <string.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

/* the same as the constructor, but don't allocate any memory */
INLINE void BidHistory::reset(void)
{
	num = 0;
}

/* duplicate */
#ifdef _DEBUG
INLINE BidHistory *BidHistory::duplicate(int max_space)
{
	BidHistory *temp = new BidHistory((max_space ? maxnum : num));
	memcpy(temp->bid, this->bid,(max_space ? maxnum : num)*sizeof(Bid *));
	temp->num = num;
	return temp;
}
#endif

/* copy path from one array to another */
INLINE void BidHistory::copyTo (BidHistory *dest)
{
	memcpy(dest->bid,bid,sizeof(Bid *) * num);
	dest->num = num;
}

/* remove one item from the path */
INLINE void BidHistory::remove(void)
{
#ifdef _DEBUG
	if (num) 
#endif
		num--;
#ifdef _DEBUG
	else 
		printf ("error -- can't remove item from path!");
#endif
}

/* append */
INLINE void BidHistory::append(Bid * bid)
{
#ifdef _DEBUG
	if (num+1>maxnum)
	{
		printf ("Error -- added too many vectors to bidhistory\n");
		exit(1);
	}
#endif
	this->bid[num++] = bid;
}

#endif //BIDHISTORY2
