///////////////////////////////////////////////
/* Stores a full or partial (bid) allocation */
///////////////////////////////////////////////

#ifndef BID_H
#define BID_H

#include "defines.h"
#include "vector_include.h"

class BidHistory;

#include "bidhistory.h"
#include "inputbid.h"

// DF DEFINES
#define DF_IS_SINGLETON (71)

class Bid
{
public:
	// access functions
	unsigned nextBin();
	int pruneAvg();
	unsigned pruneVal();
	void setPruneVal(unsigned val);
	void setPruneAvg(int val);
	void setNextBin(unsigned val);
	bool isSingleton();

	// subbin functions
	static void firstSubbin();
	static void prevSubbin(int bin_num);
	static void nextSubbin(int bin_num);
	
	// variables
	VECTOR *vec;
	unsigned amount;
	int average;
	BIDHISTORY_TYPE bid_num;
	int bin_number;
	BidHistory *bid_array;
	BidHistory *slaves;
	unsigned char delete_flag;
	InputBid *input_bid;   // the original bid this one was generated from
	unsigned int num_dummies;

	// constructor/destructor
	Bid(VECTOR *v, int a,int num,int bin_num, InputBid *ib);
	~Bid();
private:
#ifdef MULTI_UNIT
	unsigned prune_val[MAX_SUBBINS],next_bin[MAX_SUBBINS];
	int prune_avg[MAX_SUBBINS];
#else
	unsigned prune_val, next_bin;
	int prune_avg;
#endif
	// only one copy of this variable exists for all bids
	static int *subbin_num;
};

// only do this oncec
#ifdef BID_CPP
int *Bid::subbin_num = NULL;
#endif

#ifdef INLINING_ON
#include "bid2.cpp"
#endif

#endif
