// == Compile: source /usr/sweet/ilog/ilog.csh
// == Compile: g++ $CPPFLAGS $LDFAGS *.cpp -lcplex -lnsl -lsocket -O3

#ifdef WIN32
#pragma warning(disable : 4786)
#endif

#ifndef USE_CPLEX
#define USE_CPLEX
#endif

#include<iostream>
#include<fstream>
#include<set>
#include<cmath>
#include<algorithm>
#include "stopwatch.h"

#ifdef USE_CPLEX
 #include <ilcplex/cplex.h>
#endif

using namespace std;

#include "BidSet.h"

Stopwatch sw;
Stopwatch sw2;

double parseTime;
double bgTime;
double clusterTime;
double shortPathTime;
double totalTime;

#ifdef USE_CPLEX
double LPtime;

class LPData {
public:
  CPXENVptr     env;
  CPXLPptr      lp;
  int           status;

  double *obj;
  double *lb;
  double *ub;

  double *rhs;
  char *sense;

  int *rmatbeg;
  int *rmatind;
  double *rmatval;

  double *xvals;

  LPData();
  void allocate(BidSet *b);
}; 

LPData lpd;

/* LP slack */
void LPfeatures(ofstream &fout, BidSet *bids);
double LPsolve(BidSet *b);

#endif

/* clustering */
float testSmallWorldBidGraph(ofstream &fout, int bids, int **bidGraph, int calc );

int main(int argc, char** argv)
{
	sw.Start();
	sw2.Start();
	if (argc !=3 )
	{
		cerr << "Usage: features infile outfile" << endl;
		// == NOTE: Don't forget to change this when features/order changes!!

	    cout << "bids, goods, "
		 << "bg_abs_price_dev, bg_ppg_dev, bg_psqrg_dev, bg_edge_dense, "
		 << "bg_deg_dev, bg_max_deg, bg_min_deg, "
		 << "bp_avg_good_deg, bp_good_deg_dev, bp_max_good_deg, bp_min_good_deg, "
		 << "bp_avg_bid_deg, bp_bid_deg_dev, bp_max_bid_deg, bp_min_bid_deg, "
		 << "bg_deg_q1, bg_deg_q2, bg_deg_q3, ";
#ifdef USE_CPLEX
	    cout << "lp_avg, lp_l2_avg, lp_linf,";
#endif
	    cout << "cc_bg_radius, cc_bg_ecc_avg, cc_bg_ecc_dev, cc_clustering, cc_path, cc_cp_ratio, cc_clust_dev, ";

	    cout << "total_time, parseTime, bgTime, clusterTime, shortPathTime";
#ifdef USE_CPLEX
            cout << ", LPtime";
#endif
	    cout << endl;

		return 1;
	}


	BidSet bids(argv[1], false);
	//if( !bids.parse(argv[1]) )
	// return 1;

	parseTime = sw2.Lap();
	sw2.Start();

	bids.makeBidGraph();


	// -- bid graph properties

	int n= bids.numBids();

	long nEdges=0;
	double sqEdges=0;
	double sumPrices=0, sumPSquared=0;
	double sumPricesPG=0, sumPPGSquared=0;
	double sumPricesPSQRG=0, sumPSQRGSquared=0;
	double maxPrice=0, minPrice = bids.getBid(0)->amount;

	double maxDegree = -1, minDegree = n + 1;

	double maxBidSize = -1, minBidSize = bids.numGoods() + bids.numDummyGoods() + 1;
	double avgBidSize = 0, sumSQBidSize = 0;

	int i;

	int* degArray = new int[n];

	int deg = 0;
	for(i=0; i<n; i++)
	{
		Bid* b=bids.getBid(i);
	
		// -- bid size stats
		
		deg = b->num_goods;
		avgBidSize += deg;
		sumSQBidSize += deg*deg;
		maxBidSize = (deg > maxBidSize ? deg : maxBidSize);
		minBidSize = (deg < minBidSize ? deg : minBidSize);


		// -- prices
		maxPrice = (maxPrice > b->amount ? maxPrice : b->amount);
		minPrice = (minPrice < b->amount ? minPrice : b->amount);

		sumPrices += b->amount;
		sumPSquared += (b->amount) * (b->amount);
		
		double ppg = (b->amount) / double(b->num_goods);
		sumPricesPG += ppg;
		sumPPGSquared += ppg*ppg;
	    
		ppg = (b->amount) / sqrt(double(b->num_goods));

		sumPricesPSQRG += ppg;
		sumPSQRGSquared += ppg*ppg;

		// -- bid graph
		//deg = b->conflicts.size();
		deg = b->conflicts;

		degArray[i] = deg;
	//	cout <<"node " << i << " degree is " << b->conflicts << endl;

		nEdges = nEdges+deg;
		sqEdges = sqEdges + deg * deg;
		maxDegree = (deg > maxDegree ? deg : maxDegree);
		minDegree = (deg < minDegree ? deg : minDegree);	
		
	}

	// -- prices
	sumPrices /= double(n);
	sumPSquared /= double(n);
	sumPricesPG /= double(n);
	sumPPGSquared /= double(n);
	sumPricesPSQRG /= double(n);
	sumPSQRGSquared /= double(n);


	double factor = (maxPrice == minPrice ? 1.0 : maxPrice - minPrice);

	double priceDev = sqrt(fabs(sumPSquared - sumPrices * sumPrices)) / factor;
	double ppgDev = sqrt(fabs(sumPPGSquared - sumPricesPG * sumPricesPG)) / factor;
	double psqrgDev = sqrt(fabs(sumPSQRGSquared - sumPricesPSQRG * sumPricesPSQRG)) / factor;

	// -- bid graph
	double connectivity =  double(nEdges) / double(n);
	double conDev = sqrt(fabs(sqEdges / double(n) - connectivity * connectivity)) / double(n);
	maxDegree /= double(n);
	minDegree /= double(n);
	
	nEdges /= 2;
    	
	double density = nEdges / double( n*(n-1) / 2 );
//	printf("nEdges=%ld, n=%d, density=%lf\n", nEdges, n, density);
	// -- bid size stats
	int nGoods = bids.getGoodMap().size();

	avgBidSize /= double(n);
	double bidSizeDev = sqrt(fabs(sumSQBidSize / double(n) - avgBidSize * avgBidSize));
	/* FH: missing normalization by nGoods (to be equivaent to goodDegDev below)! There should be: bidSizeDev /= double(nGoods); */
	/* FH: If at all, that normalization should be done *before* taking stddev */
	avgBidSize /= double(nGoods);
	maxBidSize /= double(nGoods);
	minBidSize /= double(nGoods);
        bidSizeDev /=  double(nGoods);
	

	// -- calculate a few percentile statistics for the bid graph
	sort(degArray, degArray+n);
	double quotOne = degArray [n / 4 - 1] / double(n);
	double median = degArray [n / 2] / double(n);
	double quotThree = degArray [(3*n) / 4 - 1] / double(n);
	
	delete[] degArray;

	// -- bipartite grap properties
    
	double maxGoodDegree=-1, minGoodDegree=bids.numBids()+1;
	double avgGoodDeg=0, sqGoodDeg=0;
	
	// Lin changed this part from ngoods. ngoods is the number of active goods and it can not be used as index
	for(i=0; i<bids.numGoods(); i++)
	{
		int deg = bids.getGoodMap()[i].size();
        
    	avgGoodDeg += deg;
		sqGoodDeg += deg*deg;
		maxGoodDegree = (deg > maxGoodDegree ? deg : maxGoodDegree);
		minGoodDegree = (deg < minGoodDegree ? deg : minGoodDegree);
	}

	avgGoodDeg /= double(nGoods);
	double goodDegDev = sqrt(fabs(sqGoodDeg / double(nGoods) - avgGoodDeg * avgGoodDeg));
	avgGoodDeg /= double(n);
	goodDegDev /= double(n);
	maxGoodDegree /= double(n);
	minGoodDegree /= double(n);

	// bgTime = sw.Lap() - parseTime;
	bgTime = sw2.Lap();


	// -- Output results

	ofstream out(argv[2], ios::app);

	if(!out)
	{
		cerr << "Failed to open " << argv[2] << endl;
		return 1;

	}
	
	out      // -- size
		 << bids.numBids() << ", " << nGoods << ", "

		 // -- prices
		<< priceDev << ", "  << ppgDev << ", " << psqrgDev << ", "
		 
		 // -- bid graph
		 <<	density  << ", "
		 << conDev << ", "
		 << maxDegree << ", " 
		 << minDegree << ", "

		 // -- Good nodes in bipartite
		 <<  avgGoodDeg << ", " << goodDegDev << ", "
	         << maxGoodDegree << ", " << minGoodDegree << ", "
		 
		 // -- bid nodes in bipartite
		 << avgBidSize << ", " << bidSizeDev << ", "
		 << maxBidSize << ", " << minBidSize << ", "

		 // -- percentiles
		 << quotOne << ", " << median << ", " << quotThree << ", ";

#ifdef USE_CPLEX
	sw2.Start();
	LPfeatures(out, &bids);
	LPtime = sw2.Lap();
#endif

	sw2.Start();
	testSmallWorldBidGraph(out, bids.numBids(), bids.bidGraph, 1/*calc avg min path*/);


	totalTime = parseTime + bgTime + clusterTime + shortPathTime;
#ifdef USE_CPLEX
	totalTime+= LPtime;
#endif

	out << totalTime << ", " <<  parseTime << ", "
	<< bgTime << ", " << clusterTime << ", " << shortPathTime;
#ifdef USE_CPLEX
	out << ", " << LPtime;
#endif
	out << endl;
	out.close();
	cout << "total = " << sw.Lap() << endl;
 
	return 0;
}

 

/* adapted/copied from testbidgraph.c */
float testSmallWorldBidGraph(ofstream &fout, int bids, int **bidGraph, int calcavgpath  )
{
   int i,j, k, nn, neighbours, n1, n2;
   float avgpath, avgclustering, almost, stdevclust;
   int *neighbour, *deg;
   float *clust;
   long int *eccentricity;
   long int diameter = 0;
   long int radius = 0;
   double eccaverage=0, eccdev=0;

   neighbour = new int[bids];
   deg = new int[bids];
   clust = new float[bids];
   eccentricity = new long int[bids];

   /* Calculate the average clustering index of the graph */

 avgclustering = 0.0;
 for  ( i = 0 ; i < bids ; i++ )
 {
   neighbours = 0; 
   for ( j = 0; j < bids ; j++ )  {
      if ( bidGraph[i][j]  ) { neighbour[neighbours++] = j;   }
   }
   deg[i] = neighbours;
  
   if ( neighbours > 1 ) {
     nn = 0;
     almost = (neighbours*(neighbours-1))/2;
     for ( n1 = 0; n1 < (neighbours-1) ; n1++ )  {
       for ( n2 = n1+1; n2 < neighbours ; n2++ )  {
         if ( bidGraph[neighbour[n1]][neighbour[n2]] )  nn++;
       }
     }
     clust[i] = (((float)nn)/almost);
     avgclustering += clust[i];
   }
     else
      {  if ( neighbours == 1 ) {  clust[i] = 1.0; avgclustering += 1.0; }  else clust[i] = 0.0; }
 } 

 avgclustering /= ((float)bids);

  stdevclust = 0.0;
  for ( i = 0; i < bids ; i++ )  {
    stdevclust += ((clust[i]-avgclustering)*(clust[i]-avgclustering));
  }

  stdevclust = sqrt(stdevclust/((float)bids));


//      for(i=0; i<bids; i++)
//        {
// 	 for(j=0; j<bids; j++)
// 	   cout << bidGraph[i][j] << "\t";
// 	 cout << endl;
//        }
 
    
     // -- Set up for Floyd
     // == make sure this works
     int INF_DIST = bids << 1;

     for (i = 0; i < bids; i++) {
       eccentricity[i]=0;
        for (j = 0; j < bids; j++) {
          if ( i != j ) {  if (bidGraph[i][j] == 0)  bidGraph[i][j] = INF_DIST;  }
        }
     }

  

 // clusterTime = sw.Lap() - LPtime;
 clusterTime = sw2.Lap();
 sw2.Start();

 if ( calcavgpath ) {
   printf( "calculating shortest paths\n" );
   avgpath = 0.0;

     //floyd walsh all pairs shortest path algorithm to compute shortest distances
     for (k = 0; k < bids; k++) {
        for (i = 0; i < bids; i++) {
           for (j = i+1; j < bids; j++) {   
              bidGraph[i][j] = min( bidGraph[i][j], bidGraph[i][k]+bidGraph[k][j] );
              bidGraph[j][i] = bidGraph[i][j];

              if ( (k == (bids-1)) && (i < j) )  {

		 if(bidGraph[i][j]!=INF_DIST) 
		   {
		     avgpath += bidGraph[i][j]; 
		     if(eccentricity[i] < bidGraph[i][j])
		       eccentricity[i] = bidGraph[i][j];
		     if(eccentricity[j] < bidGraph[i][j])
		       eccentricity[j] = bidGraph[i][j];
		   }
              }  
           }// for j
        }// for i
      }//for k


     
//      for(i=0; i<bids; i++)
//        {
//       	 for(j=0; j<bids; j++)
// 	   cout << bidGraph[i][j] << "\t";
// 	 cout << endl;
//        }

    avgpath /= ((float)(bids*(bids-1)/2)); 
    radius = INF_DIST;
    diameter = 0;
    for(i=0; i<bids; i++)
      {
	// == NOTE: This notion of radius is bad for connected components
	if(eccentricity[i] < radius)
	  radius = eccentricity[i];
	if(eccentricity[i] > diameter)
	  diameter = eccentricity[i];

	eccaverage += eccentricity[i];
	eccdev += eccentricity[i] * eccentricity[i];
      }
    eccaverage /= (double)bids;
    eccdev = sqrt(fabs(eccdev/(double)bids - eccaverage * eccaverage));

    eccaverage /= double(diameter);
    eccdev /= double(diameter);
    avgpath /= double(diameter);
  }
   else avgpath = 1.0;

  shortPathTime = sw2.Lap();

  fout << double(radius) / double(diameter) <<  ", " << eccaverage << ", " <<
	  eccdev << ", " << avgclustering << ", " << avgpath << ", " <<
	  (avgclustering/avgpath) << ", " << stdevclust << ", ";


   delete[] neighbour;
   delete[] deg;
   delete[] clust;
   delete[] eccentricity;

  return (  avgclustering/avgpath );
}

#ifdef USE_CPLEX
LPData::LPData() {
  env = NULL;
  lp = NULL;
  status = 0;
}

void LPData::allocate(BidSet *b) {
  int bids = b->numBids();
  int goods = b->numGoods() + b->numDummyGoods();
  int goodsMentioned = 0;

  for(int i = 0;i < b->numBids();i++) {
    goodsMentioned += b->getBid(i)->num_goods;
  }

  obj = new double[bids];
  lb = new double[bids];
  ub = new double[bids];
  xvals = new double[bids];

  int rowsInLPMat = goods;
  int colsInLPMat = bids;
  int nonzeroInLPMat = goodsMentioned;

  rhs = new double[rowsInLPMat];
  sense = new char[rowsInLPMat];

  rmatbeg = new int[rowsInLPMat];
  rmatind = new int[nonzeroInLPMat];
  rmatval = new double[nonzeroInLPMat];

}



void LPfeatures(ofstream &fout, BidSet *bids) {

  /* Initialize the CPLEX environment */
  lpd.env = CPXopenCPLEX (&lpd.status);
  if ( lpd.env == NULL ) {
    char  errmsg[1024];
    fprintf (stderr, "Could not open CPLEX environment.\n");
    CPXgeterrorstring (lpd.env, lpd.status, errmsg);
    fprintf (stderr, "%s", errmsg);
    exit(1);
  }

  BidSet b = *bids;

  lpd.allocate(&b);
  double objval = LPsolve(&b);

  double sum = 0;
  double l2 = 0;
  double max_dist = -1;
  //  double *dists = new double[b.numBids()];
  for(int i = 0;i < b.numBids();i++) {
    double dist = min(abs(lpd.xvals[i]), abs(lpd.xvals[i] - 1));
    sum += dist;
    l2 += dist*dist;
    max_dist = max(max_dist, dist);
    //dists[i] = dist;
  }

  //  sort(dists, dists + b.numBids());

  //  double median = dists [ b.numBids() / 2 ];
  //  delete[] dists;

  fout << sum / double(b.numBids()) << ", "
       << sqrt(l2/double(b.numBids())) << ", " 
       << max_dist << ", ";

  
  return; 
}

double LPsolve(BidSet *b) {
  int bids = b->numBids();
  int goods = b->numGoods() + b->numDummyGoods();
  int goodsMentioned = 0;

  int      solstat;
  double   objval;

  for(int i = 0;i < b->numBids();i++) {
    goodsMentioned += b->getBid(i)->num_goods;
  }

  int rowsInLPMat = goods;
  int colsInLPMat = bids;
  int nonzeroInLPMat = goodsMentioned;

  int currIndex = 0;

  for(int i = 0;i < bids;i++) {
    lpd.obj[i] = b->getBid(i)->amount;
    lpd.lb[i] = 0;
    lpd.ub[i] = 1;
  }
   
   /*lpd.status = CPXsetintparam (lpd.env, CPX_PARAM_SCRIND, CPX_ON);
   if (lpd.status) {
      fprintf (stderr,
               "Failure to turn on screen indicator, error %d.\n", lpd.status);
    exit(1);
   }*/
   

   /* Turn on data checking */

   
   /*
   lpd.status = CPXsetintparam (lpd.env, CPX_PARAM_DATACHECK, CPX_ON);
   if (lpd.status) {
      fprintf (stderr,
               "Failure to turn on data checking, error %d.\n", lpd.status);
    exit(1);
   }
   */

  lpd.lp = CPXcreateprob (lpd.env, &lpd.status, "lpex1");
  if ( lpd.lp == NULL ) {
   fprintf (stderr, "Failed to create LP.\n");
   return -1;
  }

  CPXchgobjsen (lpd.env, lpd.lp, CPX_MAX);  /* Problem is maximization */
  lpd.status = CPXnewcols (lpd.env, lpd.lp, colsInLPMat, lpd.obj, lpd.lb, lpd.ub, NULL, NULL);

  int goodCount = 0;
  for(int j = 0;j < goods;j++) {
      lpd.rmatbeg[goodCount] = currIndex;
      for(int k = 0;k < bids;k++) {
	if(b->getBid(k)->contains(j)) {
	  lpd.rmatind[currIndex] = k;
	  lpd.rmatval[currIndex++] = 1;
	}
      }
      lpd.sense[goodCount] = 'L';
      lpd.rhs[goodCount] = 1;
      goodCount++;
  }

  lpd.status = CPXaddrows(lpd.env, lpd.lp, 0, rowsInLPMat, nonzeroInLPMat, lpd.rhs, lpd.sense, lpd.rmatbeg,
  lpd.rmatind, lpd.rmatval, NULL, NULL);

   /*lpd.status = CPXwriteprob (lpd.env, lpd.lp, "try1.lp", NULL);
   if ( lpd.status ) {
      fprintf (stderr, "Failed to write LP to disk.\n");
      exit(1);
   }*/



  lpd.status = CPXlpopt (lpd.env, lpd.lp);
  if (lpd.status) {
    fprintf (stderr, "Failed to optimize LP.\n");
  }

  lpd.status = CPXsolution (lpd.env, lpd.lp, &solstat, &objval, lpd.xvals, NULL, NULL, NULL);


  if ( lpd.lp != NULL ) {
    lpd.status = CPXfreeprob (lpd.env, &lpd.lp);
    if (lpd.status) {
      fprintf (stderr, "CPXfreeprob failed, error code %d.\n", lpd.status);
    }
  }
  lpd.lp = NULL;
//  printf("lp solve = %f\n", objval);
  return objval;
}
#endif // -- USE_CPLEX
