///////////////////////////////////////////////
/* Stores a full or partial (bid) allocation */
///////////////////////////////////////////////

#ifdef WIN32
#pragma warning (disable : 4786)
#endif

#ifndef BID_H
#define BID_H

#include <set>
using namespace std;

class Bid {

public:
	Bid(double a, int i = 0);
	~Bid();

	double amount;
	int bid_num;
	int indexInBidSet;
	int num_goods;
	bool visited;
	//set<Bid*> conflicts; // -- Set of conflicting bids

	int conflicts; //Number of conflicts - o.w. runs out of memory

	int firstDummyGood(int total_goods);
	void addGood(int g);

	inline void removeGood(int g) {
		array[indexOf(g)] = array[--num_goods]; // it's OK if these are the same
		sorted = false;
	}
	inline int getGood(int index) { return array[index]; }
	inline bool contains(int g) {
		return (indexOf(g) >= 0);
	}

	bool subsetEqualOf(Bid *other);

	bool conflictsWith(Bid *other);

protected:
	int *array;
	int array_size;
	int indexOf(int g);
	void sort();
	bool sorted;
	void sortFrom(int begin, int end, int *tempArray);
	void merge(int leftBegin, int rightBegin, int rightEnd, int *tempArray);

};

#endif
