// Param.h: interface for the Param class.
//
//////////////////////////////////////////////////////////////////////

#ifdef WIN32
#pragma warning (disable : 4786)
#endif

#ifndef _PARAM_H_
#define _PARAM_H_

#include <string.h>

/* #ifdef DNAME_DEF
const int dname_count = 7;
const char *dname[] = {"arbitrary","matching","multipaths","paths","regions","scheduling", "legacy"};
#else
extern const int dname_count;
extern const char *dname[];
#endif */

#ifndef _WIN32
#ifndef stricmp
#define stricmp strcasecmp
#endif
#endif

class Param   {

public:
  static const char* CATS_VERSION_STRING; // = "2.1"

  static const int dname_count; // = 7
  static const char* dname[]; // = {"arbitrary","matching","multipaths","paths","regions","scheduling", "legacy"}

	void usage();
	static double ERand(unsigned short x[3]);
	static int Round(double val);
	// functions
	void Seed();
	static double DRand();
	static long LRand();
	static double DRand(double minval, double maxval);
	static long LRand(long minval, long maxval);
	Param(char** argv, int argc);
	virtual ~Param();
	char *outputSettings(bool tofile);
	int output_frequency;

	// general variables
	enum dist_type { ARBITRARY, MATCHING, MULTIPATHS, PATHS, REGIONS, SCHEDULING, LEGACY, UNASSIGNED};
	dist_type distribution;
	int num_runs;
	bool cplex_output;
	int random_seed, random_seed2;
	const char *filename;
	const char *cplex_filename;
	bool converting;


	int num_bids;
	bool random_bids;
	int min_bids, max_bids;

	int num_goods;
	bool random_goods;
	int min_goods, max_goods;

	bool remove_dominated_bids;
	bool output_parameter_settings;
	bool integer_prices;
	bool parse_error;
	bool verbatim;
	bool random_parameters;
	int bid_alpha; // for rounding to integer


private:
	char *output_settings_buffer;
};

#endif
