#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chess.h"
#include "data.h"

/* by albert 030318  */

/***********************************************

  SpeedTest(): Test the speed of a search alg.

*/

void SpeedTest(){

  FILE* infile;
  TREE * const tree=local[0];

  long time=0, positions=0;
  char tbuffer[512];


  /* parse args */
  strcpy(tbuffer, buffer);
  nargs=ReadParse(tbuffer,args," ;");
  if (nargs<3){
	printf("usage: speedtest <file> <depth>\n");
	return;
  }

  infile=fopen(args[1], "r");
  if (infile==NULL){
	Print(4095,"unable to open %s for input\n", args[1]);
	return;
  }

  search_depth=atoi(args[2]);
  search_time_limit= 60000;

  annotate_mode=1;
  ponder=0;
  swindle_mode=0;

  if (book_file) {
    fclose(book_file);
    fclose(books_file);
    book_file=0;
    books_file=0;
  }

  while(1){
	if (!fgets(tbuffer,512,infile))break;
	if (! strchr(tbuffer, '/')) continue;

	strcpy(buffer,"setboard ");
	strcpy(buffer+9,tbuffer);

	nargs=ReadParse(buffer,args," ;");
	Option(tree);


	InitializeHashTables();
	last_pv.pathd=0;
	thinking=1;
	tree->position[1]=tree->position[0];
	(void)Iterate(wtm, think, 0);

	thinking=0;
	if (iteration_depth!=search_depth){
	  Print(4095,"Searched %d plies deep\n", iteration_depth);
	  continue;
	}

	time+= end_time-start_time;
	++positions;
  }

  annotate_mode=0;
  fclose(infile);

  Print(4095, "\n\n");
  Print(4095, "total positions searched:\t%ld\n", positions);
  Print(4095, "total search time:\t%.2f\n", time/100.0);
  Print(4095, "avg time per positon:\t%.2f\n", (time/100.0)/positions);

}
