//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC

/////////////////////////////////////////////////////////////////////
////                                                             ////
////  Internal DMA Engine                                        ////
////                                                             ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          rudi@asics.ws                                      ////
////                                                             ////
////                                                             ////
////  Downloaded from: http://www.opencores.org/cores/usb/       ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000-2003 Rudolf Usselmann                    ////
////                         www.asics.ws                        ////
////                         rudi@asics.ws                       ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
////     THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY     ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED   ////
//// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS   ////
//// FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL THE AUTHOR      ////
//// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,         ////
//// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    ////
//// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE   ////
//// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        ////
//// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF  ////
//// LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT  ////
//// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  ////
//// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         ////
//// POSSIBILITY OF SUCH DAMAGE.                                 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////

//  CVS Log
//
//  $Id: usbf_idma.v,v 1.8 2003/10/17 02:36:57 rudi Exp $
//
//  $Date: 2003/10/17 02:36:57 $
//  $Revision: 1.8 $
//  $Author: rudi $
//  $Locker:  $
//  $State: Exp $
//
// Change History:
//               $Log: usbf_idma.v,v $
//               Revision 1.8  2003/10/17 02:36:57  rudi
//               - Disabling bit stuffing and NRZI encoding during speed negotiation
//               - Now the core can send zero size packets
//               - Fixed register addresses for some of the higher endpoints
//                 (conversion between decimal/hex was wrong)
//               - The core now does properly evaluate the function address to
//                 determine if the packet was intended for it.
//               - Various other minor bugs and typos
//
//               Revision 1.7  2001/11/04 12:22:45  rudi
//
//               - Fixed previous fix (brocke something else ...)
//               - Majore Synthesis cleanup
//
//               Revision 1.6  2001/11/03 03:26:22  rudi
//
//               - Fixed several interrupt and error condition reporting bugs
//
//               Revision 1.5  2001/09/24 01:15:28  rudi
//
//               Changed reset to be active high async.
//
//               Revision 1.4  2001/09/23 08:39:33  rudi
//
//               Renamed DEBUG and VERBOSE_DEBUG to USBF_DEBUG and USBF_VERBOSE_DEBUG ...
//
//               Revision 1.3  2001/09/19 14:38:57  rudi
//
//               Fixed TxValid handling bug.
//
//               Revision 1.2  2001/09/13 13:14:02  rudi
//
//               Fixed a problem that would sometimes prevent the core to come out of
//               reset and immediately be operational ...
//
//               Revision 1.1  2001/08/03 05:30:09  rudi
//
//
//               1) Reorganized directory structure
//
//               Revision 1.2  2001/03/31 13:00:51  rudi
//
//               - Added Core configuration
//               - Added handling of OUT packets less than MAX_PL_SZ in DMA mode
//               - Modified WISHBONE interface and sync logic
//               - Moved SSRAM outside the core (added interface)
//               - Many small bug fixes ...
//
//               Revision 1.0  2001/03/07 09:17:12  rudi
//
//
//               Changed all revisions to revision 1.0. This is because OpenCores CVS
//               interface could not handle the original '0.1' revision ....
//
//               Revision 0.1.0.1  2001/02/28 08:10:50  rudi
//               Initial Release
//
//                            

`include "usbf_defines.v"

module usbf_idma(/*AUTOARG*/
   // Outputs
   send_data, tx_data_st7, tx_data_st6, tx_data_st5, tx_data_st4,
   tx_data_st3, tx_data_st2, tx_data_st1, tx_data_st0, idma_done,
   sizu_c10, sizu_c9, sizu_c8, sizu_c7, sizu_c6, sizu_c5, sizu_c4,
   sizu_c3, sizu_c2, sizu_c1, sizu_c0, madr14, madr13, madr12, madr11,
   madr10, madr9, madr8, madr7, madr6, madr5, madr4, madr3, madr2,
   madr1, madr0, mdout31, mdout30, mdout29, mdout28, mdout27, mdout26,
   mdout25, mdout24, mdout23, mdout22, mdout21, mdout20, mdout19,
   mdout18, mdout17, mdout16, mdout15, mdout14, mdout13, mdout12,
   mdout11, mdout10, mdout9, mdout8, mdout7, mdout6, mdout5, mdout4,
   mdout3, mdout2, mdout1, mdout0, mwe, mreq, 
   usbf_idma_state,//FMP_VC_0
   send_data_r,  send_zero_length_r,//FMP_VC_0
   rx_dma_en_r ,//FMP_VC_0
   // Inputs
   clk, rst, rx_data_st, rx_data_valid, rx_data_done, rd_next,
   rx_dma_en, tx_dma_en, abort, buf_size, dma_en, send_zero_length,
   adr, size, mdin, mack
   );
   
   //FMP_VC_2 //parameter	SSRAM_HADR = 14;
	 
   output [7:0] usbf_idma_state;//FMP_VC_0
   output 	send_data_r,  send_zero_length_r;//FMP_VC_0
   output 	rx_dma_en_r;//FMP_VC_0
   
   // Packet Disassembler/Assembler interface
   input 	clk, rst;
   input [7:0] 	rx_data_st;
   input 	rx_data_valid;
   input 	rx_data_done;
   output 	send_data;
   //FMP_VC_1//output	[7:0]	tx_data_st;
   output 	tx_data_st7;
   output 	tx_data_st6;
   output 	tx_data_st5;
   output 	tx_data_st4;
   output 	tx_data_st3;
   output 	tx_data_st2;
   output 	tx_data_st1;
   output 	tx_data_st0;
   
   input 	rd_next;
   
   // Protocol Engine
   input 	rx_dma_en;	// Allows the data to be stored
   input 	tx_dma_en;	// Allows for data to be retrieved
   input 	abort;		// Abort Transfer (time_out, crc_err or rx_error)
   output 	idma_done;	// DMA is done
   input [13:0] buf_size;	// Actual buffer size
   input 	dma_en;		// External DMA enabled
   input 	send_zero_length;
   
   // Register File Manager Interface
   //FMP_VC_2//FMP_VC_6//input	[(SSRAM_HADR + 2):0]	adr;	// Byte Address
   input [16:0] adr;	// Byte Address
   input [13:0] size;		// Size in bytes
   //FMP_VC_1//output	[10:0]	sizu_c;		// Up and Down counting size registers, used to update
   output 	sizu_c10;
   output 	sizu_c9;
   output 	sizu_c8;
   output 	sizu_c7;
   output 	sizu_c6;
   output 	sizu_c5;
   output 	sizu_c4;
   output 	sizu_c3;
   output 	sizu_c2;
   output 	sizu_c1;
   output 	sizu_c0;
   
   
   // Memory Arb interface
   //FMP_VC_1//output	[14:0]	madr;	// word address
   output 	madr14;
   output 	madr13;
   output 	madr12;
   output 	madr11;
   output 	madr10;
   output 	madr9;
   output 	madr8;
   output 	madr7;
   output 	madr6;
   output 	madr5;
   output 	madr4;
   output 	madr3;
   output 	madr2;
   output 	madr1;
   output 	madr0;
   
   //FMP_VC_1//output	[31:0]	mdout;
   output 	mdout31;  
   output 	mdout30;  
   output 	mdout29;  
   output 	mdout28;  
   output 	mdout27;  
   output 	mdout26;  
   output 	mdout25;  
   output 	mdout24;  
   output 	mdout23;  
   output 	mdout22;  
   output 	mdout21;  
   output 	mdout20;  
   output 	mdout19;  
   output 	mdout18;  
   output 	mdout17;  
   output 	mdout16;  
   output 	mdout15;  
   output 	mdout14;  
   output 	mdout13;  
   output 	mdout12;  
   output 	mdout11;  
   output 	mdout10;  
   output 	mdout9;  
   output 	mdout8;  
   output 	mdout7;  
   output 	mdout6;  
   output 	mdout5;  
   output 	mdout4;  
   output 	mdout3;  
   output 	mdout2;  
   output 	mdout1;  
   output 	mdout0;  
   
   input [31:0] mdin;
   output 	mwe;
   output 	mreq;
   input 	mack;
   
///////////////////////////////////////////////////////////////////
//
// Local Wires and Registers
//

/* -----\/----- EXCLUDED -----\/-----
//FMP_VC_2
 parameter	[7:0]	// synopsys enum state
		IDLE		= 8'b00000001,
		WAIT_MRD	= 8'b00000010,
		MEM_WR		= 8'b00000100,
		MEM_WR1		= 8'b00001000,
		MEM_WR2		= 8'b00010000,
		MEM_RD1		= 8'b00100000,
		MEM_RD2		= 8'b01000000,
		MEM_RD3		= 8'b10000000;
 -----/\----- EXCLUDED -----/\----- */

   reg [7:0] 	/* synopsys enum state */ state, next_state;
   // synopsys state_vector state

   reg		tx_dma_en_r, rx_dma_en_r;
   
   reg [14:0] 	adr_cw;		// Internal word address counter
   reg [2:0] 	adr_cb;			// Internal byte address counter
   reg [14:0] 	adrw_next;	// next address
   reg [14:0] 	adrw_next1;	// next address (after overrun check)
   reg [14:0] 	last_buf_adr;	// Last Buffer Address
   reg [2:0] 	adrb_next;		// next byte address
   reg [13:0] 	sizd_c;			// Internal size counter
   reg [10:0] 	sizu_c;			// Internal size counter
   wire		adr_incw;
   wire		adr_incb;
   wire		siz_dec;
   wire		siz_inc;
   
   reg		word_done;		// Indicates that a word has been
   // assembled
   reg		mreq_d;			// Memory request from State Machine
   reg [31:0] 	dtmp_r;			// Temp data assembly register
   reg [31:0] 	dout_r;			// Data output register
   reg		mwe_d;			// Memory Write enable
   reg		dtmp_sel;		// Selects tmp data register for pre-fetch
   
   reg		sizd_is_zero;		// Indicates when all bytes have been
   // transferred
   wire		sizd_is_zero_d;
   
   reg [7:0] 	tx_data_st;		// Data output to packet assembler
   reg [31:0] 	rd_buf0, rd_buf1;	// Mem Rd. buffers for TX
   reg		rd_first;		// Indicates initial fill of buffers
   
   reg		idma_done;		// DMA transfer is done
   
   reg		mack_r;
   wire		send_data;		// Enable UTMI Transmitter
   reg		send_data_r;
   
   reg		word_done_r;
   reg		wr_last;
   reg		wr_last_en;
   reg		wr_done;
   reg		wr_done_r;
   reg		dtmp_sel_r;
   reg		mwe;
   reg		rx_data_done_r2;
   wire		fill_buf0, fill_buf1;
   wire		adrb_is_3;
   
   reg		rx_data_done_r;
   reg		rx_data_valid_r;
   reg [7:0] 	rx_data_st_r;
   
   reg		send_zero_length_r;
   
   

///////////////////////////////////////////////////////////////////
//
// Memory Arb interface
//

   // Memory Request
   assign 	mreq = (mreq_d & !mack_r) | word_done_r;
   
   // Output Data
   //FMP_VC_3//assign mdout = dout_r;
   wire [31:0] 	mdout = dout_r;
   // Memory Address
   //FMP_VC_3//assign madr = adr_cw;
   wire [14:0] 	madr = adr_cw;
   
   always @(posedge clk)
     mwe <= mwe_d;

   always @(posedge clk)
     mack_r <= mreq & mack;

   
   //FMP_VC_1
   assign 	mdout31 = mdout[31:31];
   assign 	mdout30 = mdout[30:30];
   assign 	mdout29 = mdout[29:29];
   assign 	mdout28 = mdout[28:28];
   assign 	mdout27 = mdout[27:27];
   assign 	mdout26 = mdout[26:26];
   assign 	mdout25 = mdout[25:25];
   assign 	mdout24 = mdout[24:24];
   assign 	mdout23 = mdout[23:23];
   assign 	mdout22 = mdout[22:22];
   assign 	mdout21 = mdout[21:21];
   assign 	mdout20 = mdout[20:20];
   assign 	mdout19 = mdout[19:19];
   assign 	mdout18 = mdout[18:18];
   assign 	mdout17 = mdout[17:17];
   assign 	mdout16 = mdout[16:16];
   assign 	mdout15 = mdout[15:15];
   assign 	mdout14 = mdout[14:14];
   assign 	mdout13 = mdout[13:13];
   assign 	mdout12 = mdout[12:12];
   assign 	mdout11 = mdout[11:11];
   assign 	mdout10 = mdout[10:10];
   assign 	mdout9  = mdout[9:9];
   assign 	mdout8  = mdout[8:8];
   assign 	mdout7  = mdout[7:7];
   assign 	mdout6  = mdout[6:6];
   assign 	mdout5  = mdout[5:5]; 
   assign 	mdout4  = mdout[4:4];
   assign 	mdout3  = mdout[3:3];
   assign 	mdout2  = mdout[2:2];
   assign 	mdout1  = mdout[1:1];
   assign 	mdout0  = mdout[0:0];
 
   //FMP_VC_1
   assign   madr14 = madr[14:14];
   assign   madr13 = madr[13:13];
   assign   madr12 = madr[12:12];
   assign   madr11 = madr[11:11];
   assign   madr10 = madr[10:10];
   assign   madr9  = madr[9:9];
   assign   madr8  = madr[8:8];
   assign   madr7  = madr[7:7];
   assign   madr6  = madr[6:6];
   assign   madr5  = madr[5:5]; 
   assign   madr4  = madr[4:4];
   assign   madr3  = madr[3:3];
   assign   madr2  = madr[2:2];
   assign   madr1  = madr[1:1];
   assign   madr0  = madr[0:0];
 




   /* FMP_VC_4*/
// synopsys translate_off
`ifdef VCEGAR
   initial begin
      mwe     =  1'd0;
      mack_r  =  1'd0;
      rx_data_valid_r         =  1'd0;
      rx_data_st_r    =  8'd0;
      rx_data_done_r  =  1'd0;
      tx_dma_en_r     =  1'd0;
      rx_dma_en_r     =  1'd0;
      send_zero_length_r      =  1'd0;
      adr_cw  =  15'd0;
      last_buf_adr    =  15'd0;
      adr_cb  =  3'd0;
      sizd_c  =  14'h3fff;
      sizd_is_zero    =  1'd0;
      sizu_c  =  11'd0;
      idma_done       =  1'd0;
      dtmp_sel_r      =  1'd0;
      dtmp_r  =  32'd0;
      word_done       =  1'd0;
      dout_r  =  32'd0;
      wr_last         =  1'd0;
      wr_done_r       =  1'd0;
      wr_done         =  1'd0;
      rd_buf0         =  32'd0;
      rd_buf1         =  32'd0;
      send_data_r     =  1'd0;
      state   =  8'd1;
      rx_data_done_r2       =  1'd0;
      word_done_r   =  1'd0;
   end
`endif
// synopsys translate_on   
   //FMP_VC_0
   assign  usbf_idma_state = state;
   
///////////////////////////////////////////////////////////////////
//
// Misc Logic
//

   always @(posedge clk)
     rx_data_valid_r <= rx_data_valid;
   
   always @(posedge clk)
     rx_data_st_r <= rx_data_st;
   
   always @(posedge clk)
     rx_data_done_r <= rx_data_done;
   
   always @(posedge clk)
     rx_data_done_r2 <= rx_data_done_r;
   
   // Generate one cycle pulses for tx and rx dma enable
   always @(posedge clk)
     tx_dma_en_r <= tx_dma_en;
   
   always @(posedge clk)
     rx_dma_en_r <= rx_dma_en;
   
   always @(posedge clk)
     send_zero_length_r <= send_zero_length;
   
   // address counter
   always @(posedge clk)
    //FMP_VC_2//FMP_VC_6//	if(rx_dma_en_r || tx_dma_en_r)	adr_cw <= adr[(14 + 2):2];
     if(rx_dma_en_r || tx_dma_en_r)	adr_cw <= adr[16:2];
     else				adr_cw <= adrw_next1;

   always @(posedge clk)
     last_buf_adr <= adr + { {14+2-13{1'b0}}, buf_size };
   
   always @(dma_en or adrw_next or last_buf_adr)
     //FMP_VC_2//FMP_VC_6//	if(adrw_next == last_buf_adr && dma_en)	adrw_next1 = {14+1{1'b0}};
     if(adrw_next == last_buf_adr && dma_en)	adrw_next1 = {15{1'b0}};
     else					adrw_next1 = adrw_next;
   
   always @(adr_incw or adr_cw)
     if(adr_incw)	adrw_next = adr_cw + {{14{1'b0}}, 1'b1};
     else		adrw_next = adr_cw;
   
`ifdef USBF_ASYNC_RESET
   always @(posedge clk or negedge rst)
`else
     always @(posedge clk)
`endif
       if(!rst)			adr_cb <= 3'h0;
       else
	 if(rx_dma_en_r || tx_dma_en_r)	adr_cb <= adr[2:0];
	 else				adr_cb <= adrb_next;
   
   always @(adr_incb or adr_cb)
     if(adr_incb)	adrb_next = adr_cb + 3'h1;
     else		adrb_next = adr_cb;
   
   assign  adr_incb = rx_data_valid_r | rd_next;
   assign  adr_incw = !dtmp_sel_r & mack_r;
   
   // Size Counter (counting backward from input size)
`ifdef USBF_ASYNC_RESET
   always @(posedge clk or negedge rst)
`else
     always @(posedge clk)
`endif
       if(!rst)			sizd_c <= 14'h3fff;
       else
	 if(tx_dma_en || tx_dma_en_r)	sizd_c <= size;
	 else
	   if(siz_dec)			sizd_c <= sizd_c - 14'h1;
   
   assign  siz_dec = (rd_first & mack_r) | (rd_next & (sizd_c != 14'h0));
   
   assign  sizd_is_zero_d = sizd_c == 14'h0;
   
   always @(posedge clk)
     sizd_is_zero <= sizd_is_zero_d;
   
   // Size Counter (counting up from zero)
`ifdef USBF_ASYNC_RESET
   always @(posedge clk or negedge rst)
`else
     always @(posedge clk)
`endif
       if(!rst)		sizu_c <= 11'h0;
       else
	// Do I need to add "abort" in the next line ???
	 if(rx_dma_en_r)		sizu_c <= 11'h0;
	 else
	   if(siz_inc)		sizu_c <= sizu_c + 11'h1;
   
   assign  siz_inc = rx_data_valid_r;
   
   //FMP_VC_1
   assign    sizu_c10 = sizu_c[10:10];
   assign    sizu_c9 = 	sizu_c[9:9];
   assign    sizu_c8 = 	sizu_c[8:8];
   assign    sizu_c7 = 	sizu_c[7:7];
   assign    sizu_c6 = 	sizu_c[6:6];
   assign    sizu_c5 = 	sizu_c[5:5];
   assign    sizu_c4 = 	sizu_c[4:4];
   assign    sizu_c3 = 	sizu_c[3:3];
   assign    sizu_c2 = 	sizu_c[2:2];
   assign    sizu_c1 = 	sizu_c[1:1];
   assign    sizu_c0 = 	sizu_c[0:0];

   // DMA Done Indicator
   always @(posedge clk)
     idma_done <= (rx_data_done_r | sizd_is_zero_d); // & !tx_dma_en;
   
///////////////////////////////////////////////////////////////////
//
// RX Logic
//

   always @(posedge clk)
     dtmp_sel_r <= dtmp_sel;
   
   // Memory data input
   always @(posedge clk)
     if(dtmp_sel_r)			dtmp_r <= mdin;
     else
       if(rx_data_valid_r)
	 begin
	    if(adr_cb[1:0] == 2'h0)	dtmp_r[07:00] <= rx_data_st_r;
	    if(adr_cb[1:0] == 2'h1)	dtmp_r[15:08] <= rx_data_st_r;
	    if(adr_cb[1:0] == 2'h2)	dtmp_r[23:16] <= rx_data_st_r;
	    if(adr_cb[1:0] == 2'h3)	dtmp_r[31:24] <= rx_data_st_r;
	 end
   
   always @(posedge clk)
     word_done <= ((adr_cb[1:0] == 2'h3) & rx_data_valid_r) | wr_last;
   
   always @(posedge clk)
     word_done_r <= word_done & !word_done_r;

   // Store output data and address when we got a word
   always @(posedge clk)
     if(word_done)	dout_r <= dtmp_r;

   always @(posedge clk)
     wr_last <= (adr_cb[1:0] != 2'h0) & !rx_data_valid_r & wr_last_en;
   
   always @(posedge clk)
     wr_done_r <= rx_data_done_r;
   
   always @(posedge clk)
     wr_done <= wr_done_r;
   
///////////////////////////////////////////////////////////////////
//
// TX Logic
//

// Fill TX Buffers
   always @(posedge clk)
     if(fill_buf0)	rd_buf0 <= mdin;
   
   always @(posedge clk)
     if(fill_buf1)	rd_buf1 <= mdin;
   
   always @(adrb_next or rd_buf0 or rd_buf1)
     case(adrb_next[2:0])	// synopsys full_case parallel_case
       3'h0: tx_data_st = rd_buf0[07:00];
       3'h1: tx_data_st = rd_buf0[15:08];
       3'h2: tx_data_st = rd_buf0[23:16];
       3'h3: tx_data_st = rd_buf0[31:24];
       3'h4: tx_data_st = rd_buf1[07:00];
       3'h5: tx_data_st = rd_buf1[15:08];
       3'h6: tx_data_st = rd_buf1[23:16];
       3'h7: tx_data_st = rd_buf1[31:24];
// synopsys translate_off
       default:  tx_data_st = 8'hde; //FMP_VC_5 
// synopsys translate_on
     endcase // case(adrb_next[2:0])
   //FMP_VC_1   
   assign tx_data_st7 = tx_data_st[7:7];
   assign tx_data_st6 = tx_data_st[6:6];
   assign tx_data_st5 = tx_data_st[5:5];
   assign tx_data_st4 = tx_data_st[4:4];
   assign tx_data_st3 = tx_data_st[3:3];
   assign tx_data_st2 = tx_data_st[2:2];
   assign tx_data_st1 = tx_data_st[1:1];
   assign tx_data_st0 = tx_data_st[0:0];

		    
   assign fill_buf0 = !adr_cw[0] & mack_r;
   assign fill_buf1 =  adr_cw[0] & mack_r;
   
   assign adrb_is_3 = adr_cb[1:0] == 2'h3;
   
`ifdef USBF_ASYNC_RESET
   always @(posedge clk or negedge rst)
`else
     always @(posedge clk)
`endif
       if(!rst)		send_data_r <= 1'b0;
       else
	 if(rd_first)		send_data_r <= 1'b1;
	 else
	   if(((sizd_c==14'h1) && rd_next) || sizd_is_zero_d)	send_data_r <= 1'b0;
   
   assign send_data = send_data_r | send_zero_length_r;
   
///////////////////////////////////////////////////////////////////
//
// IDMA Load/Store State Machine
//

// store incoming data to memory until rx_data done
// First pre-fetch data from memory, so that bytes can be stuffed properly


`ifdef USBF_ASYNC_RESET
   always @(posedge clk or negedge rst)
`else
     always @(posedge clk)
`endif
       if(!rst)	state <= 8'b00000001;
       else		state <= next_state;
   
   always @(state or mack_r or abort or rx_dma_en_r or tx_dma_en_r or 
	    sizd_is_zero or wr_last or wr_done or rx_data_done_r2 or 
	    rd_next or adrb_is_3 or send_zero_length_r)
     begin
	next_state = state;	// Default do not change state
	mreq_d = 1'b0;
	mwe_d = 1'b0;
	rd_first = 1'b0;
	dtmp_sel = 1'b0;
	wr_last_en = 1'b0;
	
	case(state)	// synopsys full_case parallel_case
	  8'b00000001:
	    begin

// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered IDLE state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(rst)
begin
if(rx_dma_en_r === 1'bx)	$display("ERROR: IDMA: IDLE: rx_dma_en_r is unknown. (%t)", $time);
if(tx_dma_en_r === 1'bx)	$display("ERROR: IDMA: IDLE: tx_dma_en_r is unknown. (%t)", $time);
if(abort === 1'bx)		$display("ERROR: IDMA: IDLE: abort is unknown. (%t)", $time);
end
`endif
// synopsys translate_on

	       if(rx_dma_en_r && !abort)
		 begin
		    next_state = 8'b00000010;
		 end
	       if(tx_dma_en_r && !abort && !send_zero_length_r)
		 begin
		    next_state = 8'b00100000;
		 end
	    end
	  
	  8'b00000010:	// Pre-fetch a word from memory
	    begin
	       
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered WAIT_MRD state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(abort === 1'bx)	$display("ERROR: IDMA: WAIT_MRD: abort is unknown. (%t)", $time);
if(mack_r === 1'bx)	$display("ERROR: IDMA: WAIT_MRD: mack_r is unknown. (%t)", $time);
`endif
// synopsys translate_on

	       if(abort)	next_state = 8'b00000001;
	       else
		 if(mack_r)	next_state = 8'b00000100;
		 else
		   begin
		      dtmp_sel = 1'b1;
		      mreq_d = 1'b1;
		   end
	    end
	  
	  8'b00000100:
	    begin

// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered MEM_WR state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(abort === 1'bx)	$display("ERROR: IDMA: MEM_WR: abort is unknown. (%t)", $time);
if(rx_data_done_r2 === 1'bx)	$display("ERROR: IDMA: MEM_WR: rx_data_done_r2 is unknown. (%t)", $time);
`endif
// synopsys translate_on

	       mwe_d = 1'b1;
	       if(abort)			next_state = 8'b00000001;
	       else
		 if(rx_data_done_r2)	
		   begin
		      wr_last_en = 1'b1;
		      next_state = 8'b00001000;
		   end
	       
	    end
	  8'b00001000:
	    begin

// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered MEM_WR1 state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(abort === 1'bx)	$display("ERROR: IDMA: MEM_WR1: abort is unknown. (%t)", $time);
if(wr_last === 1'bx)	$display("ERROR: IDMA: MEM_WR1: wr_last is unknown. (%t)", $time);
if(wr_done === 1'bx)	$display("ERROR: IDMA: MEM_WR1: wr_done is unknown. (%t)", $time);
`endif
// synopsys translate_on

	       mwe_d = 1'b1;
	       wr_last_en = 1'b1;
	       if(abort)			next_state = 8'b00000001;
	       else
		 if(wr_last)			next_state = 8'b00010000;
		 else
		   if(wr_done)			next_state = 8'b00000001;
	    end
	  
	  8'b00010000:
	    begin
	       
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered MEM_WR2 state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(mack_r === 1'bx)	$display("ERROR: IDMA: MEM_WR2: mack_r is unknown. (%t)", $time);
`endif
// synopsys translate_on
	       
	       mwe_d = 1'b1;
	       if(mack_r)			next_state = 8'b00000001;
	    end
	  
	  8'b00100000:
	    begin
	       
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered MEM_RD1 state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(abort === 1'bx)	$display("ERROR: IDMA: MEM_RD1: abort is unknown. (%t)", $time);
if(mack_r === 1'bx)	$display("ERROR: IDMA: MEM_RD1: mack_r is unknown. (%t)", $time);
`endif
// synopsys translate_on

	       mreq_d = 1'b1;
	       if(mack_r)		rd_first = 1'b1;
	       if(abort)		next_state = 8'b00000001;
	       else
		 if(mack_r)		next_state = 8'b01000000;
	    end
	  8'b01000000:
	    begin

// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered MEM_RD2 state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(abort === 1'bx)	$display("ERROR: IDMA: MEM_RD2: abort is unknown. (%t)", $time);
if(mack_r === 1'bx)	$display("ERROR: IDMA: MEM_RD2: mack_r is unknown. (%t)", $time);
`endif
// synopsys translate_on

	       mreq_d = 1'b1;
	       if(abort)		next_state = 8'b00000001;
	       else
		 if(mack_r)		next_state = 8'b10000000;
	    end
	  8'b10000000:
	    begin

// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
$display("IDMA: Entered MEM_RD3 state (%t)", $time);
`endif
`ifdef USBF_DEBUG
if(abort === 1'bx)	$display("ERROR: IDMA: MEM_RD3: abort is unknown. (%t)", $time);
if(sizd_is_zero===1'bx) $display("ERROR: IDMA: MEM_RD3: sizd_is_zero is unknown. (%t)", $time);
if(adrb_is_3 === 1'bx)	$display("ERROR: IDMA: MEM_RD3: adrb_is_3 is unknown. (%t)", $time);
if(rd_next === 1'bx)	$display("ERROR: IDMA: MEM_RD3: rd_next is unknown. (%t)", $time);
`endif
// synopsys translate_on

	       if(sizd_is_zero || abort)	next_state = 8'b00000001;
	       else
		 if(adrb_is_3 && rd_next)	next_state = 8'b01000000;
	    end // case: 8'b10000000
// synopsys translate_off
	  default : next_state = 8'hde; //FMP_VC_5
// synopsys translate_on
	endcase
     end
endmodule // usbf_idma


