//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC

/////////////////////////////////////////////////////////////////////
////                                                             ////
////  Protocol Engine                                            ////
////  Performs automatic protocol functions                      ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          rudi@asics.ws                                      ////
////                                                             ////
////                                                             ////
////  Downloaded from: http://www.opencores.org/cores/usb/       ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000-2003 Rudolf Usselmann                    ////
////                         www.asics.ws                        ////
////                         rudi@asics.ws                       ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
////     THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY     ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED   ////
//// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS   ////
//// FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL THE AUTHOR      ////
//// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,         ////
//// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    ////
//// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE   ////
//// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        ////
//// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF  ////
//// LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT  ////
//// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  ////
//// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         ////
//// POSSIBILITY OF SUCH DAMAGE.                                 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////

//  CVS Log
//
//  $Id: usbf_pe.v,v 1.8 2003/10/17 02:36:57 rudi Exp $
//
//  $Date: 2003/10/17 02:36:57 $
//  $Revision: 1.8 $
//  $Author: rudi $
//  $Locker:  $
//  $State: Exp $
//
// Change History:
//               $Log: usbf_pe.v,v $
//               Revision 1.8  2003/10/17 02:36:57  rudi
//               - Disabling bit stuffing and NRZI encoding during speed negotiation
//               - Now the core can send zero size packets
//               - Fixed register addresses for some of the higher endpoints
//                 (conversion between decimal/hex was wrong)
//               - The core now does properly evaluate the function address to
//                 determine if the packet was intended for it.
//               - Various other minor bugs and typos
//
//               Revision 1.7  2001/11/04 12:22:45  rudi
//
//               - Fixed previous fix (brocke something else ...)
//               - Majore Synthesis cleanup
//
//               Revision 1.6  2001/11/03 03:26:22  rudi
//
//               - Fixed several interrupt and error condition reporting bugs
//
//               Revision 1.5  2001/09/24 01:15:28  rudi
//
//               Changed reset to be active high async.
//
//               Revision 1.4  2001/09/23 08:39:33  rudi
//
//               Renamed DEBUG and VERBOSE_DEBUG to USBF_DEBUG and USBF_VERBOSE_DEBUG ...
//
//               Revision 1.3  2001/09/13 13:14:02  rudi
//
//               Fixed a problem that would sometimes prevent the core to come out of
//               reset and immediately be operational ...
//
//               Revision 1.2  2001/08/10 08:48:33  rudi
//
//               - Changed IO names to be more clear.
//               - Uniquifyed define names to be core specific.
//
//               Revision 1.1  2001/08/03 05:30:09  rudi
//
//
//               1) Reorganized directory structure
//
//               Revision 1.2  2001/03/31 13:00:51  rudi
//
//               - Added Core configuration
//               - Added handling of OUT packets less than MAX_PL_SZ in DMA mode
//               - Modified WISHBONE interface and sync logic
//               - Moved SSRAM outside the core (added interface)
//               - Many small bug fixes ...
//
//               Revision 1.0  2001/03/07 09:17:12  rudi
//
//
//               Changed all revisions to revision 1.0. This is because OpenCores CVS
//               interface could not handle the original '0.1' revision ....
//
//               Revision 0.2  2001/03/07 09:08:13  rudi
//
//               Added USB control signaling (Line Status) block. Fixed some minor
//               typos, added resume bit and signal.
//
//               Revision 0.1.0.1  2001/02/28 08:11:07  rudi
//               Initial Release
//
//

`include "usbf_defines.v"

module usbf_pe(/*AUTOARG*/
   // Outputs
   send_token, token_pid_sel1, token_pid_sel0, data_pid_sel1,
   data_pid_sel0, send_zero_length, rx_dma_en, tx_dma_en, abort,
   adr16, adr15, adr14, adr13, adr12, adr11, adr10, adr9, adr8, adr7,
   adr6, adr5, adr4, adr3, adr2, adr1, adr0, size13, size12, size11,
   size10, size9, size8, size7, size6, size5, size4, size3, size2,
   size1, size0, buf_size13, buf_size12, buf_size11, buf_size10,
   buf_size9, buf_size8, buf_size7, buf_size6, buf_size5, buf_size4,
   buf_size3, buf_size2, buf_size1, buf_size0, dma_en, idin31, idin30,
   idin29, idin28, idin27, idin26, idin25, idin24, idin23, idin22,
   idin21, idin20, idin19, idin18, idin17, idin16, idin15, idin14,
   idin13, idin12, idin11, idin10, idin9, idin8, idin7, idin6, idin5,
   idin4, idin3, idin2, idin1, idin0, nse_err, buf0_rl, buf0_set,
   buf1_set, uc_bsel_set, uc_dpd_set, int_buf1_set, int_buf0_set,
   int_upid_set, int_crc16_set, int_to_set, int_seqerr_set,
   out_to_small,
	       usbf_pe_state,buffer_overflow, match_ro,//FMP_VC_0
	       buf0_na_o, buf1_na_o,rx_ack_to_o,tx_data_to_o, //FMP_VC_0
   // Inputs
   clk, rst, tx_valid, rx_active, pid_OUT, pid_IN, pid_SOF, pid_SETUP,
   pid_DATA0, pid_DATA1, pid_DATA2, pid_MDATA, pid_ACK, pid_NACK,
   pid_STALL, pid_NYET, pid_PRE, pid_ERR, pid_SPLIT, pid_PING,
   mode_hs, token_valid, crc5_err, rx_data_valid, rx_data_done,
   crc16_err, idma_done, sizu_c, fsel, ep_sel, match, dma_in_buf_sz1,
   dma_out_buf_avail, csr, buf0, buf1
   );

   //FMP_VC_2//parameter	SSRAM_HADR = 14;

   output [9:0] usbf_pe_state;//FMP_VC_0
   output 	buffer_overflow;//FMP_VC_0
   output 	match_ro;//FMP_VC_0
   output 	buf0_na_o, buf1_na_o;//FMP_VC_0
   output 	rx_ack_to_o;//FMP_VC_0
   output 	tx_data_to_o;//FMP_VC_0
   
   
   input 	clk, rst;
   input 	tx_valid, rx_active;
   
   // Packet Disassembler Interface
   // Decoded PIDs (used when token_valid is asserted)
   input 	pid_OUT, pid_IN, pid_SOF, pid_SETUP;
   input 	pid_DATA0, pid_DATA1, pid_DATA2, pid_MDATA;
   input 	pid_ACK, pid_NACK, pid_STALL, pid_NYET;
   input 	pid_PRE, pid_ERR, pid_SPLIT, pid_PING;
   
   input 	mode_hs;
   input 	token_valid;		// Token is valid
   input 	crc5_err;		// Token crc5 error
   
   input 	rx_data_valid;		// Data on rx_data_st is valid
   input 	rx_data_done;		// Indicates end of a transfer
   input 	crc16_err;		// Data packet CRC 16 error
   
// Packet Assembler Interface
   output 	send_token;
//FMP_VC_1//output	[1:0]	token_pid_sel;
   output	token_pid_sel1;
   output	token_pid_sel0;
   
//FMP_VC_1//output	[1:0]	data_pid_sel;
   output	data_pid_sel1;
   output	data_pid_sel0;


   output 	send_zero_length;
   
   // IDMA Interface
   output 	rx_dma_en;	// Allows the data to be stored
   output 	tx_dma_en;	// Allows for data to be retrieved
   output 	abort;		// Abort Transfer (time_out, crc_err or rx_error)
   input 	idma_done;	// DMA is done indicator
   //FMP_VC_2   //output	[SSRAM_HADR + 2:0]	adr;		// Byte Address
   //FMP_VC_1  //output	[16:0]	adr;		// Byte Address
   output 	adr16;		// Byte Address
   output 	adr15;		// Byte Address
   output 	adr14;		// Byte Address
   output 	adr13;		// Byte Address
   output 	adr12;		// Byte Address
   output 	adr11;		// Byte Address
   output 	adr10;		// Byte Address
   output 	adr9;		// Byte Address
   output 	adr8;		// Byte Address
   output 	adr7;		// Byte Address
   output 	adr6;		// Byte Address
   output 	adr5;		// Byte Address
   output 	adr4;		// Byte Address
   output 	adr3;		// Byte Address
   output 	adr2;		// Byte Address
   output 	adr1;		// Byte Address
   output 	adr0;		// Byte Address
   
   //FMP_VC_1//output	[13:0]	size;		// Size in bytes
   output 	size13;
   output 	size12;
   output 	size11;
   output 	size10;
   output 	size9;
   output 	size8;
   output 	size7;
   output 	size6;
   output 	size5;
   output 	size4;
   output 	size3;
   output 	size2;
   output 	size1;
   output 	size0;

   
   //FMP_VC_1//output	[13:0]	buf_size;	// Actual buffer size
   output 	buf_size13;
   output 	buf_size12;
   output 	buf_size11;
   output 	buf_size10;
   output 	buf_size9;
   output 	buf_size8;
   output 	buf_size7;
   output 	buf_size6;
   output 	buf_size5;
   output 	buf_size4;
   output 	buf_size3;
   output 	buf_size2;
   output 	buf_size1;
   output 	buf_size0;
   
   input [10:0] sizu_c;		// Up and Down counting size registers, used to update
   output 	dma_en;		// USB external DMA mode enabled
   
   // Register File interface
   input 	fsel;		// This function is selected

   //FMP_VC_1//output	[31:0]	idin;		// Data Output
   output 	idin31;  
   output 	idin30;  
   output 	idin29;  
   output 	idin28;  
   output 	idin27;  
   output 	idin26;  
   output 	idin25;  
   output 	idin24;  
   output 	idin23;  
   output 	idin22;  
   output 	idin21;  
   output 	idin20;  
   output 	idin19;  
   output 	idin18;  
   output 	idin17;  
   output 	idin16;  
   output 	idin15;  
   output 	idin14;  
   output 	idin13;  
   output 	idin12;  
   output 	idin11;  
   output 	idin10;  
   output 	idin9;  
   output 	idin8;  
   output 	idin7;  
   output 	idin6;  
   output 	idin5;  
   output 	idin4;  
   output 	idin3;  
   output 	idin2;  
   output 	idin1;  
   output 	idin0;  
   
   input [3:0] 	ep_sel;		// Endpoint Number Input
   input 	match;		// Endpoint Matched
   output 	nse_err;	// no such endpoint error
   input 	dma_in_buf_sz1, dma_out_buf_avail;
   
   output 	buf0_rl;	// Reload Buf 0 with original values
   output 	buf0_set;	// Write to buf 0
   output 	buf1_set;	// Write to buf 1
   output 	uc_bsel_set;	// Write to the uc_bsel field
   output 	uc_dpd_set;	// Write to the uc_dpd field
   output 	int_buf1_set;	// Set buf1 full/empty interrupt
   output 	int_buf0_set;	// Set buf0 full/empty interrupt
   output 	int_upid_set;	// Set unsupported PID interrupt
   output 	int_crc16_set;	// Set CRC16 error interrupt
   output 	int_to_set;	// Set time out interrupt
   output 	int_seqerr_set;	// Set PID sequence error interrupt
   output 	out_to_small;	// OUT packet was to small for DMA operation
   
   input [31:0] csr;		// Internal CSR Output
   input [31:0] buf0;		// Internal Buf 0 Output
   input [31:0] buf1;		// Internal Buf 1 Output


///////////////////////////////////////////////////////////////////
//
// Local Wires and Registers
//

// tx token decoding
/* -----\/----- EXCLUDED -----\/-----
//FMP_VC_2
 parameter	ACK   = 0,
		NACK  = 1,
		STALL = 2,
		NYET  = 3;
 -----/\----- EXCLUDED -----/\----- */

// State decoding
/* -----\/----- EXCLUDED -----\/-----
//FMP_VC_2
 parameter	[9:0]	// synopsys enum state
		IDLE	= 10'b000000_0001,
		TOKEN	= 10'b000000_0010,
		IN	= 10'b000000_0100,
		IN2	= 10'b000000_1000,
		OUT	= 10'b000001_0000,
		OUT2A	= 10'b000010_0000,
		OUT2B	= 10'b000100_0000,
		UPDATEW	= 10'b001000_0000,
		UPDATE	= 10'b010000_0000,
		UPDATE2	= 10'b100000_0000;
 -----/\----- EXCLUDED -----/\----- */

   reg [1:0] 	token_pid_sel;
   reg [1:0] 	token_pid_sel_d;
   reg		send_token;
   reg		send_token_d;
   reg		rx_dma_en, tx_dma_en;
   reg		int_seqerr_set_d;
   reg		int_seqerr_set;
   reg		int_upid_set;
   
   reg		match_r;
   
   // Endpoint Decoding
   wire		IN_ep, OUT_ep, CTRL_ep;		// Endpoint Types
   wire		txfr_iso, txfr_bulk;		// Transfer Types
   wire		ep_disabled, ep_stall;		// Endpoint forced conditions
   
   wire		lrg_ok, sml_ok;		// Packet size acceptance

   //FMP_VC_3//wire	[1:0]	tr_fr;			// Number of transfers per micro-frame
   //FMP_VC_3//wire	[10:0]	max_pl_sz;		// Max payload size
   //FMP_VC_3//wire	[1:0]	uc_dpd, uc_bsel;
   
// Buffer checks
   wire		buf_sel;
   reg		buf0_na, buf1_na;
   //FMP_VC_2//FMP_VC_3//FMP_VC_6// wire	[SSRAM_HADR + 2:0]	buf0_adr, buf1_adr;
   //FMP_VC_3//wire	[16:0]	buf0_adr, buf1_adr;
   //FMP_VC_3//wire	[13:0]	buf0_sz, buf1_sz;
   reg [9:0] 	/* synopsys enum state */ state, next_state;
   // synopsys state_vector state
   
   // PID next and current decoders
   reg [1:0] 	next_dpid;
   reg [1:0] 	this_dpid;
   reg		pid_seq_err;
   //FMP_VC_3//wire	[1:0]	tr_fr_d;
   
   //FMP_VC_3//wire	[13:0]	size_next;
   wire		buf_smaller;
   
   //FMP_VC_2//FMP_VC_6//reg	[SSRAM_HADR + 2:0]	adr;
   reg [16:0] 	adr;
   reg [13:0] 	new_size;
   reg [13:0] 	new_sizeb;
   reg		buffer_full;
   reg		buffer_empty;
   //FMP_VC_2//FMP_VC_3//FMP_VC_6////wire	[SSRAM_HADR + 2:0]	new_adr;
  
   reg		buffer_done;
   
   reg		no_bufs0, no_bufs1;
   wire		no_bufs;
   
// After sending Data in response to an IN token from host, the
// host must reply with an ack. The host has XXXnS to reply.
// "rx_ack_to" indicates when this time has expired.
// rx_ack_to_clr, clears the timer
   reg		rx_ack_to_clr;
   reg		rx_ack_to_clr_d;
   reg		rx_ack_to;
   reg [7:0] 	rx_ack_to_cnt;
   
// After sending a OUT token the host must send a data packet.
// The host has XX nS to send the packet. "tx_data_to" indicates
// when this time has expired.
// tx_data_to_clr, clears the timer
   wire		tx_data_to_clr;
   reg		tx_data_to; 
   reg [7:0] 	tx_data_to_cnt;

   //FMP_VC_3//wire	[7:0]	rx_ack_to_val, tx_data_to_val;

   reg		int_set_en;
   
   //FMP_VC_2//wire	[1:0]	next_bsel;
   reg		buf_set_d;
   reg		uc_stat_set_d;
   reg [31:0] 	idin;
   reg		buf0_set, buf1_set;
   reg		uc_bsel_set;
   reg		uc_dpd_set;
   reg		buf0_rl_d;
   reg		buf0_rl;
   wire		no_buf0_dma;
   reg		buf0_st_max;
   reg		buf1_st_max;
   
   //FMP_VC_2 //FMP_VC_6//reg	[SSRAM_HADR + 2:0]	adr_r;
   reg [16:0] 	adr_r;
   reg [13:0] 	size_next_r;
   
   reg		in_token;
   reg		out_token;
   reg		setup_token;
   
   wire		in_op, out_op;	// Indicate a IN or OUT operation
   reg		to_small;	// Indicates a "to small packer" error
   reg		to_large;	// Indicates a "to large packer" error
   
   reg		buffer_overflow;
   reg [1:0] 	allow_pid;
   
   reg		nse_err;
   reg		out_to_small, out_to_small_r;
   reg		abort;
   
   reg		buf0_not_aloc, buf1_not_aloc;
   
   reg		send_zero_length;
   
   
   wire [1:0] 	tr_fr = csr[12:11];	
   wire [10:0] 	max_pl_sz = csr[10:0];
   wire [1:0] 	uc_dpd = csr[29:28];	
   wire [1:0] 	uc_bsel = csr[31:30];
   wire [16:0] 	buf0_adr = buf0[16:0];
   wire [16:0] 	buf1_adr = buf1[16:0];
   wire [13:0] 	buf0_sz  = buf0[30:17];
   wire [13:0] 	buf1_sz  = buf1[30:17];	
   
   wire [7:0] 	rx_ack_to_val = mode_hs ? `USBF_RX_ACK_TO_VAL_HS : `USBF_RX_ACK_TO_VAL_FS;
   
   wire [1:0] 	tr_fr_d  = mode_hs ? tr_fr : 2'h0;
   
   wire [13:0] 	buf_size = buf_sel ? buf1_sz  : buf0_sz;
   
   wire [13:0] 	size_next = buf_smaller ? buf_size : max_pl_sz;
   
   wire [13:0] 	size = size_next;
   
   wire [16:0] 	new_adr = adr_r[16:0] +
		((out_op && dma_en) ? {{/*14 + 2-10*/6{1'b0}}, max_pl_sz[10:0]} :
		 (in_op ? {{/*14 + 2-13*/3{1'b0}}, size_next_r[13:0] } :
		  { {/*14 + 2-10*/6{1'b0}}, sizu_c[10:0]}));
   
   wire [1:0] 	next_bsel = dma_en ? 2'h0 : buffer_done ? uc_bsel + 2'h1 : uc_bsel;	// FIX_ME
   
   wire [7:0] 	tx_data_to_val = mode_hs ? `USBF_TX_DATA_TO_VAL_HS : `USBF_TX_DATA_TO_VAL_FS;	
   
   wire 	rx_ack_to_o = rx_ack_to;
   wire 	tx_data_to_o = tx_data_to;
   
   
   /* FMP_VC_4 */
// synopsys translate_off
`ifdef VCEGAR
   initial begin
      buf0_na         =  1'd0;
      buf1_na         =  1'd0;
      buf0_not_aloc   =  1'd0;
      buf1_not_aloc   =  1'd0;
      match_r         =  1'd0;
      nse_err         =  1'd0;
      send_token      =  1'd0;
      token_pid_sel   =  2'd0;
      next_dpid       =  2'd0;
      this_dpid       =  2'd0;
      pid_seq_err     =  1'd0;
      in_token        =  1'd0;
      out_token       =  1'd0;
      setup_token     =  1'd0;
      adr     =  17'd0;
      buffer_full     =  1'd0;
      buffer_empty    =  1'd0;
      buffer_done     =  1'd0;
      buf0_st_max     =  1'd0;
      buf1_st_max     =  1'd0;
      no_bufs0        =  1'd0;
      no_bufs1        =  1'd0;
      new_sizeb       =  14'd0;
      new_size        =  14'd0;
      adr_r   =  17'd0;
      size_next_r     =  14'd0;
      buffer_overflow         =  1'd0;
      out_to_small_r  =  1'd0;
      out_to_small    =  1'd0;
      to_small        =  1'd0;
      to_large        =  1'd0;
      idin    =  32'd0;
      buf0_set        =  1'd0;
      buf1_set        =  1'd0;
      uc_bsel_set     =  1'd0;
      uc_dpd_set      =  1'd0;
      buf0_rl         =  1'd0;
      abort   =  1'd0;
      rx_ack_to_clr   =  1'd0;
      rx_ack_to_cnt   =  8'd0;
      rx_ack_to       =  1'd0;
      tx_data_to_cnt  =  8'd0;
      tx_data_to      =  1'd0;
      pid_OUT_r       =  1'd0;
      pid_IN_r        =  1'd0;
      pid_PING_r      =  1'd0;
      pid_SETUP_r     =  1'd0;
      int_upid_set    =  1'd0;
      int_seqerr_set  =  1'd0;
      state   =  10'd1;
   end
`endif
// synopsys translate_on
/**********************************************/

   
///////////////////////////////////////////////////////////////////
//
// Misc Logic
//

// Endpoint/CSR Decoding
assign IN_ep   = csr[27:26]==2'b01;
assign OUT_ep  = csr[27:26]==2'b10;
assign CTRL_ep = csr[27:26]==2'b00;

assign txfr_iso  = csr[25:24]==2'b01;
assign txfr_bulk = csr[25:24]==2'b10;

assign ep_disabled = csr[23:22]==2'b01;
assign ep_stall    = csr[23:22]==2'b10;

assign lrg_ok = csr[17];
assign sml_ok = csr[16];
assign dma_en = csr[15] & !CTRL_ep;

//FMP_VC_3//assign tr_fr = csr[12:11];
//FMP_VC_3//assign max_pl_sz = csr[10:0];
//FMP_VC_3//assign uc_dpd = csr[29:28];
//FMP_VC_3//assign uc_bsel = csr[31:30];
	
// Buffer decoding and allocation checks
//FMP_VC_3//assign buf0_adr = buf0[14 + 2:0];
//FMP_VC_3//assign buf1_adr = buf1[14 + 2:0];
//FMP_VC_3//assign buf0_sz  = buf0[30:17];
//FMP_VC_3//assign buf1_sz  = buf1[30:17];

// Buffers Not Available
   always @(posedge clk)
     buf0_na <= buf0[31] | ( &buf0_adr );

   assign buf0_na_o = buf0_na; //FMP_VC_0
   
   always @(posedge clk)
     buf1_na <= buf1[31] | ( &buf1_adr );
   
   assign buf1_na_o = buf1_na; //FMP_VC_0
   
   // Buffer Not Allocated
   always @(posedge clk)
     buf0_not_aloc <= &buf0_adr;
   
   always @(posedge clk)
     buf1_not_aloc <= &buf1_adr;
   
   always @(posedge clk)
     match_r <= match;
   
   assign match_ro = match_r;//FMP_VC_0
   
   // No Such Endpoint Indicator
   always @(posedge clk)
     nse_err <= token_valid & (pid_OUT | pid_IN | pid_SETUP) & !match;
   
   always @(posedge clk)
     send_token <= send_token_d;
   
   always @(posedge clk)
     token_pid_sel <= token_pid_sel_d;

   //FMP_VC_1
   assign token_pid_sel1 = token_pid_sel[1:1];
   assign token_pid_sel0 = token_pid_sel[0:0];
  //FMP_VC_0
   assign usbf_pe_state = state;
///////////////////////////////////////////////////////////////////
//
// Data Pid Sequencer
//

//assign tr_fr_d = mode_hs ? tr_fr : 2'h0;
   
//FMP_VC_7
always @(posedge clk)	// tr/mf:ep/type:tr/type:last dpd
//FMP_VC_7//	casex({tr_fr_d,csr[27:26],csr[25:24],uc_dpd})	// synopsys full_case parallel_case
	case({tr_fr_d,csr[27:26],csr[25:24],uc_dpd})	// synopsys full_case parallel_case
//FMP_VC_7//	   8'b0?_01_01_??: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_00: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_01: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_10: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_11: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_00: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_01: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_10: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_11: next_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf

//FMP_VC_7//	   8'b10_01_01_?0: next_dpid <= 2'b01;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_00: next_dpid <= 2'b01;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_10: next_dpid <= 2'b01;	// ISO txfr. IN, 2 tr/mf
//FMP_VC_7//	   8'b10_01_01_?1: next_dpid <= 2'b00;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_01: next_dpid <= 2'b00;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_11: next_dpid <= 2'b00;	// ISO txfr. IN, 2 tr/mf

	   8'b11_01_01_00: next_dpid <= 2'b01;	// ISO txfr. IN, 3 tr/mf
	   8'b11_01_01_01: next_dpid <= 2'b10;	// ISO txfr. IN, 3 tr/mf
	   8'b11_01_01_10: next_dpid <= 2'b00;	// ISO txfr. IN, 3 tr/mf

//FMP_VC_7//	   8'b0?_10_01_??: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b00_10_01_00: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b00_10_01_01: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b00_10_01_10: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b00_10_01_11: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_00: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_01: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_10: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_11: next_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf

//FMP_VC_7//	   8'b10_10_01_??: 				// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_00, 				// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_01, 				// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_10, 				// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_11: 				// ISO txfr. OUT, 2 tr/mf
			   begin	// Resynchronize in case of PID error
				case({pid_MDATA, pid_DATA1})	// synopsys full_case parallel_case
				  2'b10: next_dpid <= 2'b01;
				  2'b01: next_dpid <= 2'b00;
// synopsys translate_off
	  default: next_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
				endcase
			   end

	   8'b11_10_01_00: 				// ISO txfr. OUT, 3 tr/mf
			   begin	// Resynchronize in case of PID error
				case({pid_MDATA, pid_DATA2})	// synopsys full_case parallel_case
				  2'b10: next_dpid <= 2'b01;
				  2'b01: next_dpid <= 2'b00;
// synopsys translate_off
	  default: next_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
				endcase
			   end
	   8'b11_10_01_01: 				// ISO txfr. OUT, 3 tr/mf
			   begin	// Resynchronize in case of PID error
				case({pid_MDATA, pid_DATA2})	// synopsys full_case parallel_case
				  2'b10: next_dpid <= 2'b10;
				  2'b01: next_dpid <= 2'b00;
// synopsys translate_off
	  default: next_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
				endcase
			   end
	   8'b11_10_01_10: 				// ISO txfr. OUT, 3 tr/mf
			   begin	// Resynchronize in case of PID error
				case({pid_MDATA, pid_DATA2})	// synopsys full_case parallel_case
				  2'b10: next_dpid <= 2'b01;
				  2'b01: next_dpid <= 2'b00;
// synopsys translate_off
	  default: next_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
				endcase
			   end

//FMP_VC_7//	   8'b??_01_00_?0,				// IN/OUT endpoint only
	   8'b00_01_00_00,				// IN/OUT endpoint only
	   8'b01_01_00_00,				// IN/OUT endpoint only
	   8'b10_01_00_00,				// IN/OUT endpoint only
	   8'b11_01_00_00,				// IN/OUT endpoint only
	   8'b00_01_00_10,				// IN/OUT endpoint only
	   8'b01_01_00_10,				// IN/OUT endpoint only
	   8'b10_01_00_10,				// IN/OUT endpoint only
	   8'b11_01_00_10,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_00_?0: next_dpid <= 2'b01;	// INT transfers
	   8'b00_10_00_00,
	   8'b01_10_00_00,
	   8'b10_10_00_00,
	   8'b11_10_00_00,
	   8'b00_10_00_10,
	   8'b01_10_00_10,
	   8'b10_10_00_10,
	   8'b11_10_00_10: next_dpid <= 2'b01;	// INT transfers

//FMP_VC_7//	   8'b??_01_00_?1,				// IN/OUT endpoint only
	   8'b00_01_00_01,				// IN/OUT endpoint only
	   8'b01_01_00_01,				// IN/OUT endpoint only
	   8'b10_01_00_01,				// IN/OUT endpoint only
	   8'b11_01_00_01,				// IN/OUT endpoint only
	   8'b00_01_00_11,				// IN/OUT endpoint only
	   8'b01_01_00_11,				// IN/OUT endpoint only
	   8'b10_01_00_11,				// IN/OUT endpoint only
	   8'b11_01_00_11,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_00_?1: next_dpid <= 2'b00;	// INT transfers
	   8'b00_10_00_01,
	   8'b01_10_00_01,
	   8'b10_10_00_01,
	   8'b11_10_00_01,
	   8'b00_10_00_11,
	   8'b01_10_00_11,
	   8'b10_10_00_11,
	   8'b11_10_00_11: next_dpid <= 2'b00;	// INT transfers

//FMP_VC_7//	   8'b??_01_10_?0,				// IN/OUT endpoint only
	   8'b00_01_10_00,				// IN/OUT endpoint only
	   8'b01_01_10_00,				// IN/OUT endpoint only
	   8'b10_01_10_00,				// IN/OUT endpoint only
	   8'b11_01_10_00,				// IN/OUT endpoint only
	   8'b00_01_10_10,				// IN/OUT endpoint only
	   8'b01_01_10_10,				// IN/OUT endpoint only
	   8'b10_01_10_10,				// IN/OUT endpoint only
	   8'b11_01_10_10,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_10_?0: next_dpid <= 2'b01;	// BULK transfers
	   8'b00_10_10_00,
	   8'b01_10_10_00,
	   8'b10_10_10_00,
	   8'b11_10_10_00,
	   8'b00_10_10_10,
	   8'b01_10_10_10,
	   8'b10_10_10_10,
	   8'b11_10_10_10: next_dpid <= 2'b01;	// BULK transfers

//FMP_VC_7//	   8'b??_01_10_?1,				// IN/OUT endpoint only
	   8'b00_01_10_01,				// IN/OUT endpoint only
	   8'b01_01_10_01,				// IN/OUT endpoint only
	   8'b10_01_10_01,				// IN/OUT endpoint only
	   8'b11_01_10_01,				// IN/OUT endpoint only
	   8'b00_01_10_11,				// IN/OUT endpoint only
	   8'b01_01_10_11,				// IN/OUT endpoint only
	   8'b10_01_10_11,				// IN/OUT endpoint only
	   8'b11_01_10_11,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_10_?1 : next_dpid <= 2'b00;
	   8'b00_10_10_01,
	   8'b01_10_10_01,
	   8'b10_10_10_01,
	   8'b11_10_10_01,
	   8'b00_10_10_11,
	   8'b01_10_10_11,
	   8'b10_10_10_11,
	   8'b11_10_10_11 : next_dpid <= 2'b00;	// BULK transfers

//FMP_VC_7//	   8'b??_00_??_??:				// CTRL Endpoint
	   8'b00_00_00_00,				// CTRL Endpoint
	   8'b00_00_00_01,				// CTRL Endpoint
	   8'b00_00_00_10,				// CTRL Endpoint
	   8'b00_00_00_11,				// CTRL Endpoint
	   8'b00_00_01_00,				// CTRL Endpoint
	   8'b00_00_01_01,				// CTRL Endpoint
	   8'b00_00_01_10,				// CTRL Endpoint
	   8'b00_00_01_11,				// CTRL Endpoint
	   8'b00_00_10_00,				// CTRL Endpoint
	   8'b00_00_10_01,				// CTRL Endpoint
	   8'b00_00_10_10,				// CTRL Endpoint
	   8'b00_00_10_11,				// CTRL Endpoint
	   8'b00_00_11_00,				// CTRL Endpoint
	   8'b00_00_11_01,				// CTRL Endpoint
	   8'b00_00_11_10,				// CTRL Endpoint
	   8'b00_00_11_11,				// CTRL Endpoint

	   8'b01_00_00_00,				// CTRL Endpoint
	   8'b01_00_00_01,				// CTRL Endpoint
	   8'b01_00_00_10,				// CTRL Endpoint
	   8'b01_00_00_11,				// CTRL Endpoint
	   8'b01_00_01_00,				// CTRL Endpoint
	   8'b01_00_01_01,				// CTRL Endpoint
	   8'b01_00_01_10,				// CTRL Endpoint
	   8'b01_00_01_11,				// CTRL Endpoint
	   8'b01_00_10_00,				// CTRL Endpoint
	   8'b01_00_10_01,				// CTRL Endpoint
	   8'b01_00_10_10,				// CTRL Endpoint
	   8'b01_00_10_11,				// CTRL Endpoint
	   8'b01_00_11_00,				// CTRL Endpoint
	   8'b01_00_11_01,				// CTRL Endpoint
	   8'b01_00_11_10,				// CTRL Endpoint
	   8'b01_00_11_11,				// CTRL Endpoint

	   8'b10_00_00_00,				// CTRL Endpoint
	   8'b10_00_00_01,				// CTRL Endpoint
	   8'b10_00_00_10,				// CTRL Endpoint
	   8'b10_00_00_11,				// CTRL Endpoint
	   8'b10_00_01_00,				// CTRL Endpoint
	   8'b10_00_01_01,				// CTRL Endpoint
	   8'b10_00_01_10,				// CTRL Endpoint
	   8'b10_00_01_11,				// CTRL Endpoint
	   8'b10_00_10_00,				// CTRL Endpoint
	   8'b10_00_10_01,				// CTRL Endpoint
	   8'b10_00_10_10,				// CTRL Endpoint
	   8'b10_00_10_11,				// CTRL Endpoint
	   8'b10_00_11_00,				// CTRL Endpoint
	   8'b10_00_11_01,				// CTRL Endpoint
	   8'b10_00_11_10,				// CTRL Endpoint
	   8'b10_00_11_11,				// CTRL Endpoint

	   8'b11_00_00_00,				// CTRL Endpoint
	   8'b11_00_00_01,				// CTRL Endpoint
	   8'b11_00_00_10,				// CTRL Endpoint
	   8'b11_00_00_11,				// CTRL Endpoint
	   8'b11_00_01_00,				// CTRL Endpoint
	   8'b11_00_01_01,				// CTRL Endpoint
	   8'b11_00_01_10,				// CTRL Endpoint
	   8'b11_00_01_11,				// CTRL Endpoint
	   8'b11_00_10_00,				// CTRL Endpoint
	   8'b11_00_10_01,				// CTRL Endpoint
	   8'b11_00_10_10,				// CTRL Endpoint
	   8'b11_00_10_11,				// CTRL Endpoint
	   8'b11_00_11_00,				// CTRL Endpoint
	   8'b11_00_11_01,				// CTRL Endpoint
	   8'b11_00_11_10,				// CTRL Endpoint
	   8'b11_00_11_11:				// CTRL Endpoint
//FMP_VC_7//		casex({setup_token, in_op, out_op, uc_dpd})	// synopsys full_case parallel_case
		case({setup_token, in_op, out_op, uc_dpd})	// synopsys full_case parallel_case
//FMP_VC_7//		   5'b1_??_??: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_00_00: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_00_01: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_00_10: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_00_11: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_01_00: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_01_01: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_01_10: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_01_11: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_10_00: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_10_01: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_10_10: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_10_11: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_11_00: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_11_01: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_11_10: next_dpid <= 2'b11;	// SETUP operation
		   5'b1_11_11: next_dpid <= 2'b11;	// SETUP operation

//FMP_VC_7//		   5'b0_10_0?: next_dpid <= 2'b11;	// IN operation
		   5'b0_10_00: next_dpid <= 2'b11;	// IN operation
		   5'b0_10_01: next_dpid <= 2'b11;	// IN operation
//FMP_VC_7//		   5'b0_10_1?: next_dpid <= 2'b01;	// IN operation
		   5'b0_10_10: next_dpid <= 2'b01;	// IN operation
		   5'b0_10_11: next_dpid <= 2'b01;	// IN operation
//FMP_VC_7//		   5'b0_01_?0: next_dpid <= 2'b11;	// OUT operation
		   5'b0_01_00: next_dpid <= 2'b11;	// OUT operation
		   5'b0_01_10: next_dpid <= 2'b11;	// OUT operation
//FMP_VC_7//		   5'b0_01_?1: next_dpid <= 2'b10;	// OUT operation
		   5'b0_01_01: next_dpid <= 2'b10;	// OUT operation
		   5'b0_01_11: next_dpid <= 2'b10;	// OUT operation
// synopsys translate_off
		  default: next_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
		endcase
// synopsys translate_off
	  default: next_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
	endcase

// Current PID decoder

// Allow any PID for ISO. transfers when mode full speed or tr_fr is zero
       always @(pid_DATA0 or pid_DATA1 or pid_DATA2 or pid_MDATA) 
	case({pid_DATA0, pid_DATA1, pid_DATA2, pid_MDATA} ) // synopsys  full_case parallel_case
	   4'b1000: allow_pid = 2'b00;
	   4'b0100: allow_pid = 2'b01;
	   4'b0010: allow_pid = 2'b10;
	   4'b0001: allow_pid = 2'b11;
// synopsys translate_off
	  default: allow_pid = 2'b00;
// synopsys translate_on
	endcase
 
//f-u-l-l-_-c-a-s-e
   
always @(posedge clk)	// tf/mf:ep/type:tr/type:last dpd
//FMP_VC_7//	casex({tr_fr_d,csr[27:26],csr[25:24],uc_dpd})	// synopsys full_case parallel_case
	case({tr_fr_d,csr[27:26],csr[25:24],uc_dpd})	// synopsys full_case parallel_case
//FMP_VC_7//	   8'b0?_01_01_??: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_00: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_01: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_10: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b00_01_01_11: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_00: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_01: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_10: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf
	   8'b01_01_01_11: this_dpid <= 2'b00;	// ISO txfr. IN, 1 tr/mf

//FMP_VC_7//	   8'b10_01_01_?0: this_dpid <= 2'b01;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_00: this_dpid <= 2'b01;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_10: this_dpid <= 2'b01;	// ISO txfr. IN, 2 tr/mf
//FMP_VC_7//	   8'b10_01_01_?1: this_dpid <= 2'b00;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_01: this_dpid <= 2'b00;	// ISO txfr. IN, 2 tr/mf
	   8'b10_01_01_11: this_dpid <= 2'b00;	// ISO txfr. IN, 2 tr/mf

	   8'b11_01_01_00: this_dpid <= 2'b10;	// ISO txfr. IN, 3 tr/mf
	   8'b11_01_01_01: this_dpid <= 2'b01;	// ISO txfr. IN, 3 tr/mf
	   8'b11_01_01_10: this_dpid <= 2'b00;	// ISO txfr. IN, 3 tr/mf

//FMP_VC_7//	   8'b00_10_01_??: this_dpid <= allow_pid;	// ISO txfr. OUT, 0 tr/mf
	   8'b00_10_01_00: this_dpid <= allow_pid;	// ISO txfr. OUT, 0 tr/mf
	   8'b00_10_01_01: this_dpid <= allow_pid;	// ISO txfr. OUT, 0 tr/mf
	   8'b00_10_01_10: this_dpid <= allow_pid;	// ISO txfr. OUT, 0 tr/mf
	   8'b00_10_01_11: this_dpid <= allow_pid;	// ISO txfr. OUT, 0 tr/mf

//FMP_VC_7//	   8'b01_10_01_??: this_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_00: this_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_01: this_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_10: this_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf
	   8'b01_10_01_11: this_dpid <= 2'b00;	// ISO txfr. OUT, 1 tr/mf

//FMP_VC_7//	   8'b10_10_01_?0: this_dpid <= 2'b11;	// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_00: this_dpid <= 2'b11;	// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_10: this_dpid <= 2'b11;	// ISO txfr. OUT, 2 tr/mf

//FMP_VC_7//	   8'b10_10_01_?1: this_dpid <= 2'b01;	// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_01: this_dpid <= 2'b01;	// ISO txfr. OUT, 2 tr/mf
	   8'b10_10_01_11: this_dpid <= 2'b01;	// ISO txfr. OUT, 2 tr/mf

	   8'b11_10_01_00: this_dpid <= 2'b11;	// ISO txfr. OUT, 3 tr/mf
	   8'b11_10_01_01: this_dpid <= 2'b11;	// ISO txfr. OUT, 3 tr/mf
	   8'b11_10_01_10: this_dpid <= 2'b10;	// ISO txfr. OUT, 3 tr/mf

//FMP_VC_7//	   8'b??_01_00_?0,				// IN/OUT endpoint only
	   8'b00_01_00_00,				// IN/OUT endpoint only
	   8'b01_01_00_00,				// IN/OUT endpoint only
	   8'b10_01_00_00,				// IN/OUT endpoint only
	   8'b11_01_00_00,				// IN/OUT endpoint only
	   8'b00_01_00_10,				// IN/OUT endpoint only
	   8'b01_01_00_10,				// IN/OUT endpoint only
	   8'b10_01_00_10,				// IN/OUT endpoint only
	   8'b11_01_00_10,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_00_?0: this_dpid <= 2'b00;	// INT transfers
	   8'b00_10_00_00,
	   8'b01_10_00_00,
	   8'b10_10_00_00,
	   8'b11_10_00_00,
	   8'b00_10_00_10,
	   8'b01_10_00_10,
	   8'b10_10_00_10,
	   8'b11_10_00_10: this_dpid <= 2'b00;	// INT transfers

//FMP_VC_7//	   8'b??_01_00_?1,				// IN/OUT endpoint only
	   8'b00_01_00_01,				// IN/OUT endpoint only
	   8'b01_01_00_01,				// IN/OUT endpoint only
	   8'b10_01_00_01,				// IN/OUT endpoint only
	   8'b11_01_00_01,				// IN/OUT endpoint only
	   8'b00_01_00_11,				// IN/OUT endpoint only
	   8'b01_01_00_11,				// IN/OUT endpoint only
	   8'b10_01_00_11,				// IN/OUT endpoint only
	   8'b11_01_00_11,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_00_?1: this_dpid <= 2'b01;	// INT transfers
	   8'b00_10_00_01,
	   8'b01_10_00_01,
	   8'b10_10_00_01,
	   8'b11_10_00_01,
	   8'b00_10_00_11,
	   8'b01_10_00_11,
	   8'b10_10_00_11,
	   8'b11_10_00_11 : this_dpid <= 2'b01;	// INT transfers
	  
//FMP_VC_7//	   8'b??_01_10_?0,				// IN/OUT endpoint only
	   8'b00_01_10_00,				// IN/OUT endpoint only
	   8'b01_01_10_00,				// IN/OUT endpoint only
	   8'b10_01_10_00,				// IN/OUT endpoint only
	   8'b11_01_10_00,				// IN/OUT endpoint only
	   8'b00_01_10_10,				// IN/OUT endpoint only
	   8'b01_01_10_10,				// IN/OUT endpoint only
	   8'b10_01_10_10,				// IN/OUT endpoint only
	   8'b11_01_10_10,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_10_?0: 
	   8'b00_10_10_00,
	   8'b01_10_10_00,
	   8'b10_10_10_00,
	   8'b11_10_10_00,
	   8'b00_10_10_10,
	   8'b01_10_10_10,
	   8'b10_10_10_10,
	   8'b11_10_10_10:  this_dpid <= 2'b00;	// BULK transfers

//FMP_VC_7//	   8'b??_01_10_?1,				// IN/OUT endpoint only
	   8'b00_01_10_01,				// IN/OUT endpoint only
	   8'b01_01_10_01,				// IN/OUT endpoint only
	   8'b10_01_10_01,				// IN/OUT endpoint only
	   8'b11_01_10_01,				// IN/OUT endpoint only
	   8'b00_01_10_11,				// IN/OUT endpoint only
	   8'b01_01_10_11,				// IN/OUT endpoint only
	   8'b10_01_10_11,				// IN/OUT endpoint only
	   8'b11_01_10_11,				// IN/OUT endpoint only
//FMP_VC_7//	   8'b??_10_10_?1
	   8'b00_10_10_01,
	   8'b01_10_10_01,
	   8'b10_10_10_01,
	   8'b11_10_10_01,
	   8'b00_10_10_11,
	   8'b01_10_10_11,
	   8'b10_10_10_11,
	   8'b11_10_10_11 : this_dpid <= 2'b01;	// BULK transfers

//FMP_VC_7//	   8'b??_00_??_??:				// CTRL Endpoint
	   8'b00_00_00_00,				// CTRL Endpoint
	   8'b00_00_00_01,				// CTRL Endpoint
	   8'b00_00_00_10,				// CTRL Endpoint
	   8'b00_00_00_11,				// CTRL Endpoint
	   8'b00_00_01_00,				// CTRL Endpoint
	   8'b00_00_01_01,				// CTRL Endpoint
	   8'b00_00_01_10,				// CTRL Endpoint
	   8'b00_00_01_11,				// CTRL Endpoint
	   8'b00_00_10_00,				// CTRL Endpoint
	   8'b00_00_10_01,				// CTRL Endpoint
	   8'b00_00_10_10,				// CTRL Endpoint
	   8'b00_00_10_11,				// CTRL Endpoint
	   8'b00_00_11_00,				// CTRL Endpoint
	   8'b00_00_11_01,				// CTRL Endpoint
	   8'b00_00_11_10,				// CTRL Endpoint
	   8'b00_00_11_11,				// CTRL Endpoint

	   8'b01_00_00_00,				// CTRL Endpoint
	   8'b01_00_00_01,				// CTRL Endpoint
	   8'b01_00_00_10,				// CTRL Endpoint
	   8'b01_00_00_11,				// CTRL Endpoint
	   8'b01_00_01_00,				// CTRL Endpoint
	   8'b01_00_01_01,				// CTRL Endpoint
	   8'b01_00_01_10,				// CTRL Endpoint
	   8'b01_00_01_11,				// CTRL Endpoint
	   8'b01_00_10_00,				// CTRL Endpoint
	   8'b01_00_10_01,				// CTRL Endpoint
	   8'b01_00_10_10,				// CTRL Endpoint
	   8'b01_00_10_11,				// CTRL Endpoint
	   8'b01_00_11_00,				// CTRL Endpoint
	   8'b01_00_11_01,				// CTRL Endpoint
	   8'b01_00_11_10,				// CTRL Endpoint
	   8'b01_00_11_11,				// CTRL Endpoint

	   8'b10_00_00_00,				// CTRL Endpoint
	   8'b10_00_00_01,				// CTRL Endpoint
	   8'b10_00_00_10,				// CTRL Endpoint
	   8'b10_00_00_11,				// CTRL Endpoint
	   8'b10_00_01_00,				// CTRL Endpoint
	   8'b10_00_01_01,				// CTRL Endpoint
	   8'b10_00_01_10,				// CTRL Endpoint
	   8'b10_00_01_11,				// CTRL Endpoint
	   8'b10_00_10_00,				// CTRL Endpoint
	   8'b10_00_10_01,				// CTRL Endpoint
	   8'b10_00_10_10,				// CTRL Endpoint
	   8'b10_00_10_11,				// CTRL Endpoint
	   8'b10_00_11_00,				// CTRL Endpoint
	   8'b10_00_11_01,				// CTRL Endpoint
	   8'b10_00_11_10,				// CTRL Endpoint
	   8'b10_00_11_11,				// CTRL Endpoint

	   8'b11_00_00_00,				// CTRL Endpoint
	   8'b11_00_00_01,				// CTRL Endpoint
	   8'b11_00_00_10,				// CTRL Endpoint
	   8'b11_00_00_11,				// CTRL Endpoint
	   8'b11_00_01_00,				// CTRL Endpoint
	   8'b11_00_01_01,				// CTRL Endpoint
	   8'b11_00_01_10,				// CTRL Endpoint
	   8'b11_00_01_11,				// CTRL Endpoint
	   8'b11_00_10_00,				// CTRL Endpoint
	   8'b11_00_10_01,				// CTRL Endpoint
	   8'b11_00_10_10,				// CTRL Endpoint
	   8'b11_00_10_11,				// CTRL Endpoint
	   8'b11_00_11_00,				// CTRL Endpoint
	   8'b11_00_11_01,				// CTRL Endpoint
	   8'b11_00_11_10,				// CTRL Endpoint
	   8'b11_00_11_11:				// CTRL Endpoint
//FMP_VC_7//		casex({setup_token,in_op, out_op, uc_dpd})	// synopsys full_case parallel_case
		case({setup_token,in_op, out_op, uc_dpd})	// synopsys full_case parallel_case
//FMP_VC_7//		   5'b1_??_??: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_00_00: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_00_01: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_00_10: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_00_11: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_01_00: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_01_01: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_01_10: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_01_11: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_10_00: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_10_01: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_10_10: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_10_11: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_11_00: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_11_01: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_11_10: this_dpid <= 2'b00;	// SETUP operation
		   5'b1_11_11: this_dpid <= 2'b00;	// SETUP operation

//FMP_VC_7//		   5'b0_10_0?: this_dpid <= 2'b00;	// IN operation
		   5'b0_10_00: this_dpid <= 2'b00;	// IN operation
		   5'b0_10_01: this_dpid <= 2'b00;	// IN operation

//FMP_VC_7//		   5'b0_10_1?: this_dpid <= 2'b01;	// IN operation
		   5'b0_10_10: this_dpid <= 2'b01;	// IN operation
		   5'b0_10_11: this_dpid <= 2'b01;	// IN operation

//FMP_VC_7//		   5'b0_01_?0: this_dpid <= 2'b00;	// OUT operation
		   5'b0_01_00: this_dpid <= 2'b00;	// OUT operation
		   5'b0_01_10: this_dpid <= 2'b00;	// OUT operation

//FMP_VC_7//		   5'b0_01_?1: this_dpid <= 2'b01;	// OUT operation
		   5'b0_01_01: this_dpid <= 2'b01;	// OUT operation
		   5'b0_01_11: this_dpid <= 2'b01;	// OUT operation
// synopsys translate_off
		  default : this_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
		endcase // case({setup_token,in_op, out_op, uc_dpd})
// synopsys translate_off
	  default : this_dpid <= 2'b00; //FMP_VC_5
// synopsys translate_on
	endcase // case({tr_fr_d,csr[27:26],csr[25:24],uc_dpd})
   

// Assign PID for outgoing packets
  
   //FMP_VC_1//assign data_pid_sel = this_dpid;
   assign data_pid_sel1 = this_dpid[1:1];
   assign data_pid_sel0 = this_dpid[0:0];
   
   // Verify PID for incoming data packets
   always @(posedge clk)
     pid_seq_err <= !(	(this_dpid==2'b00 & pid_DATA0) |
			(this_dpid==2'b01 & pid_DATA1) |
			(this_dpid==2'b10 & pid_DATA2) |
			(this_dpid==2'b11 & pid_MDATA)	);
   
///////////////////////////////////////////////////////////////////
//
// IDMA Setup & src/dst buffer select
//

// For Control endpoints things are different:
// buffer0 is used for OUT (incoming) data packets
// buffer1 is used for IN (outgoing) data packets

// Keep track of last token for control endpoints
`ifdef USBF_ASYNC_RESET
always @(posedge clk or negedge rst)
`else
always @(posedge clk)
`endif
	if(!rst)			in_token <= 1'b0;
	else
	if(pid_IN)			in_token <= 1'b1;
	else
	if(pid_OUT || pid_SETUP)	in_token <= 1'b0;

`ifdef USBF_ASYNC_RESET
always @(posedge clk or negedge rst)
`else
always @(posedge clk)
`endif
	if(!rst)			out_token <= 1'b0;
	else
	if(pid_OUT || pid_SETUP)	out_token <= 1'b1;
	else
	if(pid_IN)			out_token <= 1'b0;

`ifdef USBF_ASYNC_RESET
always @(posedge clk or negedge rst)
`else
always @(posedge clk)
`endif
	if(!rst)			setup_token <= 1'b0;
	else
	if(pid_SETUP)			setup_token <= 1'b1;
	else
	if(pid_OUT || pid_IN)		setup_token <= 1'b0;

   // Indicates if we are performing an IN operation
   assign in_op = IN_ep | (CTRL_ep & in_token);
   
   // Indicates if we are performing an OUT operation
   assign out_op = OUT_ep | (CTRL_ep & out_token);
   
   // Select buffer: buf_sel==0 buffer0; buf_sel==1 buffer1
   assign buf_sel =  dma_en ? 1'b0 : CTRL_ep ? in_token : ((uc_bsel[0] | buf0_na) & !buf1_na);
   
   // Select Address for IDMA
   always @(posedge clk)
     adr <= buf_sel ? buf1_adr : buf0_adr;
   //FMP_VC_1
   assign adr16 = adr[16:16];
   assign adr15 = adr[15:15];
   assign adr14 = adr[14:14];
   assign adr13 = adr[13:13];
   assign adr12 = adr[12:12];
   assign adr11 = adr[11:11];
   assign adr10 = adr[10:10];
   assign adr9 = adr[9:9];
   assign adr8 = adr[8:8];
   assign adr7 = adr[7:7];
   assign adr6 = adr[6:6];
   assign adr5 = adr[5:5];
   assign adr4 = adr[4:4];
   assign adr3 = adr[3:3];
   assign adr2 = adr[2:2];
   assign adr1 = adr[1:1];
   assign adr0 = adr[0:0];

	    
   // Size from Buffer
   //FMP_VC_1//assign buf_size = buf_sel ? buf1_sz  : buf0_sz;

   //FMP_VC_1
   assign buf_size13 = buf_size[13:13];
   assign buf_size12 = buf_size[12:12];
   assign buf_size11 = buf_size[11:11];
   assign buf_size10 = buf_size[10:10];
   assign buf_size9 = buf_size[9:9];
   assign buf_size8 = buf_size[8:8];
   assign buf_size7 = buf_size[7:7];
   assign buf_size6 = buf_size[6:6];
   assign buf_size5 = buf_size[5:5];
   assign buf_size4 = buf_size[4:4];
   assign buf_size3 = buf_size[3:3];
   assign buf_size2 = buf_size[2:2];
   assign buf_size1 = buf_size[1:1];
   assign buf_size0 = buf_size[0:0];
   
   // Determine which is smaller: buffer or max_pl_sz
   assign buf_smaller = buf_size < {3'h0, max_pl_sz};

   // Determine actual size for this transfer (for IDMA) IN endpoint only
   // (OUT endpoint uses sizeu_c from IDMA)
   //FMP_VC_1//assign size_next = buf_smaller ? buf_size : max_pl_sz;
   
   //FMP_VC_1//assign size = size_next;	// "size" is an output for IDMA
   assign size13 = size_next[13:13];	// "size" is an output for IDMA
   assign size12 = size_next[12:12];	// "size" is an output for IDMA
   assign size11 = size_next[11:11];	// "size" is an output for IDMA
   assign size10 = size_next[10:10];	// "size" is an output for IDMA
   assign size9 = size_next[9:9];	// "size" is an output for IDMA
   assign size8 = size_next[8:8];	// "size" is an output for IDMA
   assign size7 = size_next[7:7];	// "size" is an output for IDMA
   assign size6 = size_next[6:6];	// "size" is an output for IDMA
   assign size5 = size_next[5:5];	// "size" is an output for IDMA
   assign size4 = size_next[4:4];	// "size" is an output for IDMA
   assign size3 = size_next[3:3];	// "size" is an output for IDMA
   assign size2 = size_next[2:2];	// "size" is an output for IDMA
   assign size1 = size_next[1:1];	// "size" is an output for IDMA
   assign size0 = size_next[0:0];	// "size" is an output for IDMA

   // Buffer Full (only for OUT endpoints)
   // Indicates that there is not enough space in the buffer for one
   // more max_pl_sz packet
   always @(posedge clk)
     buffer_full <= new_size < {3'h0, max_pl_sz};

   // Buffer Empty (only for IN endpoints)
   // Indicates that there are zero bytes left in the buffer
   always @(posedge clk)
     buffer_empty <= (new_size == 14'h0);
   
   // Joint buffer full/empty flag This is the "USED" flag
   always @(posedge clk)
     buffer_done <= in_op ? buffer_empty : buffer_full;
   
   // No More buffer space at all (For high speed out - issue NYET)
   assign no_buf0_dma = dma_en &
			((IN_ep & !dma_in_buf_sz1) | (OUT_ep & !dma_out_buf_avail));
   
   always @(posedge clk)
     buf0_st_max <= (buf0_sz < {3'h0, max_pl_sz});
   
   always @(posedge clk)
     buf1_st_max <= (buf1_sz < {3'h0, max_pl_sz});
   
   always @(posedge clk)
     no_bufs0 <= buf0_na | no_buf0_dma |
		 (buf_sel ? buf0_st_max : (buffer_full & !dma_en));
   
   always @(posedge clk)
     no_bufs1 <= buf1_na | (buf_sel ? buffer_full : buf1_st_max);
   
   assign no_bufs = no_bufs0 & no_bufs1;
   
   // New Size (to be written to register file)
   always @(posedge clk)
     new_sizeb <= (out_op && dma_en) ? max_pl_sz : (in_op ? size_next : sizu_c);
   
   always @(posedge clk)
     new_size <= buf_size - new_sizeb;
   

   // New Buffer Address (to be written to register file)
   always @(posedge clk)
     adr_r <= adr;
   
   always @(posedge clk)
     size_next_r <= size_next;
   
   // Buffer Overflow
   always @(posedge clk)
     buffer_overflow <= ( {3'h0, sizu_c} > buf_size) & rx_data_valid;
   
   
   // OUT packet smaller than MAX_PL_SZ in DMA operation
   always @(posedge clk)
     out_to_small_r <= uc_stat_set_d & out_op & dma_en & (sizu_c != max_pl_sz);
   
   always @(posedge clk)
     out_to_small <= out_to_small_r;
   
///////////////////////////////////////////////////////////////////
//
// Determine if packet is to small or to large
// This is used to NACK and ignore packet for OUT endpoints
//

   always @(posedge clk)
     to_small <= !sml_ok & (sizu_c < max_pl_sz);
   
   always @(posedge clk)
     to_large <= !lrg_ok & (sizu_c > max_pl_sz);
   
///////////////////////////////////////////////////////////////////
//
// Register File Update Logic
//

//FMP_VC_3//assign next_bsel = dma_en ? 2'h0 : buffer_done ? uc_bsel + 2'h1 : uc_bsel;	// FIX_ME



/* -----\/----- EXCLUDED -----\/-----
//FMP_VC_8
always @(posedge clk)
	idin[31:17] <= out_to_small_r ? {4'h0,sizu_c} : {buffer_done,new_size};

always @(posedge clk)
//	idin[SSRAM_HADR + 2:4] <= out_to_small_r ?	buf0_adr[14 + 2:4] :
//							new_adr[14 + 2:4];
	idin[16:4] <= out_to_small_r ?	buf0_adr[16:4] :
							new_adr[16:4];
always @(posedge clk)
	if(buf_set_d)			idin[3:0] <= new_adr[3:0];
	else
	if(out_to_small_r)		idin[3:0] <= buf0_adr[3:0];
	else				idin[3:0] <= {next_dpid, next_bsel};

  -----/\----- EXCLUDED -----/\----- */

   reg [3:0] my_idin3_0; reg [12:0] my_idin16_4; reg [14:0] my_idin31_17;
   
   always@(/*AS*/buf0_adr or buffer_done or new_adr or new_size
	   or out_to_small_r or sizu_c)
     begin
	my_idin31_17 = out_to_small_r ? {4'h0,sizu_c} : {buffer_done,new_size};
	my_idin16_4  = out_to_small_r ?	buf0_adr[16:4] : new_adr[16:4];   
     end
   
always@(/*AS*/buf0_adr or buf_set_d or new_adr or next_bsel
	or next_dpid or out_to_small_r)
	if(buf_set_d)			my_idin3_0 = new_adr[3:0];
	else
	if(out_to_small_r)		my_idin3_0 = buf0_adr[3:0];
	else				my_idin3_0 = {next_dpid, next_bsel};
  
   
always @(posedge clk)
  idin <= {my_idin31_17,my_idin16_4,my_idin3_0};
   //FMP_VC_1
   assign 	idin31 = idin[31:31];
   assign 	idin30 = idin[30:30];
   assign 	idin29 = idin[29:29];
   assign 	idin28 = idin[28:28];
   assign 	idin27 = idin[27:27];
   assign 	idin26 = idin[26:26];
   assign 	idin25 = idin[25:25];
   assign 	idin24 = idin[24:24];
   assign 	idin23 = idin[23:23];
   assign 	idin22 = idin[22:22];
   assign 	idin21 = idin[21:21];
   assign 	idin20 = idin[20:20];
   assign 	idin19 = idin[19:19];
   assign 	idin18 = idin[18:18];
   assign 	idin17 = idin[17:17];
   assign 	idin16 = idin[16:16];
   assign 	idin15 = idin[15:15];
   assign 	idin14 = idin[14:14];
   assign 	idin13 = idin[13:13];
   assign 	idin12 = idin[12:12];
   assign 	idin11 = idin[11:11];
   assign 	idin10 = idin[10:10];
   assign 	idin9  = idin[9:9];
   assign 	idin8  = idin[8:8];
   assign 	idin7  = idin[7:7];
   assign 	idin6  = idin[6:6];
   assign 	idin5  = idin[5:5]; 
   assign 	idin4  = idin[4:4];
   assign 	idin3  = idin[3:3];
   assign 	idin2  = idin[2:2];
   assign 	idin1  = idin[1:1];
   assign 	idin0  = idin[0:0];
	


always @(posedge clk)
	buf0_set <= !buf_sel & buf_set_d;

always @(posedge clk)
	buf1_set <= buf_sel & buf_set_d;

always @(posedge clk)
	uc_bsel_set <= uc_stat_set_d;

always @(posedge clk)
	uc_dpd_set <= uc_stat_set_d;

always @(posedge clk)
	buf0_rl <= buf0_rl_d;

// Abort signal
always @(posedge clk)
	abort <= buffer_overflow | (match & (state != 10'b000000_0001) ) | (match_r & to_large);

///////////////////////////////////////////////////////////////////
//
// TIME OUT TIMERS
//

// After sending Data in response to an IN token from host, the
// host must reply with an ack. The host has 622nS in Full Speed
// mode and 400nS in High Speed mode to reply.
// "rx_ack_to" indicates when this time has expired.
// rx_ack_to_clr, clears the timer

always @(posedge clk)
	rx_ack_to_clr <= tx_valid | rx_ack_to_clr_d;

always @(posedge clk)
	if(rx_ack_to_clr)	rx_ack_to_cnt <= 8'h0;
	else			rx_ack_to_cnt <= rx_ack_to_cnt + 8'h1;

always @(posedge clk)
	rx_ack_to <= (rx_ack_to_cnt == rx_ack_to_val);

//assign rx_ack_to_val = mode_hs ? `USBF_RX_ACK_TO_VAL_HS : `USBF_RX_ACK_TO_VAL_FS;
   
// After sending a OUT token the host must send a data packet.
// The host has 622nS in Full Speed mode and 400nS in High Speed
// mode to send the data packet.
// "tx_data_to" indicates when this time has expired.
// "tx_data_to_clr" clears the timer

assign	tx_data_to_clr = rx_active;

always @(posedge clk)
	if(tx_data_to_clr)	tx_data_to_cnt <= 8'h0;
	else			tx_data_to_cnt <= tx_data_to_cnt + 8'h1;

always @(posedge clk)
	tx_data_to <= (tx_data_to_cnt == tx_data_to_val);

//FMP_VC_3//assign tx_data_to_val = mode_hs ? `USBF_TX_DATA_TO_VAL_HS : `USBF_TX_DATA_TO_VAL_FS;
///////////////////////////////////////////////////////////////////
//
// Interrupts
//
reg 	pid_OUT_r, pid_IN_r, pid_PING_r, pid_SETUP_r;

assign int_buf1_set = !buf_sel & buffer_done & int_set_en & !buf1_not_aloc;
assign int_buf0_set =  buf_sel & buffer_done & int_set_en & !buf0_not_aloc;

always @(posedge clk)
	pid_OUT_r <= pid_OUT;

always @(posedge clk)
	pid_IN_r <= pid_IN;

always @(posedge clk)
	pid_PING_r <= pid_PING;

always @(posedge clk)
	pid_SETUP_r <= pid_SETUP;

always @(posedge clk)
	int_upid_set <= match_r & !pid_SOF & (
				( OUT_ep & !(pid_OUT_r | pid_PING_r))		|
				(  IN_ep &  !pid_IN_r)				|
				(CTRL_ep & !(pid_IN_r | pid_OUT_r | pid_PING_r | pid_SETUP_r))
					);

assign int_to_set  = ((state == 10'b000000_1000) & rx_ack_to) | ((state == 10'b000001_0000) & tx_data_to);

assign int_crc16_set = rx_data_done & crc16_err;

always @(posedge clk)
	int_seqerr_set <= int_seqerr_set_d;

///////////////////////////////////////////////////////////////////
//
// Main Protocol State Machine
//

`ifdef USBF_ASYNC_RESET
always @(posedge clk or negedge rst)
`else
always @(posedge clk)
`endif
	if(!rst)	state <= 10'b000000_0001;
	else
	if(match)	state <= 10'b000000_0001;
	else		state <= next_state;

always @(state or ep_stall or buf0_na or buf1_na or
	pid_seq_err or idma_done or token_valid or pid_ACK or rx_data_done or
	tx_data_to or crc16_err or ep_disabled or no_bufs or mode_hs
	or dma_en or rx_ack_to or pid_PING or txfr_iso or to_small or to_large or
	CTRL_ep or pid_IN or pid_OUT or IN_ep or OUT_ep or pid_SETUP or pid_SOF
	or match_r or abort or buffer_done or no_buf0_dma or max_pl_sz)
   begin
	next_state = state;
	token_pid_sel_d = 0;
	send_token_d = 1'b0;
	rx_dma_en = 1'b0;
	tx_dma_en = 1'b0;
	buf_set_d = 1'b0;
	uc_stat_set_d = 1'b0;
	buf0_rl_d = 1'b0;
	int_set_en = 1'b0;
	rx_ack_to_clr_d = 1'b1;
	int_seqerr_set_d = 1'b0;
	send_zero_length = 1'b0;

	case(state)	// synopsys full_case parallel_case
	   10'b000000_0001:
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state IDLE (%t)", $time);
`endif
`ifdef USBF_DEBUG
		if(rst && match_r && !ep_disabled && !pid_SOF)
		begin
		if(match_r === 1'bx)	$display("ERROR: IDLE: match_r is unknown. (%t)", $time);
		if(ep_disabled === 1'bx)$display("ERROR: IDLE: ep_disabled is unknown. (%t)", $time);
		if(pid_SOF === 1'bx)	$display("ERROR: IDLE: pid_SOF is unknown. (%t)", $time);
		if(ep_stall === 1'bx)	$display("ERROR: IDLE: ep_stall is unknown. (%t)", $time);
		if(buf0_na === 1'bx)	$display("ERROR: IDLE: buf0_na is unknown. (%t)", $time);
		if(buf1_na === 1'bx)	$display("ERROR: IDLE: buf1_na is unknown. (%t)", $time);
		if(no_buf0_dma === 1'bx)$display("ERROR: IDLE: no_buf0_dma is unknown. (%t)", $time);
		if(CTRL_ep === 1'bx)	$display("ERROR: IDLE: CTRL_ep is unknown. (%t)", $time);
		if(pid_IN === 1'bx)	$display("ERROR: IDLE: pid_IN is unknown. (%t)", $time);
		if(pid_OUT === 1'bx)	$display("ERROR: IDLE: pid_OUT is unknown. (%t)", $time);
		if(pid_SETUP === 1'bx)	$display("ERROR: IDLE: pid_SETUP is unknown. (%t)", $time);
		if(pid_PING === 1'bx)	$display("ERROR: IDLE: pid_PING is unknown. (%t)", $time);
		if(mode_hs === 1'bx)	$display("ERROR: IDLE: mode_hs is unknown. (%t)", $time);
		if(IN_ep === 1'bx)	$display("ERROR: IDLE: IN_ep is unknown. (%t)", $time);
		if(OUT_ep === 1'bx)	$display("ERROR: IDLE: OUT_ep is unknown. (%t)", $time);
		end
`endif
// synopsys translate_on

			if(match_r && !ep_disabled && !pid_SOF)
			   begin
				if(ep_stall)		// Halt Forced send STALL
				   begin
					token_pid_sel_d = 2;
					send_token_d = 1'b1;
					next_state = 10'b000000_0010;
				   end
				else
				if(	(buf0_na && buf1_na) || no_buf0_dma ||
					(CTRL_ep && pid_IN   && buf1_na) ||
					(CTRL_ep && pid_OUT  && buf0_na) 
					)
				   begin		// No buffers send NAK
					token_pid_sel_d = 1;
					send_token_d = 1'b1;
					next_state = 10'b000000_0010;
				   end
				else
				if(pid_PING && mode_hs)
				   begin
					token_pid_sel_d = 0;
					send_token_d = 1'b1;
					next_state = 10'b000000_0010;
				   end
				else
				if(IN_ep || (CTRL_ep && pid_IN))
				   begin
					if(max_pl_sz == 11'h0)	send_zero_length = 1'b1;
					tx_dma_en = 1'b1;
					next_state = 10'b000000_0100;
				   end
				else
				if(OUT_ep || (CTRL_ep && (pid_OUT || pid_SETUP)))
				   begin
					rx_dma_en = 1'b1;
					next_state = 10'b000001_0000;
				   end
			   end
		   end

	   10'b000000_0010:
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state TOKEN (%t)", $time);
`endif
// synopsys translate_on
			next_state = 10'b000000_0001;
		   end

	   10'b000000_0100:
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state IN (%t)", $time);
`endif
`ifdef USBF_DEBUG
		if(idma_done === 1'bx)	$display("ERROR: IN: idma_done is unknown. (%t)", $time);
		if(txfr_iso === 1'bx)	$display("ERROR: IN: txfr_iso is unknown. (%t)", $time);
`endif
// synopsys translate_on
			rx_ack_to_clr_d = 1'b0;
			if(idma_done)
			   begin
				if(txfr_iso)	next_state = 10'b010000_0000;
				else		next_state = 10'b000000_1000;
			   end

		   end
	   10'b000000_1000:
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state IN2 (%t)", $time);
`endif
`ifdef USBF_DEBUG
		if(rx_ack_to === 1'bx)	$display("ERROR: IN2: rx_ack_to is unknown. (%t)", $time);
		if(token_valid === 1'bx)$display("ERROR: IN2: token_valid is unknown. (%t)", $time);
		if(pid_ACK === 1'bx)	$display("ERROR: IN2: pid_ACK is unknown. (%t)", $time);
`endif
// synopsys translate_on
			rx_ack_to_clr_d = 1'b0;
			// Wait for ACK from HOST or Timeout
			if(rx_ack_to)	next_state = 10'b000000_0001;
			else
			if(token_valid && pid_ACK)
			   begin
				next_state = 10'b010000_0000;
			   end
		   end

	   10'b000001_0000:
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state OUT (%t)", $time);
`endif
`ifdef USBF_DEBUG
		if(tx_data_to === 1'bx)	$display("ERROR: OUT: tx_data_to is unknown. (%t)", $time);
		if(crc16_err === 1'bx)	$display("ERROR: OUT: crc16_err is unknown. (%t)", $time);
		if(abort === 1'bx)	$display("ERROR: OUT: abort is unknown. (%t)", $time);
		if(rx_data_done === 1'bx)$display("ERROR: OUT: rx_data_done is unknown. (%t)", $time);
		if(txfr_iso === 1'bx)	$display("ERROR: OUT: txfr_iso is unknown. (%t)", $time);
		if(pid_seq_err === 1'bx)$display("ERROR: OUT: rx_data_done is unknown. (%t)", $time);
`endif
// synopsys translate_on
			if(tx_data_to || crc16_err || abort )
				next_state = 10'b000000_0001;
			else
			if(rx_data_done)
			   begin		// Send Ack
				if(txfr_iso)
				   begin
					if(pid_seq_err)		int_seqerr_set_d = 1'b1;
					next_state = 10'b001000_0000;
				   end
				else		next_state = 10'b000010_0000;
			   end
		   end

	   10'b000010_0000:
		   begin	// This is a delay State to NACK to small or to
				// large packets. this state could be skipped
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state OUT2A (%t)", $time);
`endif
`ifdef USBF_DEBUG
		if(abort === 1'bx)	$display("ERROR: OUT2A: abort is unknown. (%t)", $time);
`endif
// synopsys translate_on
			if(abort)	next_state = 10'b000000_0001;
			else		next_state = 10'b000100_0000;
		   end
	   10'b000100_0000:
		   begin	// Send ACK/NACK/NYET
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state OUT2B (%t)", $time);
`endif
`ifdef USBF_DEBUG
		if(abort === 1'bx)	$display("ERROR: OUT2B: abort is unknown. (%t)", $time);
		if(to_small === 1'bx)	$display("ERROR: OUT2B: to_small is unknown. (%t)", $time);
		if(to_large === 1'bx)	$display("ERROR: OUT2B: to_large is unknown. (%t)", $time);
		if(pid_seq_err === 1'bx)$display("ERROR: OUT2B: rx_data_done is unknown. (%t)", $time);
		if(mode_hs === 1'bx)	$display("ERROR: OUT2B: mode_hs is unknown. (%t)", $time);
		if(no_bufs === 1'bx)	$display("ERROR: OUT2B: no_bufs is unknown. (%t)", $time);
`endif
// synopsys translate_on
			if(abort)	next_state = 10'b000000_0001;
			else
			if(to_small || to_large)
			   begin
				token_pid_sel_d = 1;
				next_state = 10'b000000_0001;
			   end
			else
			if(pid_seq_err)	
			   begin
				token_pid_sel_d = 0;
				send_token_d = 1'b1;
				next_state = 10'b000000_0001;
			   end
			else
			   begin
				if(mode_hs && no_bufs)	token_pid_sel_d = 3;
				else			token_pid_sel_d = 0;
				send_token_d = 1'b1;
				next_state = 10'b010000_0000;
			   end
		   end

	   10'b001000_0000:
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state UPDATEW (%t)", $time);
`endif
// synopsys translate_on
			next_state = 10'b010000_0000;
		   end
	   10'b010000_0000:
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state UPDATE (%t)", $time);
`endif
`ifdef USBF_DEBUG
		if(buffer_done === 1'bx)	$display("ERROR: UPDATE: buffer_done is unknown. (%t)", $time);
		if(dma_en === 1'bx)	$display("ERROR: UPDATE: dma_en is unknown. (%t)", $time);
`endif
// synopsys translate_on
			// Interrupts
			int_set_en = 1'b1;
			// Buffer (used, size, adr) set or reload
			if(buffer_done && dma_en)
			   begin
				buf0_rl_d = 1'b1;
			   end
			else
			   begin
				buf_set_d = 1'b1;
			   end
			next_state = 10'b100000_0000;
		   end
	   10'b100000_0000:	// Update Register File & state
		   begin
// synopsys translate_off
`ifdef USBF_VERBOSE_DEBUG
		$display("PE: Entered state UPDATE2 (%t)", $time);
`endif
// synopsys translate_on
			// pid sequence & buffer usage
			uc_stat_set_d = 1'b1;
			next_state = 10'b000000_0001;
		   end
// synopsys translate_off
      default:  	next_state = 10'b000000_0001; //FMP_VC_5
// synopsys translate_on
	endcase // case(state)
      
   end

endmodule

