//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC

/////////////////////////////////////////////////////////////////////
////                                                             ////
////  USB CRC5 and CRC16 Modules                                 ////
////                                                             ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          rudi@asics.ws                                      ////
////                                                             ////
////                                                             ////
////  Downloaded from: http://www.opencores.org/cores/usb/       ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000-2003 Rudolf Usselmann                    ////
////                         www.asics.ws                        ////
////                         rudi@asics.ws                       ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
////     THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY     ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED   ////
//// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS   ////
//// FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL THE AUTHOR      ////
//// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,         ////
//// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    ////
//// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE   ////
//// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        ////
//// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF  ////
//// LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT  ////
//// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  ////
//// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         ////
//// POSSIBILITY OF SUCH DAMAGE.                                 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////

//  CVS Log
//
//  $Id: usbf_crc16.v,v 1.2 2003/10/17 02:36:57 rudi Exp $
//
//  $Date: 2003/10/17 02:36:57 $
//  $Revision: 1.2 $
//  $Author: rudi $
//  $Locker:  $
//  $State: Exp $
//
// Change History:
//               $Log: usbf_crc16.v,v $
//               Revision 1.2  2003/10/17 02:36:57  rudi
//               - Disabling bit stuffing and NRZI encoding during speed negotiation
//               - Now the core can send zero size packets
//               - Fixed register addresses for some of the higher endpoints
//                 (conversion between decimal/hex was wrong)
//               - The core now does properly evaluate the function address to
//                 determine if the packet was intended for it.
//               - Various other minor bugs and typos
//
//               Revision 1.1  2001/08/03 05:30:09  rudi
//
//
//               1) Reorganized directory structure
//
//               Revision 1.0  2001/03/07 09:17:12  rudi
//
//
//               Changed all revisions to revision 1.0. This is because OpenCores CVS
//               interface could not handle the original '0.1' revision ....
//
//               Revision 0.1.0.1  2001/02/28 08:10:42  rudi
//               Initial Release
//
//                            

`include "usbf_defines.v"

///////////////////////////////////////////////////////////////////
//
// CRC16
//
///////////////////////////////////////////////////////////////////

module usbf_crc16(/*AUTOARG*/
   // Outputs
   crc_out15, crc_out14, crc_out13, crc_out12, crc_out11, crc_out10,
   crc_out9, crc_out8, crc_out7, crc_out6, crc_out5, crc_out4,
   crc_out3, crc_out2, crc_out1, crc_out0,
   // Inputs
   crc_in, din
   );
input	[15:0]	crc_in;
input	[7:0]	din;
//FMP_VC_1//output	[15:0]	crc_out;
   output	crc_out15;
   output	crc_out14;
   output	crc_out13;
   output	crc_out12;
   output	crc_out11;
   output	crc_out10;
   output	crc_out9;
   output	crc_out8;
   output	crc_out7;
   output	crc_out6;
   output	crc_out5;
   output	crc_out4;
   output	crc_out3;
   output	crc_out2;
   output	crc_out1;
   output	crc_out0;

//FMP_VC_1   
assign 	/*crc_out[0]*/ crc_out0 =	din[7] ^ din[6] ^ din[5] ^ din[4] ^ din[3] ^
			din[2] ^ din[1] ^ din[0] ^ crc_in[8] ^ crc_in[9] ^
			crc_in[10] ^ crc_in[11] ^ crc_in[12] ^ crc_in[13] ^
			crc_in[14] ^ crc_in[15];
//FMP_VC_1
assign /*crc_out[1]*/  crc_out1=	din[7] ^ din[6] ^ din[5] ^ din[4] ^ din[3] ^ din[2] ^
			din[1] ^ crc_in[9] ^ crc_in[10] ^ crc_in[11] ^
			crc_in[12] ^ crc_in[13] ^ crc_in[14] ^ crc_in[15];
//FMP_VC_1
assign /*crc_out[2]*/  crc_out2=	din[1] ^ din[0] ^ crc_in[8] ^ crc_in[9];
//FMP_VC_1
assign /*crc_out[3]*/  crc_out3=	din[2] ^ din[1] ^ crc_in[9] ^ crc_in[10];
//FMP_VC_1
assign /*crc_out[4]*/  crc_out4=	din[3] ^ din[2] ^ crc_in[10] ^ crc_in[11];
//FMP_VC_1
assign /*crc_out[5]*/  crc_out5=	din[4] ^ din[3] ^ crc_in[11] ^ crc_in[12];
//FMP_VC_1
assign /*crc_out[6]*/  crc_out6=	din[5] ^ din[4] ^ crc_in[12] ^ crc_in[13];
//FMP_VC_1
assign /*crc_out[7]*/  crc_out7=	din[6] ^ din[5] ^ crc_in[13] ^ crc_in[14];
//FMP_VC_1
assign /*crc_out[8]*/  crc_out8=	din[7] ^ din[6] ^ crc_in[0] ^ crc_in[14] ^ crc_in[15];
//FMP_VC_1
assign /*crc_out[9]*/  crc_out9=	din[7] ^ crc_in[1] ^ crc_in[15];
//FMP_VC_1
assign /*crc_out[10]*/ crc_out10=	crc_in[2];
//FMP_VC_1
assign /*crc_out[11]*/ crc_out11=	crc_in[3];
//FMP_VC_1
assign /*crc_out[12]*/ crc_out12=	crc_in[4];
//FMP_VC_1
assign /*crc_out[13]*/ crc_out13=	crc_in[5];
//FMP_VC_1
assign /*crc_out[14]*/ crc_out14=	crc_in[6];
//FMP_VC_1
assign /*crc_out[15]*/ crc_out15=	din[7] ^ din[6] ^ din[5] ^ din[4] ^ din[3] ^ din[2] ^
			din[1] ^ din[0] ^ crc_in[7] ^ crc_in[8] ^ crc_in[9] ^
			crc_in[10] ^ crc_in[11] ^ crc_in[12] ^ crc_in[13] ^
			crc_in[14] ^ crc_in[15];

endmodule

