//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC

/////////////////////////////////////////////////////////////////////
////                                                             ////
////  Protocol Layer                                             ////
////  This block is typically referred to as the SEI in USB      ////
////  Specification. It encapsulates the Packet Assembler,       ////
////  disassembler, protocol engine and internal DMA             ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          rudi@asics.ws                                      ////
////                                                             ////
////                                                             ////
////  Downloaded from: http://www.opencores.org/cores/usb/       ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000-2003 Rudolf Usselmann                    ////
////                         www.asics.ws                        ////
////                         rudi@asics.ws                       ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
////     THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY     ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED   ////
//// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS   ////
//// FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL THE AUTHOR      ////
//// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,         ////
//// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    ////
//// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE   ////
//// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        ////
//// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF  ////
//// LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT  ////
//// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  ////
//// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         ////
//// POSSIBILITY OF SUCH DAMAGE.                                 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////

//  CVS Log
//
//  $Id: usbf_pl.v,v 1.5 2003/10/17 02:36:57 rudi Exp $
//
//  $Date: 2003/10/17 02:36:57 $
//  $Revision: 1.5 $
//  $Author: rudi $
//  $Locker:  $
//  $State: Exp $
//
// Change History:
//               $Log: usbf_pl.v,v $
//               Revision 1.5  2003/10/17 02:36:57  rudi
//               - Disabling bit stuffing and NRZI encoding during speed negotiation
//               - Now the core can send zero size packets
//               - Fixed register addresses for some of the higher endpoints
//                 (conversion between decimal/hex was wrong)
//               - The core now does properly evaluate the function address to
//                 determine if the packet was intended for it.
//               - Various other minor bugs and typos
//
//               Revision 1.4  2001/11/04 12:22:45  rudi
//
//               - Fixed previous fix (brocke something else ...)
//               - Majore Synthesis cleanup
//
//               Revision 1.3  2001/09/24 01:15:28  rudi
//
//               Changed reset to be active high async.
//
//               Revision 1.2  2001/08/10 08:48:33  rudi
//
//               - Changed IO names to be more clear.
//               - Uniquifyed define names to be core specific.
//
//               Revision 1.1  2001/08/03 05:30:09  rudi
//
//
//               1) Reorganized directory structure
//
//               Revision 1.2  2001/03/31 13:00:52  rudi
//
//               - Added Core configuration
//               - Added handling of OUT packets less than MAX_PL_SZ in DMA mode
//               - Modified WISHBONE interface and sync logic
//               - Moved SSRAM outside the core (added interface)
//               - Many small bug fixes ...
//
//               Revision 1.0  2001/03/07 09:17:12  rudi
//
//
//               Changed all revisions to revision 1.0. This is because OpenCores CVS
//               interface could not handle the original '0.1' revision ....
//
//               Revision 0.1.0.1  2001/02/28 08:11:11  rudi
//               Initial Release
//
//

`include "usbf_defines.v"

module main(/*AUTOARG*/
   // Outputs
   tx_data7, tx_data6, tx_data5, tx_data4, tx_data3, tx_data2,
   tx_data1, tx_data0, tx_valid, tx_valid_last, tx_first, madr14,
   madr13, madr12, madr11, madr10, madr9, madr8, madr7, madr6, madr5,
   madr4, madr3, madr2, madr1, madr0, mdout31, mdout30, mdout29,
   mdout28, mdout27, mdout26, mdout25, mdout24, mdout23, mdout22,
   mdout21, mdout20, mdout19, mdout18, mdout17, mdout16, mdout15,
   mdout14, mdout13, mdout12, mdout11, mdout10, mdout9, mdout8,
   mdout7, mdout6, mdout5, mdout4, mdout3, mdout2, mdout1, mdout0,
   mwe, mreq, idin31, idin30, idin29, idin28, idin27, idin26, idin25,
   idin24, idin23, idin22, idin21, idin20, idin19, idin18, idin17,
   idin16, idin15, idin14, idin13, idin12, idin11, idin10, idin9,
   idin8, idin7, idin6, idin5, idin4, idin3, idin2, idin1, idin0,
   ep_sel3, ep_sel2, ep_sel1, ep_sel0, nse_err, buf0_rl, buf0_set,
   buf1_set, uc_bsel_set, uc_dpd_set, int_buf1_set, int_buf0_set,
   int_upid_set, int_crc16_set, int_to_set, int_seqerr_set,
   out_to_small, pid_cs_err, crc5_err, frm_nat31, frm_nat30,
   frm_nat29, frm_nat28, frm_nat27, frm_nat26, frm_nat25, frm_nat24,
   frm_nat23, frm_nat22, frm_nat21, frm_nat20, frm_nat19, frm_nat18,
   frm_nat17, frm_nat16, frm_nat15, frm_nat14, frm_nat13, frm_nat12,
   frm_nat11, frm_nat10, frm_nat9, frm_nat8, frm_nat7, frm_nat6,
   frm_nat5, frm_nat4, frm_nat3, frm_nat2, frm_nat1, frm_nat0,
	    usbf_pd_state,usbf_pe_state, usbf_idma_state, //FMP_VC_0
	    tx_first_r,send_data_r,send_zero_length_r,  //FMP_VC_0
	    match_ro,pid_SOF,buf0_na_o,buf1_na_o,rx_ack_to_o, tx_data_to_o,//FMP_VC_0
   // Inputs
   clk, rst, rx_data, rx_valid, rx_active, rx_err, tx_ready,
   tx_valid_out, mode_hs, usb_reset, usb_suspend, usb_attached, mdin,
   mack, fa, match, dma_in_buf_sz1, dma_out_buf_avail, 
//csr, //FMP_VC_1
	    	csr31,csr30,csr29,csr28,csr27,csr26,csr25,csr24,csr23,csr22,
		csr21,csr20,csr19,csr18,csr17,csr16,csr15,csr14,csr13,csr12,
		csr11,csr10,csr9, csr8, csr7, csr6, csr5, csr4, csr3, csr2,
		csr1, csr0, 
	    buf0,   buf1
   );

   //FMP_VC_2//parameter	SSRAM_HADR = 14;

   output [3:0] usbf_pd_state; //FMP_VC_0
   output [9:0] usbf_pe_state;//FMP_VC_0
   output [7:0] usbf_idma_state;//FMP_VC_0
   output       tx_first_r,send_data_r,send_zero_length_r;//FMP_VC_0
   output 	match_ro;//FMP_VC_0
   output 	pid_SOF;//FMP_VC_0
   output 	buf0_na_o,buf1_na_o;//FMP_VC_0
   output 	rx_ack_to_o;//FMP_VC_0
   output 	tx_data_to_o;//FMP_VC_0
   
   // UTMI Interface
   input 	clk, rst;
   input [7:0] 	rx_data;
   input 	rx_valid, rx_active, rx_err;
   //FMP_VC_1//output	[7:0]	tx_data;
   output	tx_data7;
   output	tx_data6;
   output	tx_data5;
   output	tx_data4;
   output	tx_data3;
   output	tx_data2;
   output	tx_data1;
   output	tx_data0;
   
   
   output 	tx_valid;
   output 	tx_valid_last;
   input 	tx_ready;
   output 	tx_first;
   input 	tx_valid_out;
   input 	mode_hs;	// High Speed Mode
   input 	usb_reset;	// USB Reset
   input 	usb_suspend;	// USB Suspend
   input 	usb_attached;	// Attached to USB
   
   // Memory Arbiter Interface
   //FMP_VC_1//output	[14:0]	madr;		// word address
   output 	madr14;
   output 	madr13;
   output 	madr12;
   output 	madr11;
   output 	madr10;
   output 	madr9;
   output 	madr8;
   output 	madr7;
   output 	madr6;
   output 	madr5;
   output 	madr4;
   output 	madr3;
   output 	madr2;
   output 	madr1;
   output 	madr0;
   
   //FMP_VC_1//output	[31:0]	mdout;
   output 	mdout31;  
   output 	mdout30;  
   output 	mdout29;  
   output 	mdout28;  
   output 	mdout27;  
   output 	mdout26;  
   output 	mdout25;  
   output 	mdout24;  
   output 	mdout23;  
   output 	mdout22;  
   output 	mdout21;  
   output 	mdout20;  
   output 	mdout19;  
   output 	mdout18;  
   output 	mdout17;  
   output 	mdout16;  
   output 	mdout15;  
   output 	mdout14;  
   output 	mdout13;  
   output 	mdout12;  
   output 	mdout11;  
   output 	mdout10;  
   output 	mdout9;  
   output 	mdout8;  
   output 	mdout7;  
   output 	mdout6;  
   output 	mdout5;  
   output 	mdout4;  
   output 	mdout3;  
   output 	mdout2;  
   output 	mdout1;  
   output 	mdout0;  
   
   input [31:0] mdin;
   output 	mwe;
   output 	mreq;
   input 	mack;
   
   // Register File interface
   input [6:0] 	fa;		// Function Address (as set by the controller)
   
   //FMP_VC_1//output	[31:0]	idin;		// Data Input
   output 	idin31;  
   output 	idin30;  
   output 	idin29;  
   output 	idin28;  
   output 	idin27;  
   output 	idin26;  
   output 	idin25;  
   output 	idin24;  
   output 	idin23;  
   output 	idin22;  
   output 	idin21;  
   output 	idin20;  
   output 	idin19;  
   output 	idin18;  
   output 	idin17;  
   output 	idin16;  
   output 	idin15;  
   output 	idin14;  
   output 	idin13;  
   output 	idin12;  
   output 	idin11;  
   output 	idin10;  
   output 	idin9;  
   output 	idin8;  
   output 	idin7;  
   output 	idin6;  
   output 	idin5;  
   output 	idin4;  
   output 	idin3;  
   output 	idin2;  
   output 	idin1;  
   output 	idin0;  
   
   //FMP_VC_1//output	[3:0]	ep_sel;		// Endpoint Number Input
   output 	ep_sel3;  
   output 	ep_sel2;  
   output 	ep_sel1;  
   output 	ep_sel0;  
   
   
   
   input 	match;		// Endpoint Matched
   input 	dma_in_buf_sz1;
   input 	dma_out_buf_avail;
   output 	nse_err;	// no such endpoint error
   
   output 	buf0_rl;	// Reload Buf 0 with original values
   output 	buf0_set;	// Write to buf 0
   output 	buf1_set;	// Write to buf 1
   output 	uc_bsel_set;	// Write to the uc_bsel field
   output 	uc_dpd_set;	// Write to the uc_dpd field
   output 	int_buf1_set;	// Set buf1 full/empty interrupt
   output 	int_buf0_set;	// Set buf0 full/empty interrupt
   output 	int_upid_set;	// Set unsupported PID interrupt
   output 	int_crc16_set;	// Set CRC16 error interrupt
   output 	int_to_set;	// Set time out interrupt
   output 	int_seqerr_set;	// Set PID sequence error interrupt
   output 	out_to_small;	// OUT packet was to small for DMA operation
   
   //FMP_VC_1//input	[31:0]	csr;		// Internal CSR Output
   
   input 	csr31,csr30,csr29,csr28,csr27,csr26,csr25,csr24,csr23,csr22,
		csr21,csr20,csr19,csr18,csr17,csr16,csr15,csr14,csr13,csr12,
		csr11,csr10,csr9, csr8, csr7, csr6, csr5, csr4, csr3, csr2,
		csr1, csr0;
   
   
   
   
   
   input [31:0] buf0;		// Internal Buf 0 Output
   input [31:0] buf1;		// Internal Buf 1 Output
   
   // Misc
   output 	pid_cs_err;	// pid checksum error
   output 	crc5_err;	// crc5 error
   //FMP_VC_1//output	[31:0]	frm_nat;
   output 	frm_nat31;  
   output 	frm_nat30;  
   output 	frm_nat29;  
   output 	frm_nat28;  
   output 	frm_nat27;  
   output 	frm_nat26;  
   output 	frm_nat25;  
   output 	frm_nat24;  
   output 	frm_nat23;  
   output 	frm_nat22;  
   output 	frm_nat21;  
   output 	frm_nat20;  
   output 	frm_nat19;  
   output 	frm_nat18;  
   output 	frm_nat17;  
   output 	frm_nat16;  
   output 	frm_nat15;  
   output 	frm_nat14;  
   output 	frm_nat13;  
   output 	frm_nat12;  
   output 	frm_nat11;  
   output 	frm_nat10;  
   output 	frm_nat9;  
   output 	frm_nat8;  
   output 	frm_nat7;  
   output 	frm_nat6;  
   output 	frm_nat5;  
   output 	frm_nat4;  
   output 	frm_nat3;  
   output 	frm_nat2;  
   output 	frm_nat1;  
   output 	frm_nat0;
   
///////////////////////////////////////////////////////////////////
//
// Local Wires and Registers
//

   // Packet Disassembler Interface
   wire		clk, rst;
   
   wire [7:0] 	rx_data;
   wire		pid_OUT, pid_IN, pid_SOF, pid_SETUP;
   wire		pid_DATA0, pid_DATA1, pid_DATA2, pid_MDATA;
   wire		pid_ACK, pid_NACK, pid_STALL, pid_NYET;
   wire		pid_PRE, pid_ERR, pid_SPLIT, pid_PING;
   //FMP_VC_3//wire	[6:0]	token_fadr;
   wire		token_valid;
   wire		crc5_err;
   //FMP_VC_3//wire	[10:0]	frame_no;
   //FMP_VC_3//wire	[7:0]	rx_data_st;
   wire		rx_data_valid;
   wire		rx_data_done;
   wire		crc16_err;
   wire		rx_seq_err;
   
   // Packet Assembler Interface
   wire		send_token;
   //FMP_VC_3//wire	[1:0]	token_pid_sel;
   wire		send_data;
   //FMP_VC_3//wire	[1:0]	data_pid_sel;
   //FMP_VC_3//wire	[7:0]	tx_data_st;
   wire		rd_next;
   
   // IDMA Interface
   wire		rx_dma_en;	// Allows the data to be stored
   wire		tx_dma_en;	// Allows for data to be retrieved
   wire		abort;		// Abort Transfer (time_out, crc_err or rx_error)
   wire		idma_done;	// DMA is done
   //FMP_VC_3//FMP_VC_6//wire	[SSRAM_HADR + 2:0]	adr;		// Byte Address
   //FMP_VC_3//wire	[16:0]	adr;		// Byte Address
   //FMP_VC_3//wire	[13:0]	size;		// Size in bytes
   //FMP_VC_3//wire	[10:0]	sizu_c;		// Up and Down counting size registers, used
   // to update
   //wire	[13:0]	buf_size;	// Actual buffer size
   wire		dma_en;		// external dma enabled
   
   // Memory Arbiter Interface
   //FMP_VC_3//wire	[14:0]	madr;	// word address
   //FMP_VC_3//wire	[31:0]	mdout;
   wire [31:0] 	mdin;
   wire		mwe;
   wire		mreq;
   wire		mack;
   
   // Local signals
   wire		pid_bad, pid_bad1, pid_bad2;
   
   reg		hms_clk;	// 0.5 Micro Second Clock
   reg [4:0] 	hms_cnt;
   reg [10:0] 	frame_no_r;	// Current Frame Number register
   wire		frame_no_we;
   reg		frame_no_same;	// Indicates current and prev. frame numbers
   // are equal
   reg [3:0] 	mfm_cnt;	// Micro Frame Counter
   reg [11:0] 	sof_time;	// Time since last sof
   reg		clr_sof_time;
   wire		fsel;		// This Function is selected
   wire		match_o;
   
   reg		frame_no_we_r;
   
   //FMP_VC_3
   wire [31:0] 	csr = {csr31,csr30,csr29,csr28,csr27,csr26,csr25,csr24,csr23,csr22,
		       csr21,csr20,csr19,csr18,csr17,csr16,csr15,csr14,csr13,csr12,
		       csr11,csr10,csr9, csr8, csr7, csr6, csr5, csr4, csr3, csr2,
		       csr1, csr0};
   
   wire 	token_pid_sel1,token_pid_sel0;
   wire 	data_pid_sel1,data_pid_sel0;
   wire 	tx_data_st7,tx_data_st6,tx_data_st5,tx_data_st4,
		tx_data_st3,tx_data_st2,tx_data_st1,tx_data_st0;
   wire 	adr16,adr15,adr14,adr13,adr12,adr11,adr10,adr9,adr8,
		adr7,adr6,adr5,adr4,adr3,adr2,adr1,adr0;
   wire 	size13,size12,size11,size10,size9,size8,
		size7,size6,size5,size4,size3,size2,size1,size0;
   wire 	sizu_c10,sizu_c9,sizu_c8,sizu_c7,sizu_c6,sizu_c5,
		sizu_c4,sizu_c3,sizu_c2,sizu_c1,sizu_c0;
   wire 	buf_size13,buf_size12,buf_size11,buf_size10,buf_size9,buf_size8,
		buf_size7,buf_size6,buf_size5,buf_size4,buf_size3,
		buf_size2,buf_size1,buf_size0;
   
   wire		madr14,madr13,madr12,madr11,madr10,madr9,madr8,
		madr7,madr6,madr5,madr4,madr3,madr2,madr1,madr0;	// word address
   
   wire		mdout31,mdout30,mdout29,mdout28,mdout27,mdout26,mdout25,mdout24,
		mdout23,mdout22,mdout21,mdout20,mdout19,mdout18,mdout17,mdout16,
		mdout15,mdout14,mdout13,mdout12,mdout11,mdout10,mdout9,mdout8,
		mdout7,mdout6,mdout5,mdout4,mdout3,mdout2,mdout1,mdout0;
   
   wire 	token_fadr6,token_fadr5,token_fadr4,token_fadr3,token_fadr2,token_fadr1,token_fadr0;
   wire 	frame_no10,frame_no9,frame_no8,frame_no7,frame_no6,frame_no5,frame_no4,frame_no3,frame_no2,frame_no1,frame_no0;
   wire 	rx_data_st7,rx_data_st6,rx_data_st5,rx_data_st4,rx_data_st3,rx_data_st2,rx_data_st1,rx_data_st0;
   
   wire [6:0] 	token_fadr = {token_fadr6,token_fadr5,token_fadr4,token_fadr3,token_fadr2,token_fadr1,token_fadr0};
   wire [10:0] 	frame_no = {frame_no10,frame_no9,frame_no8,frame_no7,frame_no6,frame_no5,frame_no4,frame_no3,frame_no2,frame_no1,frame_no0};
   wire [7:0] 	rx_data_st = {rx_data_st7,rx_data_st6,rx_data_st5,rx_data_st4,rx_data_st3,rx_data_st2,rx_data_st1,rx_data_st0};
   
   wire [3:0] 	ep_sel = {ep_sel3,ep_sel2,ep_sel1,ep_sel1};
   
   wire [7:0] 	tx_data = {tx_data7,tx_data6,tx_data5,tx_data4,
			   tx_data3,tx_data2,tx_data1,tx_data0};
   

      /*FMP_VC_4 */
// synopsys translate_off
`ifdef VCEGAR
   initial begin
      frame_no_we_r   =  1'd0;
      frame_no_r      =  11'd0;
      frame_no_same   =  1'd0;
      mfm_cnt         =  4'd0;
      clr_sof_time    =  1'd0;
      sof_time        =  12'd0;
      hms_cnt         =  5'd0;
      hms_clk         =  1'd0;   
   end
`endif
   // synopsys translate_on
///////////////////////////////////////////////////////////////////
//
// Misc Logic
//

// PIDs we should never receive
assign pid_bad1 = pid_ACK | pid_NACK | pid_STALL | pid_NYET | pid_PRE |
			pid_ERR | pid_SPLIT;

// PIDs we should never get in full speed mode (high speed mode only)
assign pid_bad2 = !mode_hs & pid_PING;

// All bad pids
assign pid_bad = pid_bad1 | pid_bad2;

assign match_o = !pid_bad & fsel & match & token_valid & !crc5_err;

// Frame Number (from SOF token)
assign frame_no_we = token_valid & !crc5_err & pid_SOF;

always @(posedge clk)
	frame_no_we_r <= frame_no_we;

`ifdef USBF_ASYNC_RESET
always @(posedge clk or negedge rst)
`else
always @(posedge clk)
`endif
	if(!rst)		frame_no_r <= 11'h0;
	else
	if(frame_no_we_r)	frame_no_r <= frame_no;

// Micro Frame Counter
always @(posedge clk)
	frame_no_same <= frame_no_we & (frame_no_r == frame_no);

`ifdef USBF_ASYNC_RESET
always @(posedge clk or negedge rst)
`else
always @(posedge clk)
`endif
	if(!rst)		mfm_cnt <= 4'h0;
	else
	if(frame_no_we_r && !frame_no_same)
				mfm_cnt <= 4'h0;
	else
	if(frame_no_same)	mfm_cnt <= mfm_cnt + 4'h1;

//SOF delay counter
always @(posedge clk)
	clr_sof_time <= frame_no_we;

always @(posedge clk)
	if(clr_sof_time)	sof_time <= 12'h0;
	else
	if(hms_clk)		sof_time <= sof_time + 12'h1;

//FMP_VC_3//assign frm_nat = {mfm_cnt, 1'b0, frame_no_r, 4'h0, sof_time};

   wire [31:0]	frm_nat = {mfm_cnt, 1'b0, frame_no_r, 4'h0, sof_time};
   assign 	frm_nat31 = frm_nat[31:31];
   assign 	frm_nat30 = frm_nat[30:30];
   assign 	frm_nat29 = frm_nat[29:29];
   assign 	frm_nat28 = frm_nat[28:28];
   assign 	frm_nat27 = frm_nat[27:27];
   assign 	frm_nat26 = frm_nat[26:26];
   assign 	frm_nat25 = frm_nat[25:25];
   assign 	frm_nat24 = frm_nat[24:24];
   assign 	frm_nat23 = frm_nat[23:23];
   assign 	frm_nat22 = frm_nat[22:22];
   assign 	frm_nat21 = frm_nat[21:21];
   assign 	frm_nat20 = frm_nat[20:20];
   assign 	frm_nat19 = frm_nat[19:19];
   assign 	frm_nat18 = frm_nat[18:18];
   assign 	frm_nat17 = frm_nat[17:17];
   assign 	frm_nat16 = frm_nat[16:16];
   assign 	frm_nat15 = frm_nat[15:15];
   assign 	frm_nat14 = frm_nat[14:14];
   assign 	frm_nat13 = frm_nat[13:13];
   assign 	frm_nat12 = frm_nat[12:12];
   assign 	frm_nat11 = frm_nat[11:11];
   assign 	frm_nat10 = frm_nat[10:10];
   assign 	frm_nat9  = frm_nat[9:9];
   assign 	frm_nat8  = frm_nat[8:8];
   assign 	frm_nat7  = frm_nat[7:7];
   assign 	frm_nat6  = frm_nat[6:6];
   assign 	frm_nat5  = frm_nat[5:5]; 
   assign 	frm_nat4  = frm_nat[4:4];
   assign 	frm_nat3  = frm_nat[3:3];
   assign 	frm_nat2  = frm_nat[2:2];
   assign 	frm_nat1  = frm_nat[1:1];
   assign 	frm_nat0  = frm_nat[0:0];

   
// 0.5 Micro Seconds Clock Generator
`ifdef USBF_ASYNC_RESET
always @(posedge clk or negedge rst)
`else
always @(posedge clk)
`endif
	if(!rst)				hms_cnt <= 5'h0;
	else
	if(hms_clk || frame_no_we_r)		hms_cnt <= 5'h0;
	else					hms_cnt <= hms_cnt + 5'h1;

always @(posedge clk)
	hms_clk <= (hms_cnt == `USBF_HMS_DEL);

///////////////////////////////////////////////////////////////////

// This function is addressed
assign fsel = (token_fadr == fa);

///////////////////////////////////////////////////////////////////
//
// Module Instantiations
//

//Packet Decoder
usbf_pd	u0(	.clk(			clk			),
		.rst(			rst			),
		.rx_data(		rx_data			),
		.rx_valid(		rx_valid		),
		.rx_active(		rx_active		),
		.rx_err(		rx_err			),
		.pid_OUT(		pid_OUT			),
		.pid_IN(		pid_IN			),
		.pid_SOF(		pid_SOF			),
		.pid_SETUP(		pid_SETUP		),
		.pid_DATA0(		pid_DATA0		),
		.pid_DATA1(		pid_DATA1		),
		.pid_DATA2(		pid_DATA2		),
		.pid_MDATA(		pid_MDATA		),
		.pid_ACK(		pid_ACK			),
		.pid_NACK(		pid_NACK		),
		.pid_STALL(		pid_STALL		),
		.pid_NYET(		pid_NYET		),
		.pid_PRE(		pid_PRE			),
		.pid_ERR(		pid_ERR			),
		.pid_SPLIT(		pid_SPLIT		),
		.pid_PING(		pid_PING		),
		.pid_cks_err(		pid_cs_err		),
//FMP_VC_1		.token_fadr(		token_fadr		),
		.token_fadr6(		token_fadr6		),
		.token_fadr5(		token_fadr5		),
		.token_fadr4(		token_fadr4		),
		.token_fadr3(		token_fadr3		),
		.token_fadr2(		token_fadr2		),
		.token_fadr1(		token_fadr1		),
		.token_fadr0(		token_fadr0		),

		.token_endp3(		ep_sel3			),
		.token_endp2(		ep_sel2			),
		.token_endp1(		ep_sel1			),
		.token_endp0(		ep_sel0			),
		.token_valid(		token_valid		),
		.crc5_err(		crc5_err		),
//FMP_VC_1		.frame_no(		frame_no		),
		.frame_no10(		frame_no10		),
		.frame_no9(		frame_no9		),
		.frame_no8(		frame_no8		),
		.frame_no7(		frame_no7		),
		.frame_no6(		frame_no6		),
		.frame_no5(		frame_no5		),
		.frame_no4(		frame_no4		),
		.frame_no3(		frame_no3		),
		.frame_no2(		frame_no2		),
		.frame_no1(		frame_no1		),
		.frame_no0(		frame_no0		),
		
//FMP_VC_1		.rx_data_st(		rx_data_st		),
		.rx_data_st7(		rx_data_st7		),
		.rx_data_st6(		rx_data_st6		),
		.rx_data_st5(		rx_data_st5		),
		.rx_data_st4(		rx_data_st4		),
		.rx_data_st3(		rx_data_st3		),
		.rx_data_st2(		rx_data_st2		),
		.rx_data_st1(		rx_data_st1		),
		.rx_data_st0(		rx_data_st0		),

		.rx_data_valid(		rx_data_valid		),
		.rx_data_done(		rx_data_done		),
		.crc16_err(		crc16_err		),
		.seq_err(		rx_seq_err		),
		.usbf_pd_state (usbf_pd_state)//FMP_VC_0
		);
   
// Packet Assembler
usbf_pa	u1(	.clk(			clk			),
		.rst(			rst			),
		.tx_data7			(tx_data7),
		.tx_data6			(tx_data6),
		.tx_data5			(tx_data5),
		.tx_data4			(tx_data4),
		.tx_data3			(tx_data3),
		.tx_data2			(tx_data2),
		.tx_data1			(tx_data1),
		.tx_data0			(tx_data0),
		.tx_valid(		tx_valid		),
		.tx_valid_last(		tx_valid_last		),
		.tx_ready(		tx_ready		),
		.tx_first(		tx_first		),
		.send_token(		send_token		),
//FMP_VC_1        .token_pid_sel(		token_pid_sel           ),
		.token_pid_sel(		{token_pid_sel1,token_pid_sel0}	),
		.send_data(		send_data		),
//FMP_VC_1        .data_pid_sel(		data_pid_sel            ),
		.data_pid_sel(		{data_pid_sel1,data_pid_sel0}	),
		.send_zero_length(	send_zero_length	),
//FMP_VC_1	.tx_data_st(		tx_data_st		),
		 .tx_data_st(		{tx_data_st7,tx_data_st6,tx_data_st5,tx_data_st4,
					 tx_data_st3,tx_data_st2,tx_data_st1,tx_data_st0}),
		.tx_first_r(tx_first_r), //FMP_VC_0
		.rd_next(		rd_next			)
		);

// Internal DMA / Memory Arbiter Interface
usbf_idma //#(14)
	u2(
	   .send_data_r(send_data_r), //FMP_VC_0
	   .send_zero_length_r(send_zero_length_r),
	        .clk(			clk			),
		.rst(			rst			),
		.rx_data_st(		rx_data_st		),
		.rx_data_valid(		rx_data_valid		),
		.rx_data_done(		rx_data_done		),
		.send_data(		send_data		),
//FMP_VC_1		.tx_data_st(		tx_data_st		),
		.tx_data_st7(		tx_data_st7		),
		.tx_data_st6(		tx_data_st6		),
		.tx_data_st5(		tx_data_st5		),
		.tx_data_st4(		tx_data_st4		),
		.tx_data_st3(		tx_data_st3		),
		.tx_data_st2(		tx_data_st2		),
		.tx_data_st1(		tx_data_st1		),
		.tx_data_st0(		tx_data_st0		),

		.rd_next(		rd_next			),
		.rx_dma_en(		rx_dma_en		),
		.tx_dma_en(		tx_dma_en		),
		.abort(			abort			),
		.idma_done(		idma_done		),
//FMP_VC_1		.adr(			adr			),
		.adr(	{adr16,adr15,adr14,adr13,adr12,adr11,adr10,adr9,adr8,
			 adr7,adr6,adr5,adr4,adr3,adr2,adr1,adr0}),
//FMP_VC_1		.size(			size			),
		.size(	{size13,size12,size11,size10,size9,size8,
			 size7,size6,size5,size4,size3,size2,size1,size0}),
		
//FMP_VC_1		.buf_size(		buf_size		),
	.buf_size({buf_size13,buf_size12,buf_size11,buf_size10,buf_size9,buf_size8,
			 buf_size7,buf_size6,buf_size5,buf_size4,buf_size3,
		   buf_size2,buf_size1,buf_size0}),

		.dma_en(		dma_en			),
		.send_zero_length(	send_zero_length	),
		.madr14(		madr14			),
		.madr13(		madr13			),
		.madr12(		madr12			),
		.madr11(		madr11			),
		.madr10(		madr10			),
		.madr9(			madr9			),
		.madr8(			madr8			),
		.madr7(			madr7			),
		.madr6(			madr6			),
		.madr5(			madr5			),
		.madr4(			madr4			),
		.madr3(			madr3			),
		.madr2(			madr2			),
		.madr1(			madr1			),
		.madr0(			madr0			),
//		.sizu_c(		sizu_c			),
		.sizu_c10(		sizu_c10			),
		.sizu_c9(		sizu_c9			),
		.sizu_c8(		sizu_c8			),
		.sizu_c7(		sizu_c7			),
		.sizu_c6(		sizu_c6			),
		.sizu_c5(		sizu_c5			),
		.sizu_c4(		sizu_c4			),
		.sizu_c3(		sizu_c3			),
		.sizu_c2(		sizu_c2			),
		.sizu_c1(		sizu_c1			),
		.sizu_c0(		sizu_c0			),

	   .mdout31			(mdout31),
	   .mdout30			(mdout30),
	   .mdout29			(mdout29),
	   .mdout28			(mdout28),
	   .mdout27			(mdout27),
	   .mdout26			(mdout26),
	   .mdout25			(mdout25),
	   .mdout24			(mdout24),
	   .mdout23			(mdout23),
	   .mdout22			(mdout22),
	   .mdout21			(mdout21),
	   .mdout20			(mdout20),
	   .mdout19			(mdout19),
	   .mdout18			(mdout18),
	   .mdout17			(mdout17),
	   .mdout16			(mdout16),
	   .mdout15			(mdout15),
	   .mdout14			(mdout14),
	   .mdout13			(mdout13),
	   .mdout12			(mdout12),
	   .mdout11			(mdout11),
	   .mdout10			(mdout10),
	   .mdout9			(mdout9),	
	   .mdout8			(mdout8),	
	   .mdout7			(mdout7),	
	   .mdout6			(mdout6),	
	   .mdout5			(mdout5),	
	   .mdout4			(mdout4),	
	   .mdout3			(mdout3),	
	   .mdout2			(mdout2),	
	   .mdout1			(mdout1),	
	   .mdout0			(mdout0),	

 .usbf_idma_state  (usbf_idma_state), //FMP_VC_0
.rx_dma_en_r(rx_dma_en_r),//FMP_VC_0


		.mdin(			mdin			),
		.mwe(			mwe			),
		.mreq(			mreq			),
		.mack(			mack			)
		);

// Protocol Engine
usbf_pe //#(14)
	u3(
.buffer_overflow(buffer_overflow),//FMP_VC_0
	.clk(			clk			),
		.rst(			rst			),
		.tx_valid(		tx_valid_out		),
		.rx_active(		rx_active		),
		.pid_OUT(		pid_OUT			),
		.pid_IN(		pid_IN			),
		.pid_SOF(		pid_SOF			),
		.pid_SETUP(		pid_SETUP		),
		.pid_DATA0(		pid_DATA0		),
		.pid_DATA1(		pid_DATA1		),
		.pid_DATA2(		pid_DATA2		),
		.pid_MDATA(		pid_MDATA		),
		.pid_ACK(		pid_ACK			),
		.pid_NACK(		pid_NACK		),
		.pid_STALL(		pid_STALL		),
		.pid_NYET(		pid_NYET		),
		.pid_PRE(		pid_PRE			),
		.pid_ERR(		pid_ERR			),
		.pid_SPLIT(		pid_SPLIT		),
		.pid_PING(		pid_PING		),
		.mode_hs(		mode_hs			),
		.token_valid(		token_valid		),
		.crc5_err(		crc5_err		),
		.rx_data_valid(		rx_data_valid		),
		.rx_data_done(		rx_data_done		),
		.crc16_err(		crc16_err		),
		.send_token(		send_token		),
//FMP_VC_1		.token_pid_sel(		token_pid_sel		),
		.token_pid_sel1(		token_pid_sel1		),
		.token_pid_sel0(		token_pid_sel0		),

//FMP_VC_1		.data_pid_sel(		data_pid_sel		),
		.data_pid_sel1(		data_pid_sel1		),
		.data_pid_sel0(		data_pid_sel0		),
		.send_zero_length(	send_zero_length	),
		.rx_dma_en(		rx_dma_en		),
		.tx_dma_en(		tx_dma_en		),
		.abort(			abort			),
		.idma_done(		idma_done		),
//FMP_VC_1		.adr(			adr			),
		.adr16(			adr16			),
		.adr15(			adr15			),
		.adr14(			adr14			),
		.adr13(			adr13			),
		.adr12(			adr12			),
		.adr11(			adr11			),
		.adr10(			adr10			),
		.adr9(			adr9			),
		.adr8(			adr8			),
		.adr7(			adr7			),
		.adr6(			adr6			),
		.adr5(			adr5			),
		.adr4(			adr4			),
		.adr3(			adr3			),
		.adr2(			adr2			),
		.adr1(			adr1			),
		.adr0(			adr0		),
//FMP_VC_1		.size(			size			),
		.size13(		size13			),
		.size12(		size12			),
		.size11(		size11			),
		.size10(		size10			),
		.size9(			size9		),
		.size8(			size8		),
		.size7(			size7		),
		.size6(			size6		),
		.size5(			size5		),
		.size4(			size4		),
		.size3(			size3		),
		.size2(			size2		),
		.size1(			size1			),
		.size0(			size0			),
		
//FMP_VC_1		.buf_size(		buf_size		),
		.buf_size13(		buf_size13			),
		.buf_size12(		buf_size12			),
		.buf_size11(		buf_size11			),
		.buf_size10(		buf_size10			),
		.buf_size9(			buf_size9		),
		.buf_size8(			buf_size8		),
		.buf_size7(			buf_size7		),
		.buf_size6(			buf_size6		),
		.buf_size5(			buf_size5		),
		.buf_size4(			buf_size4		),
		.buf_size3(			buf_size3		),
		.buf_size2(			buf_size2		),
		.buf_size1(			buf_size1		),
		.buf_size0(			buf_size0		),
		
//FMP_VC_1		.sizu_c(		sizu_c			),
		.sizu_c(       {sizu_c10,sizu_c9,sizu_c8,sizu_c7,sizu_c6,sizu_c5,
				sizu_c4,sizu_c3,sizu_c2,sizu_c1,sizu_c0}	),
		.dma_en(		dma_en			),
		.fsel(			fsel			),
	   .idin31			(idin31),
	   .idin30			(idin30),
	   .idin29			(idin29),
	   .idin28			(idin28),
	   .idin27			(idin27),
	   .idin26			(idin26),
	   .idin25			(idin25),
	   .idin24			(idin24),
	   .idin23			(idin23),
	   .idin22			(idin22),
	   .idin21			(idin21),
	   .idin20			(idin20),
	   .idin19			(idin19),
	   .idin18			(idin18),
	   .idin17			(idin17),
	   .idin16			(idin16),
	   .idin15			(idin15),
	   .idin14			(idin14),
	   .idin13			(idin13),
	   .idin12			(idin12),
	   .idin11			(idin11),
	   .idin10			(idin10),
	   .idin9			(idin9),
	   .idin8			(idin8),
	   .idin7			(idin7),
	   .idin6			(idin6),
	   .idin5			(idin5),
	   .idin4			(idin4),
	   .idin3			(idin3),
	   .idin2			(idin2),
	   .idin1			(idin1),
	   .idin0			(idin0),
	   .usbf_pe_state  (usbf_pe_state), //FMP_VC_0
	   .match_ro(			match_ro			),//FMP_VC_0
	   .buf0_na_o(			buf0_na_o			),//FMP_VC_0
	   .buf1_na_o(			buf1_na_o			),//FMP_VC_0
	   .rx_ack_to_o (rx_ack_to_o),//FMP_VC_0
	   .tx_data_to_o (tx_data_to_o),//FMP_VC_0
		.ep_sel(		ep_sel			),
		.match(			match_o			),
		.dma_in_buf_sz1(	dma_in_buf_sz1		),
		.dma_out_buf_avail(	dma_out_buf_avail	),
		.nse_err(		nse_err			),
		.buf0_rl(		buf0_rl			),
		.buf0_set(		buf0_set		),
		.buf1_set(		buf1_set		),
		.uc_bsel_set(		uc_bsel_set		),
		.uc_dpd_set(		uc_dpd_set		),
		.int_buf1_set(		int_buf1_set		),
		.int_buf0_set(		int_buf0_set		),
		.int_upid_set(		int_upid_set		),
		.int_crc16_set(		int_crc16_set		),
		.int_to_set(		int_to_set		),
		.int_seqerr_set(	int_seqerr_set		),
		.out_to_small(		out_to_small		),
		.csr(			csr			),
		.buf0(			buf0			),
		.buf1(			buf1			)
		);

endmodule // main


