//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006-2007  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC
// //////////////////////////////////////////////////////////////////////
////                                                              ////
////  eth_txethmac.v                                              ////
///                                                              ////
////  This file is part of the Ethernet IP core project           ////
////  http://www.opencores.org/projects/ethmac/                   ////
////                                                              ////
////  Author(s):                                                  ////
////      - Igor Mohor (igorM@opencores.org)                      ////
////      - Novan Hartadi (novan@vlsi.itb.ac.id)                  ////
////      - Mahmud Galela (mgalela@vlsi.itb.ac.id)                ////
////                                                              ////
////  All additional information is avaliable in the Readme.txt   ////
////  file.                                                       ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
////                                                              ////
//// Copyright (C) 2001 Authors                                   ////
////                                                              ////
//// This source file may be used and distributed without         ////
//// restriction provided that this copyright statement is not    ////
//// removed from the file and that any derivative work contains  ////
//// the original copyright notice and the associated disclaimer. ////
////                                                              ////
//// This source file is free software; you can redistribute it   ////
//// and/or modify it under the terms of the GNU Lesser General   ////
//// Public License as published by the Free Software Foundation; ////
//// either version 2.1 of the License, or (at your option) any   ////
//// later version.                                               ////
////                                                              ////
//// This source is distributed in the hope that it will be       ////
//// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
//// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
//// PURPOSE.  See the GNU Lesser General Public License for more ////
//// details.                                                     ////
////                                                              ////
//// You should have received a copy of the GNU Lesser General    ////
//// Public License along with this source; if not, download it   ////
//// from http://www.opencores.org/lgpl.shtml                     ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
//
// CVS Revision History
//
// $Log: eth_txethmac.v,v $
// Revision 1.9  2005/02/21 11:25:28  igorm
// Delayed CRC fixed.
//
// Revision 1.8  2003/01/30 13:33:24  mohor
// When padding was enabled and crc disabled, frame was not ended correctly.
//
// Revision 1.7  2002/02/26 16:24:01  mohor
// RetryCntLatched was unused and removed from design
//
// Revision 1.6  2002/02/22 12:56:35  mohor
// Retry is not activated when a Tx Underrun occured
//
// Revision 1.5  2002/02/11 09:18:22  mohor
// Tx status is written back to the BD.
//
// Revision 1.4  2002/01/23 10:28:16  mohor
// Link in the header changed.
//
// Revision 1.3  2001/10/19 08:43:51  mohor
// eth_timescale.v changed to timescale.v This is done because of the
// simulation of the few cores in a one joined project.
//
// Revision 1.2  2001/09/11 14:17:00  mohor
// Few little NCSIM warnings fixed.
//
// Revision 1.1  2001/08/06 14:44:29  mohor
// A define FPGA added to select between Artisan RAM (for ASIC) and Block Ram (For Virtex).
// Include files fixed to contain no path.
// File names and module names changed ta have a eth_ prologue in the name.
// File eth_timescale.v is used to define timescale
// All pin names on the top module are changed to contain _I, _O or _OE at the end.
// Bidirectional signal MDIO is changed to three signals (Mdc_O, Mdi_I, Mdo_O
// and Mdo_OE. The bidirectional signal must be created on the top level. This
// is done due to the ASIC tools.
//
// Revision 1.1  2001/07/30 21:23:42  mohor
// Directory structure changed. Files checked and joind together.
//
// Revision 1.3  2001/06/19 18:16:40  mohor
// TxClk changed to MTxClk (as discribed in the documentation).
// Crc changed so only one file can be used instead of two.
//
// Revision 1.2  2001/06/19 10:38:08  mohor
// Minor changes in header.
//
// Revision 1.1  2001/06/19 10:27:58  mohor
// TxEthMAC initial release.
//
//
//

`include "timescale.v"


module eth_txethmac (/*AUTOARG*/
   // Outputs
   VCEGAR_StateIdle, VCEGAR_StateIPG, VCEGAR_StatePreamble,
   VCEGAR_StateData_0, VCEGAR_StateData_1, VCEGAR_StatePAD,
   VCEGAR_StateFCS, VCEGAR_StateJam, VCEGAR_StateJam_q,
   VCEGAR_StateBackOff, VCEGAR_StateDefer, MTxD_0, MTxD_1, MTxD_2,
   MTxD_3, MTxEn, MTxErr, TxDone, TxRetry, TxAbort, TxUsedData,
   WillTransmit, ResetCollision, RetryCnt_0, RetryCnt_1, RetryCnt_2,
   RetryCnt_3, StartTxDone, StartTxAbort, MaxCollisionOccured,
   LateCollision, DeferIndication, StatePreamble, StateData_0,
   StateData_1,
   // Inputs
   MTxClk, Reset, TxStartFrm, TxEndFrm, TxUnderRun, TxData,
   CarrierSense, Collision, Pad, CrcEn, FullD, HugEn, DlyCrcEn, MinFL,
   MaxFL, IPGT, IPGR1, IPGR2, CollValid, MaxRet, NoBckof, ExDfrEn
   );

//FMP_VC_2//parameter Tp = 1;


input MTxClk;                   // Transmit clock (from PHY)
input Reset;                    // Reset
input TxStartFrm;               // Transmit packet start frame
input TxEndFrm;                 // Transmit packet end frame
input TxUnderRun;               // Transmit packet under-run
input [7:0] TxData;             // Transmit packet data byte
input CarrierSense;             // Carrier sense (synchronized)
input Collision;                // Collision (synchronized)
input Pad;                      // Pad enable (from register)
input CrcEn;                    // Crc enable (from register)
input FullD;                    // Full duplex (from register)
input HugEn;                    // Huge packets enable (from register)
input DlyCrcEn;                 // Delayed Crc enabled (from register)
input [15:0] MinFL;             // Minimum frame length (from register)
input [15:0] MaxFL;             // Maximum frame length (from register)
input [6:0] IPGT;               // Back to back transmit inter packet gap parameter (from register)
input [6:0] IPGR1;              // Non back to back transmit inter packet gap parameter IPGR1 (from register)
input [6:0] IPGR2;              // Non back to back transmit inter packet gap parameter IPGR2 (from register)
input [5:0] CollValid;          // Valid collision window (from register)
input [3:0] MaxRet;             // Maximum retry number (from register)
input NoBckof;                  // No backoff (from register)
input ExDfrEn;                  // Excessive defferal enable (from register)

//FMP_VC_0
output  VCEGAR_StateIdle;         // Idle state
output  VCEGAR_StateIPG;          // IPG state
output  VCEGAR_StatePreamble;     // Preamble state
output  VCEGAR_StateData_0;       // VCEGAR COMPATIBLE
output  VCEGAR_StateData_1;       // VCEGAR COMPATIBLE
output  VCEGAR_StatePAD;          // PAD state
output  VCEGAR_StateFCS;          // FCS state
output  VCEGAR_StateJam;          // Jam state
output  VCEGAR_StateJam_q;        // Delayed Jam state
output  VCEGAR_StateBackOff;      // Backoff state
output  VCEGAR_StateDefer;        // Defer state

   
 //FMP_VC_1//output [3:0] MTxD;              // Transmit nibble (to PHY)
output MTxD_0;              // Transmit nibble (to PHY)
output MTxD_1;              // Transmit nibble (to PHY)
output MTxD_2;              // Transmit nibble (to PHY)
output MTxD_3;              // Transmit nibble (to PHY)

output MTxEn;                   // Transmit enable (to PHY)
output MTxErr;                  // Transmit error (to PHY)
output TxDone;                  // Transmit packet done (to RISC)
output TxRetry;                 // Transmit packet retry (to RISC)
output TxAbort;                 // Transmit packet abort (to RISC)
output TxUsedData;              // Transmit packet used data (to RISC)
output WillTransmit;            // Will transmit (to RxEthMAC)
output ResetCollision;          // Reset Collision (for synchronizing collision)
//FMP_VC_1 //output [3:0] RetryCnt;          // Latched Retry Counter for tx status purposes
output RetryCnt_0;          // Latched Retry Counter for tx status purposes
output RetryCnt_1;          // Latched Retry Counter for tx status purposes
output RetryCnt_2;          // Latched Retry Counter for tx status purposes
output RetryCnt_3;          // Latched Retry Counter for tx status purposes
               
output StartTxDone;
output StartTxAbort;
output MaxCollisionOccured;
output LateCollision;
output DeferIndication;
output StatePreamble;
 //FMP_VC_1 //output [1:0] StateData;
output StateData_0;
output StateData_1;

reg [3:0] MTxD;
reg MTxEn;
reg MTxErr;
reg TxDone;
reg TxRetry;
reg TxAbort;
reg TxUsedData;
reg WillTransmit;
reg ColWindow;
reg StopExcessiveDeferOccured;
reg [3:0] RetryCnt;
//FMP_VC_8//reg [3:0] MTxD_d;
reg StatusLatch;
reg PacketFinished_q;
reg PacketFinished;
   
   

wire ExcessiveDeferOccured;
wire StartIPG;
wire StartPreamble;
//FMP_VC_3// wire [1:0] StartData;
wire StartFCS;
wire StartJam;
wire StartDefer;
wire StartBackoff;
wire StateDefer;
wire StateIPG;
wire StateIdle;
wire StatePAD;
wire StateFCS;
wire StateJam;
wire StateJam_q;
wire StateBackOff;
wire StateSFD;
wire StartTxRetry;
wire UnderRun;
wire TooBig;
//FMP_VC_3// wire [31:0] Crc;
wire CrcError;
//FMP_VC_3//wire [2:0] DlyCrcCnt;
//FMP_VC_3//wire [15:0] NibCnt;
wire NibCntEq7;
wire NibCntEq15;
wire NibbleMinFl;
wire ExcessiveDefer;
//FMP_VC_3//wire [15:0] ByteCnt;
wire MaxFrame;
wire RetryMax;
wire RandomEq0;
wire RandomEqByteCnt;
wire PacketFinished_d;

//FMP_VC_0
wire  VCEGAR_StateIdle     = StateIdle;         // Idle state
wire  VCEGAR_StateIPG      = StateIPG;          // IPG state
wire  VCEGAR_StatePreamble = StatePreamble;     // Preamble state
wire  VCEGAR_StateData_0   = StateData_0;       // VCEGAR COMPATIBLE
wire  VCEGAR_StateData_1   = StateData_1;       // VCEGAR COMPATIBLE
wire  VCEGAR_StatePAD      = StatePAD;          // PAD state
wire  VCEGAR_StateFCS      = StateFCS;          // FCS state
wire  VCEGAR_StateJam      = StateJam;          // Jam state
wire  VCEGAR_StateJam_q    = StateJam_q;        // Delayed Jam state
wire  VCEGAR_StateBackOff  = StateBackOff;      // Backoff state
wire  VCEGAR_StateDefer    = StateDefer;        // Defer state


   //FMP_VC_3
   wire MTxD_0 = MTxD[0];
   wire MTxD_1 = MTxD[1];
   wire MTxD_2 = MTxD[2];
   wire MTxD_3 = MTxD[3];

   wire RetryCnt_0 = RetryCnt[0];
   wire RetryCnt_1 = RetryCnt[1];
   wire RetryCnt_2 = RetryCnt[2];
   wire RetryCnt_3 = RetryCnt[3];

   wire StartData_1, StartData_0;
   
   wire [1:0] StartData = {StartData_1, StartData_0};
   
//FMP_VC_3//   wire StateData_0 = StateData[0]; /// I added these but commented out
//FMP_VC_3//   wire StateData_1 = StateData[1]; /// because these are output from txstatem

   wire       StateData_1, StateData_0;
   
   wire [1:0] StateData = {StateData_1, StateData_0};
   
   wire ByteCnt_15, ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10, ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0;

   wire NibCnt_15, NibCnt_14, NibCnt_13, NibCnt_12, NibCnt_11, NibCnt_10, NibCnt_9, NibCnt_8, NibCnt_7, NibCnt_6, NibCnt_5, NibCnt_4, NibCnt_3, NibCnt_2, NibCnt_1, NibCnt_0;


   wire [15:0] ByteCnt = {ByteCnt_15, ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10, ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0};

   wire [15:0] NibCnt = {NibCnt_15, NibCnt_14, NibCnt_13, NibCnt_12, NibCnt_11, NibCnt_10, NibCnt_9, NibCnt_8, NibCnt_7, NibCnt_6, NibCnt_5, NibCnt_4, NibCnt_3, NibCnt_2, NibCnt_1, NibCnt_0};

   wire        DlyCrcCnt_2, DlyCrcCnt_1, DlyCrcCnt_0;
   
   wire [2:0] DlyCrcCnt = {DlyCrcCnt_2, DlyCrcCnt_1, DlyCrcCnt_0};

   wire Crc_31, Crc_30, Crc_29, Crc_28, Crc_27, Crc_26, Crc_25, Crc_24, Crc_23, Crc_22, Crc_21, Crc_20, Crc_19, Crc_18, Crc_17, Crc_16, Crc_15, Crc_14, Crc_13, Crc_12, Crc_11, Crc_10, Crc_9, Crc_8, Crc_7, Crc_6, Crc_5, Crc_4, Crc_3, Crc_2, Crc_1, Crc_0;
   
   wire [31:0] Crc = {Crc_31, Crc_30, Crc_29, Crc_28, Crc_27, Crc_26, Crc_25, Crc_24, Crc_23, Crc_22, Crc_21, Crc_20, Crc_19, Crc_18, Crc_17, Crc_16, Crc_15, Crc_14, Crc_13, Crc_12, Crc_11, Crc_10, Crc_9, Crc_8, Crc_7, Crc_6, Crc_5, Crc_4, Crc_3, Crc_2, Crc_1, Crc_0};


wire    MinFL_15 = MinFL[15];
wire    MinFL_14 = MinFL[14];
wire    MinFL_13 = MinFL[13];
wire    MinFL_12 = MinFL[12];
wire    MinFL_11 = MinFL[11];
wire    MinFL_10 = MinFL[10];
wire    MinFL_9 = MinFL[9];
wire    MinFL_8 = MinFL[8];
wire    MinFL_7 = MinFL[7];
wire    MinFL_6 = MinFL[6];
wire    MinFL_5 = MinFL[5];
wire    MinFL_4 = MinFL[4];
wire    MinFL_3 = MinFL[3];
wire    MinFL_2 = MinFL[2];
wire    MinFL_1 = MinFL[1];
wire    MinFL_0 = MinFL[0];


wire    MaxFL_15 = MaxFL[15];
wire    MaxFL_14 = MaxFL[14];
wire    MaxFL_13 = MaxFL[13];
wire    MaxFL_12 = MaxFL[12];
wire    MaxFL_11 = MaxFL[11];
wire    MaxFL_10 = MaxFL[10];
wire    MaxFL_9 = MaxFL[9];
wire    MaxFL_8 = MaxFL[8];
wire    MaxFL_7 = MaxFL[7];
wire    MaxFL_6 = MaxFL[6];
wire    MaxFL_5 = MaxFL[5];
wire    MaxFL_4 = MaxFL[4];
wire    MaxFL_3 = MaxFL[3];
wire    MaxFL_2 = MaxFL[2];
wire    MaxFL_1 = MaxFL[1];
wire    MaxFL_0 = MaxFL[0];
 
   
assign ResetCollision = ~(StatePreamble | (|StateData) | StatePAD | StateFCS);

assign ExcessiveDeferOccured = TxStartFrm & StateDefer & ExcessiveDefer & ~StopExcessiveDeferOccured;

assign StartTxDone = ~Collision & (StateFCS & NibCntEq7 | StateData[1] & TxEndFrm & (~Pad | Pad & NibbleMinFl) & ~CrcEn);

assign UnderRun = StateData[0] & TxUnderRun & ~Collision;

assign TooBig = ~Collision & MaxFrame & (StateData[0] & ~TxUnderRun | StateFCS);

// assign StartTxRetry = StartJam & (ColWindow & ~RetryMax);
assign StartTxRetry = StartJam & (ColWindow & ~RetryMax) & ~UnderRun;

assign LateCollision = StartJam & ~ColWindow & ~UnderRun;

assign MaxCollisionOccured = StartJam & ColWindow & RetryMax;

assign StateSFD = StatePreamble & NibCntEq15;

assign StartTxAbort = TooBig | UnderRun | ExcessiveDeferOccured | LateCollision | MaxCollisionOccured;



//FMP_VC_4//
`define VCEGAR
`ifdef VCEGAR
initial begin
   ColWindow                 = 1'b1;
   MTxD                      = 4'd0;
   MTxEn                     = 1'b0;
   MTxErr                    = 1'b0;
   PacketFinished_q          = 1'b0;
   PacketFinished            = 1'b0;
   RetryCnt                  = 4'd0;
   StatusLatch               = 1'b0;
   StopExcessiveDeferOccured = 1'b0;
   TxAbort                   = 1'b0;
   TxDone                    = 1'b0;
   TxRetry                   = 1'b0;
   TxUsedData                = 1'b0;
   WillTransmit              = 1'b0;
end
`endif
   
   
// StopExcessiveDeferOccured
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    StopExcessiveDeferOccured <= #1 1'b0;
  else
    begin
      if(~TxStartFrm)
        StopExcessiveDeferOccured <= #1 1'b0;
      else
      if(ExcessiveDeferOccured)
        StopExcessiveDeferOccured <= #1 1'b1;
    end
end


// Collision Window
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    ColWindow <= #1 1'b1;
  else
    begin  
      if(~Collision & ByteCnt[5:0] == CollValid[5:0] & (StateData[1] | StatePAD & NibCnt[0] | StateFCS & NibCnt[0]))
        ColWindow <= #1 1'b0;
      else
      if(StateIdle | StateIPG)
        ColWindow <= #1 1'b1;
    end
end


// Start Window
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    StatusLatch <= #1 1'b0;
  else
    begin
      if(~TxStartFrm)
        StatusLatch <= #1 1'b0;
      else
      if(ExcessiveDeferOccured | StateIdle)
        StatusLatch <= #1 1'b1;
     end
end


// Transmit packet used data
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    TxUsedData <= #1 1'b0;
  else
    TxUsedData <= #1 |StartData;
end


// Transmit packet done
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    TxDone <= #1 1'b0;
  else
    begin
      if(TxStartFrm & ~StatusLatch)
        TxDone <= #1 1'b0;
      else
      if(StartTxDone)
        TxDone <= #1 1'b1;
    end
end


// Transmit packet retry
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    TxRetry <= #1 1'b0;
  else
    begin
      if(TxStartFrm & ~StatusLatch)
        TxRetry <= #1 1'b0;
      else
      if(StartTxRetry)
        TxRetry <= #1 1'b1;
     end
end                                    


// Transmit packet abort
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    TxAbort <= #1 1'b0;
  else
    begin
      if(TxStartFrm & ~StatusLatch & ~ExcessiveDeferOccured)
        TxAbort <= #1 1'b0;
      else
      if(StartTxAbort)
        TxAbort <= #1 1'b1;
    end
end



// Retry counter
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    RetryCnt[3:0] <= #1 4'h0;
  else
    begin
      if(ExcessiveDeferOccured | UnderRun | TooBig | StartTxDone | TxUnderRun 
          | StateJam & NibCntEq7 & (~ColWindow | RetryMax))
        RetryCnt[3:0] <= #1 4'h0;
      else
      if(StateJam & NibCntEq7 & ColWindow & (RandomEq0 | NoBckof) | StateBackOff & RandomEqByteCnt)
        RetryCnt[3:0] <= #1 RetryCnt[3:0] + 1'b1;
    end
end


assign RetryMax = RetryCnt[3:0] == MaxRet[3:0];

//FMP_VC_10
/* -----\/----- EXCLUDED -----\/-----
// Transmit nibble
always @ (StatePreamble or StateData or StateData or StateFCS or StateJam or StateSFD or TxData or 
          Crc or NibCntEq15)
begin
  if(StateData[0])
    MTxD_d[3:0] = TxData[3:0];                                  // Lower nibble
  else
  if(StateData[1])
    MTxD_d[3:0] = TxData[7:4];                                  // Higher nibble
  else
  if(StateFCS)
    MTxD_d[3:0] = {~Crc[28], ~Crc[29], ~Crc[30], ~Crc[31]};     // Crc
  else
  if(StateJam)
    MTxD_d[3:0] = 4'h9;                                         // Jam pattern
  else
  if(StatePreamble)
    if(NibCntEq15)
      MTxD_d[3:0] = 4'hd;                                       // SFD
    else
      MTxD_d[3:0] = 4'h5;                                       // Preamble
  else
    MTxD_d[3:0] = 4'h0;
end
 -----/\----- EXCLUDED -----/\----- */
   
   
   wire [3:0] MTxD_d  = (StateData[0]) ? TxData[3:0] : 
	                                (StateData[1]) ? TxData[7:4] : 
					                 (StateFCS) ? {~Crc[28], ~Crc[29], ~Crc[30], ~Crc[31]} :
							               (StateJam) ? 4'd9 :
	                                                                            (StatePreamble) ? (NibCntEq15 ? 4'hd : 4'h5) :
	                                                                                              4'd0;
   
// Transmit Enable
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    MTxEn <= #1 1'b0;
  else
    MTxEn <= #1 StatePreamble | (|StateData) | StatePAD | StateFCS | StateJam;
end


// Transmit nibble
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    MTxD[3:0] <= #1 4'h0;
  else
    MTxD[3:0] <= #1 MTxD_d[3:0];
end


// Transmit error
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    MTxErr <= #1 1'b0;
  else
    MTxErr <= #1 TooBig | UnderRun;
end


// WillTransmit
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    WillTransmit <= #1  1'b0;
  else
    WillTransmit <= #1 StartPreamble | StatePreamble | (|StateData) | StatePAD | StateFCS | StateJam;
end

 

assign PacketFinished_d = StartTxDone | TooBig | UnderRun | LateCollision | MaxCollisionOccured | ExcessiveDeferOccured;


// Packet finished
always @ (posedge MTxClk /*or posedge Reset*/)
begin
  if(Reset)
    begin
      PacketFinished <= #1 1'b0;
      PacketFinished_q  <= #1 1'b0;
    end
  else
    begin
      PacketFinished <= #1 PacketFinished_d;
      PacketFinished_q  <= #1 PacketFinished;
    end
end

//FMP_VC_1
/* -----\/----- EXCLUDED -----\/-----
eth_txcounters txcounters1 (.StatePreamble(StatePreamble), .StateIPG(StateIPG), .StateData(StateData), 
                            .StatePAD(StatePAD), .StateFCS(StateFCS), .StateJam(StateJam), .StateBackOff(StateBackOff), 
                            .StateDefer(StateDefer), .StateIdle(StateIdle), .StartDefer(StartDefer), .StartIPG(StartIPG), 
                            .StartFCS(StartFCS), .StartJam(StartJam), .TxStartFrm(TxStartFrm), .MTxClk(MTxClk), 
                            .Reset(Reset), .MinFL(MinFL), .MaxFL(MaxFL), .HugEn(HugEn), .ExDfrEn(ExDfrEn), 
                            .PacketFinished_q(PacketFinished_q), .DlyCrcEn(DlyCrcEn), .StartBackoff(StartBackoff), 
                            .StateSFD(StateSFD), .ByteCnt(ByteCnt), .NibCnt(NibCnt), .ExcessiveDefer(ExcessiveDefer), 
                            .NibCntEq7(NibCntEq7), .NibCntEq15(NibCntEq15), .MaxFrame(MaxFrame), .NibbleMinFl(NibbleMinFl), 
                            .DlyCrcCnt(DlyCrcCnt)
                           );
 -----\/----- EXCLUDED -----\/-----*/

   /* eth_txcounters AUTO_TEMPLATE
    (
    .StatePreamble(StatePreamble), 
    .StateIPG(StateIPG), 
    .StateData({StateData_1, StateData_0}), 
    .StatePAD(StatePAD), 
    .StateFCS(StateFCS), 
    .StateJam(StateJam), 
    .StateBackOff(StateBackOff), 
    .StateDefer(StateDefer), 
    .StateIdle(StateIdle), 
    .StartDefer(StartDefer), 
    .StartIPG(StartIPG), 
    .StartFCS(StartFCS), 
    .StartJam(StartJam), 
    .TxStartFrm(TxStartFrm), 
    .MTxClk(MTxClk), 
    .Reset(Reset), 
    .MinFL({MinFL_15, MinFL_14, MinFL_13, MinFL_12, MinFL_11, MinFL_10, MinFL_9, MinFL_8, MinFL_7, MinFL_6, MinFL_5, MinFL_4, MinFL_3, MinFL_2, MinFL_1, MinFL_0}), 
    .MaxFL({MaxFL_15, MaxFL_14, MaxFL_13, MaxFL_12, MaxFL_11, MaxFL_10, MaxFL_9, MaxFL_8, MaxFL_7, MaxFL_6, MaxFL_5, MaxFL_4, MaxFL_3, MaxFL_2, MaxFL_1, MaxFL_0}), 
    .HugEn(HugEn), 
    .ExDfrEn(ExDfrEn), 
    .PacketFinished_q(PacketFinished_q), 
    .DlyCrcEn(DlyCrcEn), 
    .StartBackoff(StartBackoff), 
    .StateSFD(StateSFD), 
    .ByteCnt_0(ByteCnt_0),
    .ByteCnt_1(ByteCnt_1),
    .ByteCnt_2(ByteCnt_2),
    .ByteCnt_3(ByteCnt_3),
    .ByteCnt_4(ByteCnt_4),
    .ByteCnt_5(ByteCnt_5),
    .ByteCnt_6(ByteCnt_6),
    .ByteCnt_7(ByteCnt_7),
    .ByteCnt_8(ByteCnt_8),
    .ByteCnt_9(ByteCnt_9),
    .ByteCnt_10(ByteCnt_10),
    .ByteCnt_11(ByteCnt_11),
    .ByteCnt_12(ByteCnt_12),
    .ByteCnt_13(ByteCnt_13),
    .ByteCnt_14(ByteCnt_14),
    .ByteCnt_15(ByteCnt_15),
    .NibCnt_0(NibCnt_0),
    .NibCnt_1(NibCnt_1),
    .NibCnt_2(NibCnt_2),
    .NibCnt_3(NibCnt_3),
    .NibCnt_4(NibCnt_4),
    .NibCnt_5(NibCnt_5),
    .NibCnt_6(NibCnt_6),
    .NibCnt_7(NibCnt_7),
    .NibCnt_8(NibCnt_8),
    .NibCnt_9(NibCnt_9),
    .NibCnt_10(NibCnt_10),
    .NibCnt_11(NibCnt_11),
    .NibCnt_12(NibCnt_12),
    .NibCnt_13(NibCnt_13),
    .NibCnt_14(NibCnt_14),
    .NibCnt_15(NibCnt_15),
    .DlyCrcCnt_0(DlyCrcCnt_0),
    .DlyCrcCnt_1(DlyCrcCnt_1),
    .DlyCrcCnt_2(DlyCrcCnt_2),
    .ExcessiveDefer(ExcessiveDefer), 
    .NibCntEq7(NibCntEq7), 
    .NibCntEq15(NibCntEq15), 
    .MaxFrame(MaxFrame), 
    .NibbleMinFl(NibbleMinFl), 
    );
*/
// Connecting module Counters
eth_txcounters txcounters1 (/*AUTOINST*/
			    // Outputs
			    .ByteCnt_0	(ByteCnt_0),		 // Templated
			    .ByteCnt_1	(ByteCnt_1),		 // Templated
			    .ByteCnt_2	(ByteCnt_2),		 // Templated
			    .ByteCnt_3	(ByteCnt_3),		 // Templated
			    .ByteCnt_4	(ByteCnt_4),		 // Templated
			    .ByteCnt_5	(ByteCnt_5),		 // Templated
			    .ByteCnt_6	(ByteCnt_6),		 // Templated
			    .ByteCnt_7	(ByteCnt_7),		 // Templated
			    .ByteCnt_8	(ByteCnt_8),		 // Templated
			    .ByteCnt_9	(ByteCnt_9),		 // Templated
			    .ByteCnt_10	(ByteCnt_10),		 // Templated
			    .ByteCnt_11	(ByteCnt_11),		 // Templated
			    .ByteCnt_12	(ByteCnt_12),		 // Templated
			    .ByteCnt_13	(ByteCnt_13),		 // Templated
			    .ByteCnt_14	(ByteCnt_14),		 // Templated
			    .ByteCnt_15	(ByteCnt_15),		 // Templated
			    .NibCnt_0	(NibCnt_0),		 // Templated
			    .NibCnt_1	(NibCnt_1),		 // Templated
			    .NibCnt_2	(NibCnt_2),		 // Templated
			    .NibCnt_3	(NibCnt_3),		 // Templated
			    .NibCnt_4	(NibCnt_4),		 // Templated
			    .NibCnt_5	(NibCnt_5),		 // Templated
			    .NibCnt_6	(NibCnt_6),		 // Templated
			    .NibCnt_7	(NibCnt_7),		 // Templated
			    .NibCnt_8	(NibCnt_8),		 // Templated
			    .NibCnt_9	(NibCnt_9),		 // Templated
			    .NibCnt_10	(NibCnt_10),		 // Templated
			    .NibCnt_11	(NibCnt_11),		 // Templated
			    .NibCnt_12	(NibCnt_12),		 // Templated
			    .NibCnt_13	(NibCnt_13),		 // Templated
			    .NibCnt_14	(NibCnt_14),		 // Templated
			    .NibCnt_15	(NibCnt_15),		 // Templated
			    .ExcessiveDefer(ExcessiveDefer),	 // Templated
			    .NibCntEq7	(NibCntEq7),		 // Templated
			    .NibCntEq15	(NibCntEq15),		 // Templated
			    .MaxFrame	(MaxFrame),		 // Templated
			    .NibbleMinFl(NibbleMinFl),		 // Templated
			    .DlyCrcCnt_0(DlyCrcCnt_0),		 // Templated
			    .DlyCrcCnt_1(DlyCrcCnt_1),		 // Templated
			    .DlyCrcCnt_2(DlyCrcCnt_2),		 // Templated
			    // Inputs
			    .MTxClk	(MTxClk),		 // Templated
			    .Reset	(Reset),		 // Templated
			    .StatePreamble(StatePreamble),	 // Templated
			    .StateIPG	(StateIPG),		 // Templated
			    .StateData	({StateData_1, StateData_0}), // Templated
			    .StatePAD	(StatePAD),		 // Templated
			    .StateFCS	(StateFCS),		 // Templated
			    .StateJam	(StateJam),		 // Templated
			    .StateBackOff(StateBackOff),	 // Templated
			    .StateDefer	(StateDefer),		 // Templated
			    .StateIdle	(StateIdle),		 // Templated
			    .StateSFD	(StateSFD),		 // Templated
			    .StartDefer	(StartDefer),		 // Templated
			    .StartIPG	(StartIPG),		 // Templated
			    .StartFCS	(StartFCS),		 // Templated
			    .StartJam	(StartJam),		 // Templated
			    .StartBackoff(StartBackoff),	 // Templated
			    .TxStartFrm	(TxStartFrm),		 // Templated
			    .MinFL	({MinFL_15, MinFL_14, MinFL_13, MinFL_12, MinFL_11, MinFL_10, MinFL_9, MinFL_8, MinFL_7, MinFL_6, MinFL_5, MinFL_4, MinFL_3, MinFL_2, MinFL_1, MinFL_0}), // Templated
			    .MaxFL	({MaxFL_15, MaxFL_14, MaxFL_13, MaxFL_12, MaxFL_11, MaxFL_10, MaxFL_9, MaxFL_8, MaxFL_7, MaxFL_6, MaxFL_5, MaxFL_4, MaxFL_3, MaxFL_2, MaxFL_1, MaxFL_0}), // Templated
			    .HugEn	(HugEn),		 // Templated
			    .ExDfrEn	(ExDfrEn),		 // Templated
			    .PacketFinished_q(PacketFinished_q), // Templated
			    .DlyCrcEn	(DlyCrcEn));		 // Templated

//FMP_VC_1
/* -----\/----- EXCLUDED -----\/-----
eth_txstatem txstatem1 (.MTxClk(MTxClk), .Reset(Reset), .ExcessiveDefer(ExcessiveDefer), .CarrierSense(CarrierSense), 
                        .NibCnt(NibCnt[6:0]), .IPGT(IPGT), .IPGR1(IPGR1), .IPGR2(IPGR2), .FullD(FullD), 
                        .TxStartFrm(TxStartFrm), .TxEndFrm(TxEndFrm), .TxUnderRun(TxUnderRun), .Collision(Collision), 
                        .UnderRun(UnderRun), .StartTxDone(StartTxDone), .TooBig(TooBig), .NibCntEq7(NibCntEq7), 
                        .NibCntEq15(NibCntEq15), .MaxFrame(MaxFrame), .Pad(Pad), .CrcEn(CrcEn), 
                        .NibbleMinFl(NibbleMinFl), .RandomEq0(RandomEq0), .ColWindow(ColWindow), .RetryMax(RetryMax), 
                        .NoBckof(NoBckof), .RandomEqByteCnt(RandomEqByteCnt), .StateIdle(StateIdle), 
                        .StateIPG(StateIPG), .StatePreamble(StatePreamble), .StateData(StateData), .StatePAD(StatePAD), 
                        .StateFCS(StateFCS), .StateJam(StateJam), .StateJam_q(StateJam_q), .StateBackOff(StateBackOff), 
                        .StateDefer(StateDefer), .StartFCS(StartFCS), .StartJam(StartJam), .StartBackoff(StartBackoff), 
                        .StartDefer(StartDefer), .DeferIndication(DeferIndication), .StartPreamble(StartPreamble), .StartData(StartData), .StartIPG(StartIPG)
                       );

         .IPGT({IPGT_6, IPGT_5, IPGT_4, IPGT_3, IPGT_2, IPGT_1, IPGT_0}), 
    .IPGR1({IPGR1_6, IPGR1_5, IPGR1_4, IPGR1_3, IPGR1_2, IPGR1_1, IPGR1_0}), 
    .IPGR2({IPGR2_6, IPGR2_5, IPGR2_4, IPGR2_3, IPGR2_2, IPGR2_1, IPGR2_0}), 
 -----/\----- EXCLUDED -----/\----- */

   /*
 eth_txstatem AUTO_TEMPLATE
    (.MTxClk(MTxClk), 
    .Reset(Reset), 
    .ExcessiveDefer(ExcessiveDefer), 
    .CarrierSense(CarrierSense), 
    .NibCnt({NibCnt_6, NibCnt_5, NibCnt_4, NibCnt_3, NibCnt_2, NibCnt_1, NibCnt_0}),
    .IPGT(IPGT[6:0]), 
    .IPGR1(IPGR1[6:0]), 
    .IPGR2(IPGR2[6:0]),
    .FullD(FullD), 
    .TxStartFrm(TxStartFrm), 
    .TxEndFrm(TxEndFrm), 
    .TxUnderRun(TxUnderRun), 
    .Collision(Collision), 
    .UnderRun(UnderRun), 
    .StartTxDone(StartTxDone), 
    .TooBig(TooBig), 
    .NibCntEq7(NibCntEq7), 
    .NibCntEq15(NibCntEq15), 
    .MaxFrame(MaxFrame), 
    .Pad(Pad), 
    .CrcEn(CrcEn), 
    .NibbleMinFl(NibbleMinFl), 
    .RandomEq0(RandomEq0), 
    .ColWindow(ColWindow), 
    .RetryMax(RetryMax), 
    .NoBckof(NoBckof), 
    .RandomEqByteCnt(RandomEqByteCnt), 
    .StateIdle(StateIdle), 
    .StateIPG(StateIPG), 
    .StatePreamble(StatePreamble), 
    .StatePAD(StatePAD), 
    .StateFCS(StateFCS), 
    .StateJam(StateJam), 
    .StateJam_q(StateJam_q), 
    .StateBackOff(StateBackOff), 
    .StateDefer(StateDefer), 
    .StartFCS(StartFCS), 
    .StartJam(StartJam), 
    .StartBackoff(StartBackoff), 
    .StartDefer(StartDefer), 
    .DeferIndication(DeferIndication), 
    .StartPreamble(StartPreamble), 
    .StartIPG(StartIPG),
    .StateData_0(StateData_0), 
    .StateData_1(StateData_1), 
    .StartData_0(StartData_0),
    .StartData_1(StartData_1),
    );
    */
// Connecting module StateM
eth_txstatem txstatem1 (/*AUTOINST*/
			// Outputs
			.StateIdle	(StateIdle),		 // Templated
			.StateIPG	(StateIPG),		 // Templated
			.StatePreamble	(StatePreamble),	 // Templated
			.StateData_0	(StateData_0),		 // Templated
			.StateData_1	(StateData_1),		 // Templated
			.StatePAD	(StatePAD),		 // Templated
			.StateFCS	(StateFCS),		 // Templated
			.StateJam	(StateJam),		 // Templated
			.StateJam_q	(StateJam_q),		 // Templated
			.StateBackOff	(StateBackOff),		 // Templated
			.StateDefer	(StateDefer),		 // Templated
			.StartFCS	(StartFCS),		 // Templated
			.StartJam	(StartJam),		 // Templated
			.StartBackoff	(StartBackoff),		 // Templated
			.StartDefer	(StartDefer),		 // Templated
			.DeferIndication(DeferIndication),	 // Templated
			.StartPreamble	(StartPreamble),	 // Templated
			.StartData_0	(StartData_0),		 // Templated
			.StartData_1	(StartData_1),		 // Templated
			.StartIPG	(StartIPG),		 // Templated
			// Inputs
			.MTxClk		(MTxClk),		 // Templated
			.Reset		(Reset),		 // Templated
			.ExcessiveDefer	(ExcessiveDefer),	 // Templated
			.CarrierSense	(CarrierSense),		 // Templated
			.NibCnt		({NibCnt_6, NibCnt_5, NibCnt_4, NibCnt_3, NibCnt_2, NibCnt_1, NibCnt_0}), // Templated
			.IPGT		(IPGT[6:0]),		 // Templated
			.IPGR1		(IPGR1[6:0]),		 // Templated
			.IPGR2		(IPGR2[6:0]),		 // Templated
			.FullD		(FullD),		 // Templated
			.TxStartFrm	(TxStartFrm),		 // Templated
			.TxEndFrm	(TxEndFrm),		 // Templated
			.TxUnderRun	(TxUnderRun),		 // Templated
			.Collision	(Collision),		 // Templated
			.UnderRun	(UnderRun),		 // Templated
			.StartTxDone	(StartTxDone),		 // Templated
			.TooBig		(TooBig),		 // Templated
			.NibCntEq7	(NibCntEq7),		 // Templated
			.NibCntEq15	(NibCntEq15),		 // Templated
			.MaxFrame	(MaxFrame),		 // Templated
			.Pad		(Pad),			 // Templated
			.CrcEn		(CrcEn),		 // Templated
			.NibbleMinFl	(NibbleMinFl),		 // Templated
			.RandomEq0	(RandomEq0),		 // Templated
			.ColWindow	(ColWindow),		 // Templated
			.RetryMax	(RetryMax),		 // Templated
			.NoBckof	(NoBckof),		 // Templated
			.RandomEqByteCnt(RandomEqByteCnt));	 // Templated


wire Enable_Crc;
//FMP_VC_3//wire [3:0] Data_Crc;
wire Initialize_Crc;

assign Enable_Crc = ~StateFCS;

//FMP_VC_3//
/* -----\/----- EXCLUDED -----\/-----
assign Data_Crc[0] = StateData[0]? TxData[3] : StateData[1]? TxData[7] : 1'b0;
assign Data_Crc[1] = StateData[0]? TxData[2] : StateData[1]? TxData[6] : 1'b0;
assign Data_Crc[2] = StateData[0]? TxData[1] : StateData[1]? TxData[5] : 1'b0;
assign Data_Crc[3] = StateData[0]? TxData[0] : StateData[1]? TxData[4] : 1'b0;
 -----/\----- EXCLUDED -----/\----- */
wire Data_Crc_0 = StateData[0]? TxData[3] : StateData[1]? TxData[7] : 1'b0;
wire Data_Crc_1 = StateData[0]? TxData[2] : StateData[1]? TxData[6] : 1'b0;
wire Data_Crc_2 = StateData[0]? TxData[1] : StateData[1]? TxData[5] : 1'b0;
wire Data_Crc_3 = StateData[0]? TxData[0] : StateData[1]? TxData[4] : 1'b0;

assign Initialize_Crc = StateIdle | StatePreamble | (|DlyCrcCnt);

   
//FMP_VC_1//
/* -----\/----- EXCLUDED -----\/-----
eth_crc txcrc (.Clk(MTxClk), .Reset(Reset), .Data(Data_Crc), .Enable(Enable_Crc), .Initialize(Initialize_Crc), 
               .Crc(Crc), .CrcError(CrcError)
              );
 -----/\----- EXCLUDED -----/\----- */

/*eth_crc AUTO_TEMPLATE
 (.Clk(MTxClk), 
 .Reset(Reset), 
 .Data({Data_Crc_3, Data_Crc_2,Data_Crc_1,Data_Crc_0}), 
 .Enable(Enable_Crc), 
 .Initialize(Initialize_Crc), 
 .Crc(Crc), 
.Crc_0(Crc_0),
 .Crc_1(Crc_1),
 .Crc_2(Crc_2),
 .Crc_3(Crc_3),
 .Crc_4(Crc_4),
 .Crc_5(Crc_5),
 .Crc_6(Crc_6),
 .Crc_7(Crc_7),
 .Crc_8(Crc_8),
 .Crc_9(Crc_9),
 .Crc_10(Crc_10),
 .Crc_11(Crc_11),
 .Crc_12(Crc_12),
 .Crc_13(Crc_13),
 .Crc_14(Crc_14),
 .Crc_15(Crc_15),
 .Crc_16(Crc_16),
 .Crc_17(Crc_17),
 .Crc_18(Crc_18),
 .Crc_19(Crc_19),
 .Crc_20(Crc_20),
 .Crc_21(Crc_21),
 .Crc_22(Crc_22),
 .Crc_23(Crc_23),
 .Crc_24(Crc_24),
 .Crc_25(Crc_25),
 .Crc_26(Crc_26),
 .Crc_27(Crc_27),
 .Crc_28(Crc_28),
 .Crc_29(Crc_29),
 .Crc_30(Crc_30),
 .Crc_31(Crc_31),
 .CrcError(CrcError),
 );
*/
// Connecting module Crc
eth_crc txcrc (/*AUTOINST*/
	       // Outputs
	       .Crc_0			(Crc_0),		 // Templated
	       .Crc_1			(Crc_1),		 // Templated
	       .Crc_2			(Crc_2),		 // Templated
	       .Crc_3			(Crc_3),		 // Templated
	       .Crc_4			(Crc_4),		 // Templated
	       .Crc_5			(Crc_5),		 // Templated
	       .Crc_6			(Crc_6),		 // Templated
	       .Crc_7			(Crc_7),		 // Templated
	       .Crc_8			(Crc_8),		 // Templated
	       .Crc_9			(Crc_9),		 // Templated
	       .Crc_10			(Crc_10),		 // Templated
	       .Crc_11			(Crc_11),		 // Templated
	       .Crc_12			(Crc_12),		 // Templated
	       .Crc_13			(Crc_13),		 // Templated
	       .Crc_14			(Crc_14),		 // Templated
	       .Crc_15			(Crc_15),		 // Templated
	       .Crc_16			(Crc_16),		 // Templated
	       .Crc_17			(Crc_17),		 // Templated
	       .Crc_18			(Crc_18),		 // Templated
	       .Crc_19			(Crc_19),		 // Templated
	       .Crc_20			(Crc_20),		 // Templated
	       .Crc_21			(Crc_21),		 // Templated
	       .Crc_22			(Crc_22),		 // Templated
	       .Crc_23			(Crc_23),		 // Templated
	       .Crc_24			(Crc_24),		 // Templated
	       .Crc_25			(Crc_25),		 // Templated
	       .Crc_26			(Crc_26),		 // Templated
	       .Crc_27			(Crc_27),		 // Templated
	       .Crc_28			(Crc_28),		 // Templated
	       .Crc_29			(Crc_29),		 // Templated
	       .Crc_30			(Crc_30),		 // Templated
	       .Crc_31			(Crc_31),		 // Templated
	       .CrcError		(CrcError),		 // Templated
	       // Inputs
	       .Clk			(MTxClk),		 // Templated
	       .Reset			(Reset),		 // Templated
	       .Data			({Data_Crc_3, Data_Crc_2,Data_Crc_1,Data_Crc_0}), // Templated
	       .Enable			(Enable_Crc),		 // Templated
	       .Initialize		(Initialize_Crc));	 // Templated

//FMP_VC_1 //
// Connecting module Random
/* -----\/----- EXCLUDED -----\/-----
eth_random random1 (.MTxClk(MTxClk), .Reset(Reset), .StateJam(StateJam), .StateJam_q(StateJam_q), .RetryCnt(RetryCnt), 
                    .NibCnt(NibCnt), .ByteCnt(ByteCnt[9:0]), .RandomEq0(RandomEq0), .RandomEqByteCnt(RandomEqByteCnt));
 -----/\----- EXCLUDED -----/\----- */

   /*
    eth_random AUTO_TEMPLATE 
    (
    .MTxClk(MTxClk), 
    .Reset(Reset), 
    .StateJam(StateJam), 
    .StateJam_q(StateJam_q), 
    .RetryCnt({RetryCnt_3,RetryCnt_2,RetryCnt_1,RetryCnt_0}), 
    .NibCnt({NibCnt_15, NibCnt_14, NibCnt_13, NibCnt_12, NibCnt_11, NibCnt_10, NibCnt_9, NibCnt_8, NibCnt_7, NibCnt_6, NibCnt_5, NibCnt_4, NibCnt_3, NibCnt_2, NibCnt_1, NibCnt_0}), 
    .ByteCnt({ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0}), 
    .RandomEq0(RandomEq0), 
    .RandomEqByteCnt(RandomEqByteCnt),
    );
    */

eth_random random1 (/*AUTOINST*/
		    // Outputs
		    .RandomEq0		(RandomEq0),		 // Templated
		    .RandomEqByteCnt	(RandomEqByteCnt),	 // Templated
		    // Inputs
		    .MTxClk		(MTxClk),		 // Templated
		    .Reset		(Reset),		 // Templated
		    .StateJam		(StateJam),		 // Templated
		    .StateJam_q		(StateJam_q),		 // Templated
		    .RetryCnt		({RetryCnt_3,RetryCnt_2,RetryCnt_1,RetryCnt_0}), // Templated
		    .NibCnt		({NibCnt_15, NibCnt_14, NibCnt_13, NibCnt_12, NibCnt_11, NibCnt_10, NibCnt_9, NibCnt_8, NibCnt_7, NibCnt_6, NibCnt_5, NibCnt_4, NibCnt_3, NibCnt_2, NibCnt_1, NibCnt_0}), // Templated
		    .ByteCnt		({ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0})); // Templated




endmodule
