//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006-2007  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC
//////////////////////////////////////////////////////////////////////
////                                                              ////
////  eth_rxethmac.v                                              ////
////                                                              ////
////  This file is part of the Ethernet IP core project           ////
////  http://www.opencores.org/projects/ethmac/                   ////
////                                                              ////
////  Author(s):                                                  ////
////      - Igor Mohor (igorM@opencores.org)                      ////
////      - Novan Hartadi (novan@vlsi.itb.ac.id)                  ////
////      - Mahmud Galela (mgalela@vlsi.itb.ac.id)                ////
////                                                              ////
////  All additional information is avaliable in the Readme.txt   ////
////  file.                                                       ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
////                                                              ////
//// Copyright (C) 2001 Authors                                   ////
////                                                              ////
//// This source file may be used and distributed without         ////
//// restriction provided that this copyright statement is not    ////
//// removed from the file and that any derivative work contains  ////
//// the original copyright notice and the associated disclaimer. ////
////                                                              ////
//// This source file is free software; you can redistribute it   ////
//// and/or modify it under the terms of the GNU Lesser General   ////
//// Public License as published by the Free Software Foundation; ////
//// either version 2.1 of the License, or (at your option) any   ////
//// later version.                                               ////
////                                                              ////
//// This source is distributed in the hope that it will be       ////
//// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
//// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
//// PURPOSE.  See the GNU Lesser General Public License for more ////
//// details.                                                     ////
////                                                              ////
//// You should have received a copy of the GNU Lesser General    ////
//// Public License along with this source; if not, download it   ////
//// from http://www.opencores.org/lgpl.shtml                     ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
//
// CVS Revision History
//
// $Log: eth_rxethmac.v,v $
// Revision 1.13  2005/02/21 12:48:07  igorm
// Warning fixes.
//
// Revision 1.12  2004/04/26 15:26:23  igorm
// - Bug connected to the TX_BD_NUM_Wr signal fixed (bug came in with the
//   previous update of the core.
// - TxBDAddress is set to 0 after the TX is enabled in the MODER register.
// - RxBDAddress is set to r_TxBDNum<<1 after the RX is enabled in the MODER
//   register. (thanks to Mathias and Torbjorn)
// - Multicast reception was fixed. Thanks to Ulrich Gries
//
// Revision 1.11  2004/03/17 09:32:15  igorm
// Multicast detection fixed. Only the LSB of the first byte is checked.
//
// Revision 1.10  2002/11/22 01:57:06  mohor
// Rx Flow control fixed. CF flag added to the RX buffer descriptor. RxAbort
// synchronized.
//
// Revision 1.9  2002/11/19 17:35:35  mohor
// AddressMiss status is connecting to the Rx BD. AddressMiss is identifying
// that a frame was received because of the promiscous mode.
//
// Revision 1.8  2002/02/16 07:15:27  mohor
// Testbench fixed, code simplified, unused signals removed.
//
// Revision 1.7  2002/02/15 13:44:28  mohor
// RxAbort is an output. No need to have is declared as wire.
//
// Revision 1.6  2002/02/15 11:17:48  mohor
// File format changed.
//
// Revision 1.5  2002/02/14 20:48:43  billditt
// Addition  of new module eth_addrcheck.v
//
// Revision 1.4  2002/01/23 10:28:16  mohor
// Link in the header changed.
//
// Revision 1.3  2001/10/19 08:43:51  mohor
// eth_timescale.v changed to timescale.v This is done because of the
// simulation of the few cores in a one joined project.
//
// Revision 1.2  2001/09/11 14:17:00  mohor
// Few little NCSIM warnings fixed.
//
// Revision 1.1  2001/08/06 14:44:29  mohor
// A define FPGA added to select between Artisan RAM (for ASIC) and Block Ram (For Virtex).
// Include files fixed to contain no path.
// File names and module names changed ta have a eth_ prologue in the name.
// File eth_timescale.v is used to define timescale
// All pin names on the top module are changed to contain _I, _O or _OE at the end.
// Bidirectional signal MDIO is changed to three signals (Mdc_O, Mdi_I, Mdo_O
// and Mdo_OE. The bidirectional signal must be created on the top level. This
// is done due to the ASIC tools.
//
// Revision 1.1  2001/07/30 21:23:42  mohor
// Directory structure changed. Files checked and joind together.
//
// Revision 1.1  2001/06/27 21:26:19  mohor
// Initial release of the RxEthMAC module.
//
//
//
//
//

`include "timescale.v"


module eth_rxethmac (/*AUTOARG*/
   // Outputs
   RxData_0, RxData_1, RxData_2, RxData_3, RxData_4, RxData_5,
   RxData_6, RxData_7, RxValid, RxStartFrm, RxEndFrm, ByteCnt_15,
   ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10,
   ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4,
   ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0, ByteCntEq0,
   ByteCntGreat2, ByteCntMaxFrame, CrcError, StateIdle, StatePreamble,
   StateSFD, StateData_0, StateData_1, RxAbort, AddressMiss,
   // Inputs
   MRxClk, MRxDV, MRxD, Transmitting, HugEn, DlyCrcEn, MaxFL, r_IFG,
   Reset, MAC, r_Bro, r_Pro, r_HASH0, r_HASH1, PassAll,
   ControlFrmAddressOK
		     , Broadcast,CrcHashGood /// this for VCEGAR
		     
   );

//FMP_VC_2//parameter Tp = 1;



input         MRxClk;
input         MRxDV;
input   [3:0] MRxD;
input         Transmitting;
input         HugEn;
input         DlyCrcEn;
input  [15:0] MaxFL;
input         r_IFG;
input         Reset;
input  [47:0] MAC;     //  Station Address  
input         r_Bro;   //  broadcast disable
input         r_Pro;   //  promiscuous enable 
input [31:0]  r_HASH0; //  lower 4 bytes Hash Table
input [31:0]  r_HASH1; //  upper 4 bytes Hash Table
input         PassAll;
input         ControlFrmAddressOK;

//FMP_VC_1//output  [7:0] RxData;
   output     RxData_0;
   output     RxData_1;
   output     RxData_2;
   output     RxData_3;
   output     RxData_4;
   output     RxData_5;
   output     RxData_6;
   output     RxData_7;
   
output        RxValid;
output        RxStartFrm;
output        RxEndFrm;
//FMP_VC_1//output [15:0] ByteCnt;
output ByteCnt_15, ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10, ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0;
 
output        ByteCntEq0;
output        ByteCntGreat2;
output        ByteCntMaxFrame;
output        CrcError;
output        StateIdle;
output        StatePreamble;
output        StateSFD;
//FMP_VC_1//output  [1:0] StateData;
   output     StateData_0, StateData_1;
   
output        RxAbort;
output        AddressMiss;

//FMP_VC_0
   output     Broadcast;
   output     CrcHashGood;
   
   
reg     [7:0] RxData;
reg           RxValid;
reg           RxStartFrm;
reg           RxEndFrm;
reg           Broadcast;
reg           Multicast;
reg     [5:0] CrcHash;
reg           CrcHashGood;
reg           DelayData;
reg     [7:0] LatchedByte;
reg     [7:0] RxData_d;
reg           RxValid_d;
reg           RxStartFrm_d;
reg           RxEndFrm_d;

wire          MRxDEqD;
wire          MRxDEq5;
wire          StateDrop;
wire          ByteCntEq1;
wire          ByteCntEq2;
wire          ByteCntEq3;
wire          ByteCntEq4;
wire          ByteCntEq5;
wire          ByteCntEq6;
wire          ByteCntEq7;
wire          ByteCntSmall7;
wire   [31:0] Crc;
wire          Enable_Crc;
wire          Initialize_Crc;
wire    [3:0] Data_Crc;
wire          GenerateRxValid;
wire          GenerateRxStartFrm;
wire          GenerateRxEndFrm;
wire          DribbleRxEndFrm;
//FMP_VC_1//wire    [3:0] DlyCrcCnt;
   wire       DlyCrcCnt_0;
   wire       DlyCrcCnt_1;
   wire       DlyCrcCnt_2;
   wire       DlyCrcCnt_3;
wire    [3:0] DlyCrcCnt = {DlyCrcCnt_3,DlyCrcCnt_2,DlyCrcCnt_1,DlyCrcCnt_0};

wire          IFGCounterEq24;

assign MRxDEqD = MRxD == 4'hd;
assign MRxDEq5 = MRxD == 4'h5;

//FMP_VC_1// 
   wire ByteCnt_15, ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10, ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0;
   wire [15:0] ByteCnt = {ByteCnt_15, ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10, ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0};
   
   wire     StateData_1,StateData_0;
   wire [1:0] StateData = {StateData_1,StateData_0};
   
   wire     RxData_0 = RxData[0];
   wire     RxData_1 = RxData[1];
   wire     RxData_2 = RxData[2];
   wire     RxData_3 = RxData[3];
   wire     RxData_4 = RxData[4];
   wire     RxData_5 = RxData[5];
   wire     RxData_6 = RxData[6];
   wire     RxData_7 = RxData[7];
 
wire    MaxFL_15 = MaxFL[15];
wire    MaxFL_14 = MaxFL[14];
wire    MaxFL_13 = MaxFL[13];
wire    MaxFL_12 = MaxFL[12];
wire    MaxFL_11 = MaxFL[11];
wire    MaxFL_10 = MaxFL[10];
wire    MaxFL_9 = MaxFL[9];
wire    MaxFL_8 = MaxFL[8];
wire    MaxFL_7 = MaxFL[7];
wire    MaxFL_6 = MaxFL[6];
wire    MaxFL_5 = MaxFL[5];
wire    MaxFL_4 = MaxFL[4];
wire    MaxFL_3 = MaxFL[3];
wire    MaxFL_2 = MaxFL[2];
wire    MaxFL_1 = MaxFL[1];
wire    MaxFL_0 = MaxFL[0];

wire    HASH0_31 = r_HASH0[31];
wire    HASH0_30 = r_HASH0[30];
wire    HASH0_29 = r_HASH0[29];
wire    HASH0_28 = r_HASH0[28];
wire    HASH0_27 = r_HASH0[27];
wire    HASH0_26 = r_HASH0[26];
wire    HASH0_25 = r_HASH0[25];
wire    HASH0_24 = r_HASH0[24];
wire    HASH0_23 = r_HASH0[23];
wire    HASH0_22 = r_HASH0[22];
wire    HASH0_21 = r_HASH0[21];
wire    HASH0_20 = r_HASH0[20];
wire    HASH0_19 = r_HASH0[19];
wire    HASH0_18 = r_HASH0[18];
wire    HASH0_17 = r_HASH0[17];
wire    HASH0_16 = r_HASH0[16];
wire    HASH0_15 = r_HASH0[15];
wire    HASH0_14 = r_HASH0[14];
wire    HASH0_13 = r_HASH0[13];
wire    HASH0_12 = r_HASH0[12];
wire    HASH0_11 = r_HASH0[11];
wire    HASH0_10 = r_HASH0[10];
wire    HASH0_9 = r_HASH0[9];
wire    HASH0_8 = r_HASH0[8];
wire    HASH0_7 = r_HASH0[7];
wire    HASH0_6 = r_HASH0[6];
wire    HASH0_5 = r_HASH0[5];
wire    HASH0_4 = r_HASH0[4];
wire    HASH0_3 = r_HASH0[3];
wire    HASH0_2 = r_HASH0[2];
wire    HASH0_1 = r_HASH0[1];
wire    HASH0_0 = r_HASH0[0];

wire    HASH1_31 = r_HASH1[31];
wire    HASH1_30 = r_HASH1[30];
wire    HASH1_29 = r_HASH1[29];
wire    HASH1_28 = r_HASH1[28];
wire    HASH1_27 = r_HASH1[27];
wire    HASH1_26 = r_HASH1[26];
wire    HASH1_25 = r_HASH1[25];
wire    HASH1_24 = r_HASH1[24];
wire    HASH1_23 = r_HASH1[23];
wire    HASH1_22 = r_HASH1[22];
wire    HASH1_21 = r_HASH1[21];
wire    HASH1_20 = r_HASH1[20];
wire    HASH1_19 = r_HASH1[19];
wire    HASH1_18 = r_HASH1[18];
wire    HASH1_17 = r_HASH1[17];
wire    HASH1_16 = r_HASH1[16];
wire    HASH1_15 = r_HASH1[15];
wire    HASH1_14 = r_HASH1[14];
wire    HASH1_13 = r_HASH1[13];
wire    HASH1_12 = r_HASH1[12];
wire    HASH1_11 = r_HASH1[11];
wire    HASH1_10 = r_HASH1[10];
wire    HASH1_9 = r_HASH1[9];
wire    HASH1_8 = r_HASH1[8];
wire    HASH1_7 = r_HASH1[7];
wire    HASH1_6 = r_HASH1[6];
wire    HASH1_5 = r_HASH1[5];
wire    HASH1_4 = r_HASH1[4];
wire    HASH1_3 = r_HASH1[3];
wire    HASH1_2 = r_HASH1[2];
wire    HASH1_1 = r_HASH1[1];
wire    HASH1_0 = r_HASH1[0];



wire    MAC_47 = MAC[47];
wire    MAC_46 = MAC[46];
wire    MAC_45 = MAC[45];
wire    MAC_44 = MAC[44];
wire    MAC_43 = MAC[43];
wire    MAC_42 = MAC[42];
wire    MAC_41 = MAC[41];
wire    MAC_40 = MAC[40];
wire    MAC_39 = MAC[39];
wire    MAC_38 = MAC[38];
wire    MAC_37 = MAC[37];
wire    MAC_36 = MAC[36];
wire    MAC_35 = MAC[35];
wire    MAC_34 = MAC[34];
wire    MAC_33 = MAC[33];
wire    MAC_32 = MAC[32];
wire    MAC_31 = MAC[31];
wire    MAC_30 = MAC[30];
wire    MAC_29 = MAC[29];
wire    MAC_28 = MAC[28];
wire    MAC_27 = MAC[27];
wire    MAC_26 = MAC[26];
wire    MAC_25 = MAC[25];
wire    MAC_24 = MAC[24];
wire    MAC_23 = MAC[23];
wire    MAC_22 = MAC[22];
wire    MAC_21 = MAC[21];
wire    MAC_20 = MAC[20];
wire    MAC_19 = MAC[19];
wire    MAC_18 = MAC[18];
wire    MAC_17 = MAC[17];
wire    MAC_16 = MAC[16];
wire    MAC_15 = MAC[15];
wire    MAC_14 = MAC[14];
wire    MAC_13 = MAC[13];
wire    MAC_12 = MAC[12];
wire    MAC_11 = MAC[11];
wire    MAC_10 = MAC[10];
wire    MAC_9 = MAC[9];
wire    MAC_8 = MAC[8];
wire    MAC_7 = MAC[7];
wire    MAC_6 = MAC[6];
wire    MAC_5 = MAC[5];
wire    MAC_4 = MAC[4];
wire    MAC_3 = MAC[3];
wire    MAC_2 = MAC[2];
wire    MAC_1 = MAC[1];
wire    MAC_0 = MAC[0];

wire    CrcHash_5 = CrcHash[5];
wire    CrcHash_4 = CrcHash[4];
wire    CrcHash_3 = CrcHash[3];
wire    CrcHash_2 = CrcHash[2];
wire    CrcHash_1 = CrcHash[1];
wire    CrcHash_0 = CrcHash[0];

   
//FMP_VC_4//
`define VCEGAR
`ifdef VCEGAR
   initial begin
      RxValid      = 1'b0;
      RxValid_d    = 1'b0;
      RxStartFrm   = 1'b0;
      RxStartFrm_d = 1'b0;
      RxData       = 8'd0;
      RxEndFrm     = 1'b0;
      RxEndFrm_d   = 1'b0;
      RxData_d     = 8'd0;
      DelayData    = 1'b0;  
      Multicast    = 1'b0;
      LatchedByte  = 8'd0;
      CrcHash      = 6'd0;
      CrcHashGood  = 1'b0;
      Broadcast    = 1'b0;
   end
`endif

//FMP_VC_1   
// Rx State Machine module
/* -----\/----- EXCLUDED -----\/-----
eth_rxstatem rxstatem1 (.MRxClk(MRxClk), .Reset(Reset), .MRxDV(MRxDV), .ByteCntEq0(ByteCntEq0), 
                        .ByteCntGreat2(ByteCntGreat2), .Transmitting(Transmitting), .MRxDEq5(MRxDEq5), 
                        .MRxDEqD(MRxDEqD), .IFGCounterEq24(IFGCounterEq24), .ByteCntMaxFrame(ByteCntMaxFrame), 
                        .StateData(StateData), .StateIdle(StateIdle), .StatePreamble(StatePreamble), 
                        .StateSFD(StateSFD), .StateDrop(StateDrop)
                       );
 -----/\----- EXCLUDED -----/\----- */

/* eth_rxstatem  AUTO_TEMPLATE(
 .MRxClk(MRxClk), 
 .Reset(Reset), 
 .MRxDV(MRxDV), 
 .ByteCntEq0(ByteCntEq0), 
 .ByteCntGreat2(ByteCntGreat2), 
 .Transmitting(Transmitting), 
 .MRxDEq5(MRxDEq5), 
 .MRxDEqD(MRxDEqD), 
 .IFGCounterEq24(IFGCounterEq24), 
 .ByteCntMaxFrame(ByteCntMaxFrame), 
 .StateData(StateData), 
 .StateIdle(StateIdle), 
 .StatePreamble(StatePreamble), 
 .StateSFD(StateSFD), 
 .StateDrop(StateDrop),
 );*/
   eth_rxstatem rxstatem1 (/*AUTOINST*/
			   // Outputs
			   .StateData_0	(StateData_0),
			   .StateData_1	(StateData_1),
			   .StateIdle	(StateIdle),		 // Templated
			   .StateDrop	(StateDrop),		 // Templated
			   .StatePreamble(StatePreamble),	 // Templated
			   .StateSFD	(StateSFD),		 // Templated
			   // Inputs
			   .MRxClk	(MRxClk),		 // Templated
			   .Reset	(Reset),		 // Templated
			   .MRxDV	(MRxDV),		 // Templated
			   .ByteCntEq0	(ByteCntEq0),		 // Templated
			   .ByteCntGreat2(ByteCntGreat2),	 // Templated
			   .MRxDEq5	(MRxDEq5),		 // Templated
			   .Transmitting(Transmitting),		 // Templated
			   .MRxDEqD	(MRxDEqD),		 // Templated
			   .IFGCounterEq24(IFGCounterEq24),	 // Templated
			   .ByteCntMaxFrame(ByteCntMaxFrame));	 // Templated

//FMP_VC_1
/* -----\/----- EXCLUDED -----\/-----
// Rx Counters module
eth_rxcounters rxcounters1 (.MRxClk(MRxClk), .Reset(Reset), .MRxDV(MRxDV), .StateIdle(StateIdle), 
                            .StateSFD(StateSFD), .StateData(StateData), .StateDrop(StateDrop), 
                            .StatePreamble(StatePreamble), .MRxDEqD(MRxDEqD), .DlyCrcEn(DlyCrcEn), 
                            .DlyCrcCnt(DlyCrcCnt), .Transmitting(Transmitting), .MaxFL(MaxFL), .r_IFG(r_IFG), 
                            .HugEn(HugEn), .IFGCounterEq24(IFGCounterEq24), .ByteCntEq0(ByteCntEq0), 
                            .ByteCntEq1(ByteCntEq1), .ByteCntEq2(ByteCntEq2), .ByteCntEq3(ByteCntEq3), 
                            .ByteCntEq4(ByteCntEq4), .ByteCntEq5(ByteCntEq5), .ByteCntEq6(ByteCntEq6), 
                            .ByteCntEq7(ByteCntEq7), .ByteCntGreat2(ByteCntGreat2), 
                            .ByteCntSmall7(ByteCntSmall7), .ByteCntMaxFrame(ByteCntMaxFrame), 
                            .ByteCntOut(ByteCnt)
                           );
 -----/\----- EXCLUDED -----/\----- */


/* eth_rxcounters AUTO_TEMPLATE(
 .MRxClk(MRxClk), 
 .Reset(Reset), 
 .MRxDV(MRxDV), 
 .StateIdle(StateIdle), 
 .StateSFD(StateSFD), 
 .StateData({StateData_1,StateData_0}), 
 .StateDrop(StateDrop), 
 .StatePreamble(StatePreamble), 
 .MRxDEqD(MRxDEqD), 
 .DlyCrcEn(DlyCrcEn), 
 .DlyCrcCnt_0(DlyCrcCnt_0), 
 .DlyCrcCnt_1(DlyCrcCnt_1), 
 .DlyCrcCnt_2(DlyCrcCnt_2), 
 .DlyCrcCnt_3(DlyCrcCnt_3), 
 .Transmitting(Transmitting), 
    .MaxFL({MaxFL_15, MaxFL_14, MaxFL_13, MaxFL_12, MaxFL_11, MaxFL_10, MaxFL_9, MaxFL_8, MaxFL_7, MaxFL_6, MaxFL_5, MaxFL_4, MaxFL_3, MaxFL_2, MaxFL_1, MaxFL_0}), 
 .r_IFG(r_IFG), 
 .HugEn(HugEn), 
 .IFGCounterEq24(IFGCounterEq24), 
 .ByteCntEq0(ByteCntEq0), 
 .ByteCntEq1(ByteCntEq1), 
 .ByteCntEq2(ByteCntEq2), 
 .ByteCntEq3(ByteCntEq3), 
 .ByteCntEq4(ByteCntEq4), 
 .ByteCntEq5(ByteCntEq5), 
 .ByteCntEq6(ByteCntEq6), 
 .ByteCntEq7(ByteCntEq7), 
 .ByteCntGreat2(ByteCntGreat2), 
 .ByteCntSmall7(ByteCntSmall7), 
 .ByteCntMaxFrame(ByteCntMaxFrame), 
.ByteCntOut_15(ByteCnt_15),
.ByteCntOut_14(ByteCnt_14),
.ByteCntOut_13(ByteCnt_13),
.ByteCntOut_12(ByteCnt_12),
.ByteCntOut_11(ByteCnt_11),
.ByteCntOut_10(ByteCnt_10),
.ByteCntOut_9(ByteCnt_9),
.ByteCntOut_8(ByteCnt_8),
.ByteCntOut_7(ByteCnt_7),
.ByteCntOut_6(ByteCnt_6),
.ByteCntOut_5(ByteCnt_5),
.ByteCntOut_4(ByteCnt_4),
.ByteCntOut_3(ByteCnt_3),
.ByteCntOut_2(ByteCnt_2),
.ByteCntOut_1(ByteCnt_1),
.ByteCntOut_0(ByteCnt_0),
 );*/
   eth_rxcounters rxcounters1 (/*AUTOINST*/
			       // Outputs
			       .IFGCounterEq24(IFGCounterEq24),	 // Templated
			       .DlyCrcCnt_0(DlyCrcCnt_0),	 // Templated
			       .DlyCrcCnt_1(DlyCrcCnt_1),	 // Templated
			       .DlyCrcCnt_2(DlyCrcCnt_2),	 // Templated
			       .DlyCrcCnt_3(DlyCrcCnt_3),	 // Templated
			       .ByteCntEq0(ByteCntEq0),		 // Templated
			       .ByteCntEq1(ByteCntEq1),		 // Templated
			       .ByteCntEq2(ByteCntEq2),		 // Templated
			       .ByteCntEq3(ByteCntEq3),		 // Templated
			       .ByteCntEq4(ByteCntEq4),		 // Templated
			       .ByteCntEq5(ByteCntEq5),		 // Templated
			       .ByteCntEq6(ByteCntEq6),		 // Templated
			       .ByteCntEq7(ByteCntEq7),		 // Templated
			       .ByteCntGreat2(ByteCntGreat2),	 // Templated
			       .ByteCntSmall7(ByteCntSmall7),	 // Templated
			       .ByteCntMaxFrame(ByteCntMaxFrame), // Templated
			       .ByteCntOut_15(ByteCnt_15),	 // Templated
			       .ByteCntOut_14(ByteCnt_14),	 // Templated
			       .ByteCntOut_13(ByteCnt_13),	 // Templated
			       .ByteCntOut_12(ByteCnt_12),	 // Templated
			       .ByteCntOut_11(ByteCnt_11),	 // Templated
			       .ByteCntOut_10(ByteCnt_10),	 // Templated
			       .ByteCntOut_9(ByteCnt_9),	 // Templated
			       .ByteCntOut_8(ByteCnt_8),	 // Templated
			       .ByteCntOut_7(ByteCnt_7),	 // Templated
			       .ByteCntOut_6(ByteCnt_6),	 // Templated
			       .ByteCntOut_5(ByteCnt_5),	 // Templated
			       .ByteCntOut_4(ByteCnt_4),	 // Templated
			       .ByteCntOut_3(ByteCnt_3),	 // Templated
			       .ByteCntOut_2(ByteCnt_2),	 // Templated
			       .ByteCntOut_1(ByteCnt_1),	 // Templated
			       .ByteCntOut_0(ByteCnt_0),	 // Templated
			       // Inputs
			       .MRxClk	(MRxClk),		 // Templated
			       .Reset	(Reset),		 // Templated
			       .MRxDV	(MRxDV),		 // Templated
			       .StateSFD(StateSFD),		 // Templated
			       .StateData({StateData_1,StateData_0}), // Templated
			       .MRxDEqD	(MRxDEqD),		 // Templated
			       .StateIdle(StateIdle),		 // Templated
			       .StateDrop(StateDrop),		 // Templated
			       .DlyCrcEn(DlyCrcEn),		 // Templated
			       .StatePreamble(StatePreamble),	 // Templated
			       .Transmitting(Transmitting),	 // Templated
			       .HugEn	(HugEn),		 // Templated
			       .MaxFL	({MaxFL_15, MaxFL_14, MaxFL_13, MaxFL_12, MaxFL_11, MaxFL_10, MaxFL_9, MaxFL_8, MaxFL_7, MaxFL_6, MaxFL_5, MaxFL_4, MaxFL_3, MaxFL_2, MaxFL_1, MaxFL_0}), // Templated
			       .r_IFG	(r_IFG));		 // Templated

//FMP_VC_1
/* -----\/----- EXCLUDED -----\/-----
// Rx Address Check
eth_rxaddrcheck rxaddrcheck1
              (.MRxClk(MRxClk),         .Reset( Reset),             .RxData(RxData), 
               .Broadcast (Broadcast),  .r_Bro (r_Bro),             .r_Pro(r_Pro),
               .ByteCntEq6(ByteCntEq6), .ByteCntEq7(ByteCntEq7),    .ByteCntEq2(ByteCntEq2), 
               .ByteCntEq3(ByteCntEq3), .ByteCntEq4(ByteCntEq4),    .ByteCntEq5(ByteCntEq5), 
               .HASH0(r_HASH0),         .HASH1(r_HASH1),           
               .CrcHash(CrcHash),       .CrcHashGood(CrcHashGood),  .StateData(StateData),
               .Multicast(Multicast),   .MAC(MAC),                  .RxAbort(RxAbort),
               .RxEndFrm(RxEndFrm),     .AddressMiss(AddressMiss),  .PassAll(PassAll),
               .ControlFrmAddressOK(ControlFrmAddressOK)
              );
 -----/\----- EXCLUDED -----/\----- */

/* eth_rxaddrcheck AUTO_TEMPLATE(
 .MRxClk(MRxClk),
 .Reset( Reset), 
 .RxData({RxData_7, RxData_6, RxData_5, RxData_4, RxData_3, RxData_2, RxData_1, RxData_0}), 
 .Broadcast (Broadcast), 
 .r_Bro (r_Bro), 
 .r_Pro(r_Pro),
 .ByteCntEq6(ByteCntEq6), 
 .ByteCntEq7(ByteCntEq7),    
 .ByteCntEq2(ByteCntEq2), 
 .ByteCntEq3(ByteCntEq3), 
 .ByteCntEq4(ByteCntEq4),    
 .ByteCntEq5(ByteCntEq5), 
 .HASH0({HASH0_31, HASH0_30, HASH0_29, HASH0_28, HASH0_27, HASH0_26, HASH0_25, HASH0_24, HASH0_23, HASH0_22, HASH0_21, HASH0_20, HASH0_19, HASH0_18, HASH0_17, HASH0_16, HASH0_15, HASH0_14, HASH0_13, HASH0_12, HASH0_11, HASH0_10, HASH0_9, HASH0_8, HASH0_7, HASH0_6, HASH0_5, HASH0_4, HASH0_3, HASH0_2, HASH0_1, HASH0_0}),         
 .HASH1({HASH1_31, HASH1_30, HASH1_29, HASH1_28, HASH1_27, HASH1_26, HASH1_25, HASH1_24, HASH1_23, HASH1_22, HASH1_21, HASH1_20, HASH1_19, HASH1_18, HASH1_17, HASH1_16, HASH1_15, HASH1_14, HASH1_13, HASH1_12, HASH1_11, HASH1_10, HASH1_9, HASH1_8, HASH1_7, HASH1_6, HASH1_5, HASH1_4, HASH1_3, HASH1_2, HASH1_1, HASH1_0}),           
 .CrcHash({CrcHash_5, CrcHash_4, CrcHash_3, CrcHash_2, CrcHash_1, CrcHash_0}),       
 .CrcHashGood(CrcHashGood),  
 .StateData({StateData_1,StateData_0}),
 .Multicast(Multicast),   
 .MAC({MAC_47, MAC_46, MAC_45, MAC_44, MAC_43, MAC_42, MAC_41, MAC_40, MAC_39, MAC_38, MAC_37, MAC_36, MAC_35, MAC_34, MAC_33, MAC_32, MAC_31, MAC_30, MAC_29, MAC_28, MAC_27, MAC_26, MAC_25, MAC_24, MAC_23, MAC_22, MAC_21, MAC_20, MAC_19, MAC_18, MAC_17, MAC_16, MAC_15, MAC_14, MAC_13, MAC_12, MAC_11, MAC_10, MAC_9, MAC_8, MAC_7, MAC_6, MAC_5, MAC_4, MAC_3, MAC_2, MAC_1, MAC_0}),                  
 .RxAbort(RxAbort),
 .RxEndFrm(RxEndFrm),     
 .AddressMiss(AddressMiss),  
 .PassAll(PassAll),
 .ControlFrmAddressOK(ControlFrmAddressOK), 
 );*/
eth_rxaddrcheck rxaddrcheck1
              (/*AUTOINST*/
	       // Outputs
	       .RxAbort			(RxAbort),		 // Templated
	       .AddressMiss		(AddressMiss),		 // Templated
	       // Inputs
	       .MRxClk			(MRxClk),		 // Templated
	       .Reset			( Reset),		 // Templated
	       .RxData			({RxData_7, RxData_6, RxData_5, RxData_4, RxData_3, RxData_2, RxData_1, RxData_0}), // Templated
	       .Broadcast		(Broadcast),		 // Templated
	       .r_Bro			(r_Bro),		 // Templated
	       .r_Pro			(r_Pro),		 // Templated
	       .ByteCntEq2		(ByteCntEq2),		 // Templated
	       .ByteCntEq3		(ByteCntEq3),		 // Templated
	       .ByteCntEq4		(ByteCntEq4),		 // Templated
	       .ByteCntEq5		(ByteCntEq5),		 // Templated
	       .ByteCntEq6		(ByteCntEq6),		 // Templated
	       .ByteCntEq7		(ByteCntEq7),		 // Templated
	       .HASH0			({HASH0_31, HASH0_30, HASH0_29, HASH0_28, HASH0_27, HASH0_26, HASH0_25, HASH0_24, HASH0_23, HASH0_22, HASH0_21, HASH0_20, HASH0_19, HASH0_18, HASH0_17, HASH0_16, HASH0_15, HASH0_14, HASH0_13, HASH0_12, HASH0_11, HASH0_10, HASH0_9, HASH0_8, HASH0_7, HASH0_6, HASH0_5, HASH0_4, HASH0_3, HASH0_2, HASH0_1, HASH0_0}), // Templated
	       .HASH1			({HASH1_31, HASH1_30, HASH1_29, HASH1_28, HASH1_27, HASH1_26, HASH1_25, HASH1_24, HASH1_23, HASH1_22, HASH1_21, HASH1_20, HASH1_19, HASH1_18, HASH1_17, HASH1_16, HASH1_15, HASH1_14, HASH1_13, HASH1_12, HASH1_11, HASH1_10, HASH1_9, HASH1_8, HASH1_7, HASH1_6, HASH1_5, HASH1_4, HASH1_3, HASH1_2, HASH1_1, HASH1_0}), // Templated
	       .CrcHash			({CrcHash_5, CrcHash_4, CrcHash_3, CrcHash_2, CrcHash_1, CrcHash_0}), // Templated
	       .CrcHashGood		(CrcHashGood),		 // Templated
	       .Multicast		(Multicast),		 // Templated
	       .MAC			({MAC_47, MAC_46, MAC_45, MAC_44, MAC_43, MAC_42, MAC_41, MAC_40, MAC_39, MAC_38, MAC_37, MAC_36, MAC_35, MAC_34, MAC_33, MAC_32, MAC_31, MAC_30, MAC_29, MAC_28, MAC_27, MAC_26, MAC_25, MAC_24, MAC_23, MAC_22, MAC_21, MAC_20, MAC_19, MAC_18, MAC_17, MAC_16, MAC_15, MAC_14, MAC_13, MAC_12, MAC_11, MAC_10, MAC_9, MAC_8, MAC_7, MAC_6, MAC_5, MAC_4, MAC_3, MAC_2, MAC_1, MAC_0}), // Templated
	       .StateData		({StateData_1,StateData_0}), // Templated
	       .RxEndFrm		(RxEndFrm),		 // Templated
	       .PassAll			(PassAll),		 // Templated
	       .ControlFrmAddressOK	(ControlFrmAddressOK));	 // Templated


assign Enable_Crc = MRxDV & (|{StateData_1,StateData_0} & ~ByteCntMaxFrame);
assign Initialize_Crc = StateSFD | DlyCrcEn & (|{DlyCrcCnt_3,DlyCrcCnt_2,DlyCrcCnt_1,DlyCrcCnt_0}) & {DlyCrcCnt_3,DlyCrcCnt_2,DlyCrcCnt_1,DlyCrcCnt_0} < 4'h9;
   
//FMP_VC_1
/* -----\/----- EXCLUDED -----\/-----
 assign Data_Crc[0] = MRxD[3];
assign Data_Crc[1] = MRxD[2];
assign Data_Crc[2] = MRxD[1];
assign Data_Crc[3] = MRxD[0];
 -----/\----- EXCLUDED -----/\----- */
wire Data_Crc_0 = MRxD[3];
wire Data_Crc_1 = MRxD[2];
wire Data_Crc_2 = MRxD[1];
wire Data_Crc_3 = MRxD[0];

 
   wire Crc_31, Crc_30, Crc_29, Crc_28, Crc_27, Crc_26, Crc_25, Crc_24, Crc_23, Crc_22, Crc_21, Crc_20, Crc_19, Crc_18, Crc_17, Crc_16, Crc_15, Crc_14, Crc_13, Crc_12, Crc_11, Crc_10, Crc_9, Crc_8, Crc_7, Crc_6, Crc_5, Crc_4, Crc_3, Crc_2, Crc_1, Crc_0;

   wire fmp_crc_ored = |{Crc_31, Crc_30, Crc_29, Crc_28, Crc_27, Crc_26, Crc_25, Crc_24, Crc_23, Crc_22, Crc_21, Crc_20, Crc_19, Crc_18, Crc_17, Crc_16, Crc_15, Crc_14, Crc_13, Crc_12, Crc_11, Crc_10, Crc_9, Crc_8, Crc_7, Crc_6, Crc_5, Crc_4, Crc_3, Crc_2, Crc_1, Crc_0};
   
    
//FMP_VC_1
/* -----\/----- EXCLUDED -----\/-----
// Connecting module Crc
eth_crc crcrx (.Clk(MRxClk), .Reset(Reset), .Data(Data_Crc), .Enable(Enable_Crc), .Initialize(Initialize_Crc), 
               .Crc(Crc), .CrcError(CrcError)
              );
 -----/\----- EXCLUDED -----/\----- */

/* eth_crc AUTO_TEMPLATE(
 .Clk(MRxClk), 
 .Reset(Reset), 
 .Data({Data_Crc_3,Data_Crc_2,Data_Crc_1,Data_Crc_0}), 
 .Enable(Enable_Crc), 
 .Initialize(Initialize_Crc), 
 .Crc(Crc), 
 .CrcError(CrcError),
  );*/
eth_crc crcrx (/*AUTOINST*/
	       // Outputs
	       .Crc_0			(Crc_0),
	       .Crc_1			(Crc_1),
	       .Crc_2			(Crc_2),
	       .Crc_3			(Crc_3),
	       .Crc_4			(Crc_4),
	       .Crc_5			(Crc_5),
	       .Crc_6			(Crc_6),
	       .Crc_7			(Crc_7),
	       .Crc_8			(Crc_8),
	       .Crc_9			(Crc_9),
	       .Crc_10			(Crc_10),
	       .Crc_11			(Crc_11),
	       .Crc_12			(Crc_12),
	       .Crc_13			(Crc_13),
	       .Crc_14			(Crc_14),
	       .Crc_15			(Crc_15),
	       .Crc_16			(Crc_16),
	       .Crc_17			(Crc_17),
	       .Crc_18			(Crc_18),
	       .Crc_19			(Crc_19),
	       .Crc_20			(Crc_20),
	       .Crc_21			(Crc_21),
	       .Crc_22			(Crc_22),
	       .Crc_23			(Crc_23),
	       .Crc_24			(Crc_24),
	       .Crc_25			(Crc_25),
	       .Crc_26			(Crc_26),
	       .Crc_27			(Crc_27),
	       .Crc_28			(Crc_28),
	       .Crc_29			(Crc_29),
	       .Crc_30			(Crc_30),
	       .Crc_31			(Crc_31),
	       .CrcError		(CrcError),		 // Templated
	       // Inputs
	       .Clk			(MRxClk),		 // Templated
	       .Reset			(Reset),		 // Templated
	       .Data			({Data_Crc_3,Data_Crc_2,Data_Crc_1,Data_Crc_0}), // Templated
	       .Enable			(Enable_Crc),		 // Templated
	       .Initialize		(Initialize_Crc));	 // Templated



// Latching CRC for use in the hash table

always @ (posedge MRxClk)
begin
  CrcHashGood <= #1 StateData[0] & ByteCntEq6;
end

always @ (posedge MRxClk)
begin
  if(Reset | StateIdle)
//FMP_VC_11//    CrcHash[5:0] <= #1 6'h0;
 CrcHash <= #1 6'h0;  else
  if(StateData[0] & ByteCntEq6)
//FMP_VC_11//    CrcHash[5:0] <= #1 Crc[31:26];
    CrcHash<= #1 {Crc_31,Crc_30,Crc_29,Crc_28,Crc_27,Crc_26};
end

//FMP_VC_11// 
// Output byte stream
/* -----\/----- EXCLUDED -----\/-----
// VCEGAR COMPATIBLE
 always @ (posedge MRxClk /-* or posedge Reset*-/)
begin
  if(Reset)
    begin
      RxData_d[7:0]      <= #1 8'h0;
      DelayData          <= #1 1'b0;
      LatchedByte[7:0]   <= #1 8'h0;
      RxData[7:0]        <= #1 8'h0;
    end
  else
    begin
      LatchedByte[7:0]   <= #1 {MRxD[3:0], LatchedByte[7:4]};  // Latched byte
      DelayData          <= #1 StateData[0];

      if(GenerateRxValid)
        RxData_d[7:0] <= #1 LatchedByte[7:0] & {8{|StateData}};  // Data goes through only in data state 
      else
      if(~DelayData)
        RxData_d[7:0] <= #1 8'h0;                                // Delaying data to be valid for two cycles. Zero when not active.

      RxData[7:0] <= #1 RxData_d[7:0];                           // Output data byte
    end
end
 -----/\----- EXCLUDED -----/\----- */
 always @ (posedge MRxClk /* or posedge Reset*/)
begin
  if(Reset)
    begin
      RxData_d      <= #1 8'h0;
      DelayData     <= #1 1'b0;
      LatchedByte   <= #1 8'h0;
      RxData        <= #1 8'h0;
    end
  else
    begin
      LatchedByte        <= #1 {MRxD[3:0], LatchedByte[7:4]};  // Latched byte
      DelayData          <= #1 StateData[0];

      if(GenerateRxValid)
        RxData_d <= #1 LatchedByte & {8{|StateData}};  // Data goes through only in data state 
      else
      if(~DelayData)
        RxData_d <= #1 8'h0;                                // Delaying data to be valid for two cycles. Zero when not active.

      RxData <= #1 RxData_d;                           // Output data byte
    end
end
    

always @ (posedge MRxClk /* or posedge Reset*/)
begin
  if(Reset)
    Broadcast <= #1 1'b0;
  else
    begin      
      if(StateData[0] & ~(&LatchedByte[7:0]) & ByteCntSmall7)
        Broadcast <= #1 1'b0;
      else
      if(StateData[0] & (&LatchedByte[7:0]) & ByteCntEq1)
        Broadcast <= #1 1'b1;
      else
      if(RxAbort | RxEndFrm)
        Broadcast <= #1 1'b0;
    end
end


always @ (posedge MRxClk /* or posedge Reset*/)
begin
  if(Reset)
    Multicast <= #1 1'b0;
  else
    begin      
      if(StateData[0] & ByteCntEq1 & LatchedByte[0])
        Multicast <= #1 1'b1;
      else if(RxAbort | RxEndFrm)
      Multicast <= #1 1'b0;
    end
end


assign GenerateRxValid = StateData[0] & (~ByteCntEq0 | DlyCrcCnt >= 4'h3);

always @ (posedge MRxClk /* or posedge Reset*/)
begin
  if(Reset)
    begin
      RxValid_d <= #1 1'b0;
      RxValid   <= #1 1'b0;
    end
  else
    begin
      RxValid_d <= #1 GenerateRxValid;
      RxValid   <= #1 RxValid_d;
    end
end


assign GenerateRxStartFrm = StateData[0] & (ByteCntEq1 & ~DlyCrcEn | DlyCrcCnt == 4'h3 & DlyCrcEn);

always @ (posedge MRxClk /* or posedge Reset*/)
begin
  if(Reset)
    begin
      RxStartFrm_d <= #1 1'b0;
      RxStartFrm   <= #1 1'b0;
    end
  else
    begin
      RxStartFrm_d <= #1 GenerateRxStartFrm;
      RxStartFrm   <= #1 RxStartFrm_d;
    end
end


assign GenerateRxEndFrm = StateData[0] & (~MRxDV & ByteCntGreat2 | ByteCntMaxFrame);
assign DribbleRxEndFrm  = StateData[1] &  ~MRxDV & ByteCntGreat2;


always @ (posedge MRxClk /* or posedge Reset*/)
begin
  if(Reset)
    begin
      RxEndFrm_d <= #1 1'b0;
      RxEndFrm   <= #1 1'b0;
    end
  else
    begin
      RxEndFrm_d <= #1 GenerateRxEndFrm;
      RxEndFrm   <= #1 RxEndFrm_d | DribbleRxEndFrm;
    end
end


endmodule
