//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006-2007  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC
module eth_macrxtx(/*AUTOARG*/
   // Outputs
   mtxerr_pad_o, mtxen_pad_o, WillTransmit, WillSendControlFrame,
   VCEGAR_StatePreamble, VCEGAR_StatePAD, VCEGAR_StateJam_q,
   VCEGAR_StateJam, VCEGAR_StateIdle, VCEGAR_StateIPG,
   VCEGAR_StateFCS, VCEGAR_StateDefer, VCEGAR_StateData_1,
   VCEGAR_StateData_0, VCEGAR_StateBackOff, TypeLengthOK, TxUsedData,
   TxRetry, TxDone, TxDataOut_7, TxDataOut_6, TxDataOut_5,
   TxDataOut_4, TxDataOut_3, TxDataOut_2, TxDataOut_1, TxDataOut_0,
   TxCtrlEndFrm, TxAbort, StateData_1, StateData_0, ShortFrame,
   SetPauseTimer, RxStateData_1, RxStateData_0, RxLateCollision,
   RxData_7, RxData_6, RxData_5, RxData_4, RxData_3, RxData_2,
   RxData_1, RxData_0, RxAbort, RetryLimit, RetryCnt_3, RetryCnt_2,
   RetryCnt_1, RetryCnt_0, RetryCntLatched_3, RetryCntLatched_2,
   RetryCntLatched_1, RetryCntLatched_0, ResetCollision,
   ReceivedPauseFrmWAddr, ReceivedPauseFrm, ReceivedPacketTooBig,
   MTxD_3, MTxD_2, MTxD_1, MTxD_0, LoadRxStatus, LateCollLatched,
   LatchedMRxErr, LatchedCrcError, InvalidSymbol, DribbleNibble,
   DeferLatched, CarrierSenseLost, ByteCnt_9, ByteCnt_8, ByteCnt_7,
   ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_15,
   ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10,
   ByteCnt_1, ByteCnt_0, AddressMiss, VCEGAR_TxAbortIn,
   // Inputs
   r_TxFlow, r_RxFlow, r_RecSmall, r_Pro, r_PassAll, r_NoBckof, r_IFG,
   r_HugEn, r_FullD, r_ExDfrEn, r_DlyCrcEn, r_Bro, mrx_clk_pad_i,
   mcoll_pad_i, TxUnderRun, TxStartFrm, TxEndFrm, TxCarrierSense,
   Transmitting, TPauseRq, RxStatusWriteLatched_sync2,
   RstDeferLatched, Collision, CarrierSense_Tx2, r_MinFL_15,
   r_MinFL_14, r_MinFL_13, r_MinFL_12, r_MinFL_11, r_MinFL_10,
   r_MinFL_9, r_MinFL_8, r_MinFL_7, r_MinFL_6, r_MinFL_5, r_MinFL_4,
   r_MinFL_3, r_MinFL_2, r_MinFL_1, r_MinFL_0, r_MaxFL_15, r_MaxFL_14,
   r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9,
   r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5, r_MaxFL_4, r_MaxFL_3,
   r_MaxFL_2, r_MaxFL_1, r_MaxFL_0, r_MAC_47, r_MAC_46, r_MAC_45,
   r_MAC_44, r_MAC_43, r_MAC_42, r_MAC_41, r_MAC_40, r_MAC_39,
   r_MAC_38, r_MAC_37, r_MAC_36, r_MAC_35, r_MAC_34, r_MAC_33,
   r_MAC_32, r_MAC_31, r_MAC_30, r_MAC_29, r_MAC_28, r_MAC_27,
   r_MAC_26, r_MAC_25, r_MAC_24, r_MAC_23, r_MAC_22, r_MAC_21,
   r_MAC_20, r_MAC_19, r_MAC_18, r_MAC_17, r_MAC_16, r_MAC_15,
   r_MAC_14, r_MAC_13, r_MAC_12, r_MAC_11, r_MAC_10, r_MAC_9, r_MAC_8,
   r_MAC_7, r_MAC_6, r_MAC_5, r_MAC_4, r_MAC_3, r_MAC_2, r_MAC_1,
   r_MAC_0, r_HASH0_31, r_HASH0_30, r_HASH0_29, r_HASH0_28,
   r_HASH0_27, r_HASH0_26, r_HASH0_25, r_HASH0_24, r_HASH0_23,
   r_HASH0_22, r_HASH0_21, r_HASH0_20, r_HASH0_19, r_HASH0_18,
   r_HASH0_17, r_HASH0_16, r_HASH0_15, r_HASH0_14, r_HASH0_13,
   r_HASH0_12, r_HASH0_11, r_HASH0_10, r_HASH0_9, r_HASH0_8,
   r_HASH0_7, r_HASH0_6, r_HASH0_5, r_HASH0_4, r_HASH0_3, r_HASH0_2,
   r_HASH0_1, r_HASH0_0, r_HASH1_31, r_HASH1_30, r_HASH1_29,
   r_HASH1_28, r_HASH1_27, r_HASH1_26, r_HASH1_25, r_HASH1_24,
   r_HASH1_23, r_HASH1_22, r_HASH1_21, r_HASH1_20, r_HASH1_19,
   r_HASH1_18, r_HASH1_17, r_HASH1_16, r_HASH1_15, r_HASH1_14,
   r_HASH1_13, r_HASH1_12, r_HASH1_11, r_HASH1_10, r_HASH1_9,
   r_HASH1_8, r_HASH1_7, r_HASH1_6, r_HASH1_5, r_HASH1_4, r_HASH1_3,
   r_HASH1_2, r_HASH1_1, r_HASH1_0, r_TxPauseTV_15, r_TxPauseTV_14,
   r_TxPauseTV_13, r_TxPauseTV_12, r_TxPauseTV_11, r_TxPauseTV_10,
   r_TxPauseTV_9, r_TxPauseTV_8, r_TxPauseTV_7, r_TxPauseTV_6,
   r_TxPauseTV_5, r_TxPauseTV_4, r_TxPauseTV_3, r_TxPauseTV_2,
   r_TxPauseTV_1, r_TxPauseTV_0, r_IPGT, r_IPGR1, r_IPGR2,
   r_CollValid_5, r_CollValid_4, r_CollValid_3, r_CollValid_2,
   r_CollValid_1, r_CollValid_0, r_MaxRet_3, r_MaxRet_2, r_MaxRet_1,
   r_MaxRet_0, mrxdv_pad_i, mrxerr_pad_i, RxEnSync, mrxd_pad_i, r_Pad,
   PerPacketPad, r_CrcEn, PerPacketCrcEn, TxData
		   ,Broadcast, CrcHashGood
   );

   //FMP_VC  This file is based on the eth_top.v, which is the top module of 
   //FMP_VC  the ETHERNET MAC core available at opencores.org
   //FMP_VC  Several units were removed, only essential units to the Ethernet
   //FMP_VC  protocol were preserved and re-wired accordingly.
   
   /*AUTOINPUT*/
   // Beginning of automatic inputs (from unused autoinst inputs)
   input		CarrierSense_Tx2;	// To macstatus1 of eth_macstatus.v
   input		Collision;		// To txethmac1 of eth_txethmac.v
   input		RstDeferLatched;	// To macstatus1 of eth_macstatus.v
   input		RxStatusWriteLatched_sync2;// To maccontrol1 of eth_maccontrol.v
   input		TPauseRq;		// To maccontrol1 of eth_maccontrol.v
   input		Transmitting;		// To rxethmac1 of eth_rxethmac.v, ...
   input		TxCarrierSense;		// To txethmac1 of eth_txethmac.v
   input		TxEndFrm;		// To maccontrol1 of eth_maccontrol.v
   input		TxStartFrm;		// To maccontrol1 of eth_maccontrol.v
   input		TxUnderRun;		// To txethmac1 of eth_txethmac.v
   input		mcoll_pad_i;		// To macstatus1 of eth_macstatus.v
   input		mrx_clk_pad_i;		// To maccontrol1 of eth_maccontrol.v, ...
   input		r_Bro;			// To rxethmac1 of eth_rxethmac.v
   input		r_DlyCrcEn;		// To maccontrol1 of eth_maccontrol.v, ...
   input		r_ExDfrEn;		// To txethmac1 of eth_txethmac.v
   input		r_FullD;		// To macstatus1 of eth_macstatus.v, ...
   input		r_HugEn;		// To rxethmac1 of eth_rxethmac.v, ...
   input		r_IFG;			// To rxethmac1 of eth_rxethmac.v
   input		r_NoBckof;		// To txethmac1 of eth_txethmac.v
   input		r_PassAll;		// To maccontrol1 of eth_maccontrol.v, ...
   input		r_Pro;			// To rxethmac1 of eth_rxethmac.v
   input		r_RecSmall;		// To macstatus1 of eth_macstatus.v
   input		r_RxFlow;		// To maccontrol1 of eth_maccontrol.v
   input		r_TxFlow;		// To maccontrol1 of eth_maccontrol.v
   // End of automatics
   /*AUTOOUTPUT*/
   // Beginning of automatic outputs (from unused autoinst outputs)
   output		AddressMiss;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_0;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_1;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_10;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_11;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_12;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_13;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_14;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_15;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_2;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_3;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_4;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_5;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_6;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_7;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_8;		// From rxethmac1 of eth_rxethmac.v
   output		ByteCnt_9;		// From rxethmac1 of eth_rxethmac.v
   output		CarrierSenseLost;	// From macstatus1 of eth_macstatus.v
   output		DeferLatched;		// From macstatus1 of eth_macstatus.v
   output		DribbleNibble;		// From macstatus1 of eth_macstatus.v
   output		InvalidSymbol;		// From macstatus1 of eth_macstatus.v
   output		LatchedCrcError;	// From macstatus1 of eth_macstatus.v
   output		LatchedMRxErr;		// From macstatus1 of eth_macstatus.v
   output		LateCollLatched;	// From macstatus1 of eth_macstatus.v
   output		LoadRxStatus;		// From macstatus1 of eth_macstatus.v
   output		MTxD_0;			// From txethmac1 of eth_txethmac.v
   output		MTxD_1;			// From txethmac1 of eth_txethmac.v
   output		MTxD_2;			// From txethmac1 of eth_txethmac.v
   output		MTxD_3;			// From txethmac1 of eth_txethmac.v
   output		ReceivedPacketTooBig;	// From macstatus1 of eth_macstatus.v
   output		ReceivedPauseFrm;	// From maccontrol1 of eth_maccontrol.v
   output		ReceivedPauseFrmWAddr;	// From maccontrol1 of eth_maccontrol.v
   output		ResetCollision;		// From txethmac1 of eth_txethmac.v
   output		RetryCntLatched_0;	// From macstatus1 of eth_macstatus.v
   output		RetryCntLatched_1;	// From macstatus1 of eth_macstatus.v
   output		RetryCntLatched_2;	// From macstatus1 of eth_macstatus.v
   output		RetryCntLatched_3;	// From macstatus1 of eth_macstatus.v
   output		RetryCnt_0;		// From txethmac1 of eth_txethmac.v
   output		RetryCnt_1;		// From txethmac1 of eth_txethmac.v
   output		RetryCnt_2;		// From txethmac1 of eth_txethmac.v
   output		RetryCnt_3;		// From txethmac1 of eth_txethmac.v
   output		RetryLimit;		// From macstatus1 of eth_macstatus.v
   output		RxAbort;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_0;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_1;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_2;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_3;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_4;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_5;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_6;		// From rxethmac1 of eth_rxethmac.v
   output		RxData_7;		// From rxethmac1 of eth_rxethmac.v
   output		RxLateCollision;	// From macstatus1 of eth_macstatus.v
   output		RxStateData_0;		// From rxethmac1 of eth_rxethmac.v
   output		RxStateData_1;		// From rxethmac1 of eth_rxethmac.v
   output		SetPauseTimer;		// From maccontrol1 of eth_maccontrol.v
   output		ShortFrame;		// From macstatus1 of eth_macstatus.v
   output		StateData_0;		// From txethmac1 of eth_txethmac.v
   output		StateData_1;		// From txethmac1 of eth_txethmac.v
   output		TxAbort;		// From maccontrol1 of eth_maccontrol.v
   output		TxCtrlEndFrm;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_0;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_1;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_2;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_3;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_4;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_5;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_6;		// From maccontrol1 of eth_maccontrol.v
   output		TxDataOut_7;		// From maccontrol1 of eth_maccontrol.v
   output		TxDone;			// From maccontrol1 of eth_maccontrol.v
   output		TxRetry;		// From txethmac1 of eth_txethmac.v
   output		TxUsedData;		// From maccontrol1 of eth_maccontrol.v
   output		TypeLengthOK;		// From maccontrol1 of eth_maccontrol.v
   output		VCEGAR_StateBackOff;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateData_0;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateData_1;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateDefer;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateFCS;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateIPG;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateIdle;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateJam;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StateJam_q;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StatePAD;	// From txethmac1 of eth_txethmac.v
   output		VCEGAR_StatePreamble;	// From txethmac1 of eth_txethmac.v
   output		WillSendControlFrame;	// From maccontrol1 of eth_maccontrol.v
   output		WillTransmit;		// From txethmac1 of eth_txethmac.v
   output		mtxen_pad_o;		// From txethmac1 of eth_txethmac.v
   output		mtxerr_pad_o;		// From txethmac1 of eth_txethmac.v
   // End of automatics

//FLAVIO FOR VCEGAR
   output 		Broadcast;   
   output 		CrcHashGood;
   
   
   input 	r_MinFL_15, r_MinFL_14, r_MinFL_13, r_MinFL_12, r_MinFL_11, r_MinFL_10, r_MinFL_9, r_MinFL_8, r_MinFL_7, r_MinFL_6, r_MinFL_5,
		r_MinFL_4, r_MinFL_3, r_MinFL_2, r_MinFL_1, r_MinFL_0;
               
   input 	r_MaxFL_15, r_MaxFL_14, r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9, r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5,
		r_MaxFL_4, r_MaxFL_3, r_MaxFL_2, r_MaxFL_1, r_MaxFL_0;

   input 	r_MAC_47, r_MAC_46, r_MAC_45, r_MAC_44, r_MAC_43, r_MAC_42, r_MAC_41, r_MAC_40, r_MAC_39, r_MAC_38, r_MAC_37, r_MAC_36, r_MAC_35, 
		r_MAC_34, r_MAC_33, r_MAC_32, r_MAC_31, r_MAC_30, r_MAC_29, r_MAC_28, r_MAC_27, r_MAC_26, r_MAC_25, r_MAC_24, r_MAC_23, r_MAC_22, 
		r_MAC_21, r_MAC_20, r_MAC_19, r_MAC_18, r_MAC_17, r_MAC_16, r_MAC_15, r_MAC_14, r_MAC_13, r_MAC_12, r_MAC_11, r_MAC_10, r_MAC_9, 
		r_MAC_8, r_MAC_7, r_MAC_6, r_MAC_5, r_MAC_4, r_MAC_3, r_MAC_2, r_MAC_1, r_MAC_0;
   
   input 	r_HASH0_31, r_HASH0_30, r_HASH0_29, r_HASH0_28, r_HASH0_27, r_HASH0_26, r_HASH0_25, r_HASH0_24, r_HASH0_23, r_HASH0_22, r_HASH0_21, 
		r_HASH0_20, r_HASH0_19, r_HASH0_18, r_HASH0_17, r_HASH0_16, r_HASH0_15, r_HASH0_14, r_HASH0_13, r_HASH0_12, r_HASH0_11, r_HASH0_10, 
		r_HASH0_9, r_HASH0_8, r_HASH0_7, r_HASH0_6, r_HASH0_5, r_HASH0_4, r_HASH0_3, r_HASH0_2, r_HASH0_1, r_HASH0_0;
    
   input 	r_HASH1_31, r_HASH1_30, r_HASH1_29, r_HASH1_28, r_HASH1_27, r_HASH1_26, r_HASH1_25, r_HASH1_24, r_HASH1_23, r_HASH1_22, r_HASH1_21, 
		r_HASH1_20, r_HASH1_19, r_HASH1_18, r_HASH1_17, r_HASH1_16, r_HASH1_15, r_HASH1_14, r_HASH1_13, r_HASH1_12, r_HASH1_11, r_HASH1_10, 
		r_HASH1_9, r_HASH1_8, r_HASH1_7, r_HASH1_6, r_HASH1_5, r_HASH1_4, r_HASH1_3, r_HASH1_2, r_HASH1_1, r_HASH1_0;

   input 	r_TxPauseTV_15, r_TxPauseTV_14, r_TxPauseTV_13, r_TxPauseTV_12, r_TxPauseTV_11, r_TxPauseTV_10, r_TxPauseTV_9, r_TxPauseTV_8, 
		r_TxPauseTV_7, r_TxPauseTV_6, r_TxPauseTV_5, r_TxPauseTV_4, r_TxPauseTV_3, r_TxPauseTV_2, r_TxPauseTV_1, r_TxPauseTV_0;
   
//   input 	r_IPGT_6,r_IPGT_5, r_IPGT_4, r_IPGT_3, r_IPGT_2, r_IPGT_1, r_IPGT_0;
   input [6:0]	r_IPGT;
   
 //  input 	r_IPGR1_6, r_IPGR1_5, r_IPGR1_4, r_IPGR1_3, r_IPGR1_2, r_IPGR1_1, r_IPGR1_0;
   input [6:0] 	r_IPGR1;
          
 //  input 	r_IPGR2_6, r_IPGR2_5, r_IPGR2_4, r_IPGR2_3, r_IPGR2_2, r_IPGR2_1, r_IPGR2_0;
   input [6:0] 	r_IPGR2;
       
   input 	r_CollValid_5, r_CollValid_4, r_CollValid_3, r_CollValid_2, r_CollValid_1, r_CollValid_0;
   
   input 	r_MaxRet_3, r_MaxRet_2, r_MaxRet_1, r_MaxRet_0;
   
   input 	mrxdv_pad_i;   // Receive data valid (from PHY)
   input 	mrxerr_pad_i;  // Receive data error (from PHY)
   input 	RxEnSync;
   input [3:0] 	mrxd_pad_i;    // Receive nibble (from PHY)
   input 	r_Pad, PerPacketPad;   
   input 	r_CrcEn, PerPacketCrcEn;
   
   input [7:0] 	TxData;




   output 	VCEGAR_TxAbortIn;

   wire 	VCEGAR_TxAbortIn = TxAbortIn;
   





   
   /////////// This is vcegar setup
   wire		mtx_clk_pad_i = mrx_clk_pad_i;  // To maccontrol1 of eth_maccontrol.v, ...
   wire		wb_rst_i = 1'b0;		// To rxethmac1 of eth_rxethmac.v, ...
   // vcegar complains about "canonicalize expects expression of Boolean type" for the inputs MRxD_Lb
   wire 		r_LoopBck  = 1'b0;
   
   ////////////////////////////////

    
//FLAVIO FOR VCEGAR
   
   wire 	maccontrol1_PadIn =  r_Pad | PerPacketPad;
   wire 	maccontrol1_CrcEnIn =  r_CrcEn | PerPacketCrcEn;
   
   wire [7:0] 	TxDataOut = {TxDataOut_7,TxDataOut_6,TxDataOut_5,TxDataOut_4,TxDataOut_3,TxDataOut_2,TxDataOut_1,TxDataOut_0};
   wire 	RxData_0, RxData_1, RxData_2, RxData_3,
		RxData_4, RxData_5, RxData_6, RxData_7;
   
   wire 	TxData_7 = TxData[7];
   wire 	TxData_6 = TxData[6];
   wire 	TxData_5 = TxData[5];
   wire 	TxData_4 = TxData[4];
   wire 	TxData_3 = TxData[3];
   wire 	TxData_2 = TxData[2];
   wire 	TxData_1 = TxData[1];
   wire 	TxData_0 = TxData[0];

   wire 	MTxD_3, MTxD_2, MTxD_1, MTxD_0;

   //FLAVIO FOR VCEGAR
   
   // Muxed MII receive data valid
   wire 	MRxDV_Lb = /*r_LoopBck? mtxen_pad_o : */mrxdv_pad_i & RxEnSync;
   
   // Muxed MII Receive Error
   wire 	MRxErr_Lb = /*r_LoopBck? mtxerr_pad_o :*/ mrxerr_pad_i & RxEnSync;
   
   // Muxed MII Receive Data
   wire MRxD_Lb_3 =/* r_LoopBck ? MTxD_3  :*/ mrxd_pad_i[3];
   wire MRxD_Lb_2 =/*  r_LoopBck ? MTxD_2 :*/ mrxd_pad_i[2];
   wire MRxD_Lb_1 =/*  r_LoopBck ? MTxD_1 :*/ mrxd_pad_i[1];
   wire MRxD_Lb_0 =/*  r_LoopBck ? MTxD_0 :*/ mrxd_pad_i[0];
   
   


// Connecting MACControl

   /* 
    eth_maccontrol AUTO_TEMPLATE(
    .MTxClk(mtx_clk_pad_i),
    .TPauseRq(TPauseRq), 
    .TxPauseTV({r_TxPauseTV_15, r_TxPauseTV_14, r_TxPauseTV_13, r_TxPauseTV_12, r_TxPauseTV_11, r_TxPauseTV_10, r_TxPauseTV_9, r_TxPauseTV_8, r_TxPauseTV_7, r_TxPauseTV_6, r_TxPauseTV_5, r_TxPauseTV_4, r_TxPauseTV_3, r_TxPauseTV_2, r_TxPauseTV_1, r_TxPauseTV_0}),                      
    .TxDataIn({TxData_7, TxData_6, TxData_5, TxData_4, TxData_3, TxData_2, TxData_1, TxData_0}), 
    .TxStartFrmIn(TxStartFrm),
    .TxEndFrmIn(TxEndFrm), 
    .TxUsedDataIn(TxUsedDataIn), 
    .TxDoneIn(TxDoneIn), 
    .TxAbortIn(TxAbortIn),      
    .MRxClk(mrx_clk_pad_i), 
    .RxData({RxData_7, RxData_6, RxData_5, RxData_4, RxData_3, RxData_2, RxData_1, RxData_0}),            
    .RxValid(RxValid), 
    .RxStartFrm(RxStartFrm),     
    .RxEndFrm(RxEndFrm),
    .ReceiveEnd(ReceiveEnd),     
    .ReceivedPacketGood(ReceivedPacketGood),
    .TxFlow(r_TxFlow),
    .RxFlow(r_RxFlow), 
    .DlyCrcEn(r_DlyCrcEn),
    .MAC({r_MAC_47, r_MAC_46, r_MAC_45, r_MAC_44, r_MAC_43, r_MAC_42, r_MAC_41, r_MAC_40, r_MAC_39, r_MAC_38, r_MAC_37, r_MAC_36, r_MAC_35, r_MAC_34, r_MAC_33, r_MAC_32, r_MAC_31, r_MAC_30, r_MAC_29, r_MAC_28, r_MAC_27, r_MAC_26, r_MAC_25, r_MAC_24, r_MAC_23, r_MAC_22, r_MAC_21, r_MAC_20, r_MAC_19, r_MAC_18, r_MAC_17, r_MAC_16, r_MAC_15, r_MAC_14, r_MAC_13, r_MAC_12, r_MAC_11, r_MAC_10, r_MAC_9, r_MAC_8, r_MAC_7, r_MAC_6, r_MAC_5, r_MAC_4, r_MAC_3, r_MAC_2, r_MAC_1, r_MAC_0}),
    .PadIn(maccontrol1_PadIn), 
    .PadOut(PadOut),     
    .CrcEnIn(maccontrol1_CrcEnIn), 
    .CrcEnOut(CrcEnOut),  
    .TxReset(wb_rst_i), 
    .RxReset(wb_rst_i),     
    .ReceivedLengthOK(ReceivedLengthOK),
    .TxDataOut(TxDataOut), 
    .TxStartFrmOut(TxStartFrmOut), 
    .TxEndFrmOut(TxEndFrmOut),  
    .TxUsedDataOut(TxUsedData), 
    .TxDoneOut(TxDone), 
    .TxAbortOut(TxAbort), 
    .WillSendControlFrame(WillSendControlFrame),
    .TxCtrlEndFrm(TxCtrlEndFrm), 
    .ReceivedPauseFrm(ReceivedPauseFrm),
    .ControlFrmAddressOK(ControlFrmAddressOK),
    .SetPauseTimer(SetPauseTimer),
    .RxStatusWriteLatched_sync2(RxStatusWriteLatched_sync2), 
    .r_PassAll(r_PassAll),
    );*/
   
eth_maccontrol maccontrol1
(/*AUTOINST*/
 // Outputs
 .TxDataOut_7				(TxDataOut_7),
 .TxDataOut_6				(TxDataOut_6),
 .TxDataOut_5				(TxDataOut_5),
 .TxDataOut_4				(TxDataOut_4),
 .TxDataOut_3				(TxDataOut_3),
 .TxDataOut_2				(TxDataOut_2),
 .TxDataOut_1				(TxDataOut_1),
 .TxDataOut_0				(TxDataOut_0),
 .TxStartFrmOut				(TxStartFrmOut),	 // Templated
 .TxEndFrmOut				(TxEndFrmOut),		 // Templated
 .TxDoneOut				(TxDone),		 // Templated
 .TxAbortOut				(TxAbort),		 // Templated
 .TxUsedDataOut				(TxUsedData),		 // Templated
 .PadOut				(PadOut),		 // Templated
 .CrcEnOut				(CrcEnOut),		 // Templated
 .WillSendControlFrame			(WillSendControlFrame),	 // Templated
 .TxCtrlEndFrm				(TxCtrlEndFrm),		 // Templated
 .ReceivedPauseFrm			(ReceivedPauseFrm),	 // Templated
 .ControlFrmAddressOK			(ControlFrmAddressOK),	 // Templated
 .SetPauseTimer				(SetPauseTimer),	 // Templated
 .ReceivedPauseFrmWAddr			(ReceivedPauseFrmWAddr),
 .TypeLengthOK				(TypeLengthOK),
 // Inputs
 .MTxClk				(mtx_clk_pad_i),	 // Templated
 .MRxClk				(mrx_clk_pad_i),	 // Templated
 .TxReset				(wb_rst_i),		 // Templated
 .RxReset				(wb_rst_i),		 // Templated
 .TPauseRq				(TPauseRq),		 // Templated
 .TxDataIn				({TxData_7, TxData_6, TxData_5, TxData_4, TxData_3, TxData_2, TxData_1, TxData_0}), // Templated
 .TxStartFrmIn				(TxStartFrm),		 // Templated
 .TxUsedDataIn				(TxUsedDataIn),		 // Templated
 .TxEndFrmIn				(TxEndFrm),		 // Templated
 .TxDoneIn				(TxDoneIn),		 // Templated
 .TxAbortIn				(TxAbortIn),		 // Templated
 .PadIn					(maccontrol1_PadIn),	 // Templated
 .CrcEnIn				(maccontrol1_CrcEnIn),	 // Templated
 .RxData				({RxData_7, RxData_6, RxData_5, RxData_4, RxData_3, RxData_2, RxData_1, RxData_0}), // Templated
 .RxValid				(RxValid),		 // Templated
 .RxStartFrm				(RxStartFrm),		 // Templated
 .RxEndFrm				(RxEndFrm),		 // Templated
 .ReceiveEnd				(ReceiveEnd),		 // Templated
 .ReceivedPacketGood			(ReceivedPacketGood),	 // Templated
 .ReceivedLengthOK			(ReceivedLengthOK),	 // Templated
 .TxFlow				(r_TxFlow),		 // Templated
 .RxFlow				(r_RxFlow),		 // Templated
 .DlyCrcEn				(r_DlyCrcEn),		 // Templated
 .TxPauseTV				({r_TxPauseTV_15, r_TxPauseTV_14, r_TxPauseTV_13, r_TxPauseTV_12, r_TxPauseTV_11, r_TxPauseTV_10, r_TxPauseTV_9, r_TxPauseTV_8, r_TxPauseTV_7, r_TxPauseTV_6, r_TxPauseTV_5, r_TxPauseTV_4, r_TxPauseTV_3, r_TxPauseTV_2, r_TxPauseTV_1, r_TxPauseTV_0}), // Templated
 .MAC					({r_MAC_47, r_MAC_46, r_MAC_45, r_MAC_44, r_MAC_43, r_MAC_42, r_MAC_41, r_MAC_40, r_MAC_39, r_MAC_38, r_MAC_37, r_MAC_36, r_MAC_35, r_MAC_34, r_MAC_33, r_MAC_32, r_MAC_31, r_MAC_30, r_MAC_29, r_MAC_28, r_MAC_27, r_MAC_26, r_MAC_25, r_MAC_24, r_MAC_23, r_MAC_22, r_MAC_21, r_MAC_20, r_MAC_19, r_MAC_18, r_MAC_17, r_MAC_16, r_MAC_15, r_MAC_14, r_MAC_13, r_MAC_12, r_MAC_11, r_MAC_10, r_MAC_9, r_MAC_8, r_MAC_7, r_MAC_6, r_MAC_5, r_MAC_4, r_MAC_3, r_MAC_2, r_MAC_1, r_MAC_0}), // Templated
 .RxStatusWriteLatched_sync2		(RxStatusWriteLatched_sync2), // Templated
 .r_PassAll				(r_PassAll));		 // Templated

   /* eth_rxethmac AUTO_TEMPLATE
    (
    .MRxClk(mrx_clk_pad_i),
    .MRxDV(MRxDV_Lb), 
    .MRxD({MRxD_Lb_3,MRxD_Lb_2,MRxD_Lb_1,MRxD_Lb_0}),
    .Transmitting(Transmitting),    
    .HugEn(r_HugEn),  
    .DlyCrcEn(r_DlyCrcEn), 
    .MaxFL({r_MaxFL_15, r_MaxFL_14, r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9, r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5, r_MaxFL_4, r_MaxFL_3, r_MaxFL_2, r_MaxFL_1, r_MaxFL_0}), 
    .r_IFG(r_IFG),                        
    .Reset(wb_rst_i),
    .RxData(RxData),     
    .RxValid(RxValid),                    
    .RxStartFrm(RxStartFrm), 
    .RxEndFrm(RxEndFrm),  
    .ByteCnt(RxByteCnt), 
    .ByteCntEq0(RxByteCntEq0),   
    .ByteCntGreat2(RxByteCntGreat2),
    .ByteCntMaxFrame(RxByteCntMaxFrame), 
    .CrcError(RxCrcError),    
    .StateIdle(RxStateIdle),
    .StatePreamble(RxStatePreamble), 
    .StateSFD(RxStateSFD),  
    .StateData_1(RxStateData_1),
    .StateData_0(RxStateData_0),
    .MAC({r_MAC_47, r_MAC_46, r_MAC_45, r_MAC_44, r_MAC_43, r_MAC_42, r_MAC_41, r_MAC_40, r_MAC_39, r_MAC_38, r_MAC_37, r_MAC_36, r_MAC_35, r_MAC_34, r_MAC_33, r_MAC_32, r_MAC_31, r_MAC_30, r_MAC_29, r_MAC_28, r_MAC_27, r_MAC_26, r_MAC_25, r_MAC_24, r_MAC_23, r_MAC_22, r_MAC_21, r_MAC_20, r_MAC_19, r_MAC_18, r_MAC_17, r_MAC_16, r_MAC_15, r_MAC_14, r_MAC_13, r_MAC_12, r_MAC_11, r_MAC_10, r_MAC_9, r_MAC_8, r_MAC_7, r_MAC_6, r_MAC_5, r_MAC_4, r_MAC_3, r_MAC_2, r_MAC_1, r_MAC_0}),
    .r_Pro(r_Pro),
    .r_Bro(r_Bro),
    .r_HASH0({r_HASH0_31, r_HASH0_30, r_HASH0_29, r_HASH0_28, r_HASH0_27, r_HASH0_26, r_HASH0_25, r_HASH0_24, r_HASH0_23, r_HASH0_22, r_HASH0_21, r_HASH0_20, r_HASH0_19, r_HASH0_18, r_HASH0_17, r_HASH0_16, r_HASH0_15, r_HASH0_14, r_HASH0_13, r_HASH0_12, r_HASH0_11, r_HASH0_10, r_HASH0_9, r_HASH0_8, r_HASH0_7, r_HASH0_6, r_HASH0_5, r_HASH0_4, r_HASH0_3, r_HASH0_2, r_HASH0_1, r_HASH0_0}),    
    .r_HASH1({r_HASH1_31, r_HASH1_30, r_HASH1_29, r_HASH1_28, r_HASH1_27, r_HASH1_26, r_HASH1_25, r_HASH1_24, r_HASH1_23, r_HASH1_22, r_HASH1_21, r_HASH1_20, r_HASH1_19, r_HASH1_18, r_HASH1_17, r_HASH1_16, r_HASH1_15, r_HASH1_14, r_HASH1_13, r_HASH1_12, r_HASH1_11, r_HASH1_10, r_HASH1_9, r_HASH1_8, r_HASH1_7, r_HASH1_6, r_HASH1_5, r_HASH1_4, r_HASH1_3, r_HASH1_2, r_HASH1_1, r_HASH1_0}),
    .RxAbort(RxAbort), 
    .AddressMiss(AddressMiss), 
    .PassAll(r_PassAll),
    .ControlFrmAddressOK(ControlFrmAddressOK),
    ); */

// Connecting RxEthMAC
eth_rxethmac rxethmac1
(/*AUTOINST*/
 // Outputs
 .Broadcast (Broadcast), 
 .CrcHashGood (CrcHashGood),
 .RxData_0				(RxData_0),
 .RxData_1				(RxData_1),
 .RxData_2				(RxData_2),
 .RxData_3				(RxData_3),
 .RxData_4				(RxData_4),
 .RxData_5				(RxData_5),
 .RxData_6				(RxData_6),
 .RxData_7				(RxData_7),
 .RxValid				(RxValid),		 // Templated
 .RxStartFrm				(RxStartFrm),		 // Templated
 .RxEndFrm				(RxEndFrm),		 // Templated
 .ByteCnt_15				(ByteCnt_15),
 .ByteCnt_14				(ByteCnt_14),
 .ByteCnt_13				(ByteCnt_13),
 .ByteCnt_12				(ByteCnt_12),
 .ByteCnt_11				(ByteCnt_11),
 .ByteCnt_10				(ByteCnt_10),
 .ByteCnt_9				(ByteCnt_9),
 .ByteCnt_8				(ByteCnt_8),
 .ByteCnt_7				(ByteCnt_7),
 .ByteCnt_6				(ByteCnt_6),
 .ByteCnt_5				(ByteCnt_5),
 .ByteCnt_4				(ByteCnt_4),
 .ByteCnt_3				(ByteCnt_3),
 .ByteCnt_2				(ByteCnt_2),
 .ByteCnt_1				(ByteCnt_1),
 .ByteCnt_0				(ByteCnt_0),
 .ByteCntEq0				(RxByteCntEq0),		 // Templated
 .ByteCntGreat2				(RxByteCntGreat2),	 // Templated
 .ByteCntMaxFrame			(RxByteCntMaxFrame),	 // Templated
 .CrcError				(RxCrcError),		 // Templated
 .StateIdle				(RxStateIdle),		 // Templated
 .StatePreamble				(RxStatePreamble),	 // Templated
 .StateSFD				(RxStateSFD),		 // Templated
 .StateData_0				(RxStateData_0),	 // Templated
 .StateData_1				(RxStateData_1),	 // Templated
 .RxAbort				(RxAbort),		 // Templated
 .AddressMiss				(AddressMiss),		 // Templated
 // Inputs
 .MRxClk				(mrx_clk_pad_i),	 // Templated
 .MRxDV					(MRxDV_Lb),		 // Templated
// .MRxD					({MRxD_Lb_3,MRxD_Lb_2,MRxD_Lb_1,MRxD_Lb_0}), // Templated
 .MRxD (mrxd_pad_i[3:0]),
 .Transmitting				(Transmitting),		 // Templated
 .HugEn					(r_HugEn),		 // Templated
 .DlyCrcEn				(r_DlyCrcEn),		 // Templated
 .MaxFL					({r_MaxFL_15, r_MaxFL_14, r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9, r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5, r_MaxFL_4, r_MaxFL_3, r_MaxFL_2, r_MaxFL_1, r_MaxFL_0}), // Templated
 .r_IFG					(r_IFG),		 // Templated
 .Reset					(wb_rst_i),		 // Templated
 .MAC					({r_MAC_47, r_MAC_46, r_MAC_45, r_MAC_44, r_MAC_43, r_MAC_42, r_MAC_41, r_MAC_40, r_MAC_39, r_MAC_38, r_MAC_37, r_MAC_36, r_MAC_35, r_MAC_34, r_MAC_33, r_MAC_32, r_MAC_31, r_MAC_30, r_MAC_29, r_MAC_28, r_MAC_27, r_MAC_26, r_MAC_25, r_MAC_24, r_MAC_23, r_MAC_22, r_MAC_21, r_MAC_20, r_MAC_19, r_MAC_18, r_MAC_17, r_MAC_16, r_MAC_15, r_MAC_14, r_MAC_13, r_MAC_12, r_MAC_11, r_MAC_10, r_MAC_9, r_MAC_8, r_MAC_7, r_MAC_6, r_MAC_5, r_MAC_4, r_MAC_3, r_MAC_2, r_MAC_1, r_MAC_0}), // Templated
 .r_Bro					(r_Bro),		 // Templated
 .r_Pro					(r_Pro),		 // Templated
 .r_HASH0				({r_HASH0_31, r_HASH0_30, r_HASH0_29, r_HASH0_28, r_HASH0_27, r_HASH0_26, r_HASH0_25, r_HASH0_24, r_HASH0_23, r_HASH0_22, r_HASH0_21, r_HASH0_20, r_HASH0_19, r_HASH0_18, r_HASH0_17, r_HASH0_16, r_HASH0_15, r_HASH0_14, r_HASH0_13, r_HASH0_12, r_HASH0_11, r_HASH0_10, r_HASH0_9, r_HASH0_8, r_HASH0_7, r_HASH0_6, r_HASH0_5, r_HASH0_4, r_HASH0_3, r_HASH0_2, r_HASH0_1, r_HASH0_0}), // Templated
 .r_HASH1				({r_HASH1_31, r_HASH1_30, r_HASH1_29, r_HASH1_28, r_HASH1_27, r_HASH1_26, r_HASH1_25, r_HASH1_24, r_HASH1_23, r_HASH1_22, r_HASH1_21, r_HASH1_20, r_HASH1_19, r_HASH1_18, r_HASH1_17, r_HASH1_16, r_HASH1_15, r_HASH1_14, r_HASH1_13, r_HASH1_12, r_HASH1_11, r_HASH1_10, r_HASH1_9, r_HASH1_8, r_HASH1_7, r_HASH1_6, r_HASH1_5, r_HASH1_4, r_HASH1_3, r_HASH1_2, r_HASH1_1, r_HASH1_0}), // Templated
 .PassAll				(r_PassAll),		 // Templated
 .ControlFrmAddressOK			(ControlFrmAddressOK));	 // Templated

/* eth_macstatus AUTO_TEMPLATE
(
 .MRxClk(mrx_clk_pad_i), 
 .Reset(wb_rst_i),
 .ReceiveEnd(ReceiveEnd),
 .ReceivedPacketGood(ReceivedPacketGood),
 .ReceivedLengthOK(ReceivedLengthOK), 
 .RxCrcError(RxCrcError),
 .MRxErr(MRxErr_Lb),           
 .MRxDV(MRxDV_Lb), 
 .RxStateSFD(RxStateSFD),       
 .RxStateData({RxStateData_1,RxStateData_0}),    
 .RxStatePreamble(RxStatePreamble), 
 .RxStateIdle(RxStateIdle),    
 .Transmitting(Transmitting),   
 .RxByteCnt({ByteCnt_15, ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10, ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0}), 
 .RxByteCntEq0(RxByteCntEq0),   
 .RxByteCntGreat2(RxByteCntGreat2),  
 .RxByteCntMaxFrame(RxByteCntMaxFrame), 
 .InvalidSymbol(InvalidSymbol),
 .MRxD({MRxD_Lb_3,MRxD_Lb_2,MRxD_Lb_1,MRxD_Lb_0}),          
 .LatchedCrcError(LatchedCrcError), 
 .Collision(mcoll_pad_i),
 .CollValid({r_CollValid_5, r_CollValid_4, r_CollValid_3, r_CollValid_2, r_CollValid_1, r_CollValid_0}),  
 .RxLateCollision(RxLateCollision),  
 .r_RecSmall(r_RecSmall),
 .r_MinFL({r_MinFL_15, r_MinFL_14, r_MinFL_13, r_MinFL_12, r_MinFL_11, r_MinFL_10, r_MinFL_9, r_MinFL_8, r_MinFL_7, r_MinFL_6, r_MinFL_5, r_MinFL_4, r_MinFL_3, r_MinFL_2, r_MinFL_1, r_MinFL_0}),        
 .r_MaxFL({r_MaxFL_15, r_MaxFL_14, r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9, r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5, r_MaxFL_4, r_MaxFL_3, r_MaxFL_2, r_MaxFL_1, r_MaxFL_0}),                    
 .ShortFrame(ShortFrame),
 .DribbleNibble(DribbleNibble),  
 .ReceivedPacketTooBig(ReceivedPacketTooBig), 
 .r_HugEn(r_HugEn),
 .LoadRxStatus(LoadRxStatus),  
 .RetryCnt({RetryCnt_3,RetryCnt_2,RetryCnt_1,RetryCnt_0}),                   
 .StartTxDone(StartTxDone),
 .StartTxAbort(StartTxAbort),   
 .RetryCntLatched(RetryCntLatched),      
 .MTxClk(mtx_clk_pad_i),
 .MaxCollisionOccured(MaxCollisionOccured), 
 .RetryLimit(RetryLimit),             
 .LateCollision(LateCollision),
 .LateCollLatched(LateCollLatched),  
 .DeferIndication(DeferIndication),          
 .DeferLatched(DeferLatched),
 .RstDeferLatched(RstDeferLatched), 
 .TxStartFrm(TxStartFrmOut),        
 .StatePreamble(StatePreamble),           
 .StateData({StateData_1,StateData_0}),
 .CarrierSense(CarrierSense_Tx2),   
 .CarrierSenseLost(CarrierSenseLost),      
 .TxUsedData(TxUsedDataIn),
 .LatchedMRxErr(LatchedMRxErr),     
 .Loopback(r_LoopBck),                     
 .r_FullD(r_FullD),
 );*/

// Connecting MacStatus module
eth_macstatus macstatus1 
(/*AUTOINST*/
 // Outputs
 .ReceivedLengthOK			(ReceivedLengthOK),	 // Templated
 .ReceiveEnd				(ReceiveEnd),		 // Templated
 .ReceivedPacketGood			(ReceivedPacketGood),	 // Templated
 .InvalidSymbol				(InvalidSymbol),	 // Templated
 .LatchedCrcError			(LatchedCrcError),	 // Templated
 .RxLateCollision			(RxLateCollision),	 // Templated
 .ShortFrame				(ShortFrame),		 // Templated
 .DribbleNibble				(DribbleNibble),	 // Templated
 .ReceivedPacketTooBig			(ReceivedPacketTooBig),	 // Templated
 .LoadRxStatus				(LoadRxStatus),		 // Templated
 .RetryCntLatched_0			(RetryCntLatched_0),
 .RetryCntLatched_1			(RetryCntLatched_1),
 .RetryCntLatched_2			(RetryCntLatched_2),
 .RetryCntLatched_3			(RetryCntLatched_3),
 .RetryLimit				(RetryLimit),		 // Templated
 .LateCollLatched			(LateCollLatched),	 // Templated
 .DeferLatched				(DeferLatched),		 // Templated
 .CarrierSenseLost			(CarrierSenseLost),	 // Templated
 .LatchedMRxErr				(LatchedMRxErr),	 // Templated
 // Inputs
 .MRxClk				(mrx_clk_pad_i),	 // Templated
 .Reset					(wb_rst_i),		 // Templated
 .RxCrcError				(RxCrcError),		 // Templated
 .MRxErr				(MRxErr_Lb),		 // Templated
 .MRxDV					(MRxDV_Lb),		 // Templated
 .RxStateSFD				(RxStateSFD),		 // Templated
 .RxStateData				({RxStateData_1,RxStateData_0}), // Templated
 .RxStatePreamble			(RxStatePreamble),	 // Templated
 .RxStateIdle				(RxStateIdle),		 // Templated
 .Transmitting				(Transmitting),		 // Templated
 .RxByteCnt				({ByteCnt_15, ByteCnt_14, ByteCnt_13, ByteCnt_12, ByteCnt_11, ByteCnt_10, ByteCnt_9, ByteCnt_8, ByteCnt_7, ByteCnt_6, ByteCnt_5, ByteCnt_4, ByteCnt_3, ByteCnt_2, ByteCnt_1, ByteCnt_0}), // Templated
 .RxByteCntEq0				(RxByteCntEq0),		 // Templated
 .RxByteCntGreat2			(RxByteCntGreat2),	 // Templated
 .RxByteCntMaxFrame			(RxByteCntMaxFrame),	 // Templated
// .MRxD					({MRxD_Lb_3,MRxD_Lb_2,MRxD_Lb_1,MRxD_Lb_0}), // Templated
 .MRxD	 (mrxd_pad_i[3:0]),
 .Collision				(mcoll_pad_i),		 // Templated
 .CollValid				({r_CollValid_5, r_CollValid_4, r_CollValid_3, r_CollValid_2, r_CollValid_1, r_CollValid_0}), // Templated
 .r_RecSmall				(r_RecSmall),		 // Templated
 .r_MinFL				({r_MinFL_15, r_MinFL_14, r_MinFL_13, r_MinFL_12, r_MinFL_11, r_MinFL_10, r_MinFL_9, r_MinFL_8, r_MinFL_7, r_MinFL_6, r_MinFL_5, r_MinFL_4, r_MinFL_3, r_MinFL_2, r_MinFL_1, r_MinFL_0}), // Templated
 .r_MaxFL				({r_MaxFL_15, r_MaxFL_14, r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9, r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5, r_MaxFL_4, r_MaxFL_3, r_MaxFL_2, r_MaxFL_1, r_MaxFL_0}), // Templated
 .r_HugEn				(r_HugEn),		 // Templated
 .StartTxDone				(StartTxDone),		 // Templated
 .StartTxAbort				(StartTxAbort),		 // Templated
 .RetryCnt				({RetryCnt_3,RetryCnt_2,RetryCnt_1,RetryCnt_0}), // Templated
 .MTxClk				(mtx_clk_pad_i),	 // Templated
 .MaxCollisionOccured			(MaxCollisionOccured),	 // Templated
 .LateCollision				(LateCollision),	 // Templated
 .DeferIndication			(DeferIndication),	 // Templated
 .TxStartFrm				(TxStartFrmOut),	 // Templated
 .StatePreamble				(StatePreamble),	 // Templated
 .StateData				({StateData_1,StateData_0}), // Templated
 .CarrierSense				(CarrierSense_Tx2),	 // Templated
 .TxUsedData				(TxUsedDataIn),		 // Templated
 .Loopback				(r_LoopBck),		 // Templated
 .r_FullD				(r_FullD),		 // Templated
 .RstDeferLatched			(RstDeferLatched));	 // Templated


   /* .IPGT({r_IPGT_6,r_IPGT_5, r_IPGT_4, r_IPGT_3, r_IPGT_2, r_IPGT_1, r_IPGT_0}), 
 .IPGR1({r_IPGR1_6, r_IPGR1_5, r_IPGR1_4, r_IPGR1_3, r_IPGR1_2, r_IPGR1_1, r_IPGR1_0}),              
 .IPGR2({r_IPGR2_6, r_IPGR2_5, r_IPGR2_4, r_IPGR2_3, r_IPGR2_2, r_IPGR2_1, r_IPGR2_0}),         
    */
/* eth_txethmac AUTO_TEMPLATE
(
 .MTxClk(mtx_clk_pad_i),   
 .Reset(wb_rst_i),    
 .CarrierSense(TxCarrierSense), 
 .Collision(Collision),    
 .TxData({TxDataOut_7, TxDataOut_6, TxDataOut_5, TxDataOut_4, TxDataOut_3, TxDataOut_2, TxDataOut_1, TxDataOut_0}),  
 .TxStartFrm(TxStartFrmOut), 
 .TxUnderRun(TxUnderRun),    
 .TxEndFrm(TxEndFrmOut),   
 .Pad(PadOut),  
 .MinFL({r_MinFL_15, r_MinFL_14, r_MinFL_13, r_MinFL_12, r_MinFL_11, r_MinFL_10, r_MinFL_9, r_MinFL_8, r_MinFL_7, r_MinFL_6, r_MinFL_5, r_MinFL_4, r_MinFL_3, r_MinFL_2, r_MinFL_1, r_MinFL_0}),               
 .CrcEn(CrcEnOut),           
 .FullD(r_FullD), 
 .HugEn(r_HugEn),
 .DlyCrcEn(r_DlyCrcEn),      
 .IPGT(r_IPGT), 
 .IPGR1(r_IPGR1),              
 .IPGR2(r_IPGR2),         
 .CollValid({r_CollValid_5, r_CollValid_4, r_CollValid_3, r_CollValid_2, r_CollValid_1, r_CollValid_0}), 
 .MaxRet({r_MaxRet_3, r_MaxRet_2, r_MaxRet_1, r_MaxRet_0}),           
 .NoBckof(r_NoBckof),     
 .ExDfrEn(r_ExDfrEn), 
 .MaxFL({r_MaxFL_15, r_MaxFL_14, r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9, r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5, r_MaxFL_4, r_MaxFL_3, r_MaxFL_2, r_MaxFL_1, r_MaxFL_0}),              
 .MTxEn(mtxen_pad_o),       
 .MTxD(mtxd_pad_o),
 .MTxErr(mtxerr_pad_o),          
 .TxUsedData(TxUsedDataIn),    
 .TxDone(TxDoneIn),
 .TxRetry(TxRetry),                
 .TxAbort(TxAbortIn),              
 .WillTransmit(WillTransmit), 
 .ResetCollision(ResetCollision),   
 .RetryCnt(RetryCnt),               
 .StartTxDone(StartTxDone), 
 .StartTxAbort(StartTxAbort),      
 .MaxCollisionOccured(MaxCollisionOccured), 
 .LateCollision(LateCollision),   
 .DeferIndication(DeferIndication), 
 .StatePreamble(StatePreamble),    
 .StateData(StateData),   
); */   
// Connecting TxEthMAC
eth_txethmac txethmac1
(/*AUTOINST*/
 // Outputs
 .VCEGAR_StateIdle			(VCEGAR_StateIdle),
 .VCEGAR_StateIPG			(VCEGAR_StateIPG),
 .VCEGAR_StatePreamble			(VCEGAR_StatePreamble),
 .VCEGAR_StateData_0			(VCEGAR_StateData_0),
 .VCEGAR_StateData_1			(VCEGAR_StateData_1),
 .VCEGAR_StatePAD			(VCEGAR_StatePAD),
 .VCEGAR_StateFCS			(VCEGAR_StateFCS),
 .VCEGAR_StateJam			(VCEGAR_StateJam),
 .VCEGAR_StateJam_q			(VCEGAR_StateJam_q),
 .VCEGAR_StateBackOff			(VCEGAR_StateBackOff),
 .VCEGAR_StateDefer			(VCEGAR_StateDefer),
 .MTxD_0				(MTxD_0),
 .MTxD_1				(MTxD_1),
 .MTxD_2				(MTxD_2),
 .MTxD_3				(MTxD_3),
 .MTxEn					(mtxen_pad_o),		 // Templated
 .MTxErr				(mtxerr_pad_o),		 // Templated
 .TxDone				(TxDoneIn),		 // Templated
 .TxRetry				(TxRetry),		 // Templated
 .TxAbort				(TxAbortIn),		 // Templated
 .TxUsedData				(TxUsedDataIn),		 // Templated
 .WillTransmit				(WillTransmit),		 // Templated
 .ResetCollision			(ResetCollision),	 // Templated
 .RetryCnt_0				(RetryCnt_0),
 .RetryCnt_1				(RetryCnt_1),
 .RetryCnt_2				(RetryCnt_2),
 .RetryCnt_3				(RetryCnt_3),
 .StartTxDone				(StartTxDone),		 // Templated
 .StartTxAbort				(StartTxAbort),		 // Templated
 .MaxCollisionOccured			(MaxCollisionOccured),	 // Templated
 .LateCollision				(LateCollision),	 // Templated
 .DeferIndication			(DeferIndication),	 // Templated
 .StatePreamble				(StatePreamble),	 // Templated
 .StateData_0				(StateData_0),
 .StateData_1				(StateData_1),
 // Inputs
 .MTxClk				(mtx_clk_pad_i),	 // Templated
 .Reset					(wb_rst_i),		 // Templated
 .TxStartFrm				(TxStartFrmOut),	 // Templated
 .TxEndFrm				(TxEndFrmOut),		 // Templated
 .TxUnderRun				(TxUnderRun),		 // Templated
 .TxData				({TxDataOut_7, TxDataOut_6, TxDataOut_5, TxDataOut_4, TxDataOut_3, TxDataOut_2, TxDataOut_1, TxDataOut_0}), // Templated
 .CarrierSense				(TxCarrierSense),	 // Templated
 .Collision				(Collision),		 // Templated
 .Pad					(PadOut),		 // Templated
 .CrcEn					(CrcEnOut),		 // Templated
 .FullD					(r_FullD),		 // Templated
 .HugEn					(r_HugEn),		 // Templated
 .DlyCrcEn				(r_DlyCrcEn),		 // Templated
 .MinFL					({r_MinFL_15, r_MinFL_14, r_MinFL_13, r_MinFL_12, r_MinFL_11, r_MinFL_10, r_MinFL_9, r_MinFL_8, r_MinFL_7, r_MinFL_6, r_MinFL_5, r_MinFL_4, r_MinFL_3, r_MinFL_2, r_MinFL_1, r_MinFL_0}), // Templated
 .MaxFL					({r_MaxFL_15, r_MaxFL_14, r_MaxFL_13, r_MaxFL_12, r_MaxFL_11, r_MaxFL_10, r_MaxFL_9, r_MaxFL_8, r_MaxFL_7, r_MaxFL_6, r_MaxFL_5, r_MaxFL_4, r_MaxFL_3, r_MaxFL_2, r_MaxFL_1, r_MaxFL_0}), // Templated
 .IPGT					(r_IPGT),		 // Templated
 .IPGR1					(r_IPGR1),		 // Templated
 .IPGR2					(r_IPGR2),		 // Templated
 .CollValid				({r_CollValid_5, r_CollValid_4, r_CollValid_3, r_CollValid_2, r_CollValid_1, r_CollValid_0}), // Templated
 .MaxRet				({r_MaxRet_3, r_MaxRet_2, r_MaxRet_1, r_MaxRet_0}), // Templated
 .NoBckof				(r_NoBckof),		 // Templated
 .ExDfrEn				(r_ExDfrEn));		 // Templated

   
endmodule // ethmacrxtx

/*
Local Variables: 
verilog-library-directories:(".")
End: 
*/
