//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006-2007  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC
//////////////////////////////////////////////////////////////////////
////                                                              ////
////  eth_maccontrol.v                                            ////
////                                                              ////
////  This file is part of the Ethernet IP core project           ////
////  http://www.opencores.org/projects/ethmac/                   ////
////                                                              ////
////  Author(s):                                                  ////
////      - Igor Mohor (igorM@opencores.org)                      ////
////                                                              ////
////  All additional information is avaliable in the Readme.txt   ////
////  file.                                                       ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
////                                                              ////
//// Copyright (C) 2001 Authors                                   ////
////                                                              ////
//// This source file may be used and distributed without         ////
//// restriction provided that this copyright statement is not    ////
//// removed from the file and that any derivative work contains  ////
//// the original copyright notice and the associated disclaimer. ////
////                                                              ////
//// This source file is free software; you can redistribute it   ////
//// and/or modify it under the terms of the GNU Lesser General   ////
//// Public License as published by the Free Software Foundation; ////
//// either version 2.1 of the License, or (at your option) any   ////
//// later version.                                               ////
////                                                              ////
//// This source is distributed in the hope that it will be       ////
//// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
//// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
//// PURPOSE.  See the GNU Lesser General Public License for more ////
//// details.                                                     ////
////                                                              ////
//// You should have received a copy of the GNU Lesser General    ////
//// Public License along with this source; if not, download it   ////
//// from http://www.opencores.org/lgpl.shtml                     ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
//
// CVS Revision History
//
// $Log: eth_maccontrol.v,v $
// Revision 1.7  2003/01/22 13:49:26  tadejm
// When control packets were received, they were ignored in some cases.
//
// Revision 1.6  2002/11/22 01:57:06  mohor
// Rx Flow control fixed. CF flag added to the RX buffer descriptor. RxAbort
// synchronized.
//
// Revision 1.5  2002/11/21 00:14:39  mohor
// TxDone and TxAbort changed so they're not propagated to the wishbone
// module when control frame is transmitted.
//
// Revision 1.4  2002/11/19 17:37:32  mohor
// When control frame (PAUSE) was sent, status was written in the
// eth_wishbone module and both TXB and TXC interrupts were set. Fixed.
// Only TXC interrupt is set.
//
// Revision 1.3  2002/01/23 10:28:16  mohor
// Link in the header changed.
//
// Revision 1.2  2001/10/19 08:43:51  mohor
// eth_timescale.v changed to timescale.v This is done because of the
// simulation of the few cores in a one joined project.
//
// Revision 1.1  2001/08/06 14:44:29  mohor
// A define FPGA added to select between Artisan RAM (for ASIC) and Block Ram (For Virtex).
// Include files fixed to contain no path.
// File names and module names changed ta have a eth_ prologue in the name.
// File eth_timescale.v is used to define timescale
// All pin names on the top module are changed to contain _I, _O or _OE at the end.
// Bidirectional signal MDIO is changed to three signals (Mdc_O, Mdi_I, Mdo_O
// and Mdo_OE. The bidirectional signal must be created on the top level. This
// is done due to the ASIC tools.
//
// Revision 1.1  2001/07/30 21:23:42  mohor
// Directory structure changed. Files checked and joind together.
//
// Revision 1.1  2001/07/03 12:51:54  mohor
// Initial release of the MAC Control module.
//
//
//
//


`include "timescale.v"


module eth_maccontrol (/*AUTOARG*/
   // Outputs
   TxDataOut_7, TxDataOut_6, TxDataOut_5, TxDataOut_4, TxDataOut_3,
   TxDataOut_2, TxDataOut_1, TxDataOut_0, TxStartFrmOut, TxEndFrmOut,
   TxDoneOut, TxAbortOut, TxUsedDataOut, PadOut, CrcEnOut,
   WillSendControlFrame, TxCtrlEndFrm, ReceivedPauseFrm,
   ControlFrmAddressOK, SetPauseTimer, ReceivedPauseFrmWAddr,
   TypeLengthOK,
   // Inputs
   MTxClk, MRxClk, TxReset, RxReset, TPauseRq, TxDataIn, TxStartFrmIn,
   TxUsedDataIn, TxEndFrmIn, TxDoneIn, TxAbortIn, PadIn, CrcEnIn,
   RxData, RxValid, RxStartFrm, RxEndFrm, ReceiveEnd,
   ReceivedPacketGood, ReceivedLengthOK, TxFlow, RxFlow, DlyCrcEn,
   TxPauseTV, MAC, RxStatusWriteLatched_sync2, r_PassAll
   );


//FMP_VC_2//parameter   Tp = 1;


input         MTxClk;                   // Transmit clock (from PHY)
input         MRxClk;                   // Receive clock (from PHY)
input         TxReset;                  // Transmit reset
input         RxReset;                  // Receive reset
input         TPauseRq;                 // Transmit control frame (from host)
input   [7:0] TxDataIn;                 // Transmit packet data byte (from host)
input         TxStartFrmIn;             // Transmit packet start frame input (from host)
input         TxUsedDataIn;             // Transmit packet used data (from TxEthMAC)
input         TxEndFrmIn;               // Transmit packet end frame input (from host)
input         TxDoneIn;                 // Transmit packet done (from TxEthMAC)
input         TxAbortIn;                // Transmit packet abort (input from TxEthMAC)
input         PadIn;                    // Padding (input from registers)
input         CrcEnIn;                  // Crc append (input from registers)
input   [7:0] RxData;                   // Receive Packet Data (from RxEthMAC)
input         RxValid;                  // Received a valid packet
input         RxStartFrm;               // Receive packet start frame (input from RxEthMAC)
input         RxEndFrm;                 // Receive packet end frame (input from RxEthMAC)
input         ReceiveEnd;               // End of receiving of the current packet (input from RxEthMAC)
input         ReceivedPacketGood;       // Received packet is good
input         ReceivedLengthOK;         // Length of the received packet is OK
input         TxFlow;                   // Tx flow control (from registers)
input         RxFlow;                   // Rx flow control (from registers)
input         DlyCrcEn;                 // Delayed CRC enabled (from registers)
input  [15:0] TxPauseTV;                // Transmit Pause Timer Value (from registers)
input  [47:0] MAC;                      // MAC address (from registers)
input         RxStatusWriteLatched_sync2;
input         r_PassAll;

//FMP_VC_1//output  [7:0] TxDataOut;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_7;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_6;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_5;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_4;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_3;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_2;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_1;                // Transmit Packet Data (to TxEthMAC)
output   TxDataOut_0;                // Transmit Packet Data (to TxEthMAC)
output        TxStartFrmOut;            // Transmit packet start frame (output to TxEthMAC)
output        TxEndFrmOut;              // Transmit packet end frame (output to TxEthMAC)
output        TxDoneOut;                // Transmit packet done (to host)
output        TxAbortOut;               // Transmit packet aborted (to host)
output        TxUsedDataOut;            // Transmit packet used data (to host)
output        PadOut;                   // Padding (output to TxEthMAC)
output        CrcEnOut;                 // Crc append (output to TxEthMAC)
output        WillSendControlFrame;
output        TxCtrlEndFrm;
output        ReceivedPauseFrm;
output        ControlFrmAddressOK;
output        SetPauseTimer;

//FMP_VC_0
   output     ReceivedPauseFrmWAddr;
   output     TypeLengthOK;
   
//FMP_VC_1
   wire  TxDataOut_7,TxDataOut_6,TxDataOut_5,TxDataOut_4,TxDataOut_3,TxDataOut_2,TxDataOut_1,TxDataOut_0;
   

   
reg           TxUsedDataOutDetected;    
reg           TxAbortInLatched;         
reg           TxDoneInLatched;          
reg           MuxedDone;                
reg           MuxedAbort;               

wire          Pause;                    
wire          TxCtrlStartFrm;
wire          CtrlMux;                  
wire          SendingCtrlFrm;           // Sending Control Frame (enables padding and CRC)
wire          BlockTxDone;
   
//FMP_VC_1//FMP_VC_3//wire    [7:0] ControlData;              
wire       ControlData_7,ControlData_6,ControlData_5,ControlData_4,
	      ControlData_3,ControlData_2,ControlData_1,ControlData_0;

wire    [7:0] ControlData = {ControlData_7,ControlData_6,ControlData_5,ControlData_4,
			     ControlData_3,ControlData_2,ControlData_1,ControlData_0};  

//FMP_VC_1
   wire     RxData_0 = RxData[0];
   wire     RxData_1 = RxData[1];
   wire     RxData_2 = RxData[2];
   wire     RxData_3 = RxData[3];
   wire     RxData_4 = RxData[4];
   wire     RxData_5 = RxData[5];
   wire     RxData_6 = RxData[6];
   wire     RxData_7 = RxData[7];

//FMP_VC_1
wire    MAC_47 = MAC[47];
wire    MAC_46 = MAC[46];
wire    MAC_45 = MAC[45];
wire    MAC_44 = MAC[44];
wire    MAC_43 = MAC[43];
wire    MAC_42 = MAC[42];
wire    MAC_41 = MAC[41];
wire    MAC_40 = MAC[40];
wire    MAC_39 = MAC[39];
wire    MAC_38 = MAC[38];
wire    MAC_37 = MAC[37];
wire    MAC_36 = MAC[36];
wire    MAC_35 = MAC[35];
wire    MAC_34 = MAC[34];
wire    MAC_33 = MAC[33];
wire    MAC_32 = MAC[32];
wire    MAC_31 = MAC[31];
wire    MAC_30 = MAC[30];
wire    MAC_29 = MAC[29];
wire    MAC_28 = MAC[28];
wire    MAC_27 = MAC[27];
wire    MAC_26 = MAC[26];
wire    MAC_25 = MAC[25];
wire    MAC_24 = MAC[24];
wire    MAC_23 = MAC[23];
wire    MAC_22 = MAC[22];
wire    MAC_21 = MAC[21];
wire    MAC_20 = MAC[20];
wire    MAC_19 = MAC[19];
wire    MAC_18 = MAC[18];
wire    MAC_17 = MAC[17];
wire    MAC_16 = MAC[16];
wire    MAC_15 = MAC[15];
wire    MAC_14 = MAC[14];
wire    MAC_13 = MAC[13];
wire    MAC_12 = MAC[12];
wire    MAC_11 = MAC[11];
wire    MAC_10 = MAC[10];
wire    MAC_9 = MAC[9];
wire    MAC_8 = MAC[8];
wire    MAC_7 = MAC[7];
wire    MAC_6 = MAC[6];
wire    MAC_5 = MAC[5];
wire    MAC_4 = MAC[4];
wire    MAC_3 = MAC[3];
wire    MAC_2 = MAC[2];
wire    MAC_1 = MAC[1];
wire    MAC_0 = MAC[0];   

//FMP_VC_1
wire    TxPauseTV_15 = TxPauseTV[15];
wire    TxPauseTV_14 = TxPauseTV[14];
wire    TxPauseTV_13 = TxPauseTV[13];
wire    TxPauseTV_12 = TxPauseTV[12];
wire    TxPauseTV_11 = TxPauseTV[11];
wire    TxPauseTV_10 = TxPauseTV[10];
wire    TxPauseTV_9 = TxPauseTV[9];
wire    TxPauseTV_8 = TxPauseTV[8];
wire    TxPauseTV_7 = TxPauseTV[7];
wire    TxPauseTV_6 = TxPauseTV[6];
wire    TxPauseTV_5 = TxPauseTV[5];
wire    TxPauseTV_4 = TxPauseTV[4];
wire    TxPauseTV_3 = TxPauseTV[3];
wire    TxPauseTV_2 = TxPauseTV[2];
wire    TxPauseTV_1 = TxPauseTV[1];
wire    TxPauseTV_0 = TxPauseTV[0];

   
//FMP_VC_4//
`define VCEGAR
`ifdef VCEGAR
   initial begin
      TxUsedDataOutDetected = 1'b0;
      TxDoneInLatched       = 1'b0;
      TxAbortInLatched      = 1'b0;
      MuxedAbort            = 1'b0;
      MuxedDone             = 1'b0;
   end
`endif
   
// Signal TxUsedDataOut was detected (a transfer is already in progress)
//FMP_VC_9//always @ (posedge MTxClk/* or posedge TxReset*/)
always @ (posedge MRxClk/* or posedge TxReset*/)
begin
  if(TxReset)
    TxUsedDataOutDetected <= #1 1'b0;
  else
  if(TxDoneIn | TxAbortIn)
    TxUsedDataOutDetected <= #1 1'b0;
  else
  if(TxUsedDataOut)
    TxUsedDataOutDetected <= #1 1'b1;
end    


// Latching variables
//FMP_VC_9//always @ (posedge MTxClk/* or posedge TxReset*/)
always @ (posedge MRxClk/* or posedge TxReset*/)
begin
  if(TxReset)
    begin
      TxAbortInLatched <= #1 1'b0;
      TxDoneInLatched  <= #1 1'b0;
    end
  else
    begin
      TxAbortInLatched <= #1 TxAbortIn;
      TxDoneInLatched  <= #1 TxDoneIn;
    end
end



// Generating muxed abort signal
//FMP_VC_9//always @ (posedge MTxClk/* or posedge TxReset*/)
always @ (posedge MRxClk/* or posedge TxReset*/)
begin
  if(TxReset)
    MuxedAbort <= #1 1'b0;
  else
  if(TxStartFrmIn)
    MuxedAbort <= #1 1'b0;
  else
  if(TxAbortIn & ~TxAbortInLatched & TxUsedDataOutDetected)
    MuxedAbort <= #1 1'b1;
end


// Generating muxed done signal
///FMP_VC_9//always @ (posedge MTxClk/* or posedge TxReset*/)
 always @ (posedge MRxClk/* or posedge TxReset*/) 
begin
  if(TxReset)
    MuxedDone <= #1 1'b0;
  else
  if(TxStartFrmIn)
    MuxedDone <= #1 1'b0;
  else
  if(TxDoneIn & (~TxDoneInLatched) & TxUsedDataOutDetected)
    MuxedDone <= #1 1'b1;
end


// TxDoneOut
assign TxDoneOut  = CtrlMux? ((~TxStartFrmIn) & (~BlockTxDone) & MuxedDone) : 
                             ((~TxStartFrmIn) & (~BlockTxDone) & TxDoneIn);

// TxAbortOut
assign TxAbortOut  = CtrlMux? ((~TxStartFrmIn) & (~BlockTxDone) & MuxedAbort) :
                              ((~TxStartFrmIn) & (~BlockTxDone) & TxAbortIn);

// TxUsedDataOut
assign TxUsedDataOut  = ~CtrlMux & TxUsedDataIn;

// TxStartFrmOut
assign TxStartFrmOut = CtrlMux? TxCtrlStartFrm : (TxStartFrmIn & ~Pause);


// TxEndFrmOut
assign TxEndFrmOut = CtrlMux? TxCtrlEndFrm : TxEndFrmIn;


// TxDataOut[7:0]
//FMP_VC_1//assign TxDataOut[7:0] = CtrlMux? ControlData[7:0] : TxDataIn[7:0];
   wire TxDataIn_0 = TxDataIn[0];
   wire TxDataIn_1 = TxDataIn[1];
   wire TxDataIn_2 = TxDataIn[2];
   wire TxDataIn_3 = TxDataIn[3];
   wire TxDataIn_4 = TxDataIn[4];
   wire TxDataIn_5 = TxDataIn[5];
   wire TxDataIn_6 = TxDataIn[6];
   wire TxDataIn_7 = TxDataIn[7];

assign TxDataOut_0 = CtrlMux? ControlData_0 : TxDataIn_0;
assign TxDataOut_1 = CtrlMux? ControlData_1 : TxDataIn_1;
assign TxDataOut_2 = CtrlMux? ControlData_2 : TxDataIn_2;
assign TxDataOut_3 = CtrlMux? ControlData_3 : TxDataIn_3;
assign TxDataOut_4 = CtrlMux? ControlData_4 : TxDataIn_4;
assign TxDataOut_5 = CtrlMux? ControlData_5 : TxDataIn_5;
assign TxDataOut_6 = CtrlMux? ControlData_6 : TxDataIn_6;
assign TxDataOut_7 = CtrlMux? ControlData_7 : TxDataIn_7;



// PadOut
assign PadOut = PadIn | SendingCtrlFrm;


// CrcEnOut
assign CrcEnOut = CrcEnIn | SendingCtrlFrm;



// Connecting receivecontrol module
/* -----\/----- EXCLUDED -----\/-----
eth_receivecontrol receivecontrol1 
(
 .MTxClk(MTxClk), .MRxClk(MRxClk), .TxReset(TxReset), .RxReset(RxReset), .RxData(RxData), 
 .RxValid(RxValid), .RxStartFrm(RxStartFrm), .RxEndFrm(RxEndFrm), .RxFlow(RxFlow), 
 .ReceiveEnd(ReceiveEnd), .MAC(MAC), .DlyCrcEn(DlyCrcEn), .TxDoneIn(TxDoneIn), 
 .TxAbortIn(TxAbortIn), .TxStartFrmOut(TxStartFrmOut), .ReceivedLengthOK(ReceivedLengthOK), 
 .ReceivedPacketGood(ReceivedPacketGood), .TxUsedDataOutDetected(TxUsedDataOutDetected), 
 .Pause(Pause), .ReceivedPauseFrm(ReceivedPauseFrm), .AddressOK(ControlFrmAddressOK), 
 .r_PassAll(r_PassAll), .RxStatusWriteLatched_sync2(RxStatusWriteLatched_sync2), .SetPauseTimer(SetPauseTimer)
);
 -----/\----- EXCLUDED -----/\----- */
/*
eth_receivecontrol AUTO_TEMPLATE
(
 .MTxClk(MTxClk), 
 .MRxClk(MRxClk), 
 .TxReset(TxReset), 
 .RxReset(RxReset), 
 .RxData({RxData_7, RxData_6, RxData_5, RxData_4, RxData_3, RxData_2, RxData_1, RxData_0}), 
 .RxValid(RxValid), 
 .RxStartFrm(RxStartFrm), 
 .RxEndFrm(RxEndFrm), 
 .RxFlow(RxFlow), 
 .ReceiveEnd(ReceiveEnd), 
 .MAC({MAC_47, MAC_46, MAC_45, MAC_44, MAC_43, MAC_42, MAC_41, MAC_40, MAC_39, MAC_38, MAC_37, MAC_36, MAC_35, MAC_34, MAC_33, MAC_32, MAC_31, MAC_30, MAC_29, MAC_28, MAC_27, MAC_26, MAC_25, MAC_24, MAC_23, MAC_22, MAC_21, MAC_20, MAC_19, MAC_18, MAC_17, MAC_16, MAC_15, MAC_14, MAC_13, MAC_12, MAC_11, MAC_10, MAC_9, MAC_8, MAC_7, MAC_6, MAC_5, MAC_4, MAC_3, MAC_2, MAC_1, MAC_0}),                  
 .DlyCrcEn(DlyCrcEn), 
 .TxDoneIn(TxDoneIn), 
 .TxAbortIn(TxAbortIn), 
 .TxStartFrmOut(TxStartFrmOut), 
 .ReceivedLengthOK(ReceivedLengthOK), 
 .ReceivedPacketGood(ReceivedPacketGood), 
 .TxUsedDataOutDetected(TxUsedDataOutDetected), 
 .Pause(Pause), 
 .ReceivedPauseFrm(ReceivedPauseFrm), 
 .AddressOK(ControlFrmAddressOK), 
 .r_PassAll(r_PassAll), 
 .RxStatusWriteLatched_sync2(RxStatusWriteLatched_sync2), 
 .SetPauseTimer(SetPauseTimer),
 .ReceivedPauseFrmWAddr(ReceivedPauseFrmWAddr),
);
 */
eth_receivecontrol receivecontrol1 
(/*AUTOINST*/
 // Outputs
 .Pause					(Pause),		 // Templated
 .ReceivedPauseFrm			(ReceivedPauseFrm),	 // Templated
 .AddressOK				(ControlFrmAddressOK),	 // Templated
 .SetPauseTimer				(SetPauseTimer),	 // Templated
 .ReceivedPauseFrmWAddr			(ReceivedPauseFrmWAddr), // Templated
 .TypeLengthOK				(TypeLengthOK),
 // Inputs
 .MTxClk				(MTxClk),                 // Templated
 .MRxClk				(MRxClk),		 // Templated
 .TxReset				(TxReset),		 // Templated
 .RxReset				(RxReset),		 // Templated
 .RxData				({RxData_7, RxData_6, RxData_5, RxData_4, RxData_3, RxData_2, RxData_1, RxData_0}), // Templated
 .RxValid				(RxValid),		 // Templated
 .RxStartFrm				(RxStartFrm),		 // Templated
 .RxEndFrm				(RxEndFrm),		 // Templated
 .RxFlow				(RxFlow),		 // Templated
 .ReceiveEnd				(ReceiveEnd),		 // Templated
 .MAC					({MAC_47, MAC_46, MAC_45, MAC_44, MAC_43, MAC_42, MAC_41, MAC_40, MAC_39, MAC_38, MAC_37, MAC_36, MAC_35, MAC_34, MAC_33, MAC_32, MAC_31, MAC_30, MAC_29, MAC_28, MAC_27, MAC_26, MAC_25, MAC_24, MAC_23, MAC_22, MAC_21, MAC_20, MAC_19, MAC_18, MAC_17, MAC_16, MAC_15, MAC_14, MAC_13, MAC_12, MAC_11, MAC_10, MAC_9, MAC_8, MAC_7, MAC_6, MAC_5, MAC_4, MAC_3, MAC_2, MAC_1, MAC_0}), // Templated
 .DlyCrcEn				(DlyCrcEn),		 // Templated
 .TxDoneIn				(TxDoneIn),		 // Templated
 .TxAbortIn				(TxAbortIn),		 // Templated
 .TxStartFrmOut				(TxStartFrmOut),	 // Templated
 .ReceivedLengthOK			(ReceivedLengthOK),	 // Templated
 .ReceivedPacketGood			(ReceivedPacketGood),	 // Templated
 .TxUsedDataOutDetected			(TxUsedDataOutDetected), // Templated
 .RxStatusWriteLatched_sync2		(RxStatusWriteLatched_sync2), // Templated
 .r_PassAll				(r_PassAll));		 // Templated

   

   
//FMP_VC_1 
/* -----\/----- EXCLUDED -----\/-----
eth_transmitcontrol transmitcontrol1
(
 .MTxClk(MTxClk), .TxReset(TxReset), .TxUsedDataIn(TxUsedDataIn), .TxUsedDataOut(TxUsedDataOut), 
 .TxDoneIn(TxDoneIn), .TxAbortIn(TxAbortIn), .TxStartFrmIn(TxStartFrmIn), .TPauseRq(TPauseRq), 
 .TxUsedDataOutDetected(TxUsedDataOutDetected), .TxFlow(TxFlow), .DlyCrcEn(DlyCrcEn), .TxPauseTV(TxPauseTV), 
 .MAC(MAC), .TxCtrlStartFrm(TxCtrlStartFrm), .TxCtrlEndFrm(TxCtrlEndFrm), .SendingCtrlFrm(SendingCtrlFrm), 
 .CtrlMux(CtrlMux), .ControlData(ControlData), .WillSendControlFrame(WillSendControlFrame), .BlockTxDone(BlockTxDone)
);
 -----/\----- EXCLUDED -----/\----- */

/*
 eth_transmitcontrol AUTO_TEMPLATE
 (
 .MTxClk(MTxClk), 
 .TxReset(TxReset), 
 .TxUsedDataIn(TxUsedDataIn), 
 .TxUsedDataOut(TxUsedDataOut), 
 .TxDoneIn(TxDoneIn), 
 .TxAbortIn(TxAbortIn), 
 .TxStartFrmIn(TxStartFrmIn), 
 .TPauseRq(TPauseRq), 
 .TxUsedDataOutDetected(TxUsedDataOutDetected), 
 .TxFlow(TxFlow), 
 .DlyCrcEn(DlyCrcEn), 
 .TxPauseTV({TxPauseTV_15, TxPauseTV_14, TxPauseTV_13, TxPauseTV_12, TxPauseTV_11, TxPauseTV_10, TxPauseTV_9, TxPauseTV_8, TxPauseTV_7, TxPauseTV_6, TxPauseTV_5, TxPauseTV_4, TxPauseTV_3, TxPauseTV_2, TxPauseTV_1, TxPauseTV_0}), 
 .MAC({MAC_47, MAC_46, MAC_45, MAC_44, MAC_43, MAC_42, MAC_41, MAC_40, MAC_39, MAC_38, MAC_37, MAC_36, MAC_35, MAC_34, MAC_33, MAC_32, MAC_31, MAC_30, MAC_29, MAC_28, MAC_27, MAC_26, MAC_25, MAC_24, MAC_23, MAC_22, MAC_21, MAC_20, MAC_19, MAC_18, MAC_17, MAC_16, MAC_15, MAC_14, MAC_13, MAC_12, MAC_11, MAC_10, MAC_9, MAC_8, MAC_7, MAC_6, MAC_5, MAC_4, MAC_3, MAC_2, MAC_1, MAC_0}),                  
 .TxCtrlStartFrm(TxCtrlStartFrm), 
 .TxCtrlEndFrm(TxCtrlEndFrm), 
 .SendingCtrlFrm(SendingCtrlFrm), 
 .CtrlMux(CtrlMux), 
 .ControlData_7(ControlData_7), 
 .ControlData_6(ControlData_6), 
 .ControlData_5(ControlData_5), 
 .ControlData_4(ControlData_4), 
 .ControlData_3(ControlData_3), 
 .ControlData_2(ControlData_2), 
 .ControlData_1(ControlData_1), 
 .ControlData_0(ControlData_0), 
 .WillSendControlFrame(WillSendControlFrame), 
 .BlockTxDone(BlockTxDone),
);
 */
eth_transmitcontrol transmitcontrol1
(/*AUTOINST*/
 // Outputs
 .TxCtrlStartFrm			(TxCtrlStartFrm),	 // Templated
 .TxCtrlEndFrm				(TxCtrlEndFrm),		 // Templated
 .SendingCtrlFrm			(SendingCtrlFrm),	 // Templated
 .CtrlMux				(CtrlMux),		 // Templated
 .ControlData_0				(ControlData_0),	 // Templated
 .ControlData_1				(ControlData_1),	 // Templated
 .ControlData_2				(ControlData_2),	 // Templated
 .ControlData_3				(ControlData_3),	 // Templated
 .ControlData_4				(ControlData_4),	 // Templated
 .ControlData_5				(ControlData_5),	 // Templated
 .ControlData_6				(ControlData_6),	 // Templated
 .ControlData_7				(ControlData_7),	 // Templated
 .WillSendControlFrame			(WillSendControlFrame),	 // Templated
 .BlockTxDone				(BlockTxDone),		 // Templated
 // Inputs
 .MTxClk				(MTxClk),		 // Templated
 .TxReset				(TxReset),		 // Templated
 .TxUsedDataIn				(TxUsedDataIn),		 // Templated
 .TxUsedDataOut				(TxUsedDataOut),	 // Templated
 .TxDoneIn				(TxDoneIn),		 // Templated
 .TxAbortIn				(TxAbortIn),		 // Templated
 .TxStartFrmIn				(TxStartFrmIn),		 // Templated
 .TPauseRq				(TPauseRq),		 // Templated
 .TxUsedDataOutDetected			(TxUsedDataOutDetected), // Templated
 .TxFlow				(TxFlow),		 // Templated
 .DlyCrcEn				(DlyCrcEn),		 // Templated
 .TxPauseTV				({TxPauseTV_15, TxPauseTV_14, TxPauseTV_13, TxPauseTV_12, TxPauseTV_11, TxPauseTV_10, TxPauseTV_9, TxPauseTV_8, TxPauseTV_7, TxPauseTV_6, TxPauseTV_5, TxPauseTV_4, TxPauseTV_3, TxPauseTV_2, TxPauseTV_1, TxPauseTV_0}), // Templated
 .MAC					({MAC_47, MAC_46, MAC_45, MAC_44, MAC_43, MAC_42, MAC_41, MAC_40, MAC_39, MAC_38, MAC_37, MAC_36, MAC_35, MAC_34, MAC_33, MAC_32, MAC_31, MAC_30, MAC_29, MAC_28, MAC_27, MAC_26, MAC_25, MAC_24, MAC_23, MAC_22, MAC_21, MAC_20, MAC_19, MAC_18, MAC_17, MAC_16, MAC_15, MAC_14, MAC_13, MAC_12, MAC_11, MAC_10, MAC_9, MAC_8, MAC_7, MAC_6, MAC_5, MAC_4, MAC_3, MAC_2, MAC_1, MAC_0})); // Templated

   

endmodule
