//FMP_VC
//FMP_VC  EverLost Benchmarks
//FMP_VC  Copyright (C) 2006-2007  Flavio M. de Paula
//FMP_VC
//FMP_VC  This is a modified version of the original one from 
//FMP_VC  opencores.org. 
//FMP_VC  This file is licensed under the GNU Lesser  General
//FMP_VC  Public License. See lgpl.txt for more details.
//FMP_VC
//FMP_VC
//////////////////////////////////////////////////////////////////////
////                                                              ////
////  eth_crc.v                                                   ////
////                                                              ////
////  This file is part of the Ethernet IP core project           ////
////  http://www.opencores.org/projects/ethmac/                   ////
////                                                              ////
////  Author(s):                                                  ////
////      - Igor Mohor (igorM@opencores.org)                      ////
////      - Novan Hartadi (novan@vlsi.itb.ac.id)                  ////
////      - Mahmud Galela (mgalela@vlsi.itb.ac.id)                ////
////                                                              ////
////  All additional information is avaliable in the Readme.txt   ////
////  file.                                                       ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
////                                                              ////
//// Copyright (C) 2001 Authors                                   ////
////                                                              ////
//// This source file may be used and distributed without         ////
//// restriction provided that this copyright statement is not    ////
//// removed from the file and that any derivative work contains  ////
//// the original copyright notice and the associated disclaimer. ////
////                                                              ////
//// This source file is free software; you can redistribute it   ////
//// and/or modify it under the terms of the GNU Lesser General   ////
//// Public License as published by the Free Software Foundation; ////
//// either version 2.1 of the License, or (at your option) any   ////
//// later version.                                               ////
////                                                              ////
//// This source is distributed in the hope that it will be       ////
//// useful, but WITHOUT ANY WARRANTY; without even the implied   ////
//// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR      ////
//// PURPOSE.  See the GNU Lesser General Public License for more ////
//// details.                                                     ////
////                                                              ////
//// You should have received a copy of the GNU Lesser General    ////
//// Public License along with this source; if not, download it   ////
//// from http://www.opencores.org/lgpl.shtml                     ////
////                                                              ////
//////////////////////////////////////////////////////////////////////
//
// CVS Revision History
//
// $Log: eth_crc.v,v $
// Revision 1.3  2002/01/23 10:28:16  mohor
// Link in the header changed.
//
// Revision 1.2  2001/10/19 08:43:51  mohor
// eth_timescale.v changed to timescale.v This is done because of the
// simulation of the few cores in a one joined project.
//
// Revision 1.1  2001/08/06 14:44:29  mohor
// A define FPGA added to select between Artisan RAM (for ASIC) and Block Ram (For Virtex).
// Include files fixed to contain no path.
// File names and module names changed ta have a eth_ prologue in the name.
// File eth_timescale.v is used to define timescale
// All pin names on the top module are changed to contain _I, _O or _OE at the end.
// Bidirectional signal MDIO is changed to three signals (Mdc_O, Mdi_I, Mdo_O
// and Mdo_OE. The bidirectional signal must be created on the top level. This
// is done due to the ASIC tools.
//
// Revision 1.1  2001/07/30 21:23:42  mohor
// Directory structure changed. Files checked and joind together.
//
// Revision 1.3  2001/06/19 18:16:40  mohor
// TxClk changed to MTxClk (as discribed in the documentation).
// Crc changed so only one file can be used instead of two.
//
// Revision 1.2  2001/06/19 10:38:07  mohor
// Minor changes in header.
//
// Revision 1.1  2001/06/19 10:27:57  mohor
// TxEthMAC initial release.
//
//
//


`include "timescale.v"

module eth_crc (/*AUTOARG*/
   // Outputs
   Crc_0, Crc_1, Crc_2, Crc_3, Crc_4, Crc_5, Crc_6, Crc_7, Crc_8,
   Crc_9, Crc_10, Crc_11, Crc_12, Crc_13, Crc_14, Crc_15, Crc_16,
   Crc_17, Crc_18, Crc_19, Crc_20, Crc_21, Crc_22, Crc_23, Crc_24,
   Crc_25, Crc_26, Crc_27, Crc_28, Crc_29, Crc_30, Crc_31, CrcError,
   // Inputs
   Clk, Reset, Data, Enable, Initialize
   );


//FMP_VC_2 //parameter Tp = 1;

input Clk;
input Reset;
input [3:0] Data;
input Enable;
input Initialize;

//FMP_VC_1 //output [31:0] Crc;
 output  Crc_0;
 output  Crc_1;
 output  Crc_2;
 output  Crc_3;
 output  Crc_4;
 output  Crc_5;
 output  Crc_6;
 output  Crc_7;
 output  Crc_8;
 output  Crc_9;
 output  Crc_10;
 output  Crc_11;
 output  Crc_12;
 output  Crc_13;
 output  Crc_14;
 output  Crc_15;
 output  Crc_16;
 output  Crc_17;
 output  Crc_18;
 output  Crc_19;
 output  Crc_20;
 output  Crc_21;
 output  Crc_22;
 output  Crc_23;
 output  Crc_24;
 output  Crc_25;
 output  Crc_26;
 output  Crc_27;
 output  Crc_28;
 output  Crc_29;
 output  Crc_30;
 output  Crc_31;


output CrcError;

reg  [31:0] Crc;

//FMP_VC_3 //wire [31:0] CrcNext;

//FMP_VC_1
 wire  Crc_0 = Crc[0];
 wire  Crc_1 = Crc[1];
 wire  Crc_2 = Crc[2];
 wire  Crc_3 = Crc[3];
 wire  Crc_4 = Crc[4];
 wire  Crc_5 = Crc[5];
 wire  Crc_6 = Crc[6];
 wire  Crc_7 = Crc[7];
 wire  Crc_8 = Crc[8];
 wire  Crc_9 = Crc[9];
 wire  Crc_10 = Crc[10];
 wire  Crc_11 = Crc[11];
 wire  Crc_12 = Crc[12];
 wire  Crc_13 = Crc[13];
 wire  Crc_14 = Crc[14];
 wire  Crc_15 = Crc[15];
 wire  Crc_16 = Crc[16];
 wire  Crc_17 = Crc[17];
 wire  Crc_18 = Crc[18];
 wire  Crc_19 = Crc[19];
 wire  Crc_20 = Crc[20];
 wire  Crc_21 = Crc[21];
 wire  Crc_22 = Crc[22];
 wire  Crc_23 = Crc[23];
 wire  Crc_24 = Crc[24];
 wire  Crc_25 = Crc[25];
 wire  Crc_26 = Crc[26];
 wire  Crc_27 = Crc[27];
 wire  Crc_28 = Crc[28];
 wire  Crc_29 = Crc[29];
 wire  Crc_30 = Crc[30];
 wire  Crc_31 = Crc[31];


//FMP_VC_3
wire CrcNext_0 = Enable & (Data[0] ^ Crc[28]); 
wire CrcNext_1 = Enable & (Data[1] ^ Data[0] ^ Crc[28] ^ Crc[29]); 
wire CrcNext_2 = Enable & (Data[2] ^ Data[1] ^ Data[0] ^ Crc[28] ^ Crc[29] ^ Crc[30]); 
wire CrcNext_3 = Enable & (Data[3] ^ Data[2] ^ Data[1] ^ Crc[29] ^ Crc[30] ^ Crc[31]); 
wire CrcNext_4 = (Enable & (Data[3] ^ Data[2] ^ Data[0] ^ Crc[28] ^ Crc[30] ^ Crc[31])) ^ Crc[0]; 
wire CrcNext_5 = (Enable & (Data[3] ^ Data[1] ^ Data[0] ^ Crc[28] ^ Crc[29] ^ Crc[31])) ^ Crc[1]; 
wire CrcNext_6 = (Enable & (Data[2] ^ Data[1] ^ Crc[29] ^ Crc[30])) ^ Crc[ 2]; 
wire CrcNext_7 = (Enable & (Data[3] ^ Data[2] ^ Data[0] ^ Crc[28] ^ Crc[30] ^ Crc[31])) ^ Crc[3]; 
wire CrcNext_8 = (Enable & (Data[3] ^ Data[1] ^ Data[0] ^ Crc[28] ^ Crc[29] ^ Crc[31])) ^ Crc[4]; 
wire CrcNext_9 = (Enable & (Data[2] ^ Data[1] ^ Crc[29] ^ Crc[30])) ^ Crc[5]; 
wire CrcNext_10 = (Enable & (Data[3] ^ Data[2] ^ Data[0] ^ Crc[28] ^ Crc[30] ^ Crc[31])) ^ Crc[6]; 
wire CrcNext_11 = (Enable & (Data[3] ^ Data[1] ^ Data[0] ^ Crc[28] ^ Crc[29] ^ Crc[31])) ^ Crc[7]; 
wire CrcNext_12 = (Enable & (Data[2] ^ Data[1] ^ Data[0] ^ Crc[28] ^ Crc[29] ^ Crc[30])) ^ Crc[8]; 
wire CrcNext_13 = (Enable & (Data[3] ^ Data[2] ^ Data[1] ^ Crc[29] ^ Crc[30] ^ Crc[31])) ^ Crc[9]; 
wire CrcNext_14 = (Enable & (Data[3] ^ Data[2] ^ Crc[30] ^ Crc[31])) ^ Crc[10]; 
wire CrcNext_15 = (Enable & (Data[3] ^ Crc[31])) ^ Crc[11]; 
wire CrcNext_16 = (Enable & (Data[0] ^ Crc[28])) ^ Crc[12]; 
wire CrcNext_17 = (Enable & (Data[1] ^ Crc[29])) ^ Crc[13]; 
wire CrcNext_18 = (Enable & (Data[2] ^ Crc[30])) ^ Crc[14]; 
wire CrcNext_19 = (Enable & (Data[3] ^ Crc[31])) ^ Crc[15]; 
wire CrcNext_20 = Crc[16]; 
wire CrcNext_21 = Crc[17]; 
wire CrcNext_22 = (Enable & (Data[0] ^ Crc[28])) ^ Crc[18]; 
wire CrcNext_23 = (Enable & (Data[1] ^ Data[0] ^ Crc[29] ^ Crc[28])) ^ Crc[19]; 
wire CrcNext_24 = (Enable & (Data[2] ^ Data[1] ^ Crc[30] ^ Crc[29])) ^ Crc[20]; 
wire CrcNext_25 = (Enable & (Data[3] ^ Data[2] ^ Crc[31] ^ Crc[30])) ^ Crc[21]; 
wire CrcNext_26 = (Enable & (Data[3] ^ Data[0] ^ Crc[31] ^ Crc[28])) ^ Crc[22]; 
wire CrcNext_27 = (Enable & (Data[1] ^ Crc[29])) ^ Crc[23]; 
wire CrcNext_28 = (Enable & (Data[2] ^ Crc[30])) ^ Crc[24]; 
wire CrcNext_29 = (Enable & (Data[3] ^ Crc[31])) ^ Crc[25]; 
wire CrcNext_30 = Crc[26]; 
wire CrcNext_31 = Crc[27]; 

//FMP_VC_4
`define VCEGAR
`ifdef VCEGAR
   initial begin
      Crc =  32'hffffffff;
   end
`endif

always @ (posedge Clk /*or posedge Reset*/)
begin
  if (Reset)
    Crc <= #1 32'hffffffff;
  else
  if(Initialize)
    Crc <= #1 32'hffffffff;
  else
//FMP_VC_3 //Crc <= #1 CrcNext;
    Crc <= #1 {CrcNext_31, CrcNext_30, CrcNext_29, CrcNext_28, CrcNext_27, CrcNext_26, CrcNext_25, CrcNext_24, CrcNext_23, CrcNext_22, CrcNext_21, CrcNext_20, CrcNext_19, CrcNext_18, CrcNext_17, CrcNext_16, CrcNext_15, CrcNext_14, CrcNext_13, CrcNext_12, CrcNext_11, CrcNext_10, CrcNext_9, CrcNext_8, CrcNext_7, CrcNext_6, CrcNext_5, CrcNext_4, CrcNext_3, CrcNext_2, CrcNext_1, CrcNext_0};

end

assign CrcError = Crc[31:0] != 32'hc704dd7b;  // CRC not equal to magic number

endmodule
