/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doodleproject.numerics4j.random;

import net.sf.doodleproject.numerics4j.random.AbstractDiscreteRandomVariable;
import net.sf.doodleproject.numerics4j.random.BetaRandomVariable;
import net.sf.doodleproject.numerics4j.random.RNG;
import net.sf.doodleproject.numerics4j.random.RandomRNG;

public class BinomialRandomVariable
extends AbstractDiscreteRandomVariable {
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public BinomialRandomVariable() {
        this(1, 0.5);
    }

    public BinomialRandomVariable(int n, double p) {
        this(n, p, new RandomRNG());
    }

    public BinomialRandomVariable(int n, double p, RNG source) {
        super(source);
        this.setNumberOfTrials(n);
        this.setProbabilityOfSuccess(p);
    }

    public static int nextRandomVariable(int n, double p, RNG source) {
        int i;
        int x = 0;
        int pivot = (int)((double)n * p);
        do {
            double v;
            if (p < (v = BetaRandomVariable.nextRandomVariable(i = (int)(1.0 + (double)n * p), (double)n + 1.0 - (double)i, source))) {
                p /= v;
                n = i - 1;
                continue;
            }
            x += i;
            p = (p - v) / (1.0 - v);
            n -= i;
        } while (n > pivot);
        for (i = 0; i < pivot; ++i) {
            double u = source.nextRandomNumber();
            if (!(u < p)) continue;
            ++x;
        }
        return x;
    }

    private int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    private double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public int nextRandomVariable() {
        return BinomialRandomVariable.nextRandomVariable(this.getNumberOfTrials(), this.getProbabilityOfSuccess(), this.getSource());
    }

    private void setNumberOfTrials(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("number of trials must be positive.");
        }
        this.numberOfTrials = n;
    }

    private void setProbabilityOfSuccess(double p) {
        if (Double.isNaN(p) || p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("probability of success mustbe between 0.0 and 1.0, exclusive.");
        }
        this.probabilityOfSuccess = p;
    }
}

