/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.helpers;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.StatusVariableKillHandler;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorHelper;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineAlgorithmRun;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractRunReschedulingTargetAlgorithmEvaluatorDecorator;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RetryCrashedRunsTargetAlgorithmEvaluatorDecorator
extends AbstractRunReschedulingTargetAlgorithmEvaluatorDecorator {
    private AtomicInteger runCount = new AtomicInteger(0);
    private final AtomicInteger crashedRunCount = new AtomicInteger(0);
    private final AtomicInteger crashedRunCountReported = new AtomicInteger(0);
    private final int retryCount;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean warningOnRetry = new AtomicBoolean(false);
    private final AtomicDouble walltime = new AtomicDouble();
    private final AtomicDouble runtime = new AtomicDouble();

    public RetryCrashedRunsTargetAlgorithmEvaluatorDecorator(int retryCount, TargetAlgorithmEvaluator tae) {
        super(tae);
        if (retryCount < 0) {
            throw new IllegalArgumentException("Retry Count should be atleast 0");
        }
        this.retryCount = retryCount;
        if (tae.isRunFinal()) {
            this.log.warn("Target Algorithm Evaluator {} issues final runs, retrying will be a waste of time", (Object)tae.getClass().getSimpleName());
        }
    }

    @Override
    public void evaluateRunsAsync(List<AlgorithmRunConfiguration> rcs, TargetAlgorithmEvaluatorCallback handler, final TargetAlgorithmEvaluatorRunObserver obs) {
        final List<AlgorithmRunConfiguration> runConfigs = Collections.unmodifiableList(rcs);
        final ConcurrentHashMap<AlgorithmRunConfiguration, RunningAlgorithmRunResult> observerRunStatusMap = new ConcurrentHashMap<AlgorithmRunConfiguration, RunningAlgorithmRunResult>();
        final ConcurrentHashMap<AlgorithmRunConfiguration, StatusVariableKillHandler> killHandlers = new ConcurrentHashMap<AlgorithmRunConfiguration, StatusVariableKillHandler>();
        for (AlgorithmRunConfiguration rc : runConfigs) {
            StatusVariableKillHandler kh = new StatusVariableKillHandler();
            killHandlers.put(rc, kh);
            observerRunStatusMap.put(rc, new RunningAlgorithmRunResult(rc, 0.0, 0.0, 0.0, 0L, 0.0, kh));
        }
        TargetAlgorithmEvaluatorRunObserver noCrashedRunsNotifiedRunObserver = new TargetAlgorithmEvaluatorRunObserver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (obs == null) {
                    return;
                }
                for (AlgorithmRunResult algorithmRunResult : runs) {
                    if (algorithmRunResult.isRunCompleted() && !algorithmRunResult.getRunStatus().equals((Object)RunStatus.CRASHED)) {
                        observerRunStatusMap.put(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult);
                        continue;
                    }
                    if (algorithmRunResult.getRunStatus().equals((Object)RunStatus.CRASHED)) continue;
                    if (algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING)) {
                        RunningAlgorithmRunResult runningAlgorithmRunResult = new RunningAlgorithmRunResult(algorithmRunResult.getAlgorithmRunConfiguration(), algorithmRunResult.getRuntime(), algorithmRunResult.getRunLength(), algorithmRunResult.getQuality(), algorithmRunResult.getResultSeed(), algorithmRunResult.getWallclockExecutionTime(), (KillHandler)killHandlers.get(algorithmRunResult.getAlgorithmRunConfiguration()));
                        observerRunStatusMap.put(algorithmRunResult.getAlgorithmRunConfiguration(), runningAlgorithmRunResult);
                        continue;
                    }
                    throw new IllegalStateException("Expected that the run is either running or crashed or completed, something must have changed");
                }
                ArrayList runsToPassForward = new ArrayList(runConfigs.size());
                for (AlgorithmRunConfiguration algorithmRunConfiguration : runConfigs) {
                    runsToPassForward.add(observerRunStatusMap.get(algorithmRunConfiguration));
                }
                try {
                    obs.currentStatus(runsToPassForward);
                }
                finally {
                    for (AlgorithmRunResult algorithmRunResult : runs) {
                        if (!algorithmRunResult.getRunStatus().equals((Object)RunStatus.RUNNING) || !((StatusVariableKillHandler)killHandlers.get(algorithmRunResult.getAlgorithmRunConfiguration())).isKilled()) continue;
                        algorithmRunResult.kill();
                    }
                }
            }
        };
        ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult> callbackRunStatusMap = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunResult>();
        RetryingTargetAlgorithmEvaluatorCallback callback = new RetryingTargetAlgorithmEvaluatorCallback(this.retryCount, callbackRunStatusMap, handler, runConfigs, this.tae, obs, noCrashedRunsNotifiedRunObserver);
        this.tae.evaluateRunsAsync(runConfigs, callback, noCrashedRunsNotifiedRunObserver);
    }

    @Override
    public List<AlgorithmRunResult> evaluateRun(List<AlgorithmRunConfiguration> runConfigs, TargetAlgorithmEvaluatorRunObserver obs) {
        return TargetAlgorithmEvaluatorHelper.evaluateRunSyncToAsync(runConfigs, this, obs);
    }

    @Override
    public int getRunCount() {
        return this.runCount.get();
    }

    @Override
    public void seek(List<AlgorithmRunResult> runs) {
        this.tae.seek(runs);
        this.runCount.addAndGet(runs.size());
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
        if (this.crashedRunCount.get() > 0) {
            this.log.info("During execution we received (and subsequently retried up to {} times) {} crashed runs, we ultimately reported {} runs back to the caller, this caused a loss of {} reported CPU seconds and {} wall-clock seconds", new Object[]{this.retryCount, this.crashedRunCount.get(), this.crashedRunCountReported.get(), this.runtime.get(), this.walltime.get()});
        }
    }

    private class RetryingTargetAlgorithmEvaluatorCallback
    implements TargetAlgorithmEvaluatorCallback {
        private final int retriesLeft;
        private final Map<AlgorithmRunConfiguration, AlgorithmRunResult> knownResults;
        private final TargetAlgorithmEvaluatorCallback originalCallback;
        private final List<AlgorithmRunConfiguration> originalRunConfigurations;
        private final TargetAlgorithmEvaluator tae;
        private final TargetAlgorithmEvaluatorRunObserver clientsTaeObs;
        private final TargetAlgorithmEvaluatorRunObserver taeObs;

        public RetryingTargetAlgorithmEvaluatorCallback(int retriesLeft, Map<AlgorithmRunConfiguration, AlgorithmRunResult> knownResults, TargetAlgorithmEvaluatorCallback originalCallback, List<AlgorithmRunConfiguration> originalRunConfigurations, TargetAlgorithmEvaluator tae, TargetAlgorithmEvaluatorRunObserver clientsTaeObs, TargetAlgorithmEvaluatorRunObserver taeObs) {
            this.retriesLeft = retriesLeft;
            if (retriesLeft < 0) {
                throw new IllegalStateException("Must have atleast zero retries left (in which case we won't retry)");
            }
            this.knownResults = knownResults;
            this.originalCallback = originalCallback;
            this.originalRunConfigurations = originalRunConfigurations;
            this.clientsTaeObs = clientsTaeObs;
            this.tae = tae;
            this.taeObs = taeObs;
        }

        @Override
        public void onSuccess(List<AlgorithmRunResult> runs) {
            ArrayList<AlgorithmRunConfiguration> runConfigsToRetry = new ArrayList<AlgorithmRunConfiguration>(runs.size());
            boolean crashedRunsToRetry = false;
            for (AlgorithmRunResult runResult : runs) {
                if (!runResult.getRunStatus().equals((Object)RunStatus.CRASHED) || this.retriesLeft == 0) {
                    this.knownResults.put(runResult.getAlgorithmRunConfiguration(), runResult);
                    continue;
                }
                if (runResult.getRunStatus().equals((Object)RunStatus.CRASHED) && this.retriesLeft > 0) {
                    crashedRunsToRetry = true;
                    RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.crashedRunCount.incrementAndGet();
                    RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.runtime.addAndGet(runResult.getRuntime());
                    RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.walltime.addAndGet(runResult.getWallclockExecutionTime());
                    runConfigsToRetry.add(runResult.getAlgorithmRunConfiguration());
                    continue;
                }
                throw new IllegalStateException("Expected the two conditionals above this to cover all cases");
            }
            if (crashedRunsToRetry) {
                if (RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.warningOnRetry.compareAndSet(false, true)) {
                    RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.log.warn("We have detected a crashed run and will automatically retrying it, other alerts will only be logged at DEBUG level: {} ", (Object)CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString((AlgorithmRunConfiguration)runConfigsToRetry.get(0)));
                } else {
                    RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.log.debug("Retrying {} crashed runs (Attempts {} left)", (Object)runConfigsToRetry.size(), (Object)this.retriesLeft);
                }
                RetryingTargetAlgorithmEvaluatorCallback taeCallback = new RetryingTargetAlgorithmEvaluatorCallback(this.retriesLeft - 1, this.knownResults, this.originalCallback, this.originalRunConfigurations, this.tae, this.clientsTaeObs, this.taeObs);
                this.tae.evaluateRunsAsync(runConfigsToRetry, taeCallback, this.taeObs);
            } else {
                ArrayList<AlgorithmRunResult> runResults = new ArrayList<AlgorithmRunResult>(this.originalRunConfigurations.size());
                for (AlgorithmRunConfiguration rc : this.originalRunConfigurations) {
                    AlgorithmRunResult runResult = this.knownResults.get(rc);
                    if (runResult == null) {
                        throw new IllegalStateException("Expected that run configuration : " + rc + " would have a result in map with size: " + this.knownResults.size() + " and contents: " + this.knownResults);
                    }
                    if (runResult.getRunStatus().equals((Object)RunStatus.CRASHED)) {
                        RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.crashedRunCountReported.incrementAndGet();
                    }
                    runResults.add(runResult);
                }
                if (runResults.size() != this.originalRunConfigurations.size()) {
                    throw new IllegalStateException("Expected that the number of runs returned would equal the number of run configurations requested, instead got: " + runResults.size() + " vs: " + this.originalRunConfigurations.size());
                }
                if (this.clientsTaeObs != null) {
                    this.clientsTaeObs.currentStatus(runResults);
                }
                RetryCrashedRunsTargetAlgorithmEvaluatorDecorator.this.runCount.addAndGet(runResults.size());
                this.originalCallback.onSuccess(runResults);
            }
        }

        @Override
        public void onFailure(RuntimeException e) {
            this.originalCallback.onFailure(e);
        }
    }
}

