/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunningAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.kill.KillHandler;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.misc.associatedvalue.Pair;
import ca.ubc.cs.beta.aeatk.misc.logback.MarkerFilter;
import ca.ubc.cs.beta.aeatk.misc.logging.LoggingMarker;
import ca.ubc.cs.beta.aeatk.misc.string.SplitQuotedString;
import ca.ubc.cs.beta.aeatk.misc.watch.StopWatch;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CommandLineAlgorithmRun
implements Callable<AlgorithmRunResult> {
    private static final long serialVersionUID = -70897405824987641L;
    public static final String AUTOMATIC_CONFIGURATOR_RESULT_REGEX = "^\\s*Result\\s*of\\s*(this)?\\s*[Aa]lgorithm\\s*[rR]un\\s*:";
    public static final String OLD_AUTOMATIC_CONFIGURATOR_RESULT_REGEX = "^\\s*(Final)?\\s*[Rr]esult\\s+(?:([Ff]or)|([oO]f))\\s+(?:(HAL)|(ParamILS)|(SMAC)|([tT]his [wW]rapper)):";
    private static final Pattern pattern = Pattern.compile("^\\s*Result\\s*of\\s*(this)?\\s*[Aa]lgorithm\\s*[rR]un\\s*:");
    private static final Pattern oldPattern = Pattern.compile("^\\s*(Final)?\\s*[Rr]esult\\s+(?:([Ff]or)|([oO]f))\\s+(?:(HAL)|(ParamILS)|(SMAC)|([tT]his [wW]rapper)):");
    private static transient Logger log = LoggerFactory.getLogger(CommandLineAlgorithmRun.class);
    private Queue<String> outputQueue = new ArrayDeque<String>(2000);
    private transient TargetAlgorithmEvaluatorRunObserver runObserver;
    private transient KillHandler killHandler;
    public static final String PORT_ENVIRONMENT_VARIABLE = "AEATK_PORT";
    public static final String FREQUENCY_ENVIRONMENT_VARIABLE = "AEATK_CPU_TIME_FREQUENCY";
    public static final String CONCURRENT_TASK_ID = "AEATK_CONCURRENT_TASK_ID";
    public static final String EXECUTION_UUID_ENVIRONMENT_VARIABLE_DEFAULT = "AEATK_EXECUTION_UUID";
    private final UUID uuid = UUID.randomUUID();
    private static final String envVariableForChildren;
    private static transient Marker fullProcessOutputMarker;
    public static final String COMMAND_SEPERATOR;
    private final int observerFrequency;
    private AtomicBoolean processEnded = new AtomicBoolean(false);
    private final transient BlockingQueue<Integer> executionIDs;
    private final transient CommandLineTargetAlgorithmEvaluatorOptions options;
    private final AlgorithmRunConfiguration runConfig;
    private static final transient AtomicBoolean jvmShutdownDetected;
    private final StopWatch wallClockTimer = new StopWatch();
    private AtomicDouble wallClockTime = new AtomicDouble();
    private static final Set<Pair<CommandLineAlgorithmRun, Process>> outstandingRuns;
    private volatile AlgorithmRunResult completedAlgorithmRun;
    private static final int MAX_LINES_TO_SAVE = 1000;
    private volatile boolean wasKilled = false;
    AtomicBoolean killPreviouslyCalled = new AtomicBoolean(false);

    protected void startWallclockTimer() {
        this.wallClockTimer.start();
    }

    protected void stopWallclockTimer() {
        this.wallClockTime.set((double)this.wallClockTimer.stop() / 1000.0);
    }

    protected long getCurrentWallClockTime() {
        return this.wallClockTimer.time();
    }

    public CommandLineAlgorithmRun(AlgorithmRunConfiguration runConfig, TargetAlgorithmEvaluatorRunObserver obs, KillHandler handler, CommandLineTargetAlgorithmEvaluatorOptions options, BlockingQueue<Integer> executionIDs) {
        this.runConfig = runConfig;
        this.runObserver = obs;
        this.killHandler = handler;
        this.observerFrequency = options.observerFrequency;
        if (this.observerFrequency < 25) {
            throw new IllegalArgumentException("Observer Frequency can't be less than 25 milliseconds");
        }
        this.options = options;
        this.executionIDs = executionIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized AlgorithmRunResult call() {
        Thread.currentThread().setName("CLI TAE (Master Thread - TBD)");
        if (this.killHandler.isKilled()) {
            log.trace("Run has already been toggled as killed {}", (Object)this.runConfig);
            RunStatus rr = RunStatus.KILLED;
            ExistingAlgorithmRunResult run = new ExistingAlgorithmRunResult(this.runConfig, rr, 0.0, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), "", 0.0);
            try {
                this.runObserver.currentStatus(Collections.singletonList(run));
                return run;
            }
            catch (RuntimeException t) {
                log.error("Error occured while notify observer ", (Throwable)t);
                throw t;
            }
        }
        this.runObserver.currentStatus(Collections.singletonList(new RunningAlgorithmRunResult(this.runConfig, 0.0, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), 0.0, this.killHandler)));
        if (jvmShutdownDetected.get()) {
            String rawResultLine = "JVM Shutdown Detected";
            ExistingAlgorithmRunResult run = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.KILLED, 0.0, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), "JVM Shutdown Detected, algorithm not executed", 0.0);
            this.runObserver.currentStatus(Collections.singletonList(run));
            return run;
        }
        if (this.killHandler.isKilled()) {
            log.trace("Run was killed", (Object)this.runConfig);
            String rawResultLine = "Kill detected before target algorithm invoked";
            ExistingAlgorithmRunResult run = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.KILLED, 0.0, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), "Kill detected before target algorithm invoked", 0.0);
            this.runObserver.currentStatus(Collections.singletonList(run));
            return run;
        }
        File execDir = new File(this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory());
        if (!execDir.exists()) {
            throw new TargetAlgorithmAbortException("Algorithm Execution Directory: " + this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory() + " does not exist");
        }
        if (!execDir.isDirectory()) {
            throw new TargetAlgorithmAbortException("Algorithm Execution Directory: " + this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory() + " is not a directory");
        }
        try {
            Integer token;
            try {
                token = this.executionIDs.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return ExistingAlgorithmRunResult.getAbortResult(this.runConfig, "Target CLI Thread was Interrupted");
            }
            final Integer myToken = token;
            Thread.currentThread().setName("CLI TAE (Master Thread - #" + myToken + ")");
            try {
                DatagramSocket serverSocket;
                if (this.killHandler.isKilled()) {
                    log.trace("Run was killed", (Object)this.runConfig);
                    ExistingAlgorithmRunResult run = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.KILLED, 0.0, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), "Kill detected before target algorithm invoked", 0.0);
                    this.runObserver.currentStatus(Collections.singletonList(run));
                    ExistingAlgorithmRunResult existingAlgorithmRunResult = run;
                    return existingAlgorithmRunResult;
                }
                int port = 0;
                if (this.options.listenForUpdates) {
                    serverSocket = new DatagramSocket();
                    port = serverSocket.getLocalPort();
                } else {
                    serverSocket = null;
                }
                final AtomicDouble currentRuntime = new AtomicDouble(0.0);
                Runnable socketThread = new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setName("CLI TAE (Socket Thread - #" + myToken + ")");
                        byte[] receiveData = new byte[1024];
                        while (true) {
                            try {
                                while (true) {
                                    DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
                                    serverSocket.receive(receivePacket);
                                    InetAddress IPAddress = receivePacket.getAddress();
                                    if (!InetAddress.getByName("localhost").equals(IPAddress)) {
                                        log.warn("Received Request from Non-localhost, ignoring request from: {}", (Object)IPAddress.getHostAddress());
                                        continue;
                                    }
                                    Double runtime = Double.valueOf(new String(receivePacket.getData()));
                                    currentRuntime.set(runtime.doubleValue());
                                }
                            }
                            catch (RuntimeException e) {
                                log.trace("Got some runtime exception while processing data packet", (Throwable)e);
                                continue;
                            }
                            catch (SocketException e) {
                                return;
                            }
                            catch (IOException e) {
                                log.warn("Unknown IOException occurred ", (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                };
                this.startWallclockTimer();
                final Process proc = this.runProcess(port, token);
                try {
                    outstandingRuns.add(new Pair<CommandLineAlgorithmRun, Process>(this, proc));
                    final Process innerProcess = proc;
                    final Semaphore stdErrorDone = new Semaphore(0);
                    Runnable standardErrorReader = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Thread.currentThread().setName("CLI TAE (STDERR Thread - #" + myToken + ")");
                            try {
                                try (BufferedReader procIn = new BufferedReader(new InputStreamReader(innerProcess.getErrorStream()));){
                                    do {
                                        boolean read = false;
                                        while (procIn.ready()) {
                                            read = true;
                                            String line = procIn.readLine();
                                            if (line == null) {
                                                return;
                                            }
                                            log.warn("[PROCESS-ERR]  {}", (Object)line);
                                        }
                                        if (read) continue;
                                        Thread.sleep(50L);
                                    } while (!CommandLineAlgorithmRun.this.processEnded.get());
                                    StringBuilder sb = new StringBuilder();
                                    if (procIn.ready()) {
                                        char[] input = new char[10000];
                                        procIn.read(input);
                                        sb.append(String.valueOf(input));
                                    }
                                    if (sb.toString().trim().length() > 0) {
                                        log.warn("[PROCESS-ERR] {}", (Object)sb.toString().trim());
                                    }
                                }
                                finally {
                                    stdErrorDone.release();
                                    log.trace("Standard Error Done");
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                            catch (IOException e) {
                                log.warn("Unexpected IOException occurred {}", (Throwable)e);
                            }
                        }
                    };
                    Runnable observerThread = new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setName("CLI TAE (Observer Thread - #" + myToken + ")");
                            while (true) {
                                double currentTime = (double)CommandLineAlgorithmRun.this.getCurrentWallClockTime() / 1000.0;
                                CommandLineAlgorithmRun.this.runObserver.currentStatus(Collections.singletonList(new RunningAlgorithmRunResult(CommandLineAlgorithmRun.this.runConfig, Math.max(0.0, currentRuntime.get()), 0.0, 0.0, CommandLineAlgorithmRun.this.runConfig.getProblemInstanceSeedPair().getSeed(), currentTime, CommandLineAlgorithmRun.this.killHandler)));
                                try {
                                    Thread.sleep(25L);
                                    if (CommandLineAlgorithmRun.this.killHandler.isKilled()) {
                                        CommandLineAlgorithmRun.this.wasKilled = true;
                                        log.trace("Trying to kill run: {} latest time: {} ", (Object)CommandLineAlgorithmRun.this.runConfig, (Object)currentRuntime.get());
                                        CommandLineAlgorithmRun.this.killProcess(proc);
                                        return;
                                    }
                                    Thread.sleep(CommandLineAlgorithmRun.this.observerFrequency - 25);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    return;
                                }
                            }
                        }
                    };
                    ExecutorService threadPoolExecutor = Executors.newCachedThreadPool(new SequentiallyNamedThreadFactory("Command Line Target Algorithm Evaluator Thread "));
                    try {
                        if (this.options.listenForUpdates) {
                            threadPoolExecutor.execute(socketThread);
                        }
                        threadPoolExecutor.execute(observerThread);
                        threadPoolExecutor.execute(standardErrorReader);
                        BufferedReader read = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        if (jvmShutdownDetected.get()) {
                            this.killProcess(proc);
                        }
                        try {
                            this.processRunLoop(read, proc);
                        }
                        finally {
                            this.killProcess(proc);
                        }
                        if (this.completedAlgorithmRun == null) {
                            double currentTime;
                            if (this.wasKilled) {
                                currentTime = Math.max(0.0, currentRuntime.get());
                                this.completedAlgorithmRun = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.KILLED, currentTime, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), "Killed Manually", (double)this.getCurrentWallClockTime() / 1000.0);
                            } else if (jvmShutdownDetected.get()) {
                                currentTime = Math.max(0.0, currentRuntime.get());
                                this.completedAlgorithmRun = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.KILLED, currentTime, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), "JVM Shutdown Detected", (double)this.getCurrentWallClockTime() / 1000.0);
                            } else {
                                currentTime = Math.max(0.0, currentRuntime.get());
                                this.completedAlgorithmRun = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.CRASHED, currentTime, 0.0, 0.0, this.runConfig.getProblemInstanceSeedPair().getSeed(), "ERROR: Wrapper did not output anything that matched the expected output (\"Result of algorithm run:...\"). Please try executing the wrapper directly", (double)this.getCurrentWallClockTime() / 1000.0);
                            }
                        }
                        switch (this.completedAlgorithmRun.getRunStatus()) {
                            case ABORT: 
                            case CRASHED: {
                                log.error("The following algorithm call failed: cd \"{}\" " + COMMAND_SEPERATOR + "  {} ", (Object)new File(this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory()).getAbsolutePath(), (Object)CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.runConfig));
                                if (this.outputQueue.size() > 0) {
                                    log.error("The last {} lines of output we saw were:", (Object)this.outputQueue.size());
                                    for (String s : this.outputQueue) {
                                        log.error("> " + s);
                                    }
                                    break;
                                } else {
                                    log.debug("No output on standard out detected");
                                    break;
                                }
                            }
                        }
                        this.outputQueue.clear();
                        read.close();
                        stdErrorDone.acquireUninterruptibly();
                    }
                    finally {
                        if (serverSocket != null) {
                            serverSocket.close();
                        }
                        threadPoolExecutor.shutdownNow();
                        try {
                            threadPoolExecutor.awaitTermination(24L, TimeUnit.HOURS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                finally {
                    if (proc != null) {
                        proc.destroy();
                    }
                }
                this.runObserver.currentStatus(Collections.singletonList(this.completedAlgorithmRun));
                log.debug("Run {} is completed", (Object)this.completedAlgorithmRun);
                return this.completedAlgorithmRun;
            }
            finally {
                if (!this.executionIDs.offer(token)) {
                    log.error("Developer Error: Couldn't offer run token back to pool, which violates an invariant. We will essentially block until it is accepted.");
                    try {
                        this.executionIDs.put(token);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        catch (IOException e1) {
            log.error("The following algorithm call failed: cd \"{}\" " + COMMAND_SEPERATOR + "  {} ", (Object)new File(this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory()).getAbsolutePath(), (Object)CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.runConfig));
            throw new TargetAlgorithmAbortException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRunLoop(BufferedReader procIn, Process p) {
        block15: {
            int i = 0;
            try {
                boolean matchFound = false;
                try {
                    do {
                        boolean read = false;
                        while (procIn.ready()) {
                            read = true;
                            String line = procIn.readLine();
                            if (line == null) {
                                log.trace("Process has ended");
                                this.processEnded.set(true);
                                break block15;
                            }
                            this.outputQueue.add(line);
                            if (this.outputQueue.size() > 1000) {
                                this.outputQueue.poll();
                            }
                            if (this.wasKilled) continue;
                            boolean matched = this.processLine(line);
                            if (matched && matchFound) {
                                log.error("Second output of matching line detected, there is a problem with your wrapper. You can try turning with log all process output enabled to debug: {} ", (Object)line);
                                this.completedAlgorithmRun = ExistingAlgorithmRunResult.getAbortResult(this.runConfig, "duplicate lines matched");
                                continue;
                            }
                            matchFound |= matched;
                        }
                        if (this.completedAlgorithmRun != null && this.wasKilled && this.completedAlgorithmRun.getWallclockExecutionTime() > 1.0) {
                            log.warn("Run was killed but we somehow completed this might be a race condition but our result is: {}. This is a warning just so that developers can see this having occurred and judge the correctness", (Object)this.completedAlgorithmRun.getResultLine());
                        }
                        if (!procIn.ready() && CommandLineAlgorithmRun.exited(p)) {
                            this.processEnded.set(true);
                            break;
                        }
                        if (read) continue;
                        if (++i % 12000 == 0) {
                            log.trace("Slept for 5 minutes waiting for pid {}  &&  (matching line found?: {} ) ", (Object)CommandLineAlgorithmRun.getPID(p), (Object)matchFound);
                        }
                        Thread.sleep(25L);
                    } while (!this.processEnded.get());
                }
                finally {
                    procIn.close();
                }
            }
            catch (IOException e) {
                if (!this.processEnded.get()) {
                    log.trace("IO Exception occurred while processing runs");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private Process runProcess(int port, Integer token) throws IOException {
        String[] execCmdArray = this.getTargetAlgorithmExecutionCommand(this.runConfig);
        if (this.options.logAllCallStrings()) {
            log.info("Call (with token {}) : cd \"{}\" " + COMMAND_SEPERATOR + "  {} ", new Object[]{token, new File(this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory()).getAbsolutePath(), CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.runConfig)});
        }
        ArrayList<String> envpList = new ArrayList<String>(System.getenv().size());
        for (Map.Entry<String, String> ent : System.getenv().entrySet()) {
            envpList.add(ent.getKey() + "=" + ent.getValue());
        }
        if (this.options.listenForUpdates) {
            envpList.add("AEATK_PORT=" + port);
            envpList.add("AEATK_CPU_TIME_FREQUENCY=" + (double)this.observerFrequency / 2000.0);
        }
        envpList.add("AEATK_CONCURRENT_TASK_ID=" + token);
        envpList.add(envVariableForChildren + "=" + this.uuid.toString());
        String[] envp = envpList.toArray(new String[0]);
        Process proc = Runtime.getRuntime().exec(execCmdArray, envp, new File(this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmExecutionDirectory()));
        log.debug("Process for {} started with pid: {} (Environment Variable: {})", new Object[]{this.runConfig, CommandLineAlgorithmRun.getPID(proc), this.uuid});
        return proc;
    }

    private String[] getTargetAlgorithmExecutionCommand(AlgorithmRunConfiguration runConfig) {
        AlgorithmExecutionConfiguration execConfig = runConfig.getAlgorithmExecutionConfiguration();
        String cmd = execConfig.getAlgorithmExecutable();
        String[] execCmdArray = SplitQuotedString.splitQuotedString(cmd);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(execCmdArray));
        list.add(runConfig.getProblemInstanceSeedPair().getProblemInstance().getInstanceName());
        list.add(runConfig.getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation());
        list.add(String.valueOf(runConfig.getCutoffTime()));
        list.add(String.valueOf(Integer.MAX_VALUE));
        list.add(String.valueOf(runConfig.getProblemInstanceSeedPair().getSeed()));
        ParameterConfiguration.ParameterStringFormat f = ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX;
        String valueDelimiter = this.options.paramArgumentsContainQuotes ? f.getValueDelimeter() : "";
        for (String key : runConfig.getParameterConfiguration().getActiveParameters()) {
            if (!f.getKeyValueSeperator().equals(" ") || !f.getGlue().equals(" ")) {
                throw new IllegalStateException("Key Value seperator or glue is not a space, and this means the way we handle this logic won't work currently");
            }
            list.add(f.getPreKey() + key);
            list.add(valueDelimiter + runConfig.getParameterConfiguration().get(key) + valueDelimiter);
        }
        return list.toArray(new String[0]);
    }

    public static String getTargetAlgorithmExecutionCommandAsString(AlgorithmRunConfiguration runConfig) {
        AlgorithmExecutionConfiguration execConfig = runConfig.getAlgorithmExecutionConfiguration();
        String cmd = execConfig.getAlgorithmExecutable();
        String[] execCmdArray = SplitQuotedString.splitQuotedString(cmd);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(execCmdArray));
        list.add(runConfig.getProblemInstanceSeedPair().getProblemInstance().getInstanceName());
        list.add(runConfig.getProblemInstanceSeedPair().getProblemInstance().getInstanceSpecificInformation());
        list.add(String.valueOf(runConfig.getCutoffTime()));
        list.add(String.valueOf(Integer.MAX_VALUE));
        list.add(String.valueOf(runConfig.getProblemInstanceSeedPair().getSeed()));
        ParameterConfiguration.ParameterStringFormat f = ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX;
        for (String key : runConfig.getParameterConfiguration().getActiveParameters()) {
            if (!f.getKeyValueSeperator().equals(" ") || !f.getGlue().equals(" ")) {
                throw new IllegalStateException("Key Value seperator or glue is not a space, and this means the way we handle this logic won't work currently");
            }
            list.add(f.getPreKey() + key);
            list.add(f.getValueDelimeter() + runConfig.getParameterConfiguration().get(key) + f.getValueDelimeter());
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            if (s.matches(".*\\s+.*")) {
                sb.append("\"" + s + "\"");
            } else {
                sb.append(s);
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public boolean processLine(String line) {
        Matcher matcher = pattern.matcher(line);
        Matcher matcher2 = oldPattern.matcher(line);
        String rawResultLine = "[No Matching Output Found]";
        if (this.options.logAllProcessOutput) {
            log.info("[PROCESS] {}", (Object)line);
        }
        if (matcher.find() || matcher2.find()) {
            if (this.options.logAllCallResults() && !this.options.logAllProcessOutput) {
                log.info("[PROCESS] {}", (Object)line);
            }
            String fullLine = line.trim();
            String additionalRunData = "";
            try {
                String acExecResultString = line.substring(line.indexOf(":") + 1).trim();
                String[] results = acExecResultString.split(",");
                for (int i = 0; i < results.length; ++i) {
                    results[i] = results[i].trim();
                }
                rawResultLine = acExecResultString;
                RunStatus acResult = RunStatus.getAutomaticConfiguratorResultForKey(results[0]);
                if (!acResult.permittedByWrappers()) {
                    throw new IllegalArgumentException(" The Run Result reported is NOT permitted to be output by a wrapper and is for internal SMAC use only.");
                }
                String runtime = results[1].trim();
                String runLength = results[2].trim();
                String bestSolution = results[3].trim();
                String seed = results[4].trim();
                if (results.length > 5) {
                    if (results.length == 6) {
                        additionalRunData = results[5].trim();
                    } else {
                        log.warn("Too many fields were encounted (expected 5 or 6) when parsing line (Additional Run Data cannot have commas): {}\n ", (Object)line);
                    }
                }
                double runLengthD = Double.valueOf(runLength);
                double runtimeD = Double.valueOf(runtime);
                double qualityD = Double.valueOf(bestSolution);
                long resultSeedD = Long.valueOf(seed);
                if (!MarkerFilter.log(fullProcessOutputMarker.getName())) {
                    log.info("Algorithm Reported: {}", (Object)line);
                }
                this.completedAlgorithmRun = new ExistingAlgorithmRunResult(this.runConfig, acResult, runtimeD, runLengthD, qualityD, resultSeedD, additionalRunData, (double)this.getCurrentWallClockTime() / 1000.0);
                return true;
            }
            catch (NumberFormatException e) {
                this.completedAlgorithmRun = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.CRASHED, this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime(), 0.0, 0.0, 0L, "ERROR: Couldn't parse output from wrapper (invalid number format): " + e.getMessage(), (double)this.getCurrentWallClockTime() / 1000.0);
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.runConfig), fullLine};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely one of the values of runLength, runtime, quality could not be parsed as a Double, or the seed could not be parsed as a valid long", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunStatus.CRASHED);
                return true;
            }
            catch (IllegalArgumentException e) {
                this.completedAlgorithmRun = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.CRASHED, this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime(), 0.0, 0.0, 0L, "ERROR: Couldn't parse output from wrapper (not enough arguments): " + e.getMessage(), (double)this.getCurrentWallClockTime() / 1000.0);
                ArrayList<String> validValues = new ArrayList<String>();
                for (RunStatus r : RunStatus.values()) {
                    if (!r.permittedByWrappers()) continue;
                    validValues.addAll(r.getAliases());
                }
                Collections.sort(validValues);
                Object[] validArgs = validValues.toArray(new String[0]);
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.runConfig), fullLine, Arrays.toString(validArgs)};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely the Algorithm did not report a result string as one of: {}", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunStatus.CRASHED);
                return true;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.completedAlgorithmRun = new ExistingAlgorithmRunResult(this.runConfig, RunStatus.CRASHED, this.runConfig.getAlgorithmExecutionConfiguration().getAlgorithmMaximumCutoffTime(), 0.0, 0.0, 0L, "ERROR: Couldn't parse output from wrapper (problem with arguments): " + e.getMessage(), (double)this.getCurrentWallClockTime() / 1000.0);
                Object[] args = new Object[]{CommandLineAlgorithmRun.getTargetAlgorithmExecutionCommandAsString(this.runConfig), fullLine};
                log.error("Target Algorithm Call failed:{}\nResponse:{}\nComment: Most likely the algorithm did not specify all of the required outputs that is <solved>,<runtime>,<runlength>,<quality>,<seed>", args);
                log.error("Exception that occured trying to parse result was: ", (Throwable)e);
                log.error("Run will be counted as {}", (Object)RunStatus.CRASHED);
                return true;
            }
        }
        return false;
    }

    public static int getPID(Process p) {
        int pid = 0;
        try {
            Field f = p.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            pid = Integer.valueOf(f.get(p).toString());
            f.setAccessible(false);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            return -1;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (pid > 0) {
            return pid;
        }
        return -1;
    }

    public static boolean exited(Process p) {
        try {
            p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    private String replacePid(String input, int pid) {
        return input.replaceAll("%pid", String.valueOf(pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void killProcess(Process p) {
        if (this.killPreviouslyCalled.getAndSet(true)) {
            return;
        }
        outstandingRuns.remove(new Pair<CommandLineAlgorithmRun, Process>(this, p));
        try {
            int pid;
            block48: {
                pid = CommandLineAlgorithmRun.getPID(p);
                if (this.options.pgEnvKillCommand != null && this.options.pgEnvKillCommand.trim().length() > 1) {
                    try {
                        String killEnvCmd = this.options.pgEnvKillCommand + " " + envVariableForChildren + " " + this.uuid.toString() + " " + pid;
                        ProcessBuilder pb = new ProcessBuilder(new String[0]);
                        pb.redirectErrorStream(true);
                        pb.command(SplitQuotedString.splitQuotedString(killEnvCmd));
                        Process p2 = pb.start();
                        try (BufferedReader read = new BufferedReader(new InputStreamReader(p2.getInputStream()));){
                            String line = null;
                            while ((line = read.readLine()) != null) {
                                log.trace("Kill environment {} output> {}", (Object)this.uuid.toString(), (Object)line);
                            }
                        }
                        finally {
                            p2.destroy();
                            try {
                                if (p2.waitFor() > 0) {
                                    log.warn("Kill script execution returned non-zero exit status: {} ", (Object)p2.exitValue());
                                }
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                    catch (IOException e) {
                        log.error("Error while executing {} execute Kill Environment Command", (Throwable)e);
                    }
                } else {
                    try {
                        block49: {
                            if (pid <= 0) break block48;
                            String command = this.replacePid(this.options.pgNiceKillCommand, pid);
                            log.trace("Trying to send SIGTERM to process group id: {} with command \"{}\"", (Object)pid, (Object)command);
                            try {
                                int retValPGroup = this.executeKillCommand(command);
                                if (retValPGroup > 0) {
                                    log.trace("SIGTERM to process group failed with error code {}", (Object)retValPGroup);
                                    int retVal = this.executeKillCommand(this.replacePid(this.options.procNiceKillCommand, pid));
                                    if (retVal > 0) {
                                        Object[] args = new Object[]{pid, retVal};
                                        log.trace("SIGTERM to process id: {} attempted failed with return code {}", args);
                                        break block49;
                                    } else {
                                        log.trace("SIGTERM delivered successfully to process id: {}", (Object)pid, (Object)pid);
                                    }
                                    break block49;
                                }
                                log.trace("SIGTERM delivered successfully to process group id: {} ", (Object)pid);
                            }
                            catch (IOException e) {
                                log.error("Couldn't SIGTERM process or process group ", (Throwable)e);
                            }
                        }
                        int totalSleepTime = 0;
                        int currSleepTime = 25;
                        do {
                            if (CommandLineAlgorithmRun.exited(p)) {
                                return;
                            }
                            Thread.sleep(currSleepTime);
                        } while ((totalSleepTime += (currSleepTime = (int)((double)currSleepTime * 1.5))) <= 3000);
                        log.trace("Trying to send SIGKILL to process group id: {}", (Object)pid);
                        try {
                            int retVal = this.executeKillCommand(this.replacePid(this.options.pgForceKillCommand, pid));
                            if (retVal > 0) {
                                log.trace("SIGKILL to pid: {} attempted failed with return code {}", (Object)pid, (Object)retVal);
                                int retVal3 = this.executeKillCommand(this.replacePid(this.options.procForceKillCommand, pid));
                                if (retVal3 > 0) {
                                    Object[] args = new Object[]{pid, retVal};
                                    log.trace("SIGKILL to process id: {} attempted failed with return code {}", args);
                                    break block48;
                                } else {
                                    log.trace("SIGKILL delivered successfully to process id: {}", (Object)pid, (Object)pid);
                                }
                                break block48;
                            }
                            log.trace("SIGKILL delivered successfully to pid: {} ", (Object)pid);
                        }
                        catch (IOException e) {
                            log.error("Couldn't SIGKILL process or process group ", (Throwable)e);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.processEnded.set(true);
                        this.stopWallclockTimer();
                        return;
                    }
                }
            }
            p.destroy();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("This shouldn't be possible", (Throwable)e);
            }
            if (p.exitValue() <= 0) return;
            if (p.exitValue() == 143) return;
            if (p.exitValue() == 137) return;
            if (p.exitValue() == 130) return;
            log.debug("Process with pid {} and {} signaled non-zero exit status: {}", new Object[]{pid, this.uuid.toString(), p.exitValue()});
            return;
        }
        finally {
            this.processEnded.set(true);
            this.stopWallclockTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeKillCommand(String command) throws IOException, InterruptedException {
        log.trace("Executing termination command: {}");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.redirectErrorStream(true);
        pb.command(SplitQuotedString.splitQuotedString(command));
        Process p2 = pb.start();
        try (BufferedReader read = new BufferedReader(new InputStreamReader(p2.getInputStream()));){
            String line = null;
            while ((line = read.readLine()) != null) {
                log.trace("Kill For environment {}: command \"{}\" output> {}", new Object[]{this.uuid.toString(), command, line});
            }
        }
        try {
            int n = p2.waitFor();
            return n;
        }
        finally {
            p2.destroy();
        }
    }

    static {
        if (!System.getenv().containsKey(EXECUTION_UUID_ENVIRONMENT_VARIABLE_DEFAULT)) {
            envVariableForChildren = EXECUTION_UUID_ENVIRONMENT_VARIABLE_DEFAULT;
        } else {
            int i = 0;
            while (System.getenv().containsKey("AEATK_EXECUTION_UUID_SUB_" + i++)) {
            }
            envVariableForChildren = "AEATK_EXECUTION_UUID_SUB_" + i++;
        }
        fullProcessOutputMarker = MarkerFactory.getMarker((String)LoggingMarker.FULL_PROCESS_OUTPUT.name());
        log.trace("This version of SMAC hardcodes run length for calls to the target algorithm to {}.", (Object)Integer.MAX_VALUE);
        COMMAND_SEPERATOR = System.getProperty("os.name").toLowerCase().contains("win") ? "&" : ";";
        jvmShutdownDetected = new AtomicBoolean(false);
        outstandingRuns = Collections.newSetFromMap(new ConcurrentHashMap());
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("CLI Shutdown Thread");
                jvmShutdownDetected.set(true);
                if (outstandingRuns.size() > 0) {
                    log.debug("Terminating approximately {} outstanding algorithm runs", (Object)outstandingRuns.size());
                }
                log.trace("Further runs will be instantly terminated");
                for (Pair p : outstandingRuns) {
                    ((CommandLineAlgorithmRun)p.getFirst()).killProcess((Process)p.getSecond());
                }
            }
        });
        log.trace("Shutdown hook to terminate all outstanding runs enabled");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }
}

