/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.misc.model;

import ca.ubc.cs.beta.aeatk.options.RandomForestOptions;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMACRandomForestHelper {
    private static final Logger log = LoggerFactory.getLogger(SMACRandomForestHelper.class);

    public static RegtreeBuildParams getRandomForestBuildParams(RandomForestOptions rfOptions, int numberOfFeatures, int[] categoricalSize, Map<Integer, int[][]> nameConditionsMapParentsArray, Map<Integer, double[][][]> nameConditionsMapParentsValues, Map<Integer, int[][]> nameConditionsMapOp, Random rand) {
        RegtreeBuildParams buildParams = new RegtreeBuildParams(false, rfOptions.splitMin, rfOptions.ratioFeatures, categoricalSize);
        buildParams.splitMin = rfOptions.splitMin;
        buildParams.ratioFeatures = rfOptions.ratioFeatures;
        buildParams.logModel = rfOptions.logModel == null ? 1 : (rfOptions.logModel != false ? 1 : 0);
        buildParams.storeResponses = rfOptions.storeDataInLeaves;
        buildParams.random = rand;
        buildParams.minVariance = rfOptions.minVariance;
        if (rfOptions.brokenVarianceCalculation) {
            log.warn("Model set to use broken variance calculation, this may affect performance");
            buildParams.brokenVarianceCalculation = true;
        } else {
            buildParams.brokenVarianceCalculation = false;
        }
        buildParams.catDomainSizes = new int[categoricalSize.length + numberOfFeatures];
        System.arraycopy(categoricalSize, 0, buildParams.catDomainSizes, 0, categoricalSize.length);
        if (rfOptions.ignoreConditionality) {
            buildParams.nameConditionsMapOp = null;
            buildParams.nameConditionsMapParentsArray = null;
            buildParams.nameConditionsMapParentsValues = null;
        } else {
            buildParams.nameConditionsMapOp = new HashMap<Integer, int[][]>(nameConditionsMapOp);
            buildParams.nameConditionsMapParentsArray = new HashMap<Integer, int[][]>(nameConditionsMapParentsArray);
            buildParams.nameConditionsMapParentsValues = new HashMap<Integer, double[][][]>(nameConditionsMapParentsValues);
        }
        return buildParams;
    }
}

