/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.ant.execscript;

import ca.ubc.cs.beta.aeatk.ant.execscript.ExecScriptCreatorOptions;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ExecScriptCreator {
    public static void main(String[] args) {
        ExecScriptCreatorOptions opts = new ExecScriptCreatorOptions();
        JCommander jcom = JCommanderHelper.getJCommanderAndCheckForHelp(args, opts);
        try {
            boolean created;
            File f;
            jcom.parse(args);
            if (!opts.skipClassCheck) {
                try {
                    Class.forName(opts.clazz);
                }
                catch (ClassNotFoundException e) {
                    System.out.println("Classpath is: " + System.getProperty("java.class.path"));
                    throw new ParameterException("Error locating class: " + opts.clazz + " error: " + e.getClass().getCanonicalName() + ":" + e.getMessage() + "\n Maybe try using: --skip-class-check");
                }
            }
            if ((f = new File(opts.filename).getAbsoluteFile()).isDirectory()) {
                f = new File(opts.filename + File.separator + opts.nameOfProgram).getAbsoluteFile();
            } else if (!f.getParentFile().exists() && !(created = f.getParentFile().mkdirs())) {
                throw new ParameterException("Could not create parent directory " + f.getParentFile());
            }
            String script = ExecScriptCreator.getScript(opts.clazz, opts.nameOfProgram, opts.mem, opts.printMem);
            System.out.println("Execution Script writing to: " + f);
            FileWriter fWrite = new FileWriter(f);
            fWrite.write(script);
            fWrite.close();
            if (opts.batFile) {
                boolean created2;
                String batchFile = ExecScriptCreator.getBatch(opts.clazz, opts.nameOfProgram, opts.mem, opts.printMem);
                File f2 = new File(opts.filename);
                if (f2.isDirectory()) {
                    f2 = new File(opts.filename + File.separator + opts.nameOfProgram + ".bat");
                } else if (!f2.getParentFile().exists() && !(created2 = f2.getParentFile().mkdirs())) {
                    throw new ParameterException("Could not create parent directory " + f2.getParentFile());
                }
                System.out.println("Execution Script writing to: " + f2);
                FileWriter fWrite2 = new FileWriter(f2);
                fWrite2.write(batchFile);
                fWrite2.close();
            }
        }
        catch (ParameterException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(255);
        }
        System.exit(0);
    }

    public static String getScript(String javaClassName, String nameOfProgram, int ram, boolean printMem) {
        StringBuilder sb = new StringBuilder();
        sb.append("#!/usr/bin/env bash").append("\n");
        sb.append("SMAC_MEMORY_INPUT=$SMAC_MEMORY").append("\n");
        sb.append("SMACMEM=").append(ram).append("\n");
        sb.append("test \"$SMAC_MEMORY_INPUT\" -ge 1 2>&- && SMACMEM=$SMAC_MEMORY_INPUT").append("\n");
        sb.append("EXEC=").append(javaClassName).append("\n");
        sb.append("DIR=\"$( cd \"$( dirname \"${BASH_SOURCE[0]}\" )\" && pwd )\"").append("\n");
        sb.append("if [ ! -d \"$DIR/lib\" ]; then").append("\n");
        sb.append("DIR=\"$(dirname \"$DIR\")\"").append("\n");
        sb.append("fi").append("\n");
        sb.append("LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$DIR/lib/native/:$DIR/lib/:$DIR/\n");
        sb.append("DYLD_FALLBACK_LIBRARY_PATH=$DYLD_FALLBACK_LIBRARY_PATH:$DIR/lib/native/:$DIR/lib/:$DIR/\n");
        if (printMem) {
            sb.append("echo \"Starting ").append(nameOfProgram).append(" with $SMACMEM MB of RAM\"").append("\n");
        }
        sb.append("\n");
        sb.append("for f in $DIR/lib/*.jar").append("\n");
        sb.append("do").append("\n");
        sb.append("\tjarconcat=$jarconcat:$f").append("\n");
        sb.append("done").append("\n");
        sb.append("for f in $DIR/*.jar").append("\n");
        sb.append("do").append("\n");
        sb.append("\tjarconcat=$jarconcat:$f").append("\n");
        sb.append("done").append("\n");
        sb.append("jarconcat=${jarconcat:1}\n");
        sb.append("\n");
        sb.append("exec java -Xmx\"$SMACMEM\"m -cp \"$DIR/conf/:$DIR/patches/:$jarconcat:$DIR/patches/\" ca.ubc.cs.beta.aeatk.ant.execscript.Launcher $EXEC \"$@\"").append("\n");
        return sb.toString();
    }

    public static String getBatch(String javaClassName, String nameOfProgram, int ram, boolean printMem) {
        StringBuilder sb = new StringBuilder();
        sb.append("@echo off").append("\r\n");
        sb.append("set SMACMEM=").append(ram).append("\r\n");
        sb.append("IF NOT \"%SMAC_MEMORY%\"==\"\" (set SMACMEM=%SMAC_MEMORY%)").append("\r\n");
        sb.append("set DIR=%~dp0").append("\r\n");
        sb.append("IF EXIST \"%DIR%\\lib\\\" GOTO USE_LIB").append("\r\n");
        sb.append("set DIR=%DIR%\\..\\").append("\r\n");
        sb.append(":USE_LIB").append("\r\n");
        sb.append("\r\n");
        sb.append("set EXEC=" + javaClassName).append("\r\n");
        sb.append("set jarconcat=").append("\r\n");
        sb.append("SETLOCAL ENABLEDELAYEDEXPANSION").append("\r\n");
        sb.append("for /F \"delims=\" %%a IN ('dir /b /s \"%DIR%\\*.jar\"') do set jarconcat=%%a;!jarconcat!").append("\r\n");
        sb.append("for /F \"delims=\" %%a IN ('dir /b /s \"%DIR%\\lib\\*.jar\"') do set jarconcat=%%a;!jarconcat!").append("\r\n");
        if (printMem) {
            sb.append("echo Starting " + nameOfProgram + " with %SMACMEM% MB of RAM").append("\r\n");
        }
        sb.append("java -Xmx%SMACMEM%m -cp \"%DIR%conf\\;%DIR%patches\\;%jarconcat%%DIR%patches\\ \" ca.ubc.cs.beta.aeatk.ant.execscript.Launcher %EXEC% %*").append("\r\n");
        return sb.toString();
    }
}

