/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.builder;

import ca.ubc.cs.beta.aeatk.acquisitionfunctions.AcquisitionFunctions;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.eventsystem.EventHandler;
import ca.ubc.cs.beta.aeatk.eventsystem.EventManager;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.AutomaticConfigurationEnd;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.ChallengeEndEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.ChallengeStartEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.ac.IterationStartEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.basic.AlgorithmRunCompletedEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.model.ModelBuildStartEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.events.state.StateRestoredEvent;
import ca.ubc.cs.beta.aeatk.eventsystem.handlers.LogRuntimeStatistics;
import ca.ubc.cs.beta.aeatk.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aeatk.initialization.classic.ClassicInitializationProcedure;
import ca.ubc.cs.beta.aeatk.initialization.doublingcapping.DoublingCappingInitializationProcedure;
import ca.ubc.cs.beta.aeatk.initialization.table.UnbiasChallengerInitializationProcedure;
import ca.ubc.cs.beta.aeatk.misc.cputime.CPUTime;
import ca.ubc.cs.beta.aeatk.objectives.ObjectiveHelper;
import ca.ubc.cs.beta.aeatk.objectives.OverallObjective;
import ca.ubc.cs.beta.aeatk.objectives.RunObjective;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aeatk.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPool;
import ca.ubc.cs.beta.aeatk.random.SeedableRandomPoolConstants;
import ca.ubc.cs.beta.aeatk.runhistory.FileSharingRunHistoryDecorator;
import ca.ubc.cs.beta.aeatk.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.TeeRunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aeatk.runhistory.ThreadSafeRunHistoryWrapper;
import ca.ubc.cs.beta.aeatk.smac.ExecutionMode;
import ca.ubc.cs.beta.aeatk.smac.SMACOptions;
import ca.ubc.cs.beta.aeatk.state.StateDeserializer;
import ca.ubc.cs.beta.aeatk.state.StateFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.helpers.TargetAlgorithmEvaluatorNotifyTerminationCondition;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource.caching.runhistory.RunHistoryCachingTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.termination.CompositeTerminationCondition;
import ca.ubc.cs.beta.aeatk.termination.TerminationCondition;
import ca.ubc.cs.beta.aeatk.trajectoryfile.TrajectoryFileLogger;
import ca.ubc.cs.beta.smac.builder.TAEWrapper;
import ca.ubc.cs.beta.smac.configurator.AbstractAlgorithmFramework;
import ca.ubc.cs.beta.smac.configurator.SequentialModelBasedAlgorithmConfiguration;
import ca.ubc.cs.beta.smac.handler.ChallengePredictionHandler;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMACBuilder {
    private static transient Logger log = LoggerFactory.getLogger(SMACBuilder.class);
    private final EventManager eventManager;
    private volatile TrajectoryFileLogger tLog;
    private volatile LogRuntimeStatistics logRT;
    public volatile TAEWrapper taeWrapper = new TAEWrapper(){

        @Override
        public TargetAlgorithmEvaluator wrap(TargetAlgorithmEvaluator tae) {
            return tae;
        }
    };

    public SMACBuilder() {
        this.eventManager = new EventManager();
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public AbstractAlgorithmFramework getAutomaticConfigurator(AlgorithmExecutionConfiguration execConfig, InstanceListWithSeeds trainingILWS, SMACOptions options, Map<String, AbstractOptions> taeOptions, String outputDir, SeedableRandomPool pool) {
        return this.getAutomaticConfigurator(execConfig, trainingILWS, options, taeOptions, outputDir, pool, null, null);
    }

    public AbstractAlgorithmFramework getAutomaticConfigurator(AlgorithmExecutionConfiguration execConfig, InstanceListWithSeeds trainingILWS, SMACOptions options, Map<String, AbstractOptions> taeOptions, String outputDir, SeedableRandomPool pool, TargetAlgorithmEvaluator oTAE, RunHistory oRHModel) {
        AbstractAlgorithmFramework smac;
        ClassicInitializationProcedure initProc;
        ThreadSafeRunHistoryWrapper rh;
        ParameterConfigurationSpace configSpace;
        double configSpaceSize;
        CPUTime cpuTime = new CPUTime();
        StateFactory restoreSF = options.getRestoreStateFactory(outputDir);
        if (options.adaptiveCapping == null) {
            switch (options.scenarioConfig.getRunObjective()) {
                case RUNTIME: {
                    options.adaptiveCapping = true;
                    break;
                }
                case QUALITY: {
                    options.adaptiveCapping = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Not sure what to default too");
                }
            }
        }
        if (options.randomForestOptions.logModel == null) {
            switch (options.scenarioConfig.getRunObjective()) {
                case RUNTIME: {
                    options.randomForestOptions.logModel = true;
                    break;
                }
                case QUALITY: {
                    options.randomForestOptions.logModel = false;
                }
                default: {
                    throw new IllegalStateException("Not sure what to default too");
                }
            }
        }
        if (Double.isInfinite(configSpaceSize = (configSpace = execConfig.getParameterConfigurationSpace()).getUpperBoundOnSize())) {
            log.debug("Configuration Space has at least one continuous parameter or is very large (only bound expressible in IEEE 754 format is Infinity)");
        } else {
            log.debug("Configuration Space size is at most {}", (Object)configSpace.getUpperBoundOnSize());
        }
        StateFactory sf = options.getSaveStateFactory(outputDir);
        List instances = trainingILWS.getInstances();
        InstanceSeedGenerator instanceSeedGen = trainingILWS.getSeedGen();
        options.checkProblemInstancesCompatibleWithVerifySAT(instances);
        ParameterConfiguration initialIncumbent = configSpace.getParameterConfigurationFromString(options.initialIncumbent, ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX, pool.getRandom((Enum)SeedableRandomPoolConstants.INITIAL_INCUMBENT_SELECTION));
        List initialChallengers = configSpace.getParameterConfigurationsFromList(options.initialChallengers, ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX, pool.getRandom((Enum)SeedableRandomPoolConstants.INITIAL_INCUMBENT_SELECTION));
        if (!initialIncumbent.equals((Object)configSpace.getDefaultConfiguration())) {
            log.debug("Initial Incumbent set to \"{}\" ", (Object)initialIncumbent.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
        } else {
            log.debug("Initial Incumbent is the default \"{}\" ", (Object)initialIncumbent.getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_SYNTAX));
        }
        if (initialChallengers.size() > 0) {
            log.info("Specified {} initial challengers.", (Object)initialChallengers.size());
        }
        SMACBuilder.validateObjectiveCombinations(options.scenarioConfig, options.adaptiveCapping);
        TargetAlgorithmEvaluator tae = oTAE == null ? options.scenarioConfig.algoExecOptions.taeOpts.getTargetAlgorithmEvaluator(taeOptions, outputDir, options.seedOptions.numRun) : oTAE;
        NewRunHistory rhROAR = new NewRunHistory(options.scenarioConfig.getIntraInstanceObjective(), options.scenarioConfig.interInstanceObj, options.scenarioConfig.getRunObjective());
        ThreadSafeRunHistoryWrapper rhModel = oRHModel == null ? new ThreadSafeRunHistoryWrapper((RunHistory)new NewRunHistory(options.scenarioConfig.getIntraInstanceObjective(), options.scenarioConfig.interInstanceObj, options.scenarioConfig.getRunObjective())) : new ThreadSafeRunHistoryWrapper(oRHModel);
        switch (options.execMode) {
            case SMAC: {
                options.warmStartOptions.getWarmStartState(configSpace, instances, execConfig, (RunHistory)rhModel);
                break;
            }
            case ROAR: {
                break;
            }
            default: {
                throw new IllegalStateException("Execution Mode Not Supported at this time");
            }
        }
        if (rhModel.getAlgorithmRunsExcludingRedundant().size() == 0 && !options.shareModelMode) {
            rhModel = rh = new ThreadSafeRunHistoryWrapper((RunHistory)new FileSharingRunHistoryDecorator((RunHistory)rhROAR, new File(outputDir), options.seedOptions.numRun, instances, options.shareRunDataFrequency * 1000, options.shareModelMode, options.sharedModeModeAssymetricMode, options.defaultHandler, options.writeRunData));
            log.debug("No warm started data, and shared model mode is false using single run data object");
        } else {
            rhModel = new FileSharingRunHistoryDecorator((RunHistory)rhModel, new File(outputDir), options.seedOptions.numRun, instances, options.shareRunDataFrequency * 1000, options.shareModelMode, options.sharedModeModeAssymetricMode, options.defaultHandler, options.writeRunData);
            rh = new ThreadSafeRunHistoryWrapper((RunHistory)new TeeRunHistory((RunHistory)rhROAR, (RunHistory)rhModel));
        }
        if (options.shareModelMode && options.shareModeModeTAE) {
            tae = new RunHistoryCachingTargetAlgorithmEvaluatorDecorator(tae, (ThreadSafeRunHistory)rhModel);
        }
        tae = this.taeWrapper.wrap(tae);
        CompositeTerminationCondition termCond = options.scenarioConfig.limitOptions.getTerminationConditions(cpuTime);
        this.tLog = new TrajectoryFileLogger((RunHistory)rh, (TerminationCondition)termCond, outputDir + File.separator + "traj-run-" + options.seedOptions.numRun, initialIncumbent, cpuTime);
        this.eventManager.registerHandler(IncumbentPerformanceChangeEvent.class, (EventHandler)this.tLog);
        this.eventManager.registerHandler(AutomaticConfigurationEnd.class, (EventHandler)this.tLog);
        this.eventManager.registerHandler(ModelBuildStartEvent.class, (EventHandler)this.tLog);
        this.eventManager.registerHandler(ModelBuildEndEvent.class, (EventHandler)this.tLog);
        HashSet<Class> onEvents = new HashSet<Class>();
        onEvents.add(IterationStartEvent.class);
        onEvents.add(AutomaticConfigurationEnd.class);
        this.logRT = new LogRuntimeStatistics((ThreadSafeRunHistory)rh, (TerminationCondition)termCond, execConfig.getAlgorithmMaximumCutoffTime(), tae, false, cpuTime, onEvents);
        termCond.registerWithEventManager(this.eventManager);
        this.eventManager.registerHandler(ModelBuildStartEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(IncumbentPerformanceChangeEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(AlgorithmRunCompletedEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(AutomaticConfigurationEnd.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(StateRestoredEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(ChallengeStartEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(ChallengeEndEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(IterationStartEvent.class, (EventHandler)this.logRT);
        ParamConfigurationOriginTracker configTracker = options.trackingOptions.getTracker(this.eventManager, initialIncumbent, outputDir, (ThreadSafeRunHistory)rh, execConfig, options.seedOptions.numRun);
        TargetAlgorithmEvaluatorNotifyTerminationCondition acTae = new TargetAlgorithmEvaluatorNotifyTerminationCondition(tae, this.eventManager, (TerminationCondition)termCond, true);
        ObjectiveHelper objHelper = new ObjectiveHelper(options.scenarioConfig.getRunObjective(), options.scenarioConfig.getIntraInstanceObjective(), options.scenarioConfig.interInstanceObj, execConfig.getAlgorithmMaximumCutoffTime());
        switch (options.initializationMode) {
            case CLASSIC: {
                initProc = new ClassicInitializationProcedure((ThreadSafeRunHistory)rh, initialIncumbent, (TargetAlgorithmEvaluator)acTae, options.classicInitModeOpts, instanceSeedGen, instances, options.maxIncumbentRuns, (TerminationCondition)termCond, execConfig.getAlgorithmMaximumCutoffTime(), pool, options.deterministicInstanceOrdering, execConfig);
                break;
            }
            case ITERATIVE_CAPPING: {
                initProc = new DoublingCappingInitializationProcedure((ThreadSafeRunHistory)rh, initialIncumbent, (TargetAlgorithmEvaluator)acTae, options.dciModeOpts, instanceSeedGen, instances, options.maxIncumbentRuns, (TerminationCondition)termCond, execConfig.getAlgorithmMaximumCutoffTime(), pool, options.deterministicInstanceOrdering, objHelper, execConfig);
                break;
            }
            case UNBIASED_TABLE: {
                initProc = new UnbiasChallengerInitializationProcedure((ThreadSafeRunHistory)rh, initialIncumbent, (TargetAlgorithmEvaluator)acTae, execConfig, options.ucip, instanceSeedGen, instances, options.maxIncumbentRuns, (TerminationCondition)termCond, execConfig.getAlgorithmMaximumCutoffTime(), pool, options.deterministicInstanceOrdering, objHelper);
                break;
            }
            default: {
                throw new IllegalStateException("Not sure what this initialization mode is");
            }
        }
        if (options.expFunc == null) {
            switch (options.scenarioConfig.getRunObjective()) {
                case RUNTIME: {
                    options.expFunc = AcquisitionFunctions.EXPONENTIAL;
                    break;
                }
                case QUALITY: {
                    options.expFunc = AcquisitionFunctions.EI;
                    break;
                }
                default: {
                    throw new IllegalStateException("Not sure what to default too");
                }
            }
        }
        switch (options.expFunc) {
            case EXPONENTIAL: {
                if (options.randomForestOptions.logModel.booleanValue()) break;
                log.warn("With log model turned off the exponential expected improvement function is not recommended, use: " + AcquisitionFunctions.EI);
                break;
            }
            case EI: {
                if (!options.randomForestOptions.logModel.booleanValue()) break;
                log.warn("With log model turned on the expected improvement function is not recommended, use: " + AcquisitionFunctions.EXPONENTIAL);
                break;
            }
            case SIMPLE: {
                log.warn("The simple acquisition function is never recommended");
                break;
            }
            case LCB: {
                break;
            }
            default: {
                throw new IllegalStateException("Not sure what to default too");
            }
        }
        switch (options.execMode) {
            case ROAR: {
                smac = new AbstractAlgorithmFramework(options, execConfig, instances, (TargetAlgorithmEvaluator)acTae, sf, configSpace, instanceSeedGen, initialIncumbent, initialChallengers, this.eventManager, (ThreadSafeRunHistory)rh, pool, termCond, configTracker, (InitializationProcedure)initProc, cpuTime);
                break;
            }
            case SMAC: {
                smac = new SequentialModelBasedAlgorithmConfiguration(options, execConfig, instances, (TargetAlgorithmEvaluator)acTae, options.expFunc.getFunction(), sf, configSpace, instanceSeedGen, initialIncumbent, initialChallengers, this.eventManager, (ThreadSafeRunHistory)rh, pool, termCond, configTracker, (InitializationProcedure)initProc, (RunHistory)rhModel, cpuTime);
                break;
            }
            case PSEL: {
                throw new ParameterException("This version of SMAC does not support " + options.execMode + " at this time");
            }
            default: {
                throw new IllegalArgumentException("Execution Mode Specified is not supported");
            }
        }
        if (options.trackingOptions.configTracking && options.execMode.equals((Object)ExecutionMode.SMAC)) {
            ChallengePredictionHandler cph = new ChallengePredictionHandler(smac, configTracker);
            this.eventManager.registerHandler(ModelBuildStartEvent.class, (EventHandler)cph);
            this.eventManager.registerHandler(ModelBuildEndEvent.class, (EventHandler)cph);
            this.eventManager.registerHandler(ChallengeStartEvent.class, (EventHandler)cph);
        }
        options.saveContextWithState(configSpace, trainingILWS, sf);
        if (options.stateOpts.restoreIteration != null) {
            this.restoreState(options, restoreSF, smac, configSpace, instances, execConfig, (RunHistory)rh);
        }
        return smac;
    }

    public TrajectoryFileLogger getTrajectoryFileLogger() {
        return this.tLog;
    }

    public LogRuntimeStatistics getLogRuntimeStatistics() {
        return this.logRT;
    }

    private void restoreState(SMACOptions options, StateFactory sf, AbstractAlgorithmFramework smac, ParameterConfigurationSpace configSpace, List<ProblemInstance> instances, AlgorithmExecutionConfiguration execConfig, RunHistory rh) {
        if (options.stateOpts.restoreIteration < 0) {
            throw new ParameterException("Iteration must be a non-negative integer");
        }
        StateDeserializer sd = sf.getStateDeserializer("it", options.stateOpts.restoreIteration.intValue(), configSpace, instances, execConfig, rh);
        smac.restoreState(sd);
    }

    private static void validateObjectiveCombinations(ScenarioOptions scenarioOptions, boolean adaptiveCapping) {
        switch (scenarioOptions.interInstanceObj) {
            case MEAN: {
                break;
            }
            default: {
                throw new ParameterException("Model does not currently support an inter-instance objective other than " + OverallObjective.MEAN);
            }
        }
        switch (scenarioOptions.getRunObjective()) {
            case RUNTIME: {
                break;
            }
            case QUALITY: {
                if (!scenarioOptions.getIntraInstanceObjective().equals((Object)OverallObjective.MEAN)) {
                    throw new ParameterException("To optimize quality you MUST use an intra-instance objective of " + OverallObjective.MEAN);
                }
                if (!adaptiveCapping) break;
                throw new ParameterException("You can only use Adaptive Capping when using " + RunObjective.RUNTIME + " as an objective");
            }
        }
    }
}

