/*
 * Decompiled with CFR 0.152.
 */
package de.unifreiburg.cs.junit;

import ca.ubc.cs.beta.models.fastrf.RandomForest;
import ca.ubc.cs.beta.models.fastrf.RegtreeBuildParams;
import com.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class RFTester {
    public static String rfDeployment = null;
    public static Long seedOffset = Math.abs(new Random().nextLong());

    @Test
    public void testRfFromCSV() throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader("test_files/mini.csv"));
        List lines = reader.readAll();
        reader.close();
        String[] header = (String[])lines.get(0);
        double[] y = new double[lines.size()];
        double[][] Theta = new double[lines.size()][];
        for (String[] line : lines) {
            for (int i = 0; i < line.length; ++i) {
                System.out.print(line[i] + " ");
            }
            System.out.println();
        }
    }

    @Test
    public void testRfPredictionForAllThetaNull() {
        double[][] allX = new double[10][1];
        for (int i = 0; i < allX.length; ++i) {
            allX[i][0] = i;
        }
        double[] y = new double[allX.length];
        for (int i = 0; i < allX.length; ++i) {
            y[i] = 10 * i;
        }
        int[][] theta_inst_idxs = new int[allX.length][2];
        for (int i = 0; i < allX.length; ++i) {
            theta_inst_idxs[i][0] = 0;
            theta_inst_idxs[i][1] = i;
        }
        RegtreeBuildParams buildParams = new RegtreeBuildParams(1, false, 1);
        int numTrees = 10;
        RandomForest rf = RandomForest.learnModel(numTrees, null, allX, theta_inst_idxs, y, buildParams);
        double[][] meanvar = RandomForest.apply(rf, allX);
        for (int i = 0; i < meanvar.length; ++i) {
            Assert.assertEquals((double)meanvar[i][0], (double)y[i], (double)1.0E-10);
        }
    }

    @Test
    public void testRfPredictionNonUniqueX() {
        double[][] allTheta = new double[1][1];
        allTheta[0][0] = 1.0;
        int modFactor = 500;
        double[][] allX = new double[1000][1];
        for (int i = 0; i < allX.length; ++i) {
            allX[i][0] = i % modFactor;
        }
        double[] y = new double[allX.length];
        for (int i = 0; i < allX.length; ++i) {
            y[i] = 10 * i;
        }
        int[][] theta_inst_idxs = new int[allX.length][2];
        for (int i = 0; i < allX.length; ++i) {
            theta_inst_idxs[i][0] = 0;
            theta_inst_idxs[i][1] = i;
        }
        RegtreeBuildParams buildParams = new RegtreeBuildParams(2, false, 1);
        int numTrees = 1;
        RandomForest rf = RandomForest.learnModel(numTrees, allTheta, allX, theta_inst_idxs, y, buildParams);
        double[][] combinedMatrixForTest = new double[theta_inst_idxs.length][2];
        for (int i = 0; i < combinedMatrixForTest.length; ++i) {
            combinedMatrixForTest[i][0] = allTheta[theta_inst_idxs[i][0]][0];
            combinedMatrixForTest[i][1] = allX[theta_inst_idxs[i][1]][0];
        }
        double[][] meanvar = RandomForest.apply(rf, combinedMatrixForTest);
        for (int i = 0; i < meanvar.length; ++i) {
            Assert.assertEquals((double)meanvar[i][0], (double)((y[i % modFactor] + y[modFactor + i % modFactor]) / 2.0), (double)1.0E-10);
        }
    }
}

