public class Orientation  {
    Vertex vect_part;
    double real_part;
    
    public Orientation( double a, double b, double c, double d ) {
	super();
	vect_part = new Vertex(a,b,c);
	real_part = d;
    }
    
    public Orientation(){
	super();
	vect_part = new Vertex();
	real_part = 0;
    }

    public double getx() { return vect_part.getx();}
    public double gety() { return vect_part.gety();}
    public double getz() { return vect_part.getz();}
    public double geta() { return real_part;}
 
    public void update(Vertex v, double r) {
	vect_part.update(v.x,v.y,v.z);
	real_part = r;
    }

    public void update(double x, double y, double z, double r) {
	vect_part.update(x,y,z);
	real_part = r;
    }

    public void buildRotate(Vertex axis, double cos_angle) {
	double	sin_half_angle;
	double	cos_half_angle;
	double	angle;
	
	//The quaternion requires half angles.
	if ( cos_angle > 1.0 ) cos_angle = 1.0;
	if ( cos_angle < -1.0 ) cos_angle = -1.0;
	angle = Math.acos(cos_angle);
	sin_half_angle = Math.sin(angle / 2);
	cos_half_angle = Math.cos(angle / 2);

	vect_part.scalar(axis, sin_half_angle );
	real_part = cos_half_angle;
    }

    public Orientation qqMul(Orientation q1, Orientation q2) {
	Orientation res = new Orientation();
	Vertex temp_v = new Vertex();
	
	res.real_part = q1.real_part * q2.real_part - q1.vect_part.dot(q2.vect_part);
	res.vect_part.cross(q1.vect_part, q2.vect_part);
	temp_v.scalar(q1.vect_part,q2.real_part);
	res.vect_part.add(temp_v,res.vect_part);
	temp_v.scalar(q2.vect_part,q1.real_part);
	res.vect_part.add(temp_v,res.vect_part);
	return res;
    }

    public Orientation quaternionToAxisAngle(Vertex axis, double angle) {
	double	half_angle;
	double	sin_half_angle;

	half_angle = Math.acos(real_part);
	sin_half_angle = Math.sin(half_angle);
	angle = half_angle * 2;
	if ( sin_half_angle < 1e-8 && sin_half_angle > -1e-8 )
	    axis.update(1,0,0);
	else {
	    sin_half_angle = 1 / sin_half_angle;
	    axis.scalar(vect_part, sin_half_angle);
	}
	return( new Orientation(axis.getx(),axis.gety(),axis.getz(),angle) );
    }

    public void convertCameraModel(Vertex pos, Vertex at, Vertex up) {
	Vertex n = new Vertex();
	Vertex v = new Vertex();
	
	Orientation rot_quat;
	Vertex norm_axis;
	Orientation norm_quat;
	Orientation inv_norm_quat = new Orientation();
	Orientation y_quat = new Orientation();
	Orientation rot_y_quat = new Orientation();
        Orientation new_y_quat;
	Vertex new_y;
	double temp_d;

	Vertex temp_v = new Vertex();

	n.sub(at,pos);
	temp_d = n.unit(n);

	temp_d = up.unit(up);
	temp_d = up.dot(n);
	temp_v.scalar(n,temp_d);
	v.sub(up,temp_v);
	temp_d = v.unit(v);

	norm_axis = new Vertex(n.y, -n.x, 0);
	if ( norm_axis.dot(norm_axis) < 1e-8 ) {
	    //Already aligned, or maybe inverted
	    if ( n.z > 0.0 )
		norm_quat = new Orientation(0,1,0,0);
	    else
		norm_quat = new Orientation(0,0,0,1);
		
	} else {
	    temp_d = norm_axis.unit(norm_axis);
	    norm_quat = new Orientation();
	    norm_quat.buildRotate(norm_axis, -n.z);
	}

	/* norm_quat now holds the rotation needed to line up the view directions.
	** We need to find the rotation to align the up vectors also.
	**
	** Need to rotate the world y vector to see where it ends up
	** Find the inverse rotation. 
	*/
	inv_norm_quat.real_part = norm_quat.real_part;
	inv_norm_quat.vect_part.scalar(norm_quat.vect_part, -1);

	//Rotate the y.
	y_quat = new Orientation(0,1,0,0);
	new_y_quat = new Orientation();
	new_y_quat = qqMul(norm_quat,y_quat);
	new_y_quat = qqMul(new_y_quat,inv_norm_quat);
	new_y = new_y_quat.vect_part;

	//Now need to find out how much to rotate about n to line up y.
	temp_v.cross(new_y, v);
	if ( temp_v.dot(temp_v) < 1.e-8 ) {
	    /* The old and new may be pointing in the same or opposite. Need
	    ** to generate a vector perpendicular to the old or new y.
	    */
	    temp_v.update(0, -v.z, v.y);
	    if ( temp_v.dot(temp_v) < 1.e-8 )
		temp_v.update(v.z, 0, -v.x);
	}
	temp_d = temp_v.unit(temp_v);
	rot_y_quat.buildRotate(temp_v, new_y.dot(v));
	
	/* rot_y_quat holds the rotation about the initial camera direction needed
	** to align the up vectors in the final position.
	**
	** Put the 2 rotations together.
	*/
	rot_quat = new Orientation();
	rot_quat = qqMul(rot_y_quat,norm_quat);
	
	//Extract the axis and angle from the quaternion.
	Orientation temp_q = new Orientation();
        temp_q = rot_quat.quaternionToAxisAngle(vect_part, real_part);
	vect_part = temp_q.vect_part;
	real_part = temp_q.real_part;
    }
}
