/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init;

import ca.ubc.cs.beta.aeatk.misc.spi.SPIClassLoaderHelper;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.base.cli.CommandLineTargetAlgorithmEvaluatorFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.init.TAEPluginSecurityManager;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetAlgorithmEvaluatorLoader {
    private static final String NO_TAES_ERROR = "WARNING: I could not find ANY Target Algorithm Evaluators on the classpath.\n If you made this JAR (or setup the classpath) yourself chances are you did not setup SPI correctly.\n You must ensure that in the JAR (or on the classpath) there is a META-INF/services/" + TargetAlgorithmEvaluatorFactory.class.getCanonicalName() + " file\n" + " \n In this file should list every implementation of that interface" + " \n\n>>>>HOW TO FIX THIS ERROR:<<<<\n" + "\n 1) If you are using Eclipse see this page (note it's spi-0.2.4 not 0.2.1.jar): https://code.google.com/p/spi/wiki/EclipseSettings" + "\n  OR \n 2) If you are using Ant/Maven ensure that the spi-0.2.4.jar is on the classpath, and annotation processing is enabled." + "\n  OR \n 3) A worse option is to make this file manually, for most cases you simply need to have the following line: " + CommandLineTargetAlgorithmEvaluatorFactory.class.getCanonicalName() + "\n\n For information on what SPI is see: http://docs.oracle.com/javase/tutorial/ext/basics/spi.html#register-service-providers" + "\n You may also want to look at the AEATK Manual / Developer Reference for more information" + "\n NOTE: I will attempt to fallback to using the CLI TAE only\n NOTE: Sleeping for 4 seconds\n";

    public static TargetAlgorithmEvaluator getTargetAlgorithmEvaluator(String name, Map<String, AbstractOptions> taeOptions) {
        Logger log = LoggerFactory.getLogger(TargetAlgorithmEvaluatorLoader.class);
        ClassLoader loader = SPIClassLoaderHelper.getClassLoader();
        Iterator<TargetAlgorithmEvaluatorFactory> taeIt = ServiceLoader.load(TargetAlgorithmEvaluatorFactory.class, loader).iterator();
        boolean noTAEs = true;
        while (taeIt.hasNext()) {
            noTAEs = false;
            try {
                TargetAlgorithmEvaluatorFactory tae = taeIt.next();
                if (tae.getName().contains(" ")) {
                    log.warn("Target Algorithm Evaluator has white space in it's name, this is a violation of the contract of {}. Sleeping for 5 seconds", (Object)TargetAlgorithmEvaluatorFactory.class.getName());
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (!tae.getName().trim().equals(name.trim())) continue;
                return tae.getTargetAlgorithmEvaluator(taeOptions);
            }
            catch (ServiceConfigurationError e) {
                log.error("Error occured while retrieving Target Algorithm Evaluator", (Throwable)e);
                e.printStackTrace();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (noTAEs) {
            CommandLineTargetAlgorithmEvaluatorFactory cfact = new CommandLineTargetAlgorithmEvaluatorFactory();
            if (name.trim().equals(cfact.getName())) {
                log.warn("No Target Algorithm Evaluators detected, see previous warning on how to fix. Falling back to " + cfact.getName() + " manually");
                return cfact.getTargetAlgorithmEvaluator(taeOptions);
            }
            log.error("No TAEs were detected, but not sure where " + name + " is, please fix as per the following: {} ", (Object)NO_TAES_ERROR);
        }
        throw new IllegalArgumentException("No Target Algorithm Evalutor found for name: " + name);
    }

    public static Map<String, AbstractOptions> getAvailableTargetAlgorithmEvaluators() {
        return TargetAlgorithmEvaluatorLoader.getAvailableTargetAlgorithmEvaluators(SPIClassLoaderHelper.getClassLoader());
    }

    /*
     * Exception decompiling
     */
    private static Map<String, AbstractOptions> getAvailableTargetAlgorithmEvaluators(ClassLoader loader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SecurityManager initSecurityManagerIfPossible() {
        SecurityManager old = System.getSecurityManager();
        try {
            System.setSecurityManager(new TAEPluginSecurityManager());
            return old;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static void resetSecurityManagerIfPossible(SecurityManager oldSecurityManager) {
        try {
            System.setSecurityManager(oldSecurityManager);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

