/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource.forking;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.concurrent.threadfactory.SequentiallyNamedThreadFactory;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorCallback;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.AbstractAsyncTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.functionality.OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.decorators.resource.forking.ForkingTargetAlgorithmEvaluatorDecoratorPolicyOptions;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkingTargetAlgorithmEvaluatorDecorator
extends AbstractAsyncTargetAlgorithmEvaluatorDecorator {
    private static final Logger log = LoggerFactory.getLogger(ForkingTargetAlgorithmEvaluatorDecorator.class);
    private final ExecutorService fSlaveSubmitterThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1, new SequentiallyNamedThreadFactory("Forking TAE Slave Submitter", true));
    private final TargetAlgorithmEvaluator fSlaveTAE;
    private final ForkingTargetAlgorithmEvaluatorDecoratorPolicyOptions fOptions;
    private final AtomicLong masterSolvesFirst = new AtomicLong(0L);
    private final AtomicLong slaveSolvesFirst = new AtomicLong(0L);
    private final AtomicLong slaveSubmits = new AtomicLong(0L);
    private final AtomicLong requests = new AtomicLong(0L);

    public ForkingTargetAlgorithmEvaluatorDecorator(TargetAlgorithmEvaluator aMasterTAE, TargetAlgorithmEvaluator aSlaveTAE, ForkingTargetAlgorithmEvaluatorDecoratorPolicyOptions fOptions) {
        super(aMasterTAE);
        this.fSlaveTAE = aSlaveTAE;
        this.fOptions = fOptions;
        if (fOptions.fPolicy == null) {
            throw new ParameterException("If you are using the --fork-to-tae option you must also set the --fork-to-tae-policy option");
        }
    }

    @Override
    public void evaluateRunsAsync(final List<AlgorithmRunConfiguration> runConfigs, final TargetAlgorithmEvaluatorCallback callback, TargetAlgorithmEvaluatorRunObserver observer) {
        List<AlgorithmRunConfiguration> slaveRunConfigurations;
        final AtomicBoolean fForkCompletionFlag = new AtomicBoolean(false);
        this.requests.addAndGet(runConfigs.size());
        TargetAlgorithmEvaluatorCallback masterForkCallback = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                if (fForkCompletionFlag.compareAndSet(false, true)) {
                    ForkingTargetAlgorithmEvaluatorDecorator.this.masterSolvesFirst.addAndGet(runConfigs.size());
                    callback.onSuccess(runs);
                }
            }

            @Override
            public void onFailure(RuntimeException e) {
                if (fForkCompletionFlag.compareAndSet(false, true)) {
                    ForkingTargetAlgorithmEvaluatorDecorator.this.masterSolvesFirst.addAndGet(runConfigs.size());
                    callback.onFailure(e);
                } else {
                    log.error("Received run failures after callback already notified.", (Throwable)e);
                }
            }
        };
        final ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunConfiguration> newToOldRunConfigurationMap = new ConcurrentHashMap<AlgorithmRunConfiguration, AlgorithmRunConfiguration>();
        switch (this.fOptions.fPolicy) {
            case DUPLICATE_ON_SLAVE: {
                slaveRunConfigurations = runConfigs;
                break;
            }
            case DUPLICATE_ON_SLAVE_QUICK: {
                slaveRunConfigurations = new ArrayList<AlgorithmRunConfiguration>();
                for (AlgorithmRunConfiguration rc : runConfigs) {
                    AlgorithmRunConfiguration newRC = new AlgorithmRunConfiguration(rc.getProblemInstanceSeedPair(), Math.min((double)this.fOptions.duplicateOnSlaveQuickTimeout, rc.getCutoffTime()), rc.getParameterConfiguration(), rc.getAlgorithmExecutionConfiguration());
                    newToOldRunConfigurationMap.put(newRC, rc);
                    slaveRunConfigurations.add(newRC);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected policy implemented, which is not supported: " + (Object)((Object)this.fOptions.fPolicy));
            }
        }
        final TargetAlgorithmEvaluatorCallback slaveForkCallback = new TargetAlgorithmEvaluatorCallback(){

            @Override
            public void onSuccess(List<AlgorithmRunResult> runs) {
                switch (((ForkingTargetAlgorithmEvaluatorDecorator)ForkingTargetAlgorithmEvaluatorDecorator.this).fOptions.fPolicy) {
                    case DUPLICATE_ON_SLAVE: {
                        if (!fForkCompletionFlag.compareAndSet(false, true)) break;
                        ForkingTargetAlgorithmEvaluatorDecorator.this.slaveSolvesFirst.addAndGet(runConfigs.size());
                        callback.onSuccess(runs);
                        break;
                    }
                    case DUPLICATE_ON_SLAVE_QUICK: {
                        ArrayList<AlgorithmRunResult> fixedRuns = new ArrayList<AlgorithmRunResult>(runs.size());
                        for (AlgorithmRunResult run : runs) {
                            if (run.isCensoredEarly()) {
                                return;
                            }
                            AlgorithmRunConfiguration oldRC = (AlgorithmRunConfiguration)newToOldRunConfigurationMap.get(run.getAlgorithmRunConfiguration());
                            fixedRuns.add(new ExistingAlgorithmRunResult(oldRC, run.getRunStatus(), run.getRuntime(), run.getRunLength(), run.getQuality(), run.getResultSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime()));
                        }
                        if (!fForkCompletionFlag.compareAndSet(false, true)) break;
                        ForkingTargetAlgorithmEvaluatorDecorator.this.slaveSolvesFirst.addAndGet(runConfigs.size());
                        callback.onSuccess(fixedRuns);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected policy implemented, which is not supported: " + (Object)((Object)((ForkingTargetAlgorithmEvaluatorDecorator)ForkingTargetAlgorithmEvaluatorDecorator.this).fOptions.fPolicy));
                    }
                }
            }

            @Override
            public void onFailure(RuntimeException e) {
                if (fForkCompletionFlag.compareAndSet(false, true)) {
                    ForkingTargetAlgorithmEvaluatorDecorator.this.slaveSolvesFirst.addAndGet(runConfigs.size());
                    callback.onFailure(e);
                } else {
                    log.error("Received run failures after callback already notified.", (Throwable)e);
                }
            }
        };
        final TargetAlgorithmEvaluatorRunObserver forkObserver = new TargetAlgorithmEvaluatorRunObserver(){

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (fForkCompletionFlag.get()) {
                    for (AlgorithmRunResult algorithmRunResult : runs) {
                        algorithmRunResult.kill();
                    }
                }
            }
        };
        this.fSlaveSubmitterThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                if (!fForkCompletionFlag.get()) {
                    ForkingTargetAlgorithmEvaluatorDecorator.this.slaveSubmits.addAndGet(runConfigs.size());
                    ForkingTargetAlgorithmEvaluatorDecorator.this.fSlaveTAE.evaluateRunsAsync(slaveRunConfigurations, slaveForkCallback, forkObserver);
                }
            }
        });
        this.tae.evaluateRunsAsync(runConfigs, masterForkCallback, forkObserver);
    }

    @Override
    public boolean isRunFinal() {
        return this.tae.isRunFinal() && this.fSlaveTAE.isRunFinal();
    }

    @Override
    public boolean areRunsPersisted() {
        return this.tae.areRunsPersisted() && this.fSlaveTAE.areRunsPersisted();
    }

    @Override
    public boolean areRunsObservable() {
        return false;
    }

    @Override
    protected void postDecorateeNotifyShutdown() {
        try {
            this.fSlaveSubmitterThreadPool.shutdownNow();
            try {
                if (!this.fSlaveSubmitterThreadPool.awaitTermination(1L, TimeUnit.MINUTES)) {
                    log.warn("Trying to shutdown slave Target Algorithm Evaluator, no response after 1 minute will wait up to two hours before continuing");
                }
                if (!this.fSlaveSubmitterThreadPool.awaitTermination(59L, TimeUnit.MINUTES)) {
                    log.warn("Slave TAE submitter thread pool did not terminate after one hour, will wait one more hour");
                }
                if (!this.fSlaveSubmitterThreadPool.awaitTermination(60L, TimeUnit.MINUTES)) {
                    log.error("Slave TAE submitter thread pool did not terminate in 120 minutes.");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                this.fSlaveTAE.notifyShutdown();
            }
            catch (RuntimeException e) {
                log.warn("Slave Target Algorithm Evaluator did not shutdown correctly, this may or may not be because of outstanding runs still executing. This message may possibly be benign", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            log.info("Fork Target Algorithm Evaluator Statistics: Requests: {}, Master Solves First: {}, Slave Solves First: {}, Slave Submits: {}", new Object[]{this.requests.get(), this.masterSolvesFirst.get(), this.slaveSolvesFirst.get(), this.slaveSubmits.get()});
            throw throwable;
        }
        log.info("Fork Target Algorithm Evaluator Statistics: Requests: {}, Master Solves First: {}, Slave Solves First: {}, Slave Submits: {}", new Object[]{this.requests.get(), this.masterSolvesFirst.get(), this.slaveSolvesFirst.get(), this.slaveSubmits.get()});
    }

    public void throwException() {
        throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does NOT support waiting/observing/reporting the number of outstanding evaluations. This is because this Target Algorithm Evaluator may schedule runs internally that should not be " + "apparent to outside observers. You should rewrap this class with an instance of " + OutstandingEvaluationsTargetAlgorithmEvaluatorDecorator.class.getCanonicalName());
    }

    @Override
    public void waitForOutstandingEvaluations() {
        this.throwException();
    }

    @Override
    public int getNumberOfOutstandingEvaluations() {
        this.throwException();
        return -1;
    }

    @Override
    public int getNumberOfOutstandingRuns() {
        this.throwException();
        return -1;
    }

    @Override
    public int getNumberOfOutstandingBatches() {
        this.throwException();
        return -1;
    }

    @Override
    public int getRunCount() {
        this.throwException();
        return -1;
    }
}

