/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.runhistory;

import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.ExistingAlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.exceptions.DuplicateRunException;
import ca.ubc.cs.beta.aeatk.misc.MapList;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.runhistory.AbstractRunHistoryDecorator;
import ca.ubc.cs.beta.aeatk.runhistory.RunHistory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ReindexSeedRunHistoryDecorator
extends AbstractRunHistoryDecorator
implements RunHistory {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Random rand;
    private final Map<ProblemInstanceSeedPair, ProblemInstanceSeedPair> pispTransform = new HashMap<ProblemInstanceSeedPair, ProblemInstanceSeedPair>();
    private final MapList<ProblemInstance, ProblemInstanceSeedPair> mpi = new MapList(new HashMap());
    AtomicInteger nextSeed = new AtomicInteger(0);
    AtomicInteger duplicateRunsDropped = new AtomicInteger(0);

    public ReindexSeedRunHistoryDecorator(RunHistory rh, Random rand) {
        super(rh);
        this.rand = rand;
    }

    @Override
    public void append(AlgorithmRunResult run) throws DuplicateRunException {
        ProblemInstanceSeedPair pisp = run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair();
        if (run.getAlgorithmRunConfiguration().getParameterConfiguration().getParameterConfigurationSpace().getDefaultConfiguration().equals(run.getAlgorithmRunConfiguration().getParameterConfiguration())) {
            this.log.trace("Transforming run of default configuration {}", (Object)run);
        }
        if (this.pispTransform.get(pisp) != null) {
            AlgorithmRunConfiguration newRc = new AlgorithmRunConfiguration(this.pispTransform.get(pisp), run.getAlgorithmRunConfiguration().getCutoffTime(), run.getAlgorithmRunConfiguration().getParameterConfiguration(), run.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration());
            ExistingAlgorithmRunResult er = new ExistingAlgorithmRunResult(newRc, run.getRunStatus(), run.getRuntime(), run.getRunLength(), run.getQuality(), this.pispTransform.get(pisp).getSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
            try {
                this.rh.append(er);
                return;
            }
            catch (DuplicateRunException e) {
                this.log.trace("Duplicate run has been dropped, so far: {} ", (Object)this.duplicateRunsDropped.incrementAndGet());
            }
        } else {
            ArrayList<ProblemInstanceSeedPair> possiblePisps = new ArrayList<ProblemInstanceSeedPair>(this.mpi.getList(pisp.getProblemInstance()));
            Collections.shuffle(possiblePisps, this.rand);
            for (ProblemInstanceSeedPair newPisp : possiblePisps) {
                AlgorithmRunConfiguration newRc = new AlgorithmRunConfiguration(newPisp, run.getAlgorithmRunConfiguration().getCutoffTime(), run.getAlgorithmRunConfiguration().getParameterConfiguration(), run.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration());
                ExistingAlgorithmRunResult er = new ExistingAlgorithmRunResult(newRc, run.getRunStatus(), run.getRuntime(), run.getRunLength(), run.getQuality(), newPisp.getSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
                try {
                    this.rh.append(er);
                    this.pispTransform.put(pisp, newPisp);
                    return;
                }
                catch (DuplicateRunException duplicateRunException) {
                }
            }
            ProblemInstanceSeedPair newPisp = new ProblemInstanceSeedPair(pisp.getProblemInstance(), this.nextSeed.incrementAndGet());
            AlgorithmRunConfiguration newRc = new AlgorithmRunConfiguration(newPisp, run.getAlgorithmRunConfiguration().getCutoffTime(), run.getAlgorithmRunConfiguration().getParameterConfiguration(), run.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration());
            ExistingAlgorithmRunResult er = new ExistingAlgorithmRunResult(newRc, run.getRunStatus(), run.getRuntime(), run.getRunLength(), run.getQuality(), newPisp.getSeed(), run.getAdditionalRunData(), run.getWallclockExecutionTime());
            try {
                this.rh.append(er);
                this.pispTransform.put(pisp, newPisp);
                return;
            }
            catch (DuplicateRunException e) {
                this.log.trace("Duplicate run has been dropped, so far: {} ", (Object)this.duplicateRunsDropped.incrementAndGet());
            }
        }
    }

    @Override
    public int getOrCreateThetaIdx(ParameterConfiguration initialIncumbent) {
        return this.rh.getOrCreateThetaIdx(initialIncumbent);
    }
}

