/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.logging;

import ca.ubc.cs.beta.aeatk.logging.LogLevel;
import ca.ubc.cs.beta.aeatk.misc.options.CommandLineOnly;
import ca.ubc.cs.beta.aeatk.misc.options.OptionLevel;
import ca.ubc.cs.beta.aeatk.misc.options.UsageTextField;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import com.beust.jcommander.Parameter;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsageTextField(hiddenSection=true)
public class ExplicitLogFileLoggingOptions
extends AbstractOptions {
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.INTERMEDIATE)
    @Parameter(names={"--console-log-level", "--consoleLogLevel"}, description="default log level of console output (this cannot be more verbose than the logLevel)")
    public LogLevel consoleLogLevel = LogLevel.INFO;
    @CommandLineOnly
    @UsageTextField(level=OptionLevel.INTERMEDIATE)
    @Parameter(names={"--log-level", "--logLevel"}, description="messages will only be logged if they are of this severity or higher.")
    public LogLevel logLevel = LogLevel.INFO;
    public boolean suppressLogLevelConsistencyWarning = false;

    public void initializeLogging(String completeOutputDir, String filename) {
        Logger log;
        if (completeOutputDir == null) {
            completeOutputDir = new File("").getAbsolutePath();
        }
        System.setProperty("LOGLEVEL", this.logLevel.name());
        System.setProperty("OUTPUTDIR", completeOutputDir);
        System.setProperty("STDOUT-LEVEL", this.consoleLogLevel.name());
        System.setProperty("ROOT-LEVEL", this.logLevel.name());
        String logLocation = completeOutputDir + File.separator + filename;
        System.setProperty("RUNLOG", logLocation);
        if (System.getProperty("logback.configurationFile") != null) {
            log = LoggerFactory.getLogger(this.getClass());
            log.debug("System property for logback.configurationFile has been found already set as {} , logging will follow this file", (Object)System.getProperty("logback.configurationFile"));
        } else {
            String newXML = this.getClass().getPackage().getName().replace(".", "/") + "/" + "singlefile-logback.xml";
            System.setProperty("logback.configurationFile", newXML);
            Logger log2 = LoggerFactory.getLogger(this.getClass());
            if (log2.isTraceEnabled()) {
                log2.trace("Logging initialized to use file:" + newXML);
            } else {
                log2.debug("Logging initialized");
            }
        }
        log = LoggerFactory.getLogger(ExplicitLogFileLoggingOptions.class);
        log.info("Logging to: {}", (Object)logLocation);
        if (!this.suppressLogLevelConsistencyWarning && this.logLevel.lessVerbose(this.consoleLogLevel)) {
            log.warn("The console has been set to be more verbose than the log. This is generally an error, except if you have modified the logback.xml to have certain loggers be more specific");
        }
    }
}

