/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.pcscheck;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.example.pcscheck.PCSCheckOptions;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.misc.watch.AutoStartStopWatch;
import ca.ubc.cs.beta.aeatk.options.AbstractOptions;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfigurationSpace;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluatorRunObserver;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import ec.util.MersenneTwister;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCSCheckExecutor {
    private static Logger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PCSCheckOptions mainOptions = new PCSCheckOptions();
        Map<String, AbstractOptions> taeOptions = mainOptions.scenOptions.algoExecOptions.taeOpts.getAvailableTargetAlgorithmEvaluators();
        try {
            try {
                JCommander jcom;
                try {
                    jcom = JCommanderHelper.parseCheckingForHelpAndVersion(args, mainOptions, taeOptions);
                }
                catch (ParameterException e) {
                    ArrayList<String> lists = new ArrayList<String>(Arrays.asList(args));
                    lists.add("--algo-exec");
                    lists.add("foobar");
                    try {
                        jcom = JCommanderHelper.parseCheckingForHelpAndVersion(lists.toArray(new String[0]), mainOptions, taeOptions);
                    }
                    catch (RuntimeException e2) {
                        throw e;
                    }
                }
                mainOptions.logOpts.initializeLogging();
            }
            finally {
                log = LoggerFactory.getLogger(PCSCheckExecutor.class);
            }
            AlgorithmExecutionConfiguration execConfig = mainOptions.scenOptions.algoExecOptions.getAlgorithmExecutionConfigSkipDirCheck();
            ParameterConfigurationSpace configSpace = execConfig.getParameterConfigurationSpace();
            MersenneTwister configSpacePRNG = new MersenneTwister(mainOptions.configSeed);
            ParameterConfiguration config = configSpace.getParameterConfigurationFromString(mainOptions.config, ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX, configSpacePRNG);
            for (Map.Entry<String, String> entry : mainOptions.configSettingsToOverride.entrySet()) {
                config.put(entry.getKey(), entry.getValue());
            }
            log.info("PCS file parsed Successfully estimated sized is in [" + configSpace.getLowerBoundOnSize() + "," + configSpace.getUpperBoundOnSize() + "]");
            log.info("Supplied configuration {} is {}forbidden", (Object)config.getFormattedParameterString(), (Object)(config.isForbiddenParameterConfiguration() ? "" : "NOT "));
            if (configSpace.getForbiddenOrdinalAndCategoricalValues().size() > 0) {
                log.info("Values of categorical and ordinal parameter values are: {}", configSpace.getForbiddenOrdinalAndCategoricalValues());
            }
            AutoStartStopWatch watch = new AutoStartStopWatch();
            int i = 0;
            while (watch.time() < 1000L) {
                configSpace.getRandomParameterConfiguration(configSpacePRNG);
                ++i;
            }
            if (i > 100) {
                log.info("In 1000 ms was able to generate {} configurations", (Object)i);
            } else {
                log.warn("In 1000 ms only able to generate {} configurations you might find that random generation involves a lot of overhead", (Object)i);
            }
        }
        catch (ParameterException | IllegalArgumentException e) {
            log.error(e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Stack trace:", e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processRunConfig(AlgorithmRunConfiguration runConfig, TargetAlgorithmEvaluator tae, final double killTime) {
        TargetAlgorithmEvaluatorRunObserver runStatus = new TargetAlgorithmEvaluatorRunObserver(){
            private long lastUpdate = 0L;

            @Override
            public void currentStatus(List<? extends AlgorithmRunResult> runs) {
                if (System.currentTimeMillis() - this.lastUpdate < 1000L) {
                    return;
                }
                for (int i = 0; i < runs.size(); ++i) {
                    AlgorithmRunResult run = runs.get(i);
                    Object[] logArguments = new Object[]{i, run.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance(), run.getRunStatus(), run.getRuntime()};
                    log.info("Run {} on {} has status =>  {}, {}", logArguments);
                    if (!(run.getRuntime() > killTime)) continue;
                    log.info("Dynamically killing run");
                    run.kill();
                }
                this.lastUpdate = System.currentTimeMillis();
            }
        };
        List<AlgorithmRunResult> runResults = tae.evaluateRun(Collections.singletonList(runConfig), runStatus);
        log.info("Run Completed");
        for (int i = 0; i < runResults.size(); ++i) {
            AlgorithmRunResult run = runResults.get(i);
            AlgorithmRunConfiguration resultRunConfig = run.getAlgorithmRunConfiguration();
            RunStatus runResult = run.getRunStatus();
            double runtime = run.getRuntime();
            double runLength = run.getRunLength();
            double quality = run.getQuality();
            long resultSeed = run.getResultSeed();
            long requestSeed = resultRunConfig.getProblemInstanceSeedPair().getSeed();
            String additionalData = run.getAdditionalRunData();
            if (resultSeed != requestSeed) {
                log.error("Algorithm Run Result does not have a matching seed, requested: {} , returned: {}", (Object)resultSeed, (Object)requestSeed);
            }
            String configString = resultRunConfig.getParameterConfiguration().getFormattedParameterString(ParameterConfiguration.ParameterStringFormat.NODB_OR_STATEFILE_SYNTAX);
            Object[] logArguments = new Object[]{i, resultRunConfig.getProblemInstanceSeedPair().getProblemInstance(), configString, runResult, runtime, runLength, quality, resultSeed, additionalData};
            log.info("Run {} on {} with config: {} had the result => {}, {}, {}, {}, {}, {}", logArguments);
        }
    }

    private static void printJSON(AlgorithmRunConfiguration runConfig) {
        ArrayList<AlgorithmRunConfiguration> rcs = new ArrayList<AlgorithmRunConfiguration>();
        rcs.add(runConfig);
        ObjectMapper map = new ObjectMapper();
        JsonFactory factory = new JsonFactory();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
            map.configure(SerializationFeature.INDENT_OUTPUT, true);
            map.registerModule((Module)sModule);
            factory.setCodec((ObjectCodec)map);
            JsonGenerator g = factory.createGenerator((OutputStream)bout);
            g.writeObject(rcs);
            g.flush();
            log.info("----====[JSON Representation of Run Configuration]====-----:\n\n{}\n\n", (Object)bout.toString("UTF-8"));
        }
        catch (IOException e) {
            log.error("Unexpected Exception: ", (Throwable)e);
        }
    }
}

