/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.example.evaluator;

import au.com.bytecode.opencsv.CSVWriter;
import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.example.evaluator.TAEEvaluatorOptions;
import ca.ubc.cs.beta.aeatk.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import ca.ubc.cs.beta.aeatk.probleminstance.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.experimental.queuefacade.basic.BasicTargetAlgorithmEvaluatorQueue;
import ca.ubc.cs.beta.aeatk.targetalgorithmevaluator.experimental.queuefacade.basic.BasicTargetAlgorithmEvaluatorQueueResultContext;
import com.beust.jcommander.ParameterException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TAEEvaluator {
    private static Logger log;
    private static OutputStream bout;
    private static PrintStream old;

    public static void main(String[] args) {
        TAEEvaluatorOptions options = new TAEEvaluatorOptions();
        try {
            JCommanderHelper.parseCheckingForHelpAndVersion(args, options, options.fAvailableTAEOptions);
        }
        catch (ParameterException e) {
            throw e;
        }
        finally {
            options.fLoggingOptions.initializeLogging();
            log = LoggerFactory.getLogger(TAEEvaluator.class);
        }
        log.info("Setting up report file.");
        String reportFilename = options.fExperimentDir + File.separator + options.getOuputFileName();
        switch (options.fReportType) {
            case JSON: {
                reportFilename = reportFilename + ".json";
                break;
            }
            case CSV: {
                reportFilename = reportFilename + ".csv";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized output report type " + (Object)((Object)options.fReportType) + ".");
            }
        }
        if (!options.fOverwriteReport && !TAEEvaluator.checkIfOverwrite(reportFilename)) {
            log.info("Cannot overwrite currently existing report at \"{}\".", (Object)reportFilename);
            return;
        }
        try (TargetAlgorithmEvaluator aTAE = options.getTAE();){
            BasicTargetAlgorithmEvaluatorQueueResultContext aRunContext;
            InstanceListWithSeeds instancesGen;
            BasicTargetAlgorithmEvaluatorQueue aTAEQueue = new BasicTargetAlgorithmEvaluatorQueue(aTAE, true);
            AlgorithmExecutionConfiguration aExecConfig = options.fAlgorithmExecutionOptions.getAlgorithmExecutionConfig();
            ParameterConfiguration aConfiguration = options.getConfiguration();
            try {
                instancesGen = options.fProblemInstanceOptions.getTrainingProblemInstances(options.fExperimentDir, options.fSeed, options.fAlgorithmExecutionOptions.deterministic, true, false);
            }
            catch (IOException e) {
                log.error("Error while reading instances from file:", (Throwable)e);
                throw new IllegalStateException("Could not read instances from file.");
            }
            List<ProblemInstance> instances = instancesGen.getInstances();
            InstanceSeedGenerator seedGen = instancesGen.getSeedGen();
            log.info("Submitting instance executions...");
            ArrayList<AlgorithmRunConfiguration> aRunConfigs = new ArrayList<AlgorithmRunConfiguration>(instances.size());
            int aInstanceIndex = 1;
            for (ProblemInstance instance : instances) {
                log.info("Creating instance submission {}/{}.", (Object)aInstanceIndex++, (Object)instances.size());
                log.info(instance.getInstanceName());
                ProblemInstanceSeedPair aPISP = new ProblemInstanceSeedPair(instance, seedGen.getNextSeed(instance));
                AlgorithmRunConfiguration aRunConfig = new AlgorithmRunConfiguration(aPISP, options.fCutoff, aConfiguration, aExecConfig);
                aRunConfigs.add(aRunConfig);
            }
            log.info("...done.");
            log.info("Submitting {} runs asynchronously.", (Object)aRunConfigs.size());
            aTAEQueue.evaluateRunAsync(aRunConfigs);
            if (options.fExitAfterSubmission) {
                log.info("Exiting after submission, goodbye!");
                return;
            }
            log.info("Taking results from TAE queue.");
            log.info("Waiting for the completed batch from the queue...");
            try {
                aRunContext = aTAEQueue.take();
            }
            catch (InterruptedException e) {
                log.error("There was an interruption while polling a run from the TAE queue:.", (Throwable)e);
                throw new IllegalStateException("Could not poll from the TAE queue.");
            }
            log.info("Got the batch.");
            List<AlgorithmRunResult> aRuns = aRunContext.getAlgorithmRuns();
            if (aRuns.size() != aRunConfigs.size()) {
                throw new IllegalStateException("Got " + aRuns.size() + " runs back, but submitted " + aRunConfigs.size() + ".");
            }
            log.info("Writing results to file.");
            switch (options.fReportType) {
                case JSON: {
                    TAEEvaluator.writeJSONRuns(aRuns, reportFilename);
                    break;
                }
                case CSV: {
                    TAEEvaluator.writeCSVRuns(aRuns, reportFilename, options);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized output report type " + (Object)((Object)options.fReportType) + ".");
                }
            }
            log.info("Report written to \"{}\".", (Object)reportFilename);
        }
    }

    private static synchronized void startOutputCapture() {
        bout = new ByteArrayOutputStream();
        old = System.out;
        System.setOut(new PrintStream(bout));
    }

    private static synchronized String stopOutputCapture() {
        System.setOut(old);
        String boutString = bout.toString();
        System.out.println(boutString);
        return boutString;
    }

    private static boolean checkIfOverwrite(String aFilename) {
        if (new File(aFilename).exists()) {
            log.warn("Outputfile {} already exists.", (Object)aFilename);
            try (Scanner in = new Scanner(System.in);){
                while (true) {
                    TAEEvaluator.startOutputCapture();
                    old.flush();
                    old.println("Given output file already exists. Do you want to overwrite [o] or cancel [c] ? ");
                    String answer = in.nextLine();
                    TAEEvaluator.stopOutputCapture();
                    answer = answer.toLowerCase();
                    if (answer.equals("o") || answer.equals("overwrite")) {
                        log.info("Current outputfile will be overwritten.");
                        boolean bl = true;
                        return bl;
                    }
                    if (answer.equals("c") || answer.equals("cancel")) {
                        boolean bl = false;
                        return bl;
                    }
                    System.out.println("Could not understand \"" + answer + "\"");
                }
            }
        }
        return true;
    }

    private static void writeJSONRuns(List<AlgorithmRunResult> aRuns, String aFilename) {
        ObjectMapper map = new ObjectMapper();
        JsonFactory factory = new JsonFactory();
        File f = new File(aFilename);
        try {
            FileOutputStream fout = new FileOutputStream(f);
            factory.setCodec((ObjectCodec)map);
            JsonGenerator g = factory.createGenerator((OutputStream)fout);
            SimpleModule sModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
            map.configure(SerializationFeature.INDENT_OUTPUT, true);
            map.registerModule((Module)sModule);
            g.writeObject(aRuns);
            g.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Error while write runs to JSON file:", (Throwable)e);
            throw new IllegalStateException("Could not write runs to JSON.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCSVRuns(List<AlgorithmRunResult> aRuns, String aFilename, TAEEvaluatorOptions aOptions) {
        try (CSVWriter aWriter = new CSVWriter((Writer)new FileWriter(new File(aFilename), false));){
            aWriter.writeNext(new String[]{"TAE Name", "TAE Configuration", "Cutoff", "Seed", "Instance", "Run Result", "Run Time", "Additional Run Data"});
            int aRunIndex = 1;
            for (AlgorithmRunResult aRun : aRuns) {
                log.info("Processing run {}/{}.", (Object)aRunIndex++, (Object)aRuns.size());
                log.info("Writing run {} to output file.", (Object)aRun.toString());
                aWriter.writeNext(new String[]{aOptions.fTAEName, aOptions.fConfig, Double.toString(aRun.getAlgorithmRunConfiguration().getCutoffTime()), Long.toString(aRun.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getSeed()), aRun.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance().getInstanceName(), aRun.getRunStatus().toString(), Double.toString(aRun.getRuntime()), aRun.getAdditionalRunData()});
            }
            log.info("...done.");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Error while creating outputfile writer:", (Throwable)e);
            throw new IllegalArgumentException("Could not create CSV output file writer.");
        }
    }
}

