/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aeatk.algorithmrunresult;

import ca.ubc.cs.beta.aeatk.algorithmexecutionconfiguration.AlgorithmExecutionConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunconfiguration.AlgorithmRunConfiguration;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.AlgorithmRunResult;
import ca.ubc.cs.beta.aeatk.algorithmrunresult.RunStatus;
import ca.ubc.cs.beta.aeatk.exceptions.IllegalWrapperOutputException;
import ca.ubc.cs.beta.aeatk.json.serializers.AlgorithmRunResultJson;
import ca.ubc.cs.beta.aeatk.parameterconfigurationspace.ParameterConfiguration;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aeatk.probleminstance.ProblemInstanceSeedPair;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize(using=AlgorithmRunResultJson.AlgorithmRunSerializer.class)
public abstract class AbstractAlgorithmRunResult
implements AlgorithmRunResult {
    private static final long serialVersionUID = -1860615761848618478L;
    protected final AlgorithmRunConfiguration runConfig;
    private final RunStatus acResult;
    private final double runtime;
    private final double runLength;
    private final double quality;
    private final String rawResultLine;
    private final double wallClockTime;
    private final String additionalRunData;

    protected AbstractAlgorithmRunResult(AlgorithmRunConfiguration rc, RunStatus acResult, double runtime, double runLength, double quality, long resultSeed, String rawResultLine, String additionalRunData, double wallClockTime) {
        this(rc, acResult, runtime, runLength, quality, resultSeed, rawResultLine, true, additionalRunData, wallClockTime);
    }

    public AbstractAlgorithmRunResult(AlgorithmRunConfiguration runConfig, RunStatus acResult, double runtime, double runLength, double quality, long resultSeed, String rawResultLine, boolean runResultWellFormed, String additionalRunData, double wallClockTime) {
        if (Double.isNaN(runtime) || runtime < 0.0) {
            throw new IllegalWrapperOutputException("Runtime is NaN or negative", rawResultLine);
        }
        if (Double.isNaN(runLength) || runLength < 0.0 && runLength != -1.0) {
            throw new IllegalWrapperOutputException("RunLength (" + runLength + ") is NaN or negative (and not -1)", rawResultLine);
        }
        if (Double.isNaN(quality)) {
            throw new IllegalWrapperOutputException("Quality needs to be a number", rawResultLine);
        }
        if (acResult == null) {
            throw new IllegalStateException("Run Result cannot be null");
        }
        if (runConfig == null) {
            throw new IllegalArgumentException("No RunConfig specified");
        }
        if (wallClockTime < 0.0) {
            throw new IllegalArgumentException("Wallclock time must be greater than or equal to zero");
        }
        this.runConfig = runConfig;
        this.acResult = acResult;
        this.runtime = Math.min(runtime, Double.MAX_VALUE);
        this.runLength = Math.min(runLength, Double.MAX_VALUE);
        this.quality = quality;
        this.rawResultLine = this.saveRawResultLine() ? rawResultLine : "";
        this.additionalRunData = additionalRunData == null ? "" : additionalRunData.replace("\n", "\\n").replace(',', ';');
        this.wallClockTime = wallClockTime;
    }

    @Override
    public final AlgorithmRunConfiguration getAlgorithmRunConfiguration() {
        return this.runConfig;
    }

    @Override
    public final RunStatus getRunStatus() {
        return this.acResult;
    }

    @Override
    public final double getRuntime() {
        return this.runtime;
    }

    @Override
    public final double getRunLength() {
        return this.runLength;
    }

    @Override
    public final double getQuality() {
        return this.quality;
    }

    @Override
    public final long getResultSeed() {
        return this.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getSeed();
    }

    private final String _getResultLine() {
        return AbstractAlgorithmRunResult.getResultLine(this);
    }

    public static final String getResultLine(AlgorithmRunResult run) {
        String resultLine = run.getRunStatus().name() + ", " + run.getRuntime() + ", " + run.getRunLength() + ", " + run.getQuality() + ", " + run.getResultSeed();
        if (run.getAdditionalRunData().trim().length() > 0) {
            resultLine = resultLine + "," + run.getAdditionalRunData();
        }
        return resultLine;
    }

    @Override
    public final String getResultLine() {
        return this._getResultLine();
    }

    @Override
    public final boolean isRunCompleted() {
        return !this.acResult.equals((Object)RunStatus.RUNNING);
    }

    @Override
    public final String rawResultLine() {
        if (this.saveRawResultLine()) {
            return this.rawResultLine;
        }
        return "[Raw Result Line Not Saved]";
    }

    public final int hashCode() {
        return this.runConfig.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof AlgorithmRunResult) {
            AlgorithmRunResult aro = (AlgorithmRunResult)o;
            return aro.getAlgorithmRunConfiguration().equals(this.runConfig);
        }
        return false;
    }

    public String toString() {
        return AbstractAlgorithmRunResult.toString(this);
    }

    public static String toString(AlgorithmRunResult run) {
        return run.getAlgorithmRunConfiguration().toString() + " ==> <" + run.getResultLine() + "> W:(" + run.getWallclockExecutionTime() + ")";
    }

    @Override
    public double getWallclockExecutionTime() {
        return this.wallClockTime;
    }

    @Override
    public String getAdditionalRunData() {
        return this.additionalRunData;
    }

    @Override
    public boolean isCensoredEarly() {
        return this.getRunStatus().equals((Object)RunStatus.TIMEOUT) && this.getAlgorithmRunConfiguration().hasCutoffLessThanMax() || this.getRunStatus().equals((Object)RunStatus.KILLED) && this.getRuntime() < this.getAlgorithmRunConfiguration().getCutoffTime();
    }

    private boolean saveRawResultLine() {
        return false;
    }

    @Override
    public ParameterConfiguration getParameterConfiguration() {
        return this.getAlgorithmRunConfiguration().getParameterConfiguration();
    }

    @Override
    public AlgorithmExecutionConfiguration getAlgorithmExecutionConfiguration() {
        return this.getAlgorithmRunConfiguration().getAlgorithmExecutionConfiguration();
    }

    @Override
    public ProblemInstanceSeedPair getProblemInstanceSeedPair() {
        return this.getAlgorithmRunConfiguration().getProblemInstanceSeedPair();
    }

    @Override
    public ProblemInstance getProblemInstance() {
        return this.getAlgorithmRunConfiguration().getProblemInstanceSeedPair().getProblemInstance();
    }
}

