/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.models.fastrf.utils;

import ca.ubc.cs.beta.models.fastrf.utils.ArrayWithSensibleEquals;
import ca.ubc.cs.beta.models.fastrf.utils.TripletDoubleArrayDoubleArrayDouble;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class RfData
implements Serializable {
    private static final long serialVersionUID = 239457234672435L;
    private double[][] Theta;
    private double[][] X;
    private double[] y;
    private int[][] theta_inst_idxs;
    private int[] catDomainSizes;

    public RfData(ArrayList<TripletDoubleArrayDoubleArrayDouble> data, int[] catDomainSizes) {
        int numTheta = data.get((int)0).theta.length;
        int numX = data.get((int)0).x.length;
        this.Theta = new double[data.size()][numTheta];
        this.X = new double[data.size()][numX];
        this.y = new double[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            TripletDoubleArrayDoubleArrayDouble triplet = data.get(i);
            System.arraycopy(triplet.theta, 0, this.Theta[i], 0, numTheta);
            System.arraycopy(triplet.x, 0, this.X[i], 0, numX);
            this.y[i] = triplet.y;
        }
        this.construct(this.Theta, this.X, this.y, catDomainSizes);
    }

    public RfData(double[][] Theta_nonuniq, double[][] X_nonuniq, double[] y, int[] catDomainSizes) {
        this.construct(Theta_nonuniq, X_nonuniq, y, catDomainSizes);
    }

    private void construct(double[][] Theta_nonuniq, double[][] X_nonuniq, double[] y, int[] catDomainSizes) {
        this.Theta = Theta_nonuniq;
        this.X = X_nonuniq;
        this.y = y;
        this.catDomainSizes = catDomainSizes;
        this.theta_inst_idxs = new int[this.Theta.length][2];
        for (int i = 0; i < this.theta_inst_idxs.length; ++i) {
            this.theta_inst_idxs[i][0] = i;
            this.theta_inst_idxs[i][1] = i;
        }
        this.makeUnique(true);
        this.makeUnique(false);
    }

    public double[][] getTheta() {
        return this.Theta;
    }

    public double[][] getX() {
        return this.X;
    }

    public double[] getY() {
        return this.y;
    }

    public int[][] getTheta_inst_idxs() {
        return this.theta_inst_idxs;
    }

    public int[] getCatDomainSizes() {
        return this.catDomainSizes;
    }

    public void makeUnique(boolean makeThetaUnique) {
        Object x;
        ArrayWithSensibleEquals array2;
        int i;
        HashSet<ArrayWithSensibleEquals> uniqueArrays = new HashSet<ArrayWithSensibleEquals>();
        HashMap<ArrayWithSensibleEquals, Integer> mapArrayToUniqueIndex = new HashMap<ArrayWithSensibleEquals, Integer>();
        Vector newIndices = new Vector();
        if (makeThetaUnique) {
            for (i = 0; i < this.Theta.length; ++i) {
                double[] theta = this.Theta[i];
                array2 = new ArrayWithSensibleEquals(theta);
                if (!uniqueArrays.contains(array2)) {
                    mapArrayToUniqueIndex.put(array2, uniqueArrays.size());
                    uniqueArrays.add(array2);
                }
                newIndices.add(i, mapArrayToUniqueIndex.get(array2));
            }
        } else {
            for (i = 0; i < this.X.length; ++i) {
                x = this.X[i];
                array2 = new ArrayWithSensibleEquals((double[])x);
                if (!uniqueArrays.contains(array2)) {
                    mapArrayToUniqueIndex.put(array2, uniqueArrays.size());
                    uniqueArrays.add(array2);
                }
                newIndices.add(i, mapArrayToUniqueIndex.get(array2));
            }
        }
        if (makeThetaUnique) {
            double[][] uniqueTheta = new double[uniqueArrays.size()][];
            x = uniqueArrays.iterator();
            while (x.hasNext()) {
                array2 = (ArrayWithSensibleEquals)x.next();
                uniqueTheta[((Integer)mapArrayToUniqueIndex.get((Object)array2)).intValue()] = array2.values;
            }
            this.Theta = uniqueTheta;
            for (int i2 = 0; i2 < newIndices.size(); ++i2) {
                this.theta_inst_idxs[i2][0] = (Integer)newIndices.get(i2);
            }
        } else {
            double[][] uniqueX = new double[uniqueArrays.size()][];
            for (ArrayWithSensibleEquals array2 : uniqueArrays) {
                uniqueX[((Integer)mapArrayToUniqueIndex.get((Object)array2)).intValue()] = array2.values;
            }
            this.X = uniqueX;
            for (int i3 = 0; i3 < newIndices.size(); ++i3) {
                this.theta_inst_idxs[i3][1] = (Integer)newIndices.get(i3);
            }
        }
    }

    public double[][] buildMatrixForApply() {
        assert (this.Theta.length > 0);
        assert (this.X.length > 0);
        int numPoints = this.theta_inst_idxs.length;
        int dimTheta = this.Theta[0].length;
        int dimX = this.X[0].length;
        double[][] combinedMatrix = new double[numPoints][dimTheta + dimX];
        for (int i = 0; i < numPoints; ++i) {
            int j;
            for (j = 0; j < dimTheta; ++j) {
                combinedMatrix[i][j] = this.Theta[this.theta_inst_idxs[i][0]][j];
            }
            for (j = dimTheta; j < dimTheta + dimX; ++j) {
                combinedMatrix[i][j] = this.X[this.theta_inst_idxs[i][1]][j - dimTheta];
            }
        }
        return combinedMatrix;
    }
}

