/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.executors;

import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aclib.misc.spi.SPIClassLoaderHelper;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPoolConstants;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.smac.ValidationExecutorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorLoader;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.smac.validation.Validator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class ValidatorExecutor {
    private static Logger log;
    private static Marker exception;
    private static Marker stackTrace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ValidationExecutorOptions options = new ValidationExecutorOptions();
        Map taeOptions = TargetAlgorithmEvaluatorLoader.getAvailableTargetAlgorithmEvaluators();
        try {
            File f;
            ArrayList<TrajectoryFileEntry> tfes;
            JCommander jcom = JCommanderHelper.parseCheckingForHelpAndVersion((String[])args, (AbstractOptions)options, (Map)taeOptions);
            String outputDir = System.getProperty("user.dir") + File.separator + "ValidationRun-" + new SimpleDateFormat("yyyy-MM-dd--HH-mm-ss-SSS").format(new Date()) + File.separator;
            if (options.useScenarioOutDir) {
                outputDir = options.scenarioConfig.outputDirectory + File.separator;
            }
            options.logOptions.initializeLogging(outputDir, options.seedOptions.numRun);
            log = LoggerFactory.getLogger(ValidatorExecutor.class);
            JCommanderHelper.logCallString((String[])args, ValidatorExecutor.class);
            log.info("==========Configuration Options==========\n{}", (Object)options.toString());
            VersionTracker.setClassLoader((ClassLoader)SPIClassLoaderHelper.getClassLoader());
            VersionTracker.logVersions();
            for (String name : jcom.getParameterFilesToRead()) {
                log.info("Parsing (default) options from file: {} ", (Object)name);
            }
            if (options.incumbent != null && options.trajectoryFileOptions.trajectoryFile != null) {
                throw new ParameterException("You cannot specify both a configuration and a trajectory file");
            }
            if (options.validationOptions.numberOfValidationRuns == 0) {
                throw new ParameterException("You must be willing to do at least one run with the stand alone utility");
            }
            if (options.trajectoryFileOptions.trajectoryFile != null) {
                if (options.tunerTime == -1.0) {
                    options.tunerTime = options.scenarioConfig.limitOptions.tunerTimeout;
                    log.info("Using Scenario Tuner Time {} seconds", (Object)options.tunerTime);
                }
                if (options.wallTime == -1.0) {
                    options.wallTime = options.tunerTime;
                }
            } else {
                if (options.tunerTime == -1.0) {
                    options.tunerTime = 0.0;
                }
                if (options.wallTime == -1.0) {
                    options.wallTime = 0.0;
                }
                if (options.empiricalPerformance == -1.0) {
                    options.empiricalPerformance = 0.0;
                }
                log.info("Using manually set configurations");
            }
            SeedableRandomPool pool = options.seedOptions.getSeedableRandomPool();
            InstanceListWithSeeds ilws = options.getTrainingAndTestProblemInstances(pool);
            List testInstances = ilws.getInstances();
            InstanceSeedGenerator testInstanceSeedGen = ilws.getSeedGen();
            log.info("Parsing Parameter Space File", (Object)options.scenarioConfig.algoExecOptions.paramFileDelegate.paramFile);
            Random configSpacePRNG = pool.getRandom((Enum)SeedableRandomPoolConstants.VALIDATE_RANDOM_CONFIG_POOL);
            AlgorithmExecutionConfig execConfig = options.getAlgorithmExecutionConfig();
            ParamConfigurationSpace configSpace = execConfig.getParamFile();
            if (options.trajectoryFileOptions.trajectoryFile != null) {
                log.info("Parsing Trajectory File {} ", (Object)options.trajectoryFileOptions.trajectoryFile.getAbsolutePath());
                tfes = options.trajectoryFileOptions.parseTrajectoryFile(configSpace);
                if (options.validationOptions.maxTimestamp == -1.0) {
                    options.validationOptions.maxTimestamp = options.validationOptions.useWallClockTime ? (double)options.scenarioConfig.limitOptions.runtimeLimit : (double)options.scenarioConfig.limitOptions.tunerTimeout;
                }
                if (options.randomConfigurations > 0) {
                    throw new ParameterException("Cannot validate both a trajectory file and random configurations");
                }
                if (options.configurationList != null) {
                    throw new ParameterException("Cannot validate both a trajectory file and a configuration list");
                }
                if (options.incumbent != null) {
                    throw new ParameterException("Cannot validate both a trajectory and a given configuration");
                }
            } else {
                int i;
                if (options.tunerOverheadTime == -1.0) {
                    options.tunerOverheadTime = 0.0;
                }
                options.validationOptions.validateAll = true;
                ArrayList<ParamConfiguration> configToValidate = new ArrayList<ParamConfiguration>();
                int optionsSet = 0;
                if (options.incumbent != null) {
                    log.info("Parsing Supplied Configuration");
                    configToValidate.add(configSpace.getConfigurationFromString(options.incumbent, ParamConfiguration.StringFormat.NODB_OR_STATEFILE_SYNTAX, configSpacePRNG));
                    ++optionsSet;
                }
                if (options.randomConfigurations > 0) {
                    log.info("Generating {} random configurations to validate");
                    for (i = 0; i < options.randomConfigurations; ++i) {
                        if (options.includeRandomAsFirstDefault && i == 0) {
                            log.debug("Using the default as the first configuration");
                            configToValidate.add(configSpace.getDefaultConfiguration());
                            continue;
                        }
                        configToValidate.add(configSpace.getRandomConfiguration(configSpacePRNG));
                    }
                    ++optionsSet;
                }
                if (options.configurationList != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(options.configurationList));
                    while ((line = reader.readLine()) != null) {
                        if (line.trim().isEmpty()) continue;
                        configToValidate.add(configSpace.getConfigurationFromString(line, ParamConfiguration.StringFormat.NODB_OR_STATEFILE_SYNTAX, configSpacePRNG));
                    }
                    ++optionsSet;
                    reader.close();
                }
                if (optionsSet == 0) {
                    throw new ParameterException("You must set one of --trajectoryFile, --configuration, --configurationList, --randomConfiguration options");
                }
                if (optionsSet > 1) {
                    throw new ParameterException("You can only set one of --trajectoryFile, --configuration, --configurationList, --randomConfiguration options");
                }
                tfes = new ArrayList<TrajectoryFileEntry>();
                i = 0;
                for (ParamConfiguration config : configToValidate) {
                    tfes.add(new TrajectoryFileEntry(config, options.tunerTime + (double)i, options.wallTime, options.empiricalPerformance, options.tunerOverheadTime + (double)i));
                    if (!options.autoIncrementTunerTime) continue;
                    ++i;
                }
            }
            options.checkProblemInstancesCompatibleWithVerifySAT(testInstances);
            log.debug("Hard coding abort on crash, checkSATConsistencyException abort on first run crash options to false as they do more harm than good here");
            options.scenarioConfig.algoExecOptions.taeOpts.checkSATConsistencyException = false;
            options.scenarioConfig.algoExecOptions.taeOpts.abortOnCrash = false;
            options.scenarioConfig.algoExecOptions.taeOpts.abortOnFirstRunCrash = false;
            options.scenarioConfig.algoExecOptions.taeOpts.turnOffCrashes();
            TargetAlgorithmEvaluator validatingTae = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((TargetAlgorithmEvaluatorOptions)options.scenarioConfig.algoExecOptions.taeOpts, (AlgorithmExecutionConfig)execConfig, (boolean)false, (Map)taeOptions);
            if (options.useScenarioOutDir) {
                outputDir = options.scenarioConfig.outputDirectory + File.separator;
            }
            if (!((f = new File(outputDir)).mkdirs() || f.exists() && f.isDirectory() && f.canWrite())) {
                throw new ParameterException("Couldn't make output Directory:" + outputDir);
            }
            log.info("Beginning Validation on {} entries", (Object)tfes.size());
            try {
                new Validator().validate(testInstances, options.validationOptions, options.scenarioConfig.algoExecOptions.cutoffTime, testInstanceSeedGen, validatingTae, outputDir, options.scenarioConfig.runObj, options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, tfes, options.seedOptions.numRun, options.waitForPersistedRunCompletion);
            }
            finally {
                validatingTae.notifyShutdown();
            }
            log.info("Validation Completed Successfully");
            System.exit(0);
        }
        catch (Throwable t) {
            int returnValue = 255;
            if (log != null) {
                log.error(exception, "Message: {}", (Object)t.getMessage());
                if (t instanceof NullPointerException) {
                    log.error("This error is most likely caused by an improper input file format, make sure the files are non empty / in the right format");
                }
                if (!(t instanceof ParameterException)) {
                    log.error(exception, "Exception:{}", (Object)t.getClass().getCanonicalName());
                    StringWriter sWriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(sWriter);
                    t.printStackTrace(writer);
                    log.error(stackTrace, "StackTrace:{}", (Object)sWriter.toString());
                    returnValue = 1;
                }
                log.info("Exiting Application with failure");
                t = t.getCause();
            } else if (t instanceof ParameterException) {
                returnValue = 1;
                System.err.println(t.getMessage());
            } else {
                returnValue = 255;
                t.printStackTrace();
            }
            System.exit(returnValue);
        }
    }
}

