/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.executors;

import ca.ubc.cs.beta.aclib.exceptions.StateSerializationException;
import ca.ubc.cs.beta.aclib.exceptions.TrajectoryDivergenceException;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.misc.jcommander.JCommanderHelper;
import ca.ubc.cs.beta.aclib.misc.spi.SPIClassLoaderHelper;
import ca.ubc.cs.beta.aclib.misc.version.VersionTracker;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstanceOptions;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.smac.SMACOptions;
import ca.ubc.cs.beta.aclib.state.StateFactoryOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluatorOptions;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.exceptions.TargetAlgorithmAbortException;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.init.TargetAlgorithmEvaluatorBuilder;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileEntry;
import ca.ubc.cs.beta.smac.builder.SMACBuilder;
import ca.ubc.cs.beta.smac.configurator.AbstractAlgorithmFramework;
import ca.ubc.cs.beta.smac.validation.Validator;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SMACExecutor {
    private static Logger log;
    private static Marker exception;
    private static Marker stackTrace;
    private static String logLocation;
    private static InstanceListWithSeeds trainingILWS;
    private static InstanceListWithSeeds testingILWS;
    private static Map<String, AbstractOptions> taeOptions;
    private static SeedableRandomPool pool;
    private static String outputDir;
    private static String runGroupName;

    public static void main(String[] args) {
        int returnValue = SMACExecutor.oldMain(args);
        if (log != null) {
            log.info("Returning with value: {}", (Object)returnValue);
        }
        System.exit(returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int oldMain(String[] args) {
        try {
            SortedMap<TrajectoryFileEntry, Double> performance;
            SMACOptions options = SMACExecutor.parseCLIOptions(args);
            SMACBuilder smacBuilder = new SMACBuilder();
            AlgorithmExecutionConfig execConfig = options.getAlgorithmExecutionConfig();
            AbstractAlgorithmFramework smac = smacBuilder.getAutomaticConfigurator(execConfig, trainingILWS, options, taeOptions, outputDir, pool);
            smac.run();
            log.info("SMAC Termination Reason: {}", (Object)smac.getTerminationReason());
            pool.logUsage();
            List tfes = smacBuilder.getTrajectoryFileLogger().getTrajectoryFileEntries();
            boolean bl = options.doValidation = options.validationOptions.numberOfValidationRuns > 0 ? options.doValidation : false;
            if (options.doValidation) {
                if (options.validationOptions.maxTimestamp == -1.0) {
                    options.validationOptions.maxTimestamp = options.scenarioConfig.limitOptions.tunerTimeout;
                }
                options.scenarioConfig.algoExecOptions.taeOpts.turnOffCrashes();
                TargetAlgorithmEvaluator validatingTae = TargetAlgorithmEvaluatorBuilder.getTargetAlgorithmEvaluator((TargetAlgorithmEvaluatorOptions)options.scenarioConfig.algoExecOptions.taeOpts, (AlgorithmExecutionConfig)execConfig, (boolean)false, taeOptions);
                try {
                    List testInstances = testingILWS.getInstances();
                    InstanceSeedGenerator testInstanceSeedGen = testingILWS.getSeedGen();
                    performance = new Validator().validate(testInstances, options.validationOptions, options.scenarioConfig.algoExecOptions.cutoffTime, testInstanceSeedGen, validatingTae, outputDir, options.scenarioConfig.runObj, options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, tfes, options.seedOptions.numRun, true);
                }
                finally {
                    validatingTae.notifyShutdown();
                }
            } else {
                performance = new TreeMap<TrajectoryFileEntry, Double>();
                performance.put((TrajectoryFileEntry)tfes.get(tfes.size() - 1), Double.POSITIVE_INFINITY);
            }
            smac.logIncumbentPerformance(performance);
            smac.logSMACResult(performance);
            smacBuilder.getLogRuntimeStatistics().logLastRuntimeStatistics();
            smacBuilder.getEventManager().shutdown();
            log.info("SMAC Termination Reason: {}", (Object)smac.getTerminationReason());
            log.info("SMAC Completed Successfully. Log: " + logLocation);
            return 0;
        }
        catch (Throwable t) {
            System.out.flush();
            System.err.flush();
            System.err.println("Error occured running SMAC ( " + t.getClass().getSimpleName() + " : " + t.getMessage() + ")\nError Log: " + logLocation);
            System.err.flush();
            if (log != null) {
                log.error(exception, "Message: {}", (Object)t.getMessage());
                if (t instanceof ParameterException) {
                    log.info("Don't forget that some options are set by default from files in ~/.aclib/");
                    log.debug("Exception stack trace", t);
                } else if (t instanceof TargetAlgorithmAbortException) {
                    log.error("A serious problem occured during target algorithm execution and we are aborting execution ", t);
                    log.error("We tried to call the target algorithm wrapper, but this call failed.");
                    log.error("The problem is (most likely) somewhere in the wrapper.");
                    log.error("There is also possibly additional error information above (in this log)");
                    log.error("The easiest way to debug this problem is to manually execute the call we tried and see why it did not return the correct result");
                    log.error("The required syntax is something like \"Final Result for ParamILS: x,x,x,x,x\".);");
                    log.error("Specifically the regex we are matching is {}", (Object)"^\\s*(Final)?\\s*[Rr]esult\\s+(?:([Ff]or)|([oO]f))\\s+(?:(HAL)|(ParamILS)|(SMAC)|([tT]his [wW]rapper)):");
                } else {
                    log.info("Maybe try running in DEBUG mode if you are missing information");
                    log.error(exception, "Exception:{}", (Object)t.getClass().getCanonicalName());
                    StringWriter sWriter = new StringWriter();
                    PrintWriter writer = new PrintWriter(sWriter);
                    t.printStackTrace(writer);
                    log.error(stackTrace, "StackTrace:{}", (Object)sWriter.toString());
                }
                log.info("Exiting SMAC with failure. Log: " + logLocation);
                log.info("For a list of available commands use:  --help");
                log.info("Please see above for the available options. Further information is available in the following documents:");
                log.info("- The FAQ (doc/faq.pdf) contains commonly asked questions regarding troubleshooting, and usage.");
                log.info("- The Quickstart Guide (doc/quickstart.pdf) gives a simple example for getting up and running.");
                log.info("- The Manual (doc/manual.pdf) contains detailed information on file format semantics.");
                t = t.getCause();
            } else if (t instanceof ParameterException) {
                System.err.println(t.getMessage());
                t.printStackTrace();
            } else {
                t.printStackTrace();
            }
            if (t instanceof ParameterException) {
                return 1;
            }
            if (t instanceof StateSerializationException) {
                return 3;
            }
            if (t instanceof TrajectoryDivergenceException) {
                return 2;
            }
            return 255;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SMACOptions parseCLIOptions(String[] args) throws ParameterException, IOException {
        SMACOptions options = new SMACOptions();
        taeOptions = options.scenarioConfig.algoExecOptions.taeOpts.getAvailableTargetAlgorithmEvaluators();
        JCommander jcom = JCommanderHelper.getJCommanderAndCheckForHelp((String[])args, (AbstractOptions)options, taeOptions);
        jcom.setProgramName("smac");
        try {
            try {
                File outputDirFile;
                try {
                    args = SMACExecutor.processScenarioStateRestore(args);
                    jcom.parse(args);
                }
                finally {
                    runGroupName = options.runGroupOptions.getFailbackRunGroup();
                }
                if (options.adaptiveCapping == null) {
                    switch (options.scenarioConfig.runObj) {
                        case RUNTIME: {
                            options.adaptiveCapping = true;
                            break;
                        }
                        case QUALITY: {
                            options.adaptiveCapping = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Not sure what to default too");
                        }
                    }
                }
                if (options.randomForestOptions.logModel == null) {
                    switch (options.scenarioConfig.runObj) {
                        case RUNTIME: {
                            options.randomForestOptions.logModel = true;
                            break;
                        }
                        case QUALITY: {
                            options.randomForestOptions.logModel = false;
                        }
                    }
                }
                if (!(outputDirFile = new File(outputDir = options.getOutputDirectory(runGroupName = options.getRunGroupName(taeOptions.values())))).exists()) {
                    outputDirFile.mkdirs();
                    if (!outputDirFile.exists()) {
                        throw new ParameterException("Could not create all folders necessary for output directory: " + outputDir);
                    }
                }
            }
            finally {
                options.logOptions.initializeLogging(outputDir, options.seedOptions.numRun);
                logLocation = options.logOptions.getLogLocation(outputDir, options.seedOptions.numRun);
                log = LoggerFactory.getLogger(SMACExecutor.class);
                exception = MarkerFactory.getMarker((String)"EXCEPTION");
                stackTrace = MarkerFactory.getMarker((String)"STACKTRACE");
                VersionTracker.setClassLoader((ClassLoader)SPIClassLoaderHelper.getClassLoader());
                VersionTracker.logVersions();
                for (String name : jcom.getParameterFilesToRead()) {
                    log.info("Parsing (default) options from file: {} ", (Object)name);
                }
            }
            log.trace("Command Line Options Parsed");
            JCommanderHelper.logCallString((String[])args, SMACExecutor.class);
            if (log.isDebugEnabled()) {
                TreeMap<String, String> env = new TreeMap<String, String>(System.getenv());
                StringBuilder sb = new StringBuilder();
                for (String envName : env.keySet()) {
                    sb.append(envName).append("=").append((String)env.get(envName)).append("\n");
                }
                log.debug("==========Enviroment Variables===========\n{}", (Object)sb.toString());
                TreeMap<Object, Object> props = new TreeMap<Object, Object>(System.getProperties());
                sb = new StringBuilder();
                for (Map.Entry ent : props.entrySet()) {
                    sb.append(ent.getKey().toString()).append("=").append(ent.getValue().toString()).append("\n");
                }
                String hostname = "[UNABLE TO DETERMINE HOSTNAME]";
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                log.debug("Hostname:{}", (Object)hostname);
                log.debug("==========System Properties==============\n{}", (Object)sb.toString());
            }
            JCommanderHelper.logConfiguration((JCommander)jcom);
            pool = options.seedOptions.getSeedableRandomPool();
            ProblemInstanceOptions.TrainTestInstances tti = options.getTrainingAndTestProblemInstances(pool, new SeedableRandomPool(options.validationSeed + options.seedOptions.seedOffset, pool.getInitialSeeds()));
            trainingILWS = tti.getTrainingInstances();
            testingILWS = tti.getTestInstances();
            try {
                if (ManagementFactory.getThreadMXBean().isThreadCpuTimeEnabled()) {
                    log.debug("JVM Supports CPU Timing Measurements");
                } else {
                    log.warn("This Java Virtual Machine has CPU Time Measurements disabled, tunerTimeout will not contain any SMAC Execution Time.");
                }
            }
            catch (UnsupportedOperationException e) {
                log.warn("This Java Virtual Machine does not support CPU Time Measurements, tunerTimeout will not contain any SMAC Execution Time Information (http://docs.oracle.com/javase/1.5.0/docs/api/java/lang/management/ThreadMXBean.html#setThreadCpuTimeEnabled(boolean))");
            }
            if (options.seedOptions.numRun + options.seedOptions.seedOffset < 0) {
                log.warn("NumRun {} plus Seed Offset {} should be positive, things may not seed correctly", (Object)options.seedOptions.numRun, (Object)options.seedOptions.seedOffset);
            }
            return options;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ParameterException e) {
            throw e;
        }
    }

    private static String[] processScenarioStateRestore(String[] args) {
        return StateFactoryOptions.processScenarioStateRestore((String[])args);
    }

    static {
        logLocation = "<NO LOG LOCATION SPECIFIED, FAILURE MUST HAVE OCCURED EARLY>";
        runGroupName = "DEFAULT";
    }
}

