/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.smac.builder;

import ca.ubc.cs.beta.aclib.acquisitionfunctions.AcquisitionFunctions;
import ca.ubc.cs.beta.aclib.configspace.ParamConfiguration;
import ca.ubc.cs.beta.aclib.configspace.ParamConfigurationSpace;
import ca.ubc.cs.beta.aclib.configspace.tracking.ParamConfigurationOriginTracker;
import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.EventManager;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.AutomaticConfigurationEnd;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.ChallengeStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.ac.IncumbentPerformanceChangeEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.basic.AlgorithmRunCompletedEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildStartEvent;
import ca.ubc.cs.beta.aclib.eventsystem.events.state.StateRestoredEvent;
import ca.ubc.cs.beta.aclib.eventsystem.handlers.LogRuntimeStatistics;
import ca.ubc.cs.beta.aclib.execconfig.AlgorithmExecutionConfig;
import ca.ubc.cs.beta.aclib.initialization.InitializationProcedure;
import ca.ubc.cs.beta.aclib.initialization.classic.ClassicInitializationProcedure;
import ca.ubc.cs.beta.aclib.initialization.doublingcapping.DoublingCappingInitializationProcedure;
import ca.ubc.cs.beta.aclib.objectives.ObjectiveHelper;
import ca.ubc.cs.beta.aclib.objectives.OverallObjective;
import ca.ubc.cs.beta.aclib.objectives.RunObjective;
import ca.ubc.cs.beta.aclib.options.AbstractOptions;
import ca.ubc.cs.beta.aclib.options.scenario.ScenarioOptions;
import ca.ubc.cs.beta.aclib.probleminstance.InstanceListWithSeeds;
import ca.ubc.cs.beta.aclib.probleminstance.ProblemInstance;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPool;
import ca.ubc.cs.beta.aclib.random.SeedableRandomPoolConstants;
import ca.ubc.cs.beta.aclib.runhistory.NewRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.RunHistory;
import ca.ubc.cs.beta.aclib.runhistory.TeeRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistory;
import ca.ubc.cs.beta.aclib.runhistory.ThreadSafeRunHistoryWrapper;
import ca.ubc.cs.beta.aclib.seedgenerator.InstanceSeedGenerator;
import ca.ubc.cs.beta.aclib.smac.ExecutionMode;
import ca.ubc.cs.beta.aclib.smac.SMACOptions;
import ca.ubc.cs.beta.aclib.state.StateDeserializer;
import ca.ubc.cs.beta.aclib.state.StateFactory;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.TargetAlgorithmEvaluator;
import ca.ubc.cs.beta.aclib.targetalgorithmevaluator.decorators.helpers.TargetAlgorithmEvaluatorNotifyTerminationCondition;
import ca.ubc.cs.beta.aclib.termination.CompositeTerminationCondition;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.trajectoryfile.TrajectoryFileLogger;
import ca.ubc.cs.beta.smac.configurator.AbstractAlgorithmFramework;
import ca.ubc.cs.beta.smac.configurator.SequentialModelBasedAlgorithmConfiguration;
import ca.ubc.cs.beta.smac.handler.ChallengePredictionHandler;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMACBuilder {
    private static transient Logger log = LoggerFactory.getLogger(SMACBuilder.class);
    private final EventManager eventManager = new EventManager();
    private volatile TrajectoryFileLogger tLog;
    private volatile LogRuntimeStatistics logRT;

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public AbstractAlgorithmFramework getAutomaticConfigurator(AlgorithmExecutionConfig execConfig, InstanceListWithSeeds trainingILWS, SMACOptions options, Map<String, AbstractOptions> taeOptions, String outputDir, SeedableRandomPool pool) {
        AbstractAlgorithmFramework smac;
        ClassicInitializationProcedure initProc;
        StateFactory restoreSF = options.getRestoreStateFactory(outputDir);
        if (options.adaptiveCapping == null) {
            switch (options.scenarioConfig.runObj) {
                case RUNTIME: {
                    options.adaptiveCapping = true;
                    break;
                }
                case QUALITY: {
                    options.adaptiveCapping = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Not sure what to default too");
                }
            }
        }
        if (options.randomForestOptions.logModel == null) {
            switch (options.scenarioConfig.runObj) {
                case RUNTIME: {
                    options.randomForestOptions.logModel = true;
                    break;
                }
                case QUALITY: {
                    options.randomForestOptions.logModel = false;
                }
                default: {
                    throw new IllegalStateException("Not sure what to default too");
                }
            }
        }
        ParamConfigurationSpace configSpace = execConfig.getParamFile();
        log.info("Configuration Space Size is less than or equal to {} ", (Object)configSpace.getUpperBoundOnSize());
        StateFactory sf = options.getSaveStateFactory(outputDir);
        List instances = trainingILWS.getInstances();
        InstanceSeedGenerator instanceSeedGen = trainingILWS.getSeedGen();
        options.checkProblemInstancesCompatibleWithVerifySAT(instances);
        ParamConfiguration initialIncumbent = configSpace.getConfigurationFromString(options.initialIncumbent, ParamConfiguration.StringFormat.NODB_SYNTAX, pool.getRandom((Enum)SeedableRandomPoolConstants.INITIAL_INCUMBENT_SELECTION));
        if (!initialIncumbent.equals((Object)configSpace.getDefaultConfiguration())) {
            log.info("Initial Incumbent set to \"{}\" ", (Object)initialIncumbent.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
        } else {
            log.info("Initial Incumbent is the default \"{}\" ", (Object)initialIncumbent.getFormattedParamString(ParamConfiguration.StringFormat.NODB_SYNTAX));
        }
        SMACBuilder.validateObjectiveCombinations(options.scenarioConfig, options.adaptiveCapping);
        TargetAlgorithmEvaluator tae = options.scenarioConfig.algoExecOptions.taeOpts.getTargetAlgorithmEvaluator(execConfig, taeOptions, outputDir, options.seedOptions.numRun);
        NewRunHistory rhROAR = new NewRunHistory(options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, options.scenarioConfig.runObj);
        NewRunHistory rhModel = new NewRunHistory(options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, options.scenarioConfig.runObj);
        ThreadSafeRunHistoryWrapper rh = new ThreadSafeRunHistoryWrapper((RunHistory)new TeeRunHistory((RunHistory)rhROAR, (RunHistory)rhModel));
        CompositeTerminationCondition termCond = options.scenarioConfig.limitOptions.getTerminationConditions();
        this.tLog = new TrajectoryFileLogger((RunHistory)rh, (TerminationCondition)termCond, outputDir + File.separator + "traj-run-" + options.seedOptions.numRun, initialIncumbent);
        this.eventManager.registerHandler(IncumbentPerformanceChangeEvent.class, (EventHandler)this.tLog);
        this.eventManager.registerHandler(AutomaticConfigurationEnd.class, (EventHandler)this.tLog);
        this.logRT = new LogRuntimeStatistics((ThreadSafeRunHistory)rh, (TerminationCondition)termCond, execConfig.getAlgorithmCutoffTime());
        termCond.registerWithEventManager(this.eventManager);
        this.eventManager.registerHandler(ModelBuildStartEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(IncumbentPerformanceChangeEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(AlgorithmRunCompletedEvent.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(AutomaticConfigurationEnd.class, (EventHandler)this.logRT);
        this.eventManager.registerHandler(StateRestoredEvent.class, (EventHandler)this.logRT);
        ParamConfigurationOriginTracker configTracker = options.trackingOptions.getTracker(this.eventManager, initialIncumbent, outputDir, (ThreadSafeRunHistory)rh, execConfig, options.seedOptions.numRun);
        TargetAlgorithmEvaluatorNotifyTerminationCondition acTae = new TargetAlgorithmEvaluatorNotifyTerminationCondition(tae, this.eventManager, (TerminationCondition)termCond, true);
        switch (options.initializationMode) {
            case CLASSIC: {
                initProc = new ClassicInitializationProcedure((ThreadSafeRunHistory)rh, initialIncumbent, (TargetAlgorithmEvaluator)acTae, options.classicInitModeOpts, instanceSeedGen, instances, options.maxIncumbentRuns, (TerminationCondition)termCond, execConfig.getAlgorithmCutoffTime(), pool, options.deterministicInstanceOrdering);
                break;
            }
            default: {
                ObjectiveHelper objHelper = new ObjectiveHelper(options.scenarioConfig.runObj, options.scenarioConfig.intraInstanceObj, options.scenarioConfig.interInstanceObj, execConfig.getAlgorithmCutoffTime());
                initProc = new DoublingCappingInitializationProcedure((ThreadSafeRunHistory)rh, initialIncumbent, (TargetAlgorithmEvaluator)acTae, options.dciModeOpts, instanceSeedGen, instances, options.maxIncumbentRuns, (TerminationCondition)termCond, execConfig.getAlgorithmCutoffTime(), pool, options.deterministicInstanceOrdering, objHelper);
            }
        }
        if (options.expFunc == null) {
            switch (options.scenarioConfig.runObj) {
                case RUNTIME: {
                    options.expFunc = AcquisitionFunctions.EXPONENTIAL;
                    break;
                }
                case QUALITY: {
                    options.expFunc = AcquisitionFunctions.EI;
                    break;
                }
                default: {
                    throw new IllegalStateException("Not sure what to default too");
                }
            }
        }
        switch (options.expFunc) {
            case EXPONENTIAL: {
                if (options.randomForestOptions.logModel.booleanValue()) break;
                log.warn("With log model turned off the exponential expected improvement function is not recommended, use: " + AcquisitionFunctions.EI);
                break;
            }
            case EI: {
                if (!options.randomForestOptions.logModel.booleanValue()) break;
                log.warn("With log model turned on the expected improvement function is not recommended, use: " + AcquisitionFunctions.EXPONENTIAL);
                break;
            }
            case SIMPLE: {
                log.warn("The simple acquisition function is never recommended");
                break;
            }
            case LCB: {
                break;
            }
            default: {
                throw new IllegalStateException("Not sure what to default too");
            }
        }
        switch (options.execMode) {
            case ROAR: {
                smac = new AbstractAlgorithmFramework(options, instances, (TargetAlgorithmEvaluator)acTae, sf, configSpace, instanceSeedGen, initialIncumbent, this.eventManager, (ThreadSafeRunHistory)rh, pool, termCond, configTracker, (InitializationProcedure)initProc);
                break;
            }
            case SMAC: {
                options.warmStartOptions.getWarmStartState(configSpace, instances, execConfig, (RunHistory)rhModel);
                smac = new SequentialModelBasedAlgorithmConfiguration(options, instances, (TargetAlgorithmEvaluator)acTae, options.expFunc.getFunction(), sf, configSpace, instanceSeedGen, initialIncumbent, this.eventManager, (ThreadSafeRunHistory)rh, pool, termCond, configTracker, (InitializationProcedure)initProc, (RunHistory)rhModel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Execution Mode Specified is not supported");
            }
        }
        if (options.trackingOptions.configTracking && options.execMode.equals((Object)ExecutionMode.SMAC)) {
            ChallengePredictionHandler cph = new ChallengePredictionHandler(smac, configTracker);
            this.eventManager.registerHandler(ModelBuildStartEvent.class, (EventHandler)cph);
            this.eventManager.registerHandler(ModelBuildEndEvent.class, (EventHandler)cph);
            this.eventManager.registerHandler(ChallengeStartEvent.class, (EventHandler)cph);
        }
        options.saveContextWithState(configSpace, trainingILWS, sf);
        if (options.stateOpts.restoreIteration != null) {
            this.restoreState(options, restoreSF, smac, configSpace, instances, execConfig, (RunHistory)rh);
        }
        return smac;
    }

    public TrajectoryFileLogger getTrajectoryFileLogger() {
        return this.tLog;
    }

    public LogRuntimeStatistics getLogRuntimeStatistics() {
        return this.logRT;
    }

    private void restoreState(SMACOptions options, StateFactory sf, AbstractAlgorithmFramework smac, ParamConfigurationSpace configSpace, List<ProblemInstance> instances, AlgorithmExecutionConfig execConfig, RunHistory rh) {
        if (options.stateOpts.restoreIteration < 0) {
            throw new ParameterException("Iteration must be a non-negative integer");
        }
        StateDeserializer sd = sf.getStateDeserializer("it", options.stateOpts.restoreIteration.intValue(), configSpace, instances, execConfig, rh);
        smac.restoreState(sd);
    }

    private static void validateObjectiveCombinations(ScenarioOptions scenarioOptions, boolean adaptiveCapping) {
        switch (scenarioOptions.interInstanceObj) {
            case MEAN: {
                break;
            }
            default: {
                throw new ParameterException("Model does not currently support an inter-instance objective other than " + OverallObjective.MEAN);
            }
        }
        switch (scenarioOptions.runObj) {
            case RUNTIME: {
                break;
            }
            case QUALITY: {
                if (!scenarioOptions.intraInstanceObj.equals((Object)OverallObjective.MEAN)) {
                    throw new ParameterException("To optimize quality you MUST use an intra-instance objective of " + OverallObjective.MEAN);
                }
                if (!adaptiveCapping) break;
                throw new ParameterException("You can only use Adaptive Capping when using " + RunObjective.RUNTIME + " as an objective");
            }
        }
    }
}

