/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.termination.standard;

import ca.ubc.cs.beta.aclib.eventsystem.EventHandler;
import ca.ubc.cs.beta.aclib.eventsystem.EventManager;
import ca.ubc.cs.beta.aclib.eventsystem.events.model.ModelBuildEndEvent;
import ca.ubc.cs.beta.aclib.termination.ConditionType;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import ca.ubc.cs.beta.aclib.termination.standard.AbstractTerminationCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ModelIterationTerminationCondition
extends AbstractTerminationCondition
implements EventHandler<ModelBuildEndEvent> {
    private final String NAME = "NUMBER OF RUNS";
    private final long modelBuildLimit;
    private final AtomicLong modelBuildIteration = new AtomicLong(0L);

    public ModelIterationTerminationCondition(long modelBuildLimit) {
        this.modelBuildLimit = modelBuildLimit;
    }

    @Override
    public boolean haveToStop() {
        return this.modelBuildIteration.get() >= this.modelBuildLimit;
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        return Collections.singleton(new ValueMaxStatus(ConditionType.OTHER, this.modelBuildIteration.get(), this.modelBuildLimit, "NUMBER OF RUNS", "Model/Iteration", ""));
    }

    @Override
    public void handleEvent(ModelBuildEndEvent event) {
        this.modelBuildIteration.incrementAndGet();
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public void registerWithEventManager(EventManager evtManager) {
        evtManager.registerHandler(ModelBuildEndEvent.class, this);
    }

    @Override
    public String getTerminationReason() {
        if (this.haveToStop()) {
            return "Model Building / Iteration Limit (" + this.modelBuildIteration + ") has been reached";
        }
        return "";
    }
}

