/*
 * Decompiled with CFR 0.152.
 */
package ca.ubc.cs.beta.aclib.termination;

import ca.ubc.cs.beta.aclib.algorithmrun.AlgorithmRun;
import ca.ubc.cs.beta.aclib.eventsystem.EventManager;
import ca.ubc.cs.beta.aclib.termination.TerminationCondition;
import ca.ubc.cs.beta.aclib.termination.ValueMaxStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class CompositeTerminationCondition
implements TerminationCondition {
    private final LinkedHashSet<TerminationCondition> conditions;

    public CompositeTerminationCondition(TerminationCondition c) {
        this(Collections.singletonList(c));
    }

    public CompositeTerminationCondition(Collection<? extends TerminationCondition> conditions) {
        if (conditions.size() == 0) {
            throw new IllegalArgumentException("Must have atleast one condition");
        }
        this.conditions = new LinkedHashSet<TerminationCondition>(conditions);
    }

    @Override
    public boolean haveToStop() {
        for (TerminationCondition c : this.conditions) {
            if (!c.haveToStop()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ValueMaxStatus> currentStatus() {
        ArrayList<ValueMaxStatus> statuses = new ArrayList<ValueMaxStatus>();
        for (TerminationCondition c : this.conditions) {
            statuses.addAll(c.currentStatus());
        }
        return statuses;
    }

    public String toString() {
        return this.currentStatus().toString();
    }

    @Override
    public void registerWithEventManager(EventManager evtManager) {
        for (TerminationCondition c : this.conditions) {
            c.registerWithEventManager(evtManager);
        }
    }

    @Override
    public void notifyRun(AlgorithmRun run) {
        for (TerminationCondition c : this.conditions) {
            c.notifyRun(run);
        }
    }

    @Override
    public double getTunerTime() {
        double tunerTime = Double.MIN_VALUE;
        for (TerminationCondition c : this.conditions) {
            tunerTime = Math.max(tunerTime, c.getTunerTime());
        }
        return tunerTime;
    }

    @Override
    public double getWallTime() {
        double wallclockTime = Double.MIN_VALUE;
        for (TerminationCondition c : this.conditions) {
            wallclockTime = Math.max(wallclockTime, c.getWallTime());
        }
        return wallclockTime;
    }

    @Override
    public String getTerminationReason() {
        StringBuilder sb = new StringBuilder();
        for (TerminationCondition c : this.conditions) {
            if (!c.haveToStop()) continue;
            sb.append(c.getTerminationReason()).append(" & ");
        }
        sb.setCharAt(sb.length() - 2, ' ');
        return sb.toString();
    }

    public synchronized void addCondition(TerminationCondition cond) {
        this.conditions.add(cond);
    }
}

